/*
 * genList.cpp
 *
 * I made this class some time ago.  Please feel free to use it in your projects, but keep 
 * the following info in the source:
 * author: bigfreak
 * email any bugs you find to roberthamilton@usa.com
 */

#include "genList.h"

GenList::GenList(void)
{
	pNext = NULL;
	pData = NULL;
}

GenList::~GenList(void)
{
	//
	// it's assumed by the caller that we will *NOT* free the
	// stored object
	//
	if(pData != NULL)
	{
		delete pData;
		pData = NULL;
	}

	if(pNext != NULL) delete pNext;
	pData = NULL;
	pNext = NULL;
}

unsigned long GenList::GetCount()
{
	unsigned long cnt = 0;
	if(pData != NULL)
		cnt = 1;
	if(pNext == NULL)
		return cnt;
	return pNext->GetCount() + cnt;
}

void GenList::RemoveAll(void)
{
	if(pNext != NULL) delete pNext;
	if(pData != NULL) delete pData;
	pData = NULL;
	pNext = NULL;
}

void GenList::AddTail(void *newData)
{
	if(pData == NULL)
	{
		pData = newData;
		return;
	}

	GenList *pNew = new GenList;
	pNew->pData = newData;
	AddTail(pNew);
}

void GenList::AddTail(GenList *pNew)
{
	if(pNext != NULL)
	{
		pNext->AddTail(pNew);
		return;
	}

	pNext = pNew;
}

int GenList::IsEmpty(void)
{
	return 1;
}

void *GenList::operator [] (int nIndex)
{
	if(nIndex == 0)
	{
		return pData;
	}
	if(pNext == NULL)
	{
		return NULL;
	}
	return pNext->operator[](nIndex - 1);
}
void GenList::Prune(void)
{
	if(pData == NULL)
	{
		if(pNext != NULL)
		{
			pData = pNext->pData;
			pNext->pData = NULL;
		}
	}

	if(pNext == NULL)
	{
		return;
	}

	if(pNext->pData == NULL)
	{
		// should be pruned
		GenList *pNewNext = pNext->pNext;

		// prevent a recursive chain delete from happening
		pNext->pNext = NULL;
		delete pNext;
		pNext = pNewNext;
	}

	if(pNext != NULL)
	{
		pNext->Prune();
	}
}

void GenList::KillData(void)
{
	delete pData;
	pData = NULL;
}
