// stdafx.cpp : source file that includes just the standard includes
//	wadTest.pch will be the pre-compiled header
//	stdafx.obj will contain the pre-compiled type information

#include "stdafx.h"

#include "shlobj.h"

BOOL BrowseForFolder(HWND hOwner, CString& folderpath)
{
	// Create a pointer to a MALLOC (memory allocation object)
	// then get the Shell Malloc.
	IMalloc* pMalloc = 0;
	if(SHGetMalloc(&pMalloc) != NOERROR)
		return FALSE;

	// Now create BROWSEINFO structure, to tell the shell how
	// to display the dialog.
	BROWSEINFO bi;
	memset(&bi, 0, sizeof(bi));

	bi.hwndOwner = hOwner;
	bi.lpszTitle = "Please select a folder and press 'OK'.";

	// Now show the dialog and get the itemIDList for the selected folder.
	LPITEMIDLIST pIDL = SHBrowseForFolder(&bi);
	if(pIDL == NULL)
	return FALSE;

	// Now create a buffer to store the path, thne get it.
	char buffer[_MAX_PATH];
	if(SHGetPathFromIDList(pIDL, buffer) == 0)
	return FALSE;

	// Finally, set the string to the path, and return true.
	folderpath = buffer;
	return true;
}

