#pragma once

#ifndef __UI_TYPES_H__
#define __UI_TYPES_H__

namespace NUISystem
{
	enum ETableSprites
	{
		TABLE_SPRITES_TOP_LEFT = 0,
		TABLE_SPRITES_TOP_RIGHT = 1,
		TABLE_SPRITES_BOTTOM_LEFT = 2,
		TABLE_SPRITES_BOTTOM_RIGHT = 3,
		TABLE_SPRITES_TOP_MIDDLE = 4,
		TABLE_SPRITES_BOTTOM_MIDDLE = 5,
		TABLE_SPRITES_MIDDLE_LEFT = 6,
		TABLE_SPRITES_MIDDLE_RIGHT = 7,
		TABLE_SPRITES_SEPARATION_BOTTOM = 8,
		TABLE_SPRITES_SEPARATION_TOP = 9,
		TABLE_SPRITES_SEPARATION_LEFT = 10,
		TABLE_SPRITES_SEPARATION_RIGHT = 11,
		TABLE_SPRITES_CROSS = 12,

		TABLE_SPRITES_AMOUNT = 13
	};

	enum ETableExpansionTypes
	{
		TABLE_EXPANSION_HORIZONTAL = 1 << 0,
		TABLE_EXPANSION_VERTICAL = 1 << 1,
	};

	enum EState
	{
		UI_STATE_INACTIVE = 0,
		UI_STATE_ACTIVE = 1,
		UI_STATE_DEAD = 2,
		UI_STATE_SELECTED = 3,
		UI_STATE_UNSELECTED = 4,
		UI_STATE_LIST_ACTIVE = 5,
		UI_STATE_LIST_INACTIVE = 6,
		UI_STATE_LIST_UNSELECTED = 7,
		UI_STATE_CUSTOM = 8
	};

	enum EStateChangeType
	{
		STATE_CHANGE_SIMULTANEOUS = 0,
		STATE_CHANGE_PARENT_FIRST = 1,
		STATE_CHANGE_CHILDREN_FIRST = 2,
		STATE_CHANGE_PARENT_ONLY = 3,
		STATE_CHANGE_CHILDREN_ONLY = 4
	};

	//OH PLEASE DO NOT MAKE ANY EXTRA TYPES WITHOUT TELLING ME
	//BECAUSE IF ITS MORE THAN 32 ENTRIES I WILL NEED MORE BITS TO ENCODE IT
	//IN THE CCOMPONENT CLASS
#ifdef _WINDOWS
	enum EType
	{
		UI_TYPE_SPRITE = 0,
		UI_TYPE_MORPHING_SPRITE = 1,
		UI_TYPE_TABLE = 2,
		UI_TYPE_MESH = 3,
		UI_TYPE_COMPOSITE = 4,
		UI_TYPE_CHANGING_STATE_COMPOSITE = 5,
		UI_TYPE_TEXT = 6,
		UI_TYPE_MENU_ENTRY = 7,
		UI_TYPE_LIST = 8,
		UI_TYPE_VIEWPORT = 9,
		UI_TYPE_FRONTEND_SCREEN = 10,
		UI_TYPE_FRONTEND_BUTTON = 11,
		UI_TYPE_FRONTEND_LIST = 12,
		UI_TYPE_SCROLLING_VIEWPORT = 13,
		UI_TYPE_LIST_ARROW = 14,
		UI_TYPE_SLIDER = 15,
		UI_TYPE_TEXT_SLIDER = 16,
		UI_TYPE_MOVIE = 17,
		UI_TYPE_SWAPPING_STATE_COMPOSITE = 18,
		UI_TYPE_SCROLLING_COMPOSITE = 19,
		UI_TYPE_TEXT_CONTAINER = 20,
		UI_TYPE_ZOOMING_COMPOSITE = 21,
		UI_TYPE_COMPONENT_CONTAINER = 22,
		UI_TYPE_SPELL_CONTAINER = 23,
		UI_TYPE_SPELL_CONTAINER_LIST = 24,
		UI_TYPE_YESNO = 25,
		UI_TYPE_OK = 26,
		UI_TYPE_PARTICLE_EFFECT = 27,
		UI_TYPE_CONTROLLERDISCONNECT = 28,
		UI_TYPE_DIRTYDISC = 29,
		UI_TYPE_ICON_TEXT = 30,
		UI_TYPE_DYNAMIC_LIST = 31,
		UI_TYPE_MOUSE_POINTER = 32,
		UI_TYPE_HOVERABLE = 33,
		UI_TYPE_CLICKABLE = 34,
		UI_TYPE_DRAGGABLE = 35,
		UI_TYPE_DRAGGABLE_INTO =  36,
		UI_TYPE_EDIT_BOX		= 37,
		UI_TYPE_NAVIGATION_BUTTON = 38,
		UI_TYPE_KEY_REDEFINER = 39,
		UI_TYPE_REDEFINER_LIST = 40,
		UI_TYPE_SCROLLBAR = 41,
		UI_TYPE_SCROLLBAR_OUTSIDE = 42,
		UI_TYPE_SCROLLABLE_LIST = 43
	};
#else
	enum EType
	{
		UI_TYPE_SPRITE = 0,
		UI_TYPE_MORPHING_SPRITE = 1,
		UI_TYPE_TABLE = 2,
		UI_TYPE_MESH = 3,
		UI_TYPE_COMPOSITE = 4,
		UI_TYPE_CHANGING_STATE_COMPOSITE = 5,
		UI_TYPE_TEXT = 6,
		UI_TYPE_MENU_ENTRY = 7,
		UI_TYPE_LIST = 8,
		UI_TYPE_VIEWPORT = 9,
		UI_TYPE_FRONTEND_SCREEN = 10,
		UI_TYPE_FRONTEND_BUTTON = 11,
		UI_TYPE_FRONTEND_LIST = 12,
		UI_TYPE_SCROLLING_VIEWPORT = 13,
		UI_TYPE_LIST_ARROW = 14,
		UI_TYPE_SLIDER = 15,
		UI_TYPE_TEXT_SLIDER = 16,
		UI_TYPE_MOVIE = 17,
		UI_TYPE_SWAPPING_STATE_COMPOSITE = 18,
		UI_TYPE_SCROLLING_COMPOSITE = 19,
		UI_TYPE_TEXT_CONTAINER = 20,
		UI_TYPE_ZOOMING_COMPOSITE = 21,
		UI_TYPE_COMPONENT_CONTAINER = 22,
		UI_TYPE_SPELL_CONTAINER = 23,
		UI_TYPE_SPELL_CONTAINER_LIST = 24,
		UI_TYPE_YESNO = 25,
		UI_TYPE_OK = 26,
		UI_TYPE_PARTICLE_EFFECT = 27,
		UI_TYPE_CONTROLLERDISCONNECT = 28,
		UI_TYPE_DIRTYDISC = 29,
		UI_TYPE_ICON_TEXT = 30,
		UI_TYPE_DYNAMIC_LIST = 31
	};
#endif


	enum EStateChangeFlag
	{
		UI_STATE_CHANGE_NO_UPDATE = 0,
		UI_STATE_CHANGE_UPDATE_MOVEMENT = 1 << 0,
		UI_STATE_CHANGE_UPDATE_COLOUR = 1 << 1,
		UI_STATE_CHANGE_UPDATE_ZOOM = 1 << 2,
		UI_STATE_CHANGE_UPDATE_GRAPHIC = 1 << 3,
		UI_STATE_CHANGE_USE_OWN_COLOUR = 1 << 4,
		UI_STATE_CHANGE_USE_OWN_POSITION = 1 << 5,
		UI_STATE_CHANGE_USE_OWN_ZOOM = 1 << 6
	};

	enum EActionType
	{
		UI_ACTION_TYPE_NONE = 0,
		UI_ACTION_TYPE_WIELD = 1,
		UI_ACTION_TYPE_AUGMENT = 2,
		UI_ACTION_TYPE_CHANGESTATE = 3,
		UI_ACTION_TYPE_TAKE_BOAST = 4,
		UI_ACTION_TYPE_TELEPORT = 5,
		UI_ACTION_TYPE_TAKE_QUEST = 6,
		UI_ACTION_TYPE_BUY_STAT = 7,
		UI_ACTION_TYPE_BUY_ABILITY = 8,

		// Start MS CraigCo
		UI_ACTION_TYPE_NEXT_SCREEN_OPTIONS = 9,
		UI_ACTION_TYPE_NEXT_SCREEN_LIVE_AWARE = 10,
		UI_ACTION_TYPE_NEXT_SCREEN_EXTRAS = 11,
		UI_ACTION_TYPE_NEXT_SCREEN_AUDIO_OPTIONS = 12,
		UI_ACTION_TYPE_NEXT_SCREEN_VIDEO_OPTIONS = 13,
		UI_ACTION_TYPE_NEXT_SCREEN_CAMERA_OPTIONS = 14,
		UI_ACTION_TYPE_NEW_GAME = 15,
		UI_ACTION_TYPE_NEXT_SCREEN_PROFILES = 16,
		UI_ACTION_TYPE_LOAD_GAME = 17,
		UI_ACTION_TYPE_LOGIN = 18,
		UI_ACTION_TYPE_FRIENDS = 19,
		UI_ACTION_TYPE_APPEAR_OFFLINE = 20,
		// End MS CraigCo

		UI_ACTION_TYPE_DELETE = 21,
		UI_ACTION_TYPE_ADD_CHILD = 22,
		UI_ACTION_TYPE_ADD_CHILD_AUGMENTATION = 23,
		UI_ACTION_TYPE_DELETE_ALL = 24,
		UI_ACTION_TYPE_USE_ITEM = 25,
		UI_ACTION_TYPE_ITEM_ASSIGN_LEFT = 26,
		UI_ACTION_TYPE_ITEM_ASSIGN_RIGHT = 27,
		UI_ACTION_TYPE_ITEM_ASSIGN_DOWN = 28,
		UI_ACTION_TYPE_ITEM_ASSIGN_UP = 29,
		UI_ACTION_TYPE_CLOTHING_WEAR = 30,
		UI_ACTION_TYPE_UPDATE_MANNEQUIN_CLOTHING = 31,

		UI_ACTION_TYPE_BUY = 36,
		UI_ACTION_TYPE_SELL = 37,
		UI_ACTION_TYPE_DELETE_PREVIOUS = 38,
		UI_ACTION_TYPE_RESET_CLOTHING_MANNEQUIN = 39,
		UI_ACTION_TYPE_SET_BRIGHTNESS = 40,
		UI_ACTION_TYPE_SET_SOUND = 41,
		UI_ACTION_TYPE_SET_MUSIC = 42,
		UI_ACTION_TYPE_SET_CAMERA_ROTATION = 43,
		UI_ACTION_TYPE_SET_CAMERA_UP_DOWN = 44,
		UI_ACTION_TYPE_SET_VIBRATION = 45,
		UI_ACTION_TYPE_SET_HEADPHONES = 46,
		UI_ACTION_TYPE_SET_SUBTITLES = 47,
		UI_ACTION_TYPE_OPEN_MAP = 48,
		UI_ACTION_TYPE_OPEN_ABILITIES = 49,
		UI_ACTION_TYPE_OPEN_WEAPONS = 50,
		UI_ACTION_TYPE_OPEN_STATS = 51,
		UI_ACTION_TYPE_OPEN_CLOTHING = 52,
		UI_ACTION_TYPE_OPEN_ITEMS = 53,
		UI_ACTION_TYPE_CLOSE_MAP = 54,
		UI_ACTION_TYPE_CLOSE_ABILITIES = 55,
		UI_ACTION_TYPE_CLOSE_WEAPONS = 56,
		UI_ACTION_TYPE_CLOSE_STATS = 57,
		UI_ACTION_TYPE_CLOSE_CLOTHING = 58,
		UI_ACTION_TYPE_CLOSE_ITEMS = 59,
		UI_ACTION_TYPE_CLOSE_MENU = 60,

		UI_ACTION_TYPE_GUILD_SEAL_RECALL = 61,
		UI_ACTION_TYPE_LOAD = 62,
		UI_ACTION_TYPE_SAVE = 63,
		UI_ACTION_TYPE_CLOSE_PAUSE_MENU = 64,
		UI_ACTION_TYPE_PLAY_MOVIE = 65,
		UI_ACTION_TYPE_NEXT_SCREEN_PROFILES_SAVED_GAMES = 66,
		UI_ACTION_TYPE_NEXT_SCREEN_CREDITS = 67,

		UI_ACTION_TYPE_CONSTRUCT_WEAPONS_LIST = 68,
		UI_ACTION_TYPE_CONSTRUCT_CLOTHING_LIST = 69,
		UI_ACTION_TYPE_CONSTRUCT_ITEMS_LIST = 70,
		UI_ACTION_TYPE_CONSTRUCT_SKILLS_LIST = 71,
		UI_ACTION_TYPE_CONSTRUCT_QUESTS_LIST = 72,
		UI_ACTION_TYPE_CONSTRUCT_MAP_LIST = 73,
		UI_ACTION_TYPE_CONSTRUCT_STATS_LIST = 74,
		UI_ACTION_TYPE_CHANGE_CHILD_STATE = 75,
		UI_ACTION_TYPE_CONSTRUCT_EXPERIENCE_LIST = 76,
		UI_ACTION_TYPE_CONSTRUCT_PERSONALITY_LIST = 77,

		UI_ACTION_TYPE_SET_HUD = 78,
		UI_ACTION_TYPE_CLOSE_QUICK_ACCESS_MENU = 79,
		UI_ACTION_TYPE_CLOSE_TELEPORT_MENU = 80,
		UI_ACTION_TYPE_BUY_BULK = 81,
		UI_ACTION_TYPE_SELL_BULK = 82,
		UI_ACTION_TYPE_SET_TUTORIALS = 83,
		UI_ACTION_TYPE_SET_SHOW_BUDDY_NAMES = 84,
		UI_ACTION_TYPE_QUIT_TO_FRONT_END = 85,

		UI_ACTION_TYPE_PREVIOUS_SCREEN = 86,
		UI_ACTION_TYPE_ACCEPT_CHANGES = 87,
		UI_ACTION_TYPE_SET_DIALOGUE = 88,

		UI_ACTION_TYPE_XLIVE = 89,
		UI_ACTION_TYPE_XLIVE_BACK = 90,
		UI_ACTION_TYPE_LOGOUT = 91,

		UI_ACTION_TYPE_DEMOS = 92, // BUG 16531: Demo menu not functional

		UI_ACTION_TYPE_SET_GUILD_MASTER = 93,
		UI_ACTION_TYPE_SET_HUD_TOOLTIPS = 94,

		UI_ACTION_TYPE_UNDO_BUY_ABILITY = 200,
		UI_ACTION_TYPE_UNDO_BUY_STAT = 201,
		UI_ACTION_TYPE_GIVE_EXCLUSIVE_INPUT = 202,
		UI_ACTION_TYPE_REMOVE_EXCLUSIVE_INPUT = 203,
		UI_ACTION_TYPE_SEND_BACK_EVENT = 204,
		UI_ACTION_TYPE_SHOW_SPELL_SELECTION = 205,
		UI_ACTION_TYPE_SET_SPELL_TO_ASSIGN = 206,
		UI_ACTION_TYPE_TELEPORT_TO_BOAST = 207,
		UI_ACTION_TYPE_DROP_QUEST = 208,
		UI_ACTION_TYPE_ASSIGN_SPELL = 209,
		UI_ACTION_TYPE_UNASSIGN_SPELL = 210,
		UI_ACTION_TYPE_RESET_ASSIGNED_SPELLS = 211,
		UI_ACTION_TYPE_CHANGE_ALPHA = 212,
		UI_ACTION_TYPE_CHANGE_NUMBER = 213,
		UI_ACTION_TYPE_DELETE_PROFILE = 214,
		UI_ACTION_TYPE_GO_TO_DELETE_PROFILE_SCREEN = 215,
		UI_ACTION_TYPE_POP_MAP_STATE = 216,
//		UI_ACTION_TYPE_NEXT_SCREEN_OPTIONS_PROFILES = 217,
//		UI_ACTION_TYPE_NEXT_SCREEN_AUDIO_OPTIONS_PROFILES = 218,
		UI_ACTION_TYPE_NEXT_SCREEN_INVALID_PROFILE = 219,
		UI_ACTION_TYPE_NEXT_SCREEN_INVALID_SAVE = 220,
		UI_ACTION_TYPE_FREE_SPACE_ON_T = 221,
		UI_ACTION_TYPE_FREE_SPACE_ON_U = 222,
		UI_ACTION_TYPE_FLASH_DPAD_DOWN = 223,
		UI_ACTION_TYPE_FLASH_DPAD_UP = 224,
		UI_ACTION_TYPE_FLASH_DPAD_LEFT = 225,
		UI_ACTION_TYPE_FLASH_DPAD_RIGHT = 226,
		UI_ACTION_TYPE_STOP_DPAD_FLASHING = 227,
		UI_ACTION_TYPE_CONSTRUCT_LOGBOOK_LIST = 228,
		UI_ACTION_TYPE_GO_TO_MAIN_MENU_FROM_START = 229,
		UI_ACTION_TYPE_SEND_OWNED_EVENT = 230,
		UI_ACTION_TYPE_SEND_EVENT = 231,
		UI_ACTION_TYPE_MOVE_COMPONENT = 232,
		UI_ACTION_TYPE_EXIT_LIVE_GUI = 233,
		UI_ACTION_TYPE_OPEN_PC_SKILLS_MENU = 234,
		UI_ACTION_TYPE_CONSTRUCT_EXPRESSIONS_LIST = 235,
		UI_ACTION_TYPE_SCROLL_ACTIVE_LIST_UP = 236,
		UI_ACTION_TYPE_SCROLL_ACTIVE_LIST_DOWN = 237,
		UI_ACTION_TYPE_OPEN_PC_INVENTORY_MENU = 238,
		UI_ACTION_TYPE_OPEN_PC_OPTIONS_MENU = 239,
		UI_ACTION_TYPE_CONSTRUCT_PC_STYLE_CARDS_LIST = 240,
		UI_ACTION_TYPE_OPEN_PC_BUY_TRADING_GOODS_LIST = 241,
		UI_ACTION_TYPE_CLOSE_PC_BUY_TRADING_GOODS_LIST = 242,
		UI_ACTION_TYPE_CONSTRUCT_MAGIC_LIST_PC = 243,
		UI_ACTION_TYPE_ASSIGN_SPELL_PC = 244,
		UI_ACTION_TYPE_OBSERVE_EVENT = 245,
		UI_ACTION_TYPE_SET_SPELL_TO_ASSIGN_PC = 246,
		UI_ACTION_TYPE_RESET_ASSIGNED_SPELLS_PC = 247,
		UI_ACTION_TYPE_UNASSIGN_SPELL_PC = 248,
		UI_ACTION_TYPE_IGNORE_EVENT = 249,
		UI_ACTION_TYPE_NEXT_SCREEN_PROFILES_FOR_DELETE = 250,
		UI_ACTION_TYPE_ASSIGN_EXPRESSION_ITEM_PC = 251,
		UI_ACTION_TYPE_UNASSIGN_EXPRESSION_ITEM_PC = 252,
		UI_ACTION_TYPE_SET_EXPRESSION_ITEM_TO_ASSIGN_PC = 253,
		UI_ACTION_TYPE_OPEN_PC_MAP_MENU = 254,
		UI_ACTION_TYPE_OPEN_PC_STATUS_MENU = 255,
		UI_ACTION_TYPE_OPEN_PC_LOG_BOOK = 256,
		UI_ACTION_TYPE_CONSTRUCT_PC_QUESTS_LIST = 257,
		UI_ACTION_TYPE_SET_RESOLUTION = 258,
		UI_ACTION_TYPE_SET_SHADOW_DETAIL = 259,
		UI_ACTION_TYPE_SET_DECALS = 260,
		UI_ACTION_TYPE_SET_WEATHER_EFFECTS = 261,
		UI_ACTION_TYPE_SET_VERTICAL_SYNC = 262,
		UI_ACTION_TYPE_SET_GLOW_EFFECTS = 263,
		UI_ACTION_TYPE_SET_REVERSE_STEREO = 264,
		UI_ACTION_TYPE_SET_ANTIALIASING = 265,
		UI_ACTION_TYPE_SET_TEXTURE_DETAIL = 266,
		UI_ACTION_TYPE_SET_MESH_RESOLUTION = 267,
		UI_ACTION_TYPE_SET_WATER_REFLECTION = 268,
		UI_ACTION_TYPE_SET_LANDSCAPE_DETAIL = 269,
		UI_ACTION_TYPE_SET_PARTICLE_DETAIL = 270,
		UI_ACTION_TYPE_ADD_OBSERVER = 271,
		UI_ACTION_TYPE_SCROLL_ACTIVE_LIST_UNTIL_CHILD_CONTAINING = 272,
		UI_ACTION_TYPE_GO_BACK = 273,
		UI_ACTION_TYPE_CLOSE_ACTIVE_MENU = 274,
		UI_ACTION_TYPE_REMOVE_OBSERVER = 275,
		UI_ACTION_TYPE_TAVERN_GAME_BET_DOWN = 276,
		UI_ACTION_TYPE_TAVERN_GAME_BET_UP = 277,
		UI_ACTION_TYPE_RESPAWN = 278,
		UI_ACTION_TYPE_CONTINUE = 279,
		UI_ACTION_TYPE_OPEN_PC_SELL_TRADING_GOODS_LIST = 280,
		UI_ACTION_TYPE_OPEN_PC_WANTED_TRADING_GOODS_LIST = 281,
		UI_ACTION_TYPE_CONSTRUCT_PC_EXPERIENCE_LIST = 282,
		UI_ACTION_TYPE_GO_TO_REDEFINE_KEYS_MENU = 283,
		UI_ACTION_TYPE_RESET_KEYS = 284,
		UI_ACTION_TYPE_ASSIGN_SPELL_TO_ITEM_SLOT_PC = 285,
		UI_ACTION_TYPE_CONSTRUCT_STYLE_CARDS_LIST = 286,
		UI_ACTION_TYPE_SCROLL_DESCRIPTION_DOWN = 287,
		UI_ACTION_TYPE_SCROLL_DESCRIPTION_UP = 288,
		UI_ACTION_TYPE_CONSTRUCT_PC_PERSONALITY_LIST = 289,
		UI_ACTION_TYPE_SEND_OWNED_EVENT_FORCE_OBSERVATION = 291,
		UI_ACTION_TYPE_GO_TO_MAIN_MENU_FROM_PROFILE_LIST = 292,
		UI_ACTION_TYPE_NEW_PROFILE = 293,
		UI_ACTION_TYPE_NEW_PROFILE_RETURN_PRESSED = 294,
		UI_ACTION_TYPE_NEW_PROFILE_ESCAPE_PRESSED = 295,
		UI_ACTION_TYPE_QUIT_GAME = 296,
		UI_ACTION_TYPE_NEXT_SCREEN_OPTIONS_SUB_MENU = 297,
		UI_ACTION_TYPE_SET_MESH_DETAIL = 298,
		UI_ACTION_TYPE_SET_EFFECTS_DETAIL = 299,
		UI_ACTION_TYPE_SET_SCREEN_ASPECT_RATIO = 300,
		UI_ACTION_TYPE_APPLY_PROFILE_VALUES = 301,
		UI_ACTION_TYPE_CLOSE_ACTIVE_TRADE_MENU = 302,
		UI_ACTION_TYPE_SCROLL_ACTIVE_LIST_DOWN_MAX = 303,
		UI_ACTION_TYPE_SCROLL_ACTIVE_LIST_UP_MAX = 304,
		UI_ACTION_TYPE_SCROLL_DESCRIPTION_DOWN_MAX = 305,
		UI_ACTION_TYPE_SCROLL_DESCRIPTION_UP_MAX = 306,
		UI_ACTION_TYPE_SCROLL_DESCRIPTION_DOWN_ONE_PIXEL = 307,
		UI_ACTION_TYPE_SCROLL_DESCRIPTION_UP_ONE_PIXEL = 308,
		UI_ACTION_TYPE_CLOSE_TRADE_MENU_IF_LEAF = 309,
		UI_ACTION_TYPE_EXIT_LIVE_GUI_IF_LEAF = 310,
		UI_ACTION_TYPE_RESET_KEYS_WASD = 311,
		UI_ACTION_TYPE_NEXT_SCREEN_OPTIONS_SCOREBOARD = 312,
		UI_ACTION_TYPE_SET_CONTROL_METHOD = 313,
		UI_ACTION_TYPE_GOTO_QUIT_PROMPT = 314,
		UI_ACTION_TYPE_PC_QUIT_TO_FRONT_END = 315,
		UI_ACTION_TYPE_PC_ACCEPT_VIDEO_CHANGES = 316,
		UI_ACTION_TYPE_SET_REFRESH_RATE = 317,
		UI_ACTION_TYPE_SET_CAMERA_SENSITIVITY = 318,
		UI_ACTION_TYPE_SET_BOW_CAMERA = 319,
		UI_ACTION_TYPE_SET_CAMERA_RESETTING = 320,
		UI_ACTION_TYPE_GOTO_ABOUT_SCREEN = 321,
		UI_ACTION_TYPE_CLOSE_FRAME = 322,
		UI_ACTION_TYPE_SET_SHOW_TARGETING_STATUS = 323,
		UI_ACTION_TYPE_RESTORE_DEFAULTS_GAMEPLAY = 324,
		UI_ACTION_TYPE_RESTORE_DEFAULTS_VIDEO = 325,
		UI_ACTION_TYPE_RESTORE_DEFAULTS_AUDIO = 326,
		UI_ACTION_TYPE_SET_EXPRESSION_ITEM_TO_ASSIGN_SWAPPING_PC = 327,
		UI_ACTION_TYPE_SET_SPELL_TO_ASSIGN_SWAPPING_PC = 328,
		UI_ACTION_TYPE_SET_SPELL_TO_ASSIGN_IN_ITEMS_SWAPPING_PC = 329,

		//ATTENTION 2000 is Taks!
		UI_ACTION_ADD_MESH_CHILD				= 2000,
		UI_ACTION_LOAD_WEAPON_DESC				= 2001,
		UI_ACTION_LOAD_CLOTHING_DESC			= 2002,
		UI_ACTION_LOAD_ITEM_DESC				= 2003,
		UI_ACTION_LOAD_WEAPON_MENU_ENTRY_NAME	= 2004,
		UI_ACTION_LOAD_CLOTHING_MENU_ENTRY_NAME	= 2005,
		UI_ACTION_LOAD_ITEM_MENU_ENTRY_NAME		= 2006,
		UI_ACTION_LOAD_SELL_ITEM_DESC			= 2007,
		UI_ACTION_LOAD_SELL_ACTION_MENU			= 2008,
		UI_ACTION_LOAD_BUY_ITEM_DESC			= 2009,
		UI_ACTION_LOAD_BUY_ACTION_MENU			= 2010,
		UI_ACTION_LOAD_WANTED_ITEM_DESC			= 2011,
		UI_ACTION_LOAD_QUICK_MENU_EXPRESSIONS_ICON	= 2012,
		UI_ACTION_LOAD_FILE_DESC				= 2013,
		UI_ACTION_LOAD_FILE_SAVEGAME_MINIMAP	= 2014,
		UI_ACTION_REMOVE_MESH_CHILD				= 2015,
		UI_ACTION_UNLOAD_WEAPON_DESC			= 2016,
		UI_ACTION_UNLOAD_CLOTHING_DESC			= 2017,
		UI_ACTION_UNLOAD_ITEM_DESC				= 2018,
		UI_ACTION_UNLOAD_SELL_ITEM_DESC			= 2019,
		UI_ACTION_UNLOAD_SELL_ACTION_MENU		= 2020,
		UI_ACTION_UNLOAD_BUY_ITEM_DESC			= 2021,
		UI_ACTION_UNLOAD_BUY_ACTION_MENU		= 2022,
		UI_ACTION_UNLOAD_WANTED_ITEM_DESC		= 2023,

		// ATTENTION 3000 and onwards is reserved for Thanos !
		UI_ACTION_TYPE_CHEAT_MORALITY			= 3000,
		UI_ACTION_TYPE_CHEAT_RENOWN				= 3001,
		UI_ACTION_TYPE_CLOSE_BOAST_MENU			= 3002,
		UI_ACTION_TYPE_PLAY_SOUND				= 3003,
		UI_ACTION_TYPE_TAKE_QUEST_FOR_BOAST		= 3004,
		UI_ACTION_TYPE_OPEN_PC_MSN_CHAT			= 3005, 
		UI_ACTION_TYPE_ACTIVATE_MSN_CONVERSATION = 3006,
		UI_ACTION_TYPE_SEND_MESSAGE				= 3007,
		UI_ACTION_TYPE_SELECT_CONTACT			= 3008,
		UI_ACTION_TYPE_SCROLL_VIEWPORT_UP		= 3009,
		UI_ACTION_TYPE_SCROLL_VIEWPORT_DOWN		= 3010,
		UI_ACTION_TYPE_SCROLL_LIST_DOWN			= 3011,
		UI_ACTION_TYPE_SCROLL_LIST_UP			= 3012, 
		UI_ACTION_TYPE_OPEN_SCOREBOARD			= 3013,
		UI_ACTION_TYPE_CHOOSE_CLAN				= 3014, 
		UI_ACTION_TYPE_PHOTO_CAPTION			= 3015,
		UI_ACTION_TYPE_DISCARD_PHOTO			= 3016,
		UI_ACTION_TYPE_GO_TO_SCOREBOARD_SCREEN  = 3017, 
		UI_ACTION_TYPE_ACTIVATE_EDITBOX			= 3018, 
		UI_ACTION_TYPE_DEACTIVATE_EDITBOX		= 3019,
		UI_ACTION_TYPE_SET_EDITBOX_VALUES		= 3020,
		UI_ACTION_TYPE_SCOREBOARD_OK			= 3021, 
		UI_ACTION_TYPE_LOAD_PHOTO				= 3022, 
		UI_ACTION_TYPE_SCROLL_PHOTO_DOWN		= 3023,
		UI_ACTION_TYPE_SCROLL_PHOTO_UP			= 3024,
		UI_ACTION_TYPE_NEXT_SCREEN_START		= 3025,

		// 4000s are Ben's
		UI_ACTION_TYPE_OPEN_PHOTOJOURNAL		= 4000,
		UI_ACTION_TYPE_OPEN_PHOTO				= 4001,
		UI_ACTION_TYPE_EXIT_PHOTOJOURNAL_CAPTURE = 4002,
	};

	enum EEvent
	{
		UI_EVENT_UP						= 0,
		UI_EVENT_DOWN					= 1,
		UI_EVENT_LEFT					= 2,
		UI_EVENT_RIGHT					= 3,

		// Start MS CraigCo
		UI_EVENT_SELECT					= 4,
		UI_EVENT_BACK					= 5,
		// End MS CraigCo

		UI_EVENT_RIGHT_STICK_UP			= 6,
		UI_EVENT_RIGHT_STICK_DOWN		= 7,
		UI_EVENT_KEYBOARD_ARROWLEFT		= 8,
		UI_EVENT_KEYBOARD_ARROWRIGHT	= 9,
		UI_EVENT_KEYBOARD_SPACE			= 10,
		UI_EVENT_KEYBOARD_BACKSPACE		= 11,
		UI_EVENT_ZOOM_IN				= 12,
		UI_EVENT_ZOOM_OUT				= 13,
		UI_EVENT_SPELL_ROTATE_LEFT		= 14,
		UI_EVENT_SPELL_ROTATE_RIGHT		= 15,
		UI_EVENT_SPELL_LIST_UP			= 16,
		UI_EVENT_SPELL_LIST_DOWN		= 17,
		UI_EVENT_SPELL_ASSIGN			= 18,
		UI_EVENT_SPELL_UNASSIGN			= 19,
		UI_EVENT_SLIDER_LEFT			= 20,
		UI_EVENT_SLIDER_RIGHT			= 21,
		UI_EVENT_DELETE					= 22,
		UI_EVENT_X						= 23,
		UI_EVENT_Y						= 24,
		UI_EVENT_MOUSE_MOVEMENT			= 25,
		UI_EVENT_LEFT_MOUSE_CLICK		= 26,
		UI_EVENT_RIGHT_MOUSE_CLICK		= 27,
		UI_EVENT_LEFT_MOUSE_RELEASE		= 28,
		UI_EVENT_RIGHT_MOUSE_RELEASE	= 29,
		UI_EVENT_COMPONENT_DROPPED		= 30,
		UI_EVENT_LEFT_MOUSE_HELD		= 31,
		UI_EVENT_RIGHT_MOUSE_HELD		= 32,
		UI_EVENT_KEY_DOWN				= 33, 
		UI_EVENT_CHAR_DOWN				= 34,
		UI_EVENT_MIDDLE_MOUSE_CLICK		= 35,
		UI_EVENT_MOUSE_WHEEL_UP			= 36,
		UI_EVENT_MOUSE_WHEEL_DOWN		= 37,
		UI_EVENT_MOUSE_BUTTON_4_CLICK	= 38,
		UI_EVENT_MOUSE_BUTTON_5_CLICK	= 39,
		UI_EVENT_MOUSE_BUTTON_6_CLICK	= 40,
		UI_EVENT_MOUSE_BUTTON_7_CLICK	= 41,
		UI_EVENT_MOUSE_BUTTON_8_CLICK	= 42,
	};

	enum EActionParamType
	{
		UI_ACTION_PARAM_TYPE_NONE = 0,
		UI_ACTION_PARAM_TYPE_COMPONENT = 1,
		UI_ACTION_PARAM_TYPE_STATE = 2,
		UI_ACTION_PARAM_TYPE_SLONG = 3,
		UI_ACTION_PARAM_TYPE_STRING = 4,
		UI_ACTION_PARAM_TYPE_ULONG = 5,
		UI_ACTION_PARAM_TYPE_FLOAT = 6,
		UI_ACTION_PARAM_TYPE_DATE_AND_TIME = 7,
		UI_ACTION_PARAM_TYPE_EBOOL = 8,
		UI_ACTION_PARAM_TYPE_COUNTED_POINTER = 9,
		UI_ACTION_PARAM_TYPE_2DVECTOR = 10,
	};

	enum ETextAlignement
	{
		LEFT = 0,
		CENTER = 1,
		RIGHT = 2
	};
}

#endif //__UI_TYPES_H__
