#pragma once
#ifndef __THING_DEF_H__
#define __THING_DEF_H__

//--------------------------------------------------------------------
enum	ESex
{
	SEX_NULL = 0,
	SEX_MALE,
	SEX_FEMALE,
	NO_OF_SEXES,
};

//--------------------------------------------------------------------
enum EClothingCoversArea
{
	COVERS_BODY_AREA_NULL		= 0,
	COVERS_BODY_AREA_FEET		= 1<<0,
	COVERS_BODY_AREA_LEGS		= 1<<1,
	COVERS_BODY_AREA_ARSE		= 1<<2,
	COVERS_BODY_AREA_BODY		= 1<<3,
	COVERS_BODY_AREA_HEAD		= 1<<4,
	COVERS_BODY_AREA_ARMS		= 1<<5,
	COVERS_BODY_AREA_HANDS		= 1<<6,
	COVERS_BODY_AREA_FACE		= 1<<7,
	COVERS_BODY_AREA_MOUSTACHE	= 1<<8,
	COVERS_BODY_AREA_HORN		= 1<<9,
};

//--------------------------------------------------------------------
//Specific to the tattoos - to differentiate SHOULDERS from BACK from CHEST
enum ETattooSpecificCoversArea
{
	TATTOO_COVERS_AREA_NULL				= 0,
	TATTOO_COVERS_AREA_SHOULDERS_FRONT	= 1<<0,
	TATTOO_COVERS_AREA_SHOULDERS_BACK	= 1<<1,
	TATTOO_COVERS_AREA_CHEST			= 1<<2,
	TATTOO_COVERS_AREA_BACK				= 1<<3,
};

//--------------------------------------------------------------------
//These are in order of 'replaceability'
enum EHeroAttachableAppearanceModifierType
{
	APPEARANCE_HAIR = 0,
	APPEARANCE_HORN,
	APPEARANCE_CLOTHING,
	NO_OF_APPEARANCE_MODIFIER_TYPES,
};

//--------------------------------------------------------------------
enum EAppearanceModifierScalingType
{
	APPEARANCE_MOD_SCALE_CLOTHES = 0,
	APPEARANCE_MOD_SCALE_HAIR,
	APPEARANCE_MOD_SCALE_BEARDS,
	APPEARANCE_MOD_SCALE_TASHES,
	APPEARANCE_MOD_SCALE_TATTOOS,
	NO_OF_APPEARANCE_MOD_SCALE_TYPES,
};

//--------------------------------------------------------------------
enum EClothingSuitPart
{
	CLOTHING_SUIT_NULL = 0,
	CLOTHING_SUIT_HEAD,
	CLOTHING_SUIT_BODY,
	CLOTHING_SUIT_HANDS,
	CLOTHING_SUIT_LEGS,
	CLOTHING_SUIT_FEET,
};

//--------------------------------------------------------------------
enum EObjectProperty
{
	THING_OBJECT_PROPERTY_NULL				= 0,
	THING_OBJECT_PROPERTY_HAND_LAMP			= 1<<0,
	THING_OBJECT_PROPERTY_CROP				= 1<<1,
	THING_OBJECT_PROPERTY_LANDSCAPE_FEATURE	= 1<<2,
	THING_OBJECT_PROPERTY_CAGE				= 1<<3,
	THING_OBJECT_PROPERTY_SAWHORSE			= 1<<4,
	THING_OBJECT_PROPERTY_GUILD_SEAL		= 1<<5,
	THING_OBJECT_PROPERTY_ANVIL				= 1<<6,
	THING_OBJECT_PROPERTY_SIGNPOST			= 1<<7,
	THING_OBJECT_PROPERTY_UNLIT_TORCH		= 1<<8,
	THING_OBJECT_PROPERTY_LIT_TORCH			= 1<<9,
	THING_OBJECT_PROPERTY_MONEY				= 1<<10,
	THING_OBJECT_PROPERTY_WELL				= 1<<11,
	THING_OBJECT_PROPERTY_SHIP				= 1<<12,
	THING_OBJECT_PROPERTY_SUNBEAM			= 1<<13,
	THING_OBJECT_PROPERTY_CAMPFIRE			= 1<<14,
	THING_OBJECT_PROPERTY_HOPSCOTCH_BOARD	= 1<<15,
	THING_OBJECT_PROPERTY_SEAT				= 1<<16,
	THING_OBJECT_PROPERTY_BENCH				= 1<<17,
	THING_OBJECT_PROPERTY_BED				= 1<<18,
	THING_OBJECT_PROPERTY_COOKING_POT		= 1<<19,
	THING_OBJECT_PROPERTY_CUPBOARD			= 1<<20,
	THING_OBJECT_PROPERTY_CRATE_PILE		= 1<<21,
	THING_OBJECT_PROPERTY_LOG_PILE			= 1<<22,
	THING_OBJECT_PROPERTY_CANDLE			= 1<<23,
	THING_OBJECT_PROPERTY_HORN				= 1<<24,
	THING_OBJECT_PROPERTY_AUTO_PICKUP		= 1<<25,
	THING_OBJECT_PROPERTY_WORK_SPOT			= 1<<26,
	THING_OBJECT_PROPERTY_STEALABLE_ITEM	= 1<<27,
	THING_OBJECT_PROPERTY_TOWN_GATE			= 1<<28,
};

//--------------------------------------------------------------------
enum EBuildingProperty
{
	THING_BUILDING_PROPERTY_NULL = 0,
};

//--------------------------------------------------------------------
enum EShotProperty
{
	THING_SHOT_PROPERTY_NULL = 0,
	THING_SHOT_PROPERTY_CREATES_FIRE,
	THING_SHOT_PROPERTY_WILL,
};

//--------------------------------------------------------------------
enum EThingCreatureProperty
{
	THING_CREATURE_PROPERTY_NULL = 0,
	THING_CREATURE_PROPERTY_IS_MINION,
	THING_CREATURE_PROPERTY_ANNOYABLE_BY_KIDS,
	THING_CREATURE_PROPERTY_GUARD,
	THING_CREATURE_PROPERTY_FIREFLY,
};

//--------------------------------------------------------------------
enum EMarkerProperty
{
	THING_MARKER_PROPERTY_NULL					= 0,
	THING_MARKER_PROPERTY_STEALABLE_DESTINATION	= 1<<0,
};

//--------------------------------------------------------------------
enum ECreatureInteractionType
{
	CREATURE_INTERACTION_NULL			= 0,
	CREATURE_INTERACTION_CONVERSATION	= 1<<0,
	CREATURE_INTERACTION_TAG			= 1<<1,
	CREATURE_INTERACTION_MULTI_TAG		= 1<<2,
	CREATURE_INTERACTION_PURCHASING		= 1<<3,
};

//--------------------------------------------------------------------
enum ETargetingType
{
	TARGETING_NULL			= 0,
	TARGETING_USABLE		= 1<<0,
	TARGETING_TALKABLE		= 1<<1,
	TARGETING_STAB			= 1<<2,
	TARGETING_SHOOTABLE		= 1<<3,
	TARGETING_MELEE			= 1<<4,
	TARGETING_ZTARGETING	= 1<<5,
};

//--------------------------------------------------------------------
enum EHighlightingCursorType
{
	CURSOR_TYPE_NONE = 0,
	CURSOR_TYPE_USABLE,
	CURSOR_TYPE_ENEMY,
	CURSOR_TYPE_ALLY,
	CURSOR_TYPE_HAS_INFORMATION,
	MAX_NO_CURSOR_TYPES,
};

//--------------------------------------------------------------------
enum EControlledMovementType
{
	CONTROLLED_MOVEMENT_NULL = 0,
	CONTROLLED_MOVEMENT_WALKING,
	CONTROLLED_MOVEMENT_FLYING,
	CONTROLLED_MOVEMENT_FIRST_PERSON,
};

//--------------------------------------------------------------------
enum ECreatureType
{
	NOT_HUMAN,
	HUMAN_CHILD,
	HUMAN_ADULT,
	HUMAN_ELDERLY,
};

//--------------------------------------------------------------------
enum EBodyLocation
{
	BODY_LOCATION_NULL=0,
	BODY_LOCATION_FACE,
	BODY_LOCATION_LEFT_LEG,
	BODY_LOCATION_RIGHT_LEG,
	BODY_LOCATION_LEFT_ARM,
	BODY_LOCATION_RIGHT_ARM,
	BODY_LOCATION_TORSO,
	MAX_NO_BODY_LOCATIONS,
};

//--------------------------------------------------------------------
enum EHeroMorphType
{
	HERO_MORPH_NONE,
	HERO_MORPH_TAN,
	HERO_MORPH_ANTITAN,
	HERO_MORPH_BEARD,
	HERO_MORPH_HAIR_AGE,
	HERO_MORPH_SKIN_AGE,
	HERO_MORPH_EVIL,
	HERO_MORPH_GOOD,
	HERO_MORPH_MUSCLE_DEFINITION,
	HERO_MORPH_MUSCLE_DEFINITION_STOMACH,
	HERO_MORPH_WILL,
	HERO_MORPH_BODY_HAIR,
	HERO_MORPH_STRENGTH_ABOVE_AVERAGE,
	HERO_MORPH_STRENGTH_BELOW_AVERAGE,
	HERO_MORPH_FAT,
	HERO_MORPH_SKILL,
	HERO_MORPH_BALD,
	HERO_MORPH_BESERK,
	HERO_MORPH_TEENAGE,
	NO_HERO_MORPHS
};

//--------------------------------------------------------------------
enum EMeshLocationPoint
{
	MESH_LOCATION_NONE=0,
	MESH_LOCATION_POS,
	MESH_LOCATION_DUMMY,
	MESH_LOCATION_HELPER,
};

//--------------------------------------------------------------------
enum EBodyPartType
{
	BODY_PART_HEAD,
	BODY_PART_TORSO,
	BODY_PART_LEGS,
	MAX_NO_BODY_PARTS
};

//--------------------------------------------------------------------
//Do not change the order of these, or saving/loading will screw up.
enum EHeroCentreDoorType
{
	GUILD_DOOR_NULL,
	GUILD_DOOR_TRAINING,
	GUILD_DOOR_SAVE_AND_LOAD,
};

//--------------------------------------------------------------------
enum EGiftType
{
	GIFT_TYPE_FRIENDLY,
	GIFT_TYPE_ROMANTIC,
	GIFT_TYPE_OFFENSIVE,
};

//--------------------------------------------------------------------
enum EObjectAugmentationType
{
	AUGMENTATION_NULL					= 0,
	AUGMENTATION_EXTRA_DAMAGE			= 1 << 0,
	AUGMENTATION_SILVER					= 1 << 1,
	AUGMENTATION_FLAME					= 1 << 2,
	AUGMENTATION_LIGHTNING				= 1 << 3,
	AUGMENTATION_DIAMOND				= 1 << 4,
	AUGMENTATION_HEALTH_REGENERATION	= 1 << 5,
	AUGMENTATION_STAMINA_REGENERATION	= 1 << 6,
	AUGMENTATION_EXPERIENCE_INCREASE	= 1 << 7,
	AUGMENTATION_HOBBE_KILLER			= 1 << 8,
	AUGMENTATION_BANDIT_KILLER			= 1 << 9,
};

//--------------------------------------------------------------------
enum EDamageAttribute
{
	DAMAGE_NULL = -1,
	DAMAGE_MELEE,
	DAMAGE_MELEE_UNARMED,
	DAMAGE_LIGHTNING,
	DAMAGE_FIRE,
	DAMAGE_PROJECTILE,
	DAMAGE_EXPLOSION,
	DAMAGE_DRAIN,
	DAMAGE_DRAIN_HEAL,
	DAMAGE_GENERIC_WILL,
	DAMAGE_DIVINE_WRATH,
	DAMAGE_UNHOLY_POWER,
};

//--------------------------------------------------------------------
enum EAttackHistoryType
{
	ATTACK_SAME = 0,
	ATTACK_DIFFERENT,
	ATTACK_SPECIFIC,
};

//--------------------------------------------------------------------
enum EOccupyType
{
	OCCUPY_TYPE_NONE					= 0,
	OCCUPY_TYPE_COVER					= 1 << 0,
	OCCUPY_TYPE_SLEEP_POINT				= 1 << 1,
	OCCUPY_TYPE_PREFERRED_FIRE_POINT	= 1 << 2,
};

//--------------------------------------------------------------------
enum ECreatureGeneratorGenerateType
{
	GENERATE_NORMAL = 0,
	GENERATE_AMBUSH_DROP_IN,
	GENERATE_AMBUSH_JUMP_OUT,
	GENERATE_GENERATOR_ANIMATION,
	GENERATE_UNDEAD,
};

//-----------------------------------------------------------------------------------------------
enum ECreatureGroup
{
	CREATURE_GROUP_NULL					= 0,

	CREATURE_GROUP_VILLAGER				= 1<<0,
	CREATURE_GROUP_GUARD				= 1<<1,
	CREATURE_GROUP_BANDIT				= 1<<2,
	CREATURE_GROUP_BALVERINE			= 1<<3,
	CREATURE_GROUP_WHITE_BALVERINE		= 1<<4,
	CREATURE_GROUP_HOBBE				= 1<<5,
	CREATURE_GROUP_HOBBE_SPELL_CASTER	= 1<<6,
	CREATURE_GROUP_SCREAMER				= 1<<7,
	CREATURE_GROUP_WASP					= 1<<8,
	CREATURE_GROUP_SCORPION				= 1<<9,
	CREATURE_GROUP_UNDEAD				= 1<<10,
	CREATURE_GROUP_UNDEAD_LIEUTENANT	= 1<<11,
	CREATURE_GROUP_RIVAL_HERO			= 1<<12,
	CREATURE_GROUP_NYMPH				= 1<<13,
	CREATURE_GROUP_MINION				= 1<<14,
	CREATURE_GROUP_EARTH_TROLL			= 1<<15,
	CREATURE_GROUP_ROCK_TROLL			= 1<<16,
	CREATURE_GROUP_DRAGON				= 1<<17,
	CREATURE_GROUP_BEETLE				= 1<<18,
	CREATURE_GROUP_SCORPION_KING		= 1<<19,
	CREATURE_GROUP_KRAKEN				= 1<<20,
	CREATURE_GROUP_KRAKEN_TENTACLE		= 1<<21,
	CREATURE_GROUP_WASP_QUEEN			= 1<<22,
	CREATURE_GROUP_FAMILY_MEMBER		= 1<<23,
	CREATURE_GROUP_BIRD					= 1<<24,
	CREATURE_GROUP_ICE_TROLL			= 1<<25,
	CREATURE_GROUP_SUMMONER				= 1<<26,

	CREATURE_GROUP_ALL_COMBINED			= -1	// emphatically not to be assigned to any individual creature in the defs.
};

//-----------------------------------------------------------------------------------------------
enum EMorality
{
	MORALITY_SUPER_EVIL,
	MORALITY_VERY_EVIL,
	MORALITY_EVIL,
	MORALITY_NEUTRAL,
	MORALITY_GOOD,
	MORALITY_VERY_GOOD,
	MORALITY_SUPER_GOOD,
};

//-----------------------------------------------------------------------------------------------
// Feats

enum EFeatAttackType
{
	FAT_ATTACK_ANY = 0, // default
	FAT_ATTACK_SWORD,
	FAT_ATTACK_BOW,
	FAT_ATTACK_HANDS,
	FAT_ATTACK_WILL,
};


//-----------------------------------------------------------------------------------------------
// Expression Types
enum EExpressionInventoryType
{
	EXPRESSION_INVENTORY_SOCIAL = 0,
	EXPRESSION_INVENTORY_RENOWN,
	EXPRESSION_INVENTORY_ALIGNMENT,
	EXPRESSION_INVENTORY_STEALTH,
	NUM_INVENTORY_EXPRESSIONS,
};


//-----------------------------------------------------------------------------------------------
// Quite bizarrely, separate categories for inventory items
enum EUIInventoryCategory
{
	UI_INVENTORY_CATEGORY_TROPHIES = 0,
	UI_INVENTORY_CATEGORY_POTIONS,
	UI_INVENTORY_CATEGORY_GIFTS,
	UI_INVENTORY_CATEGORY_PRODUCE,
	UI_INVENTORY_CATEGORY_OTHER,
	NUM_UI_INVENTORY_CATEGORIES,
};


#endif // __THING_DEF_H__
