#pragma once
#ifndef __PHYSICS_DEF_H__
#define __PHYSICS_DEF_H__

//---------------------------------------------------------------------------------------------------------------------------------
//	PHYSICS_COLLIDE_LANDSCAPE		:	can collide with the landscape
//	PHYSICS_COLLIDE_THINGS			:	will respond to hitting into other things.  no game code will be called relating to the collision.
//	PHYSICS_INTERACT_THINGS			:	will call game code relating to collisions.  no response to hitting this thing is implied.
//	PHYSICS_IMMOVEABLE				:	this thing cannot, and will not move
//	PHYSICS_ALWAYS_FACE_MOVEMENT_DIRECTION : this thing will always face the direction of movement.  not supported.
//	PHYSICS_PRESERVE_KE				:	preserve the kinetic energy from one frame to another - will not work with players/navigators.
//	PHYSICS_ANGLED_WITH_GROUND		:	this thing will set it's angles up so it's flat on the ground surface it's sitting on
//	PHYSICS_STANDARD_COLLIDE_WITH_IMPASSABLE_LANDSCAPE	:	this will make the thing collide with impassable landscape. Navigators and controlled physics have this by default
//  PHYSICS_EXCLUDE_CREATURES		:	this thing will exclude creatures from its collision paths
//  PHYSICS_IMPASSABLE				:	this thing is impassable ONLY by controlled physics types
//---------------------------------------------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------------------------------------------
enum EPhysicsInteractionType
{
	PHYSICS_NULL = 0,
	PHYSICS_COLLIDE_LANDSCAPE = 1<<1,
	PHYSICS_COLLIDE_THINGS = 1<<2,
	PHYSICS_COLLIDE_THINGS_ONEWAY = 1<<3,
	PHYSICS_INTERACT_THINGS = 1<<4,
	PHYSICS_IMMOVEABLE = 1<<5,
	PHYSICS_ALWAYS_FACE_MOVEMENT_DIRECTION = 1<<6,
	PHYSICS_PRESERVE_KE = 1<<7,
	PHYSICS_ANGLED_WITH_GROUND = 1<<8,
	PHYSICS_STANDARD_COLLIDE_WITH_IMPASSABLE_LANDSCAPE = 1<<9,
	PHYSICS_EXCLUDE_CREATURES = 1<<10,
	PHYSICS_IMPASSABLE = 1<<11,
};

//---------------------------------------------------------------------------------------------------------------------------------
enum EHitLocationFlags
{
	COLLISION_DETECT_NULL = 0,
	COLLISION_DETECT_COMBAT,
	COLLISION_DETECT_PHYSICS,
};

#endif //__PHYSICS_DEF_H__
