//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BASE
				<CActionUseDef>
				<\CActionUseDef>

				<CTargetingDef>
//					RangeSpecialAbility		20.0;
					TargetingRanges[TARGETING_USABLE]		4.0;
					TargetingRanges[TARGETING_TALKABLE]		6.0;
					TargetingRanges[TARGETING_STAB]			2.5;
					TargetingRanges[TARGETING_SHOOTABLE]	28.0;
					TargetingRanges[TARGETING_MELEE]		14.0;
				<\CTargetingDef>

				Components.Add("CTCHitLocations");
				<CHitLocationsDef>
					HitLocations.Add(HIT_LOCATION_PHYSICS_MESH);
				<\CHitLocationsDef>
				
				<CEntitySoundDef>
					SoundMap.AddCriteria("FIRE_DEFAULT", "ON_FIRE");
				<\CEntitySoundDef>	

				IsDrawable				TRUE;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_FENCE_TEMPLATE specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Damageable				FALSE;

					IsFragile				FALSE;

					OnDeathObject			NULL;			
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;

					GroupDef				GO_BOUNDARIES;
					
					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					AlwaysFrameUpdate		FALSE;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					RenderFadeDistance		THING_FADE_DIST_MEDIUM_SHORT;
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE | PHYSICS_IMPASSABLE;
					<\CPhysicsDef>
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_FENCE_PLACEABLE_TEMPLATE  specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Damageable				FALSE;

					IsFragile				FALSE;

					OnDeathObject			NULL;
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;

					GroupDef				GO_BOUNDARIES;
					
					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM_SHORT;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_TREE_TEMPLATE  specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Damageable				FALSE;

					IsFragile				FALSE;

					Material				MATERIAL_WOOD;
					OnDeathObject			NULL;
					
					GroupDef				GO_NATURE;			
				
                    Health                  6000;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					Property				THING_OBJECT_PROPERTY_LANDSCAPE_FEATURE;
					AlwaysFrameUpdate		FALSE;

					FloorMaterial			MATERIAL_WOOD;
					RenderFadeDistance		THING_FADE_DIST_LONG;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");

					Components.Add("CTCSinglePersonOccupiable");
					
					<COccupiableDef>
						TypeFlags			OCCUPY_TYPE_COVER;
					<\COccupiableDef>

					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BUILDING_DOOR_TEMPLATE   specialises OBJECT_BASE
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;
					Health					1;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable				FALSE;
					AlwaysFrameUpdate		FALSE;
					CanComeBetweenCameraAndObservedThing	FALSE;

					<CDoorDef>
						TriggerType		DOOR_TRIGGER_ON_PERSON;
					<\CDoorDef>

					Components.Add("CTCPhysicsStandard");
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>

					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceAnimatedMesh");
					Components.Add("CTCAnimationComplex");
					Components.Add("CTCDoor");
					Components.Add("CTCEntityEvents");
					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
					<\CTargetingDef>
					
					PersistenceFlags	EPF_MOVING;
					
					<CEntitySoundDef>
						SoundMap.AddSingle("DOOR_OPEN", SND_WOODDOOROPEN_01);
						SoundMap.AddSingle("DOOR_CLOSE", SND_WOODDOORCLOSE_01);
					<\CEntitySoundDef>						
#end_definition


//*******************************************************************************************
#definition_template	OBJECT	OBJECT_LOCKABLE_DOOR_TEMPLATE specialises OBJECT_BUILDING_DOOR_TEMPLATE
					ForceNoSerialise		FALSE;

					Components.Add("CTCSwitchableNavigation");

					<CDoorDef>
						TriggerType			DOOR_TRIGGER_MANUAL;
					<\CDoorDef>
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_IMMOVEABLE|PHYSICS_COLLIDE_THINGS|PHYSICS_INTERACT_THINGS;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition OBJECT OBJECT_BUILDING_DESTROYABLE_DOOR_TEMPLATE specialises OBJECT_LOCKABLE_DOOR_TEMPLATE
					IsVulnerableToMelee		TRUE;
					Damageable				TRUE;

					Health					5;
					//MinHealth				1;
					
					<CDoorDef>
						PostVandalismCrimeIfDestroyed	TRUE;
					<\CDoorDef>

					Components.Add("CTCSmashableBarrier");
					<CSmashableDef>
						Smashable				TRUE;
						SmashParticleEmitter	SMASH_DOOR_01;
					<\CSmashableDef>

					//Components.Add("CTCDegradableBarrier");

/*					<CDegradableDef>
						Degradable					TRUE;
						InitiallyBlocksNavigation	TRUE;
					<\CDegradableDef>*/
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BED_BASE_TEMPLATE	 specialises OBJECT_BASE
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;
					Health					1;
					Property				THING_OBJECT_PROPERTY_BED;
					AlwaysFrameUpdate		TRUE;
					RenderFadeDistance		THING_FADE_DIST_SHORT;
					Damageable				FALSE;
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCActionUseBed");
					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
						TargetArc		360.0;
					<\CTargetingDef>
					
					<CActionUseDef>
						TutorialCategory	TUTORIAL_CATEGORY_BED;
					<\CActionUseDef>
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>

					Components.Add("CTCSingleUserActionPoints");
					Components.Add("CTCBed");
					
					CanComeBetweenCameraAndObservedThing	FALSE;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BED_NORMAL_TEMPLATE	 specialises OBJECT_BED_BASE_TEMPLATE

 					Components.Add("CTCGraphicAppearanceAnimatedMesh");
					Components.Add("CTCAnimationComplex");

					Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;
					PersistenceFlags		EPF_MOVING;
					
					<CBedDef>
						Animating				TRUE;
						GetInBedAnimName		"ST_GET_IN_BED_LEFT";
						SleepInBedAnimName		"ST_SLEEPING_IN_BED";
						GetUpFromBedAnimName	"ST_GET_OUT_OF_BED_LEFT";
						GetUpFromBedFastAnimName	"ST_GET_OUT_OF_BED_LEFT_FAST";
					<\CBedDef>

					<CAppearanceDef>
						Animation.Add("DEFAULT",		ANIM_OBJECT_BED_01_DEFAULT);
					<\CAppearanceDef>

#end_definition

//********************************************************************************************
#definition_template	OBJECT 	OBJECT_ANIMATING_BED_TEMPLATE		specialises OBJECT_BED_NORMAL_TEMPLATE
 					
 					Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;

					Components.Add("CTCAnimatingObject");
					<CAnimatingObjectDef>
						Animation.Add("DEFAULT",		ANIM_OBJECT_BED_01_DEFAULT);
						Animation.Add("GET_IN",			ANIM_OBJECT_BED_01_GET_IN);
						Animation.Add("GET_OUT",		ANIM_OBJECT_BED_01_GET_OUT);
						Animation.Add("GET_OUT_FAST",	ANIM_OBJECT_BED_01_GET_OUT_FAST);
						Animation.Add("SLEEP",			ANIM_OBJECT_BED_01_SLEEP);
					<\CAnimatingObjectDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BED_FLOOR_TEMPLATE	 specialises OBJECT_BED_BASE_TEMPLATE

					Components.Add("CTCGraphicAppearanceStaticMesh");

 					Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;

					<CBedDef>
						Animating				FALSE;
						GetInBedAnimName		"ST_GET_IN_FLOOR_BED";
						SleepInBedAnimName		"ST_SLEEPING_IN_FLOOR_BED";
						GetUpFromBedAnimName	"ST_GET_OUT_OF_FLOOR_BED";
					<\CBedDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_CUPBOARD_TEMPLATE  specialises OBJECT_BASE
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;
					Health					1;
//					Property				THING_OBJECT_PROPERTY_CUPBOARD;
					AlwaysFrameUpdate		TRUE;
					RenderFadeDistance		THING_FADE_DIST_SHORT;
					Damageable				FALSE;
					
					Components.Add("CTCPhysicsStandard");
					<CActionUseDef>
					<\CActionUseDef>
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>

					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceAnimatedMesh");
					Components.Add("CTCAnimationComplex");
					Components.Add("CTCCupboard");
					PersistenceFlags	EPF_MOVING;
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_CLOCKHAND_TEMPLATE   specialises OBJECT_BASE
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;
					Health					1;
					Components.Add("CTCPhysicsStandard");
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable				FALSE;
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>

					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceAnimatedMesh");
					Components.Add("CTCAnimationComplex");
					Components.Add("CTCClock");
					PersistenceFlags	EPF_MOVING;
					
					ForceNoSerialise		TRUE;
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_GRAPHICAL_FEEDBACK_TEMPLATE	 specialises OBJECT_BASE
					IsFragile				FALSE;

					OnDeathObject			NULL;			
					IsVulnerableToMelee		FALSE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable				FALSE;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					Property				THING_OBJECT_PROPERTY_NULL;
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_DEGRADABLE_BARRIER_TEMPLATE
					IsFragile				FALSE;

					IsDrawable				TRUE;
					OnDeathObject			NULL;			
					IsVulnerableToMelee		TRUE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable				TRUE;

					Health					1;
					MinHealth				1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					Property				THING_OBJECT_PROPERTY_NULL;
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					Components.Add("CTCDegradableBarrier");
					
					Components.Add("CTCSinglePersonOccupiable");
					
					<COccupiableDef>
						TypeFlags			OCCUPY_TYPE_COVER;
					<\COccupiableDef>
					
					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
						
//						RangeSpecialAbility		20.0;
						TargetingRanges[TARGETING_USABLE]		4.0;
						TargetingRanges[TARGETING_TALKABLE]		6.0;
						TargetingRanges[TARGETING_STAB]			2.5;
						TargetingRanges[TARGETING_SHOOTABLE]	28.0;
						TargetingRanges[TARGETING_MELEE]		14.0;
					<\CTargetingDef>
										
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
//						InteractionFlags	PHYSICS_IMMOVEABLE | PHYSICS_INTERACT_THINGS;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_SMASHABLE_WINDOW_TEMPLATE  specialises OBJECT_BASE
					IsFragile				FALSE;

					OnDeathObject			NULL;			
					IsVulnerableToMelee		TRUE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable			TRUE;
					CanComeBetweenCameraAndObservedThing	FALSE;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					Property				THING_OBJECT_PROPERTY_NULL;
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					Components.Add("CTCSmashableWindow");
					
					Components.Add("CTCTargeted");
					
					<CTargetingDef>
						Type			TARGETING_USABLE;
					<\CTargetingDef>
					
//					Components.Add("CTCActionUseWindow"); // no more usable windows in game (bug 12780)
					
					<CPhysicsDef>
						InteractionFlags	PHYSICS_IMMOVEABLE | PHYSICS_INTERACT_THINGS;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_FLORA_TEMPLATE    specialises OBJECT_BASE
					IsFragile				FALSE;

					OnDeathObject			NULL;			
					IsVulnerableToMelee		FALSE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_SHORT;
					Damageable				FALSE;

					GroupDef				GO_NATURE;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					Property				THING_OBJECT_PROPERTY_NULL;					
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_INTERACT_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_ITEM_NONHOLDABLE_TEMPLATE   specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Material				MATERIAL_WOOD;
					IsFragile				FALSE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_SHORT;
					Damageable				FALSE;
					
					OnDeathObject			NULL;			

					GroupDef				GO_VILLAGE;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					FloorMaterial			MATERIAL_WOOD;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_INTERACT_THINGS;
						Mass				1.0;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_VILLAGE_SOLID_FURNITURE_BASE_TEMPLATE   specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Material				MATERIAL_WOOD;
					IsFragile				FALSE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM_SHORT;
					Damageable				FALSE;
					
					OnDeathObject			NULL;			

					GroupDef				GO_VILLAGE;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					FloorMaterial			MATERIAL_WOOD;

					Components.Add("CTCPhysicsStandard");
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
						Mass				10.0;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE specialises OBJECT_VILLAGE_SOLID_FURNITURE_BASE_TEMPLATE
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
#end_definition


//*******************************************************************************************
#definition_template OBJECT  OBJECT_VILLAGE_SOLID_FURNITURE_SMALL_TEMPLATE specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					RenderFadeDistance		THING_FADE_DIST_SHORT;
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_VILLAGE_TAVERN_BAR_TEMPLATE specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Material					MATERIAL_WOOD;

					Components.Add("CTCMeshAutomaticEntityCreator");
					Components.Add("CTCTavernBar");
					Components.Add("CTCNamedUserActionPoints");
					
					CanComeBetweenCameraAndObservedThing	FALSE;
#end_definition

//*******************************************************************************************
#definition_template 	OBJECT 	OBJECT_GRAVE		specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;

					Components.Add("CTCSinglePersonOccupiable");				
					<COccupiableDef>
						TypeFlags			OCCUPY_TYPE_COVER;
					<\COccupiableDef>

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
					<\CTargetingDef>
					
					// Lets make the villagers a bit morbid
//					Components.Add("CTCInterestingToVillagers");
//					<CInterestingToVillagersDef>
//						Interest			0.1;
//					<\CInterestingToVillagersDef>

					Material				MATERIAL_ROCK;
					GroupDef				GO_REGION_GRAVEYARD;
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_VILLAGE_SOLID_FURNITURE_REPLACEABLE_TEMPLATE specialises OBJECT_VILLAGE_SOLID_FURNITURE_BASE_TEMPLATE
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceReplaceableMesh");
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_LANDSCAPE_SOLID_FURNITURE_TEMPLATE
					IsVulnerableToMelee		FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM_LONG;
					Damageable				FALSE;

					IsDrawable				TRUE;
					IsFragile				FALSE;
					
					OnDeathObject			NULL;			
					AlwaysFrameUpdate		FALSE;
					Material				MATERIAL_WOOD;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					FloorMaterial			MATERIAL_WOOD;
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CActionUseDef>
					<\CActionUseDef>

					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
					
					Components.Add("CTCHitLocations");
					<CHitLocationsDef>
						HitLocations.Add(HIT_LOCATION_PHYSICS_MESH);
					<\CHitLocationsDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_CAVE_TEMPLATE specialises OBJECT_LANDSCAPE_SOLID_FURNITURE_TEMPLATE
				    IsVulnerableToMelee		FALSE;
					Material				MATERIAL_WOOD;
					IsFragile				FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable				FALSE;

					OnDeathObject			NULL;	

					GroupDef				GO_NATURE;		
				
					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
#end_definition


//*******************************************************************************************
#definition_template	OBJECT	OBJECT_ROCK_WALKABLE_TEMPLATE specialises OBJECT_LANDSCAPE_SOLID_FURNITURE_TEMPLATE			
				    IsVulnerableToMelee		FALSE;
				    
					Material				MATERIAL_ROCK;
					FloorMaterial			MATERIAL_ROCK;
					
					IsFragile				FALSE;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					Damageable				FALSE;

					OnDeathObject			NULL;	

					GroupDef				GO_NATURE;		
				
					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_ROCK_IMPASSABLE_TEMPLATE specialises OBJECT_ROCK_WALKABLE_TEMPLATE
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE | PHYSICS_IMPASSABLE;
					<\CPhysicsDef>
					
					CanComeBetweenCameraAndObservedThing	FALSE;
#end_definition


//*******************************************************************************************
#definition_template	OBJECT	OBJECT_TREESTUMP_TEMPLATE specialises OBJECT_ROCK_WALKABLE_TEMPLATE
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE | PHYSICS_IMPASSABLE;
					<\CPhysicsDef>
					
					Material				MATERIAL_WOOD;
					FloorMaterial			MATERIAL_WOOD;			
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_BASE_TEMPLATE	 specialises OBJECT_VILLAGE_SOLID_FURNITURE_REPLACEABLE_TEMPLATE
					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
						TargetArc		105;
					<\CTargetingDef>

					Components.Add("CTCActionUseTorch");
					<CActionUseDef>
						//AnimationGroup	"***insert_your_group_here***";
						SnapToActionPoint	TRUE;
						IgnoreActionPoints	FALSE;
					<\CActionUseDef>

					//<CReplaceableMeshDef>
					//	Meshes.Add(ENGINE_GRAPHIC_STATIC_MESH, ***insert_starting_mesh_here***);
					//	Meshes.Add(ENGINE_GRAPHIC_STATIC_MESH, ***insert_mesh_when_used_here***);
					//<\CReplaceableMeshDef>

					Health					1000;
					DieOffTimer				0;

					IsSelfIlluminating		TRUE;
					Components.Add("CTCLight");

 					Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
					//Graphic.BankIndex		***insert_your_mesh_here***;
					//Material				***insert_your_material_here***;

					Components.Add("CTCVillageMember");
					<CVillageMemberDef>
						NeedsVillageToFunctionCorrectly		TRUE;
					<\CVillageMemberDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_GLOW_TEMPLATE	 specialises OBJECT_STREETLAMP_BASE_TEMPLATE
					<CLightDef>
						InnerRadius		4.0;
						OuterRadius		6.0;
						Flicker			0.5;
						Colour.R		125;
						Colour.G		71;
						Colour.B		37;
						EffectChannel	POINT_LIGHT_EFFECT_EXTERNALS;
					<\CLightDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_FLAME_TEMPLATE	 specialises OBJECT_STREETLAMP_BASE_TEMPLATE
					<CLightDef>
						InnerRadius		5.0;
						OuterRadius		7.0;
						Flicker			0.9;
						Colour.R		100;
						Colour.G		50;
						Colour.B		10;	
						EffectChannel	POINT_LIGHT_EFFECT_EXTERNALS;
					<\CLightDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_GLOW_UNLIT_TEMPLATE	 specialises OBJECT_STREETLAMP_GLOW_TEMPLATE

					Property				THING_OBJECT_PROPERTY_UNLIT_TORCH;
					<CActionUseDef>
					<\CActionUseDef>

					<CLightDef>
						StartActive			FALSE;
					<\CLightDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_GLOW_LIT_TEMPLATE	 specialises OBJECT_STREETLAMP_GLOW_TEMPLATE

					Property				THING_OBJECT_PROPERTY_LIT_TORCH;
					<CActionUseDef>
					<\CActionUseDef>

					<CLightDef>
						StartActive			TRUE;
					<\CLightDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_FLAME_UNLIT_TEMPLATE	 specialises OBJECT_STREETLAMP_FLAME_TEMPLATE

					Property				THING_OBJECT_PROPERTY_UNLIT_TORCH;
					<CActionUseDef>
					<\CActionUseDef>

					<CLightDef>
						StartActive			FALSE;
					<\CLightDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_STREETLAMP_FLAME_LIT_TEMPLATE	 specialises OBJECT_STREETLAMP_FLAME_TEMPLATE

					Property				THING_OBJECT_PROPERTY_LIT_TORCH;
					<CActionUseDef>
					<\CActionUseDef>

					<CLightDef>
						StartActive			TRUE;
					<\CLightDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_VILLAGE_TAVERN_TABLE_TEMPLATE	specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Property					THING_OBJECT_PROPERTY_SEAT;
					Material					MATERIAL_WOOD;
					AlwaysFrameUpdate			TRUE;

					<CTavernTableDef>
						AddTankards				TRUE;
						HighQualityTankards		FALSE;					
					<\CTavernTableDef>

					Components.Add("CTCTavernTable");
					Components.Add("CTCNamedUserActionPoints");
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_VILLAGE_HOME_TABLE_TEMPLATE	specialises OBJECT_VILLAGE_TAVERN_TABLE_TEMPLATE
					<CTavernTableDef>
						AddTankards				FALSE;
					<\CTavernTableDef>
#end_definition

//*******************************************************************************************
#definition	OBJECT	OBJECT_VILLAGE_SEAT_TEMPLATE	specialises OBJECT_VILLAGE_SOLID_FURNITURE_SMALL_TEMPLATE
 					Graphic.Type		ENGINE_GRAPHIC_STATIC_MESH;

					Property			THING_OBJECT_PROPERTY_SEAT;

					Components.Add("CTCSingleUserActionPoints");
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_VILLAGE_SAWHORSE_TEMPLATE	specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Property					THING_OBJECT_PROPERTY_SAWHORSE;
					Material					MATERIAL_WOOD;

					Components.Add("CTCSingleUserActionPoints");
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_VILLAGE_ANVIL_TEMPLATE	specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Property					THING_OBJECT_PROPERTY_ANVIL;
					Material					MATERIAL_METAL;

					Components.Add("CTCSingleUserActionPoints");
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_LANDSCAPE_INTANGIBLE_FURNITURE_TEMPLATE	 specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Damageable				FALSE;

					IsFragile				FALSE;
					
					OnDeathObject			NULL;			
					Material				MATERIAL_WOOD;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_LONG;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
					
					<CActionUseDef>
					<\CActionUseDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	 OBJECT_HOLDABLE_TEMPLATE    specialises OBJECT_BASE
					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
					<\CTargetingDef>

				    IsVulnerableToMelee		FALSE;
				    Damageable				FALSE;
//					//Components.Add("CTCActionUsePickUp");
					Components.Add("CTCCarryable");

					<CCarryableDef>
						ActiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
					<\CCarryableDef>

					RenderFadeDistance		THING_FADE_DIST_MEDIUM;

					IsFragile				FALSE;
					Material				MATERIAL_WOOD;
					AlwaysFrameUpdate		FALSE;
					
					OnDeathObject			NULL;			

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					
					<CPhysicsDef>
						Diameter			0.5;
						InteractionFlags 	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_INTERACT_THINGS;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_HOLDABLE_CLOTHING_TEMPLATE specialises OBJECT_HOLDABLE_TEMPLATE
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_INTERACT_THINGS;
						Diameter			0.6;
					<\CPhysicsDef>

					AlwaysFrameUpdate		FALSE;

					GroupDef				GO_CLOTHING;
					RenderFadeDistance		THING_FADE_DIST_MEDIUM;
					
					<CAppearanceModifierDef>
						ArmourDefIndex				ARMOUR_NONE;
					<\CAppearanceModifierDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_QUEST_CARD_TEMPLATE specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE

					IsSelfIlluminating		TRUE;
					GameStatePersisted		TRUE;

					Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
					Graphic.BankIndex		MESH_QUEST_SCROLL;
					Graphic.AdditiveAlpha	TRUE;
					
					Components.Add("CTCVolumeContainmentTracker");
					<CTCVolumeContainmentTrackerDef>
					<\CTCVolumeContainmentTrackerDef>

					<CPhysicsDef>
						InteractionFlags	PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>

					Components.Add("CTCQuestCard");
					<CQuestCardDef>
						InventoryCategory	INVENTORY_CATEGORY_QUEST_CARD_BLANK;
						IsExclusive			FALSE;
						NumBoasts			0;
						CanPlayerCancel		BTRUE;
					<\CQuestCardDef>

					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type			ENGINE_GRAPHIC_SPRITE;
						Graphic.BankIndex		HUD_ICON_SCROLL;
						Graphic.RenderSizeX		1.0;
						Graphic.AnimStep		1;
						Graphic.AdditiveAlpha	FALSE;

						Orientation			INVENTORY_ORIENTATION_BACKWARDS_45_DEGREES;
					<\CInventoryItemDef>

					GroupDef				GO_GAMEPLAY;
#end_definition

//*******************************************************************************************
#definition_template OBJECT OBJECT_VIGNETTE_CARD_TEMPLATE specialises OBJECT_QUEST_CARD_TEMPLATE
					<CQuestCardDef>
						IsVignette			TRUE;
						IsExclusive			FALSE;
						CanPlayerCancel		BFALSE;
					<\CQuestCardDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_SHOT_TEMPLATE  specialises OBJECT_BASE
				    IsVulnerableToMelee		FALSE;
				    Damageable				FALSE;

					AlwaysFrameUpdate		TRUE;

					IsFragile				FALSE;
					Material				MATERIAL_WOOD;

					OnDeathObject			NULL;			

					Health					1;
					DieOffTimer				400;
					IsSelfIlluminating		TRUE;

					RenderFadeDistance		THING_FADE_DIST_SHORT;
					
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CPhysicsDef>
						Diameter			0.01;
						Mass				0.1;
						InteractionFlags 	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_INTERACT_THINGS;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BRIDGE_TEMPLATE    specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Damageable				FALSE;

					IsFragile				FALSE;
					AlwaysFrameUpdate		FALSE;

					OnDeathObject			NULL;				
					Material				MATERIAL_WOOD;
					RenderFadeDistance		THING_FADE_DIST_LONG;

					GroupDef				GO_BOUNDARIES;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					FloorMaterial			MATERIAL_WOOD;
					CanComeBetweenCameraAndObservedThing		FALSE;
					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template OBJECT  OBJECT_LARGE_STRUCTURE_TEMPLATE   specialises OBJECT_BASE
					IsVulnerableToMelee		FALSE;
					Material				MATERIAL_ROCK;
					IsFragile				FALSE;
					AlwaysFrameUpdate		FALSE;
					RenderFadeDistance		THING_FADE_DIST_LONG;
					
					OnDeathObject			NULL;			

					GroupDef				GO_VILLAGE;

					Health					1;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					FloorMaterial			MATERIAL_ROCK;
					
					CanComeBetweenCameraAndObservedThing	FALSE;

					Components.Add("CTCPhysicsStandard");
					<CPhysicsDef>
						InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_IMMOVEABLE;
						Mass				10.0;
					<\CPhysicsDef>
					
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_AUTOPICKUP_ITEM_TEMPLATE	 specialises OBJECT_BASE
				    IsVulnerableToMelee		FALSE;
				    Damageable				FALSE;

					RenderFadeDistance		THING_FADE_DIST_SHORT;

					IsFragile				FALSE;
					Material				MATERIAL_WOOD;
					AlwaysFrameUpdate		FALSE;
					
					OnDeathObject			NULL;			

					Health					1;
					DieOffTimer				0;

					Property				THING_OBJECT_PROPERTY_AUTO_PICKUP;

					Components.Add("CTCPhysicsStandard");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					<CPhysicsDef>
						Diameter			2.0;
						InteractionFlags 	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_INTERACT_THINGS | PHYSICS_COLLIDE_THINGS_ONEWAY;
					<\CPhysicsDef>
#end_definition

//*******************************************************************************************
#definition_template		OBJECT		OBJECT_TRAP_TEMPLATE  specialises OBJECT_BASE
	Components.Add("CTCMeleeTrap");
	Components.Add("CTCGraphicAppearance");
	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	Components.Add("CTCAnimationComplex");
	Components.Add("CTCWeaponTrail");
	Components.Add("CTCPhysicsStandard");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_IMMOVEABLE | PHYSICS_COLLIDE_THINGS;
		Diameter			0.0;
	<\CPhysicsDef>
	RenderFadeDistance		THING_FADE_DIST_MEDIUM;
	PersistenceFlags		EPF_MOVING;
	Health                  6000;
	
	<CWeaponDef>
		WeaponTrails[AUGMENTATION_NULL]			CWeaponTrailGraphicSet(GRAPHIC_WEAPON_TRAIL, GRAPHIC_WEAPON_TRAIL2);
		WeaponTrails[AUGMENTATION_FLAME]			CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_01, SPRITE_WEAPON_TRAIL_FIRE_01);
		WeaponTrails[AUGMENTATION_LIGHTNING]		CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_LIGHTNING_01, SPRITE_WEAPON_TRAIL_LIGHTNING_01);
		WeaponTrails[AUGMENTATION_FLAME|AUGMENTATION_LIGHTNING]			CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01, SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01);
	<\CWeaponDef>

	<CTrapDef>
		TrapType			TRAP_TYPE_TRIGGER_AND_RESET;
		TriggerType			TRAP_TRIGGER_MANUAL;
		TriggerHelperName	"";
	<\CTrapDef>
	GroupDef				GO_GAMEPLAY;
#end_definition

//*******************************************************************************************
//********* WEAPON AND MISSILE TEMPLATES ****************************************************
//********* DON'T MESS!! ********************************************************************
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_MELEE_WEAPON_TEMPLATE  specialises OBJECT_BASE
					Components.Add("CTCActionUsePutInInventory");
					Components.Add("CTCTargeted");
					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot				CARRY_SLOT_RIGHT_HAND;
						SecondaryActiveCarrySlot	CARRY_SLOT_LEFT_HAND;
						PassiveCarrySlot			CARRY_SLOT_PRIMARY_SHEATHE;
						
						OffsetAmountForThingsOnTopOfMe	0.075;
					<\CCarryableDef>

					RenderFadeDistance				THING_FADE_DIST_CREATURES;
					<CTargetingDef>
						Type						TARGETING_USABLE;
					<\CTargetingDef>
					
					Material						MATERIAL_WEAPON_METAL;
					GroupDef						GO_WEAPONS;
					Health							1;
					Components.Add("CTCPhysicsStandard");
					<CPhysicsDef>
						InteractionFlags		PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_INTERACT_THINGS;
						Diameter				1.0;
					<\CPhysicsDef>
				
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					Components.Add("CTCWeapon");
					
					<CWeaponDef>
						Type					WT_SWORD;
						Class					WC_LIGHT;
						Damage					1.0;
						Property				WP_NONE;
	
						FlourishParticles										CObjectAugmentationParticleSet(0,2,FLOURISH_WISP_SHORT_01, FLOURISH_WISP_LONG_01, 0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						FlourishSpecialWeaponTrail								CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FLOURISH_01, SPRITE_WEAPON_TRAIL_FLOURISH_01);
						WeaponTrails[AUGMENTATION_NULL]							CWeaponTrailGraphicSet(GRAPHIC_WEAPON_TRAIL, GRAPHIC_WEAPON_TRAIL2);
						WeaponTrails[AUGMENTATION_FLAME]						CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_01, SPRITE_WEAPON_TRAIL_FIRE_01);
						WeaponTrails[AUGMENTATION_LIGHTNING]					CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_LIGHTNING_01, SPRITE_WEAPON_TRAIL_LIGHTNING_01);
						WeaponTrails[AUGMENTATION_LIGHTNING|AUGMENTATION_FLAME]	CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01, SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01);
						
						AnimationGroup			"SWORD";
						TargetingRange			23;
						
						UnsheatheToCombatAnim	"ST_UNSHEATHE_TO_COMBAT_POSE";
						UnsheatheToNormalAnim	"STANDARD_UNSHEATHE";
						SheatheFromCombatAnim	"ST_SHEATHE_FROM_COMBAT_POSE";
						SheatheFromNormalAnim	"STANDARD_SHEATHE";
					<\CWeaponDef>

					Components.Add("CTCWeaponTrail");
					Components.Add("CTCParticleAttachmentTracker");
					Components.Add("CTCStockItem");
					<CStockItemDef>
					<\CStockItemDef>

					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type				ENGINE_GRAPHIC_SPRITE;
						Graphic.BankIndex			HUD_ICON_SWORD;
						Graphic.RenderSizeX			1.0;
						Graphic.AnimStep			1;
						Graphic.AdditiveAlpha		FALSE;

						SlotIndex					-1;
						InventoryType				TCI_INVENTORY_WEAPONS;
						InventoryCategory			INVENTORY_CATEGORY_MELEE_WEAPONS;
						MaxNumberItems				1;
						UseButtonAction				INVENTORY_ACTION_NULL;
						Orientation					INVENTORY_ORIENTATION_45_DEGREES;
					<\CInventoryItemDef>
					
					Components.Add("CTCObjectAugmentations");
					<CObjectAugmentationsDef>
						NumberOfSlots					0;
						MaximumNumberOfSlots			5;
						
						FireProjectileTrailEffect							AUGMENTED_ARROW_FIRE;
						LightningProjectileTrailEffect						AUGMENTED_ARROW_LIGHTNING;
						FireAndLightningProjectileTrailEffect				AUGMENTED_ARROW_FIRE_LIGHTNING;
						FireProjectileOnHitEffect							AUGMENTED_ARROW_FIRE_HIT;
						LightningProjectileOnHitEffect						AUGMENTED_ARROW_LIGHTNING_HIT;
						FireAndLightningProjectileOnHitEffect				AUGMENTED_ARROW_FIRE_LIGHTNING_HIT;
						
						AugmentationParticles[AUGMENTATION_NULL]							CObjectAugmentationParticleSet(0.3,0);
						AugmentationParticles[AUGMENTATION_EXTRA_DAMAGE]					CObjectAugmentationParticleSet(0.3,2,AUGMENT_SHARP_WISP_01, AUGMENT_SHARP_WISP_02, 0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_SILVER]							CObjectAugmentationParticleSet(0.3,2,AUGMENT_SILVER_WISP_01, AUGMENT_SILVER_WISP_02, 0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_FLAME]							CObjectAugmentationParticleSet(0.3,2,AUGMENT_FIRE_WISP_01, AUGMENT_FIRE_WISP_02, AUGMENT_FIRE_WHOOSH_01, AUGMENT_FIRE_WHOOSH_02, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_LIGHTNING]						CObjectAugmentationParticleSet(0.3,2,AUGMENT_LIGHTNING_WISP_01,AUGMENT_LIGHTNING_WISP_02, AUGMENT_LIGHTNING_WHOOSH_01,AUGMENT_LIGHTNING_WHOOSH_02, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_FLAME|AUGMENTATION_LIGHTNING]	CObjectAugmentationParticleSet(0.3,2,0,0,AUGMENT_FIRE_LIGHTNING_WHOOSH_01,AUGMENT_FIRE_LIGHTNING_WHOOSH_02, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_DIAMOND]							CObjectAugmentationParticleSet(0.3,2,AUGMENT_PIERCE_WISP_01,AUGMENT_PIERCE_WISP_02,0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_HEALTH_REGENERATION]				CObjectAugmentationParticleSet(0.3,2,AUGMENT_HEALTH_UP_WISP_01,AUGMENT_HEALTH_UP_WISP_02, 0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_STAMINA_REGENERATION]			CObjectAugmentationParticleSet(0.3,2,AUGMENT_MANA_UP_WISP_01,AUGMENT_MANA_UP_WISP_02,0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						AugmentationParticles[AUGMENTATION_EXPERIENCE_INCREASE]				CObjectAugmentationParticleSet(0.3,2,AUGMENT_EXPERIENCE_UP_WISP_01,AUGMENT_EXPERIENCE_UP_WISP_02,0, 0, "AUG_01", "AUG_02", "AUG_03", "AUG_04");
						
//						InitSounds[AUGMENTATION_LIGHTNING]							"HERO_ABILITY_LIGHTNING_BLADE_INIT";
//						InitSounds[AUGMENTATION_FLAME]								"HERO_ABILITY_FLAMING_BLADE_INIT";
//						InitSounds[AUGMENTATION_LIGHTNING|AUGMENTATION_FLAME]		"HERO_ABILITY_COMBO_BLADE_INIT";
						
//						LoopingSounds[AUGMENTATION_LIGHTNING]						"HERO_ABILITY_LIGHTNING_BLADE_CONTINUOUS";
//						LoopingSounds[AUGMENTATION_FLAME]							"HERO_ABILITY_FLAMING_BLADE_CONTINUOUS";
//						LoopingSounds[AUGMENTATION_LIGHTNING|AUGMENTATION_FLAME]	"HERO_ABILITY_COMBO_BLADE_CONTINUOUS";
						
						EmptySlotName					TEXT_GUI_EMPTY_AUGMENTATION_SLOT;
						SlotUpgradeCosts.Add(1000);
						SlotUpgradeCosts.Add(2500);
						SlotUpgradeCosts.Add(4000);
						SlotUpgradeCosts.Add(6000);
						SlotUpgradeCosts.Add(10000);
					<\CObjectAugmentationsDef>
					
					<CSpecialEffectsDef>
						SpecialEffects.Add("BERSERK",						FLAMING_SWORD_LEVEL_1);
						SpecialEffects.Add("MULTI_STRIKE1",					SPECIAL_STRENGTH_MULTI_STRIKE_SWORD_HIT_01);
						SpecialEffects.Add("MULTI_STRIKE2",					SPECIAL_STRENGTH_MULTI_STRIKE_SWORD_HIT_01);
						SpecialEffects.Add("MULTI_STRIKE3",					SPECIAL_STRENGTH_MULTI_STRIKE_SWORD_HIT_01);//SPECIAL_STRENGTH_MULTI_STRIKE_SWORD_KNOCKOUT_01);
						SpecialEffects.Add("MULTI_STRIKE_FLASH",			SPECIAL_STRENGTH_MULTI_STRIKE_SWORD_SHINE_01);
						SpecialEffects.Add("MULTI_STRIKE_FLAME",			SPECIAL_STRENGTH_MULTI_STRIKE_SWORD_01);

						SpecialEffects.Add("LATERAL_SLASH_NORMAL",			LATERAL_SLASH_NORMAL);
						SpecialEffects.Add("LATERAL_SLASH_COUNTER_BLOCK",	LATERAL_SLASH_COUNTER_BLOCK);
						SpecialEffects.Add("LATERAL_SLASH_KNOCKOUT",		LATERAL_SLASH_KNOCKOUT);
						SpecialEffects.Add("LATERAL_SLASH_FLOURISH",		LATERAL_SLASH_FLOURISH);
					<\CSpecialEffectsDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_PROJECTILE_WEAPON_TEMPLATE   specialises OBJECT_BASE
					Components.Add("CTCActionUsePutInInventory");
					Components.Add("CTCTargeted");
					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot			CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot		CARRY_SLOT_PRIMARY_SHEATHE;
					<\CCarryableDef>

					RenderFadeDistance			THING_FADE_DIST_CREATURES;
					<CTargetingDef>
						Type					TARGETING_USABLE;
					<\CTargetingDef>

					Material						MATERIAL_WEAPON_WOOD;
					GroupDef						GO_WEAPONS;
					Health							1;
					ForceRenderedLastFrameOverride	TRUE;
					
					Components.Add("CTCPhysicsStandard");
					<CPhysicsDef>
						InteractionFlags		PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_INTERACT_THINGS;
						Diameter				1.5;
					<\CPhysicsDef>

					Components.Add("CTCParticleAttachmentTracker");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					Components.Add("CTCWeapon");
					<CWeaponDef>
						Type						WT_CROSSBOW;
						Damage						1.0;
						Property					WP_NONE;
						AnimationGroup				"CROSSBOW";
						Shot						SHOT_CROSSBOW_BOLT;
						Ammo						OBJECT_CROSSBOW_BOLT;
						TargetingRange				35;
						Class						WC_PROJECTILE;
						SheatheObject				0;
						
						ReloadSpeedRange			CFloatRange(1.2, 1.6);
						ProjectileWeaponAutoReload	TRUE;
						ProjectileWeaponStartLoaded	TRUE;
					<\CWeaponDef>
					
					<CWeaponDef>	
						UnsheatheToCombatAnim		"ST_UNSHEATHE_TO_COMBAT_POSE";
						UnsheatheToNormalAnim		"STANDARD_UNSHEATHE";
						SheatheFromCombatAnim		"ST_SHEATHE_FROM_COMBAT_POSE";
						SheatheFromNormalAnim		"STANDARD_SHEATHE";
					<\CWeaponDef>
					
					<CWeaponDef>
						FlourishParticles								CObjectAugmentationParticleSet(0,1,FLOURISH_WISP_SHORT_01, FLOURISH_WISP_LONG_01, 0, 0, "AUG_01", "AUG_02");
						FlourishSpecialWeaponTrail					CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FLOURISH_01, SPRITE_WEAPON_TRAIL_FLOURISH_01);
						WeaponTrails[AUGMENTATION_NULL]			CWeaponTrailGraphicSet(GRAPHIC_WEAPON_TRAIL, GRAPHIC_WEAPON_TRAIL2);
						WeaponTrails[AUGMENTATION_FLAME]			CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_01, SPRITE_WEAPON_TRAIL_FIRE_01);
						WeaponTrails[AUGMENTATION_LIGHTNING]		CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_LIGHTNING_01, SPRITE_WEAPON_TRAIL_LIGHTNING_01);
						WeaponTrails[AUGMENTATION_LIGHTNING|AUGMENTATION_FLAME]		CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01, SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01);
					<\CWeaponDef>
					
					Components.Add("CTCObjectAugmentations");
					<CObjectAugmentationsDef>
						NumberOfSlots					0;
						MaximumNumberOfSlots			5;
						
						FireProjectileTrailEffect							AUGMENTED_ARROW_FIRE;
						LightningProjectileTrailEffect						AUGMENTED_ARROW_LIGHTNING;
						FireAndLightningProjectileTrailEffect				AUGMENTED_ARROW_FIRE_LIGHTNING;
						FireProjectileOnHitEffect							AUGMENTED_ARROW_FIRE_HIT;
						LightningProjectileOnHitEffect						AUGMENTED_ARROW_LIGHTNING_HIT;
						FireAndLightningProjectileOnHitEffect				AUGMENTED_ARROW_FIRE_LIGHTNING_HIT;
						
						AugmentationParticles[AUGMENTATION_NULL]			CObjectAugmentationParticleSet(0.3,0);
						AugmentationParticles[AUGMENTATION_EXTRA_DAMAGE]	CObjectAugmentationParticleSet(0.3,1,AUGMENT_SHARP_WISP_01, AUGMENT_SHARP_WISP_02, 0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_SILVER]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_SILVER_WISP_01, AUGMENT_SILVER_WISP_02, 0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_FLAME]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_FIRE_WISP_01, AUGMENT_FIRE_WISP_02, AUGMENT_FIRE_WHOOSH_01, AUGMENT_FIRE_WHOOSH_01, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_LIGHTNING]		CObjectAugmentationParticleSet(0.3,1,AUGMENT_LIGHTNING_WISP_01,AUGMENT_LIGHTNING_WISP_02, AUGMENT_LIGHTNING_WHOOSH_01,AUGMENT_LIGHTNING_WHOOSH_01, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_FLAME|AUGMENTATION_LIGHTNING]		CObjectAugmentationParticleSet(0.3,1,0,0,AUGMENT_FIRE_LIGHTNING_WHOOSH_01,AUGMENT_FIRE_LIGHTNING_WHOOSH_01, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_DIAMOND]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_PIERCE_WISP_01,AUGMENT_PIERCE_WISP_02,0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_HEALTH_REGENERATION]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_HEALTH_UP_WISP_01,AUGMENT_HEALTH_UP_WISP_02, 0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_STAMINA_REGENERATION]		CObjectAugmentationParticleSet(0.3,1,AUGMENT_MANA_UP_WISP_01,AUGMENT_MANA_UP_WISP_02,0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_EXPERIENCE_INCREASE]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_EXPERIENCE_UP_WISP_01,AUGMENT_EXPERIENCE_UP_WISP_02,0, 0, "AUG_01", "AUG_02");
						
						EmptySlotName					TEXT_GUI_EMPTY_AUGMENTATION_SLOT;
						SlotUpgradeCosts.Add(1000);
						SlotUpgradeCosts.Add(2500);
						SlotUpgradeCosts.Add(4000);
						SlotUpgradeCosts.Add(6000);
						SlotUpgradeCosts.Add(10000);
					<\CObjectAugmentationsDef>
					
					Components.Add("CTCStockItem");
					<CStockItemDef>
					<\CStockItemDef>
					
					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type				ENGINE_GRAPHIC_SPRITE;
						Graphic.BankIndex			HUD_ICON_ARROW;
						Graphic.RenderSizeX			1.0;
						Graphic.AnimStep			1;
						Graphic.AdditiveAlpha		FALSE;
						
						SlotIndex					-1;
						InventoryType				TCI_INVENTORY_WEAPONS;
						InventoryCategory			INVENTORY_CATEGORY_RANGED_WEAPONS;
						MaxNumberItems				1;
						UseButtonAction				INVENTORY_ACTION_NULL;
						Orientation					INVENTORY_ORIENTATION_45_DEGREES;
					<\CInventoryItemDef>
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_PROJECTILE_WEAPON_CROSSBOW_TEMPLATE	specialises OBJECT_PROJECTILE_WEAPON_TEMPLATE
	
			<CStockItemDef>
				CanBeDisplayedInShop	FALSE;
			<\CStockItemDef>

					<CInventoryItemDef>
						Orientation					INVENTORY_ORIENTATION_UPSIDE_DOWN_45_DEGREES;
					<\CInventoryItemDef>
			
#end_definition
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_PROJECTILE_MISSILE_TEMPLATE    specialises OBJECT_BASE
					AlwaysFrameUpdate		TRUE;
					Material				MATERIAL_WOOD;
					Health					1;
					DieOffTimer				400;
					IsSelfIlluminating		TRUE;
					
					DrawWeaponTrails		FALSE;

					Components.Add("CTCWeapon");
					Components.Add("CTCGraphicAppearance");
					Components.Add("CTCGraphicAppearanceStaticMesh");
					
					<CWeaponDef>
						ProjectileWeaponHelperNameTip "weapon_pos_a";
						ProjectileWeaponHelperNameBase "weapon_pos_b";
						Class	WC_PROJECTILE;
						Type	WT_ARROW;
					<\CWeaponDef>
	
					<CHitLocationsDef>
						HitLocations.clear();
						HitLocations.Add(HIT_LOCATION_SHOT_DEFAULT);
					<\CHitLocationsDef>
					
					Components.Add("CTCWeaponTrail");
					Components.Add("CTCParticleAttachmentTracker");
					
					Components.Add("CTCObjectAugmentations");
					<CObjectAugmentationsDef>
						FireProjectileTrailEffect							AUGMENTED_ARROW_FIRE;
						LightningProjectileTrailEffect						AUGMENTED_ARROW_LIGHTNING;
						FireAndLightningProjectileTrailEffect				AUGMENTED_ARROW_FIRE_LIGHTNING;
						FireProjectileOnHitEffect							AUGMENTED_ARROW_FIRE_HIT;
						LightningProjectileOnHitEffect						AUGMENTED_ARROW_LIGHTNING_HIT;
						FireAndLightningProjectileOnHitEffect				AUGMENTED_ARROW_FIRE_LIGHTNING_HIT;
						WeaponTrailAttachmentPoint							"weapon_pos_a";
						
						AugmentationParticles[AUGMENTATION_NULL]			CObjectAugmentationParticleSet(0.3,0);
						AugmentationParticles[AUGMENTATION_EXTRA_DAMAGE]	CObjectAugmentationParticleSet(0.3,1,AUGMENT_SHARP_WISP_01, AUGMENT_SHARP_WISP_02, 0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_SILVER]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_SILVER_WISP_01, AUGMENT_SILVER_WISP_02, 0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_FLAME]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_FIRE_WISP_01, AUGMENT_FIRE_WISP_02, AUGMENT_FIRE_WHOOSH_01, AUGMENT_FIRE_WHOOSH_01, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_LIGHTNING]		CObjectAugmentationParticleSet(0.3,1,AUGMENT_LIGHTNING_WISP_01,AUGMENT_LIGHTNING_WISP_02, AUGMENT_LIGHTNING_WHOOSH_01,AUGMENT_LIGHTNING_WHOOSH_01, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_FLAME|AUGMENTATION_LIGHTNING]		CObjectAugmentationParticleSet(0.3,1,0,0,AUGMENT_FIRE_LIGHTNING_WHOOSH_01,AUGMENT_FIRE_LIGHTNING_WHOOSH_01, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_DIAMOND]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_PIERCE_WISP_01,AUGMENT_PIERCE_WISP_02,0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_HEALTH_REGENERATION]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_HEALTH_UP_WISP_01,AUGMENT_HEALTH_UP_WISP_02, 0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_STAMINA_REGENERATION]		CObjectAugmentationParticleSet(0.3,1,AUGMENT_MANA_UP_WISP_01,AUGMENT_MANA_UP_WISP_02,0, 0, "AUG_01", "AUG_02");
						AugmentationParticles[AUGMENTATION_EXPERIENCE_INCREASE]			CObjectAugmentationParticleSet(0.3,1,AUGMENT_EXPERIENCE_UP_WISP_01,AUGMENT_EXPERIENCE_UP_WISP_02,0, 0, "AUG_01", "AUG_02");
					<\CObjectAugmentationsDef>	
					
					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot			CARRY_SLOT_LEFT_HAND;
						PassiveCarrySlot		CARRY_SLOT_PRIMARY_SHEATHE;
					<\CCarryableDef>

					Components.Add("CTCPhysicsStandard");
					<CPhysicsDef>
						Diameter			1.0;
						Mass				0.1;
						Friction			0.2;
						InteractionFlags 	PHYSICS_COLLIDE_LANDSCAPE; // | PHYSICS_COLLIDE_THINGS_ONEWAY; // | PHYSICS_INTERACT_THINGS;
					<\CPhysicsDef>
					
					Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BOW_TEMPLATE    specialises OBJECT_PROJECTILE_WEAPON_TEMPLATE

					<CWeaponDef>
						Type						WT_BOW;
						AnimationGroup				"BOW";
						Shot						SHOT_ARROW_SINGLE;
						Ammo						OBJECT_ARROW_SINGLE;
						UseAnalogueLoading			TRUE;
						MissileLoadCarrySlot		CARRY_SLOT_RIGHT_HAND;
						
						SheatheObjectAlwaysVisible	TRUE;
						SheatheObject				OBJECT_QUIVER;
						
						ReloadSpeedRange			CFloatRange(0.75, 1.2);
						ProjectileWeaponAutoReload	FALSE;
						ProjectileWeaponStartLoaded FALSE;
					<\CWeaponDef>
					
					<CWeaponDef>	
						UnsheatheToCombatAnim		"ST_UNSHEATHE_LEFT_HAND_TO_COMBAT_POSE";
						UnsheatheToNormalAnim		"STANDARD_UNSHEATHE_LEFT_HAND";
						SheatheFromCombatAnim		"ST_SHEATHE_FROM_COMBAT_POSE";
						SheatheFromNormalAnim		"STANDARD_SHEATHE";

						ReloadSpeedRange			CFloatRange(1.0, 1.25);
					<\CWeaponDef>
					
					Components.Add("CTCAnimatingObject");
					Components.Add("CTCAnimationComplex");
					Components.Remove("CTCGraphicAppearanceStaticMesh");
					Components.Add("CTCGraphicAppearanceAnimatedMesh");
 					
					<CAppearanceDef>
						Animation.Add("DEFAULT",					ANIMATION_BOW_DEFAULT);
					<\CAppearanceDef>
					
					<CAnimatingObjectDef>
						Animation.Add("PROJECTILE_WEAPON_LOAD",		ANIMATION_BOW_PULL_BACK);
						Animation.Add("PROJECTILE_WEAPON_AIMING",	ANIMATION_BOW_PULLED);
						Animation.Add("PROJECTILE_WEAPON_FIRE",		ANIMATION_BOW_FIRE);
					<\CAnimatingObjectDef>
 					
					<CCarryableDef>
						ActiveCarrySlot		CARRY_SLOT_LEFT_HAND;
					<\CCarryableDef>
					
					<CStockItemDef>
						CanBeDisplayedInShop	FALSE;
					<\CStockItemDef>
#end_definition

//*******************************************************************************************
//************ TROPHY TEMPLATE **************************************************************
//*******************************************************************************************

#definition_template	OBJECT	OBJECT_GENERAL_TROPHY_TEMPLATE		specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					
		Components.Add("CTCTargeted");
		<CTargetingDef>
			Type				TARGETING_USABLE;
		<\CTargetingDef>
		Material					MATERIAL_METAL;

		<CPhysicsDef>
			InteractionFlags		PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_INTERACT_THINGS | PHYSICS_COLLIDE_THINGS_ONEWAY;
		<\CPhysicsDef>

		Components.Add("CTCTrophy");
		<CTrophyDef>
			EvilTrophy						FALSE;
			FakeTrophy						FALSE;
			MinigameInitialTimerSecs		15.0;
			TimeBonusPerWitness				3.0;
			RenownGainedPerWitnessAhead		100;
			EmoteIconForAvailableWitness	GRAPHIC_TEMP_REACTION_QUERY;
			ShowTrophyAnimName				"ST_SHOW_TROPHY";
			GameDebugTextScale				0.15;
			SecsDelayPerGainedWitnessSound	0.15;
			
			SoundStartGame					"MULTIPLIER_INCREASE_01";
			SoundShowTrophy					"HERO_ABILITY_SLOW_TIME_END";
			SoundGainedWitness				"TAVERN_GAME_NEW_GAME";
			SoundOutOfTime					"HERO_ABILITY_SHIELD_END";
			SoundGotAllWitnesses			"TAVERN_GAME_WIN_GAME";
			SoundEndNewHighScore			"HERO_ABILITY_ENFLAME_CAST_LEVEL_3";
			SoundEndNoNewScore				"TAVERN_GAME_LOSE_GAME";
		<\CTrophyDef>

		<CContextSensitiveItemDef>
			Type					CONTEXT_SENSITIVE_TROPHY;
			Priority				200;
			SlotIndex				1;
		<\CContextSensitiveItemDef>

		Components.Add("CTCActionUsePutInInventory");
		Components.Add("CTCCarriedActionUseTrophy");
		Components.Add("CTCInventoryItem");
		
		Components.Add("CTCCarryable");

		<CCarryableDef>
			ActiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
			PassiveCarrySlot	CARRY_SLOT_RIGHT_HAND;
		<\CCarryableDef>

		<CInventoryItemDef>
			Graphic.Type			ENGINE_GRAPHIC_SPRITE;
			Graphic.BankIndex		HUD_ICON_SCROLL;
			Graphic.RenderSizeX		1.0;
			Graphic.AnimStep		1;
			Graphic.AdditiveAlpha	FALSE;

			ItemDescription			TXT_OBJ_TROPHY_GENERIC;
			InventoryCategory		INVENTORY_CATEGORY_QUEST_ITEMS;
			SlotIndex				2;
			MaxNumberItems			1;
			UseButtonAction			INVENTORY_ACTION_CALL_EXISTING_THING_TC;
			TutorialCategory		TUTORIAL_CATEGORY_TROPHY;
		<\CInventoryItemDef>
		
		GroupDef					GO_INVENTORY_ITEMS;				
#end_definition

//*******************************************************************************************
#definition_template		OBJECT			OBJECT_CHEST_OPENABLE_TPL

	IsDrawable				TRUE;
	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type			TARGETING_USABLE;
		TargetArc		90;
		
		TargetingRanges[TARGETING_USABLE]		4.0;
		TargetingRanges[TARGETING_TALKABLE]		6.0;
		TargetingRanges[TARGETING_STAB]			2.5;
		TargetingRanges[TARGETING_SHOOTABLE]	28.0;
		TargetingRanges[TARGETING_MELEE]		14.0;
	<\CTargetingDef>
	
	Components.Add("CTCGraphicAppearance");
	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	Components.Add("CTCAnimationComplex");
	PersistenceFlags		EPF_MOVING;
	Material				MATERIAL_METAL;

	Components.Add("CTCChest");
	<CChestDef>
		PersistOnOpening	TRUE;
		OpenParticleEffect	CHEST_OPEN_01;
	<\CChestDef>
	
//	Components.Add("CTCActionUseChest");
	Components.Add("CTCActionUseActivateQuest");
	<CActivateQuestDef>
		ScriptName			"Global_OpenChest";
		LoadResources		FALSE;
	<\CActivateQuestDef>

	<CActionUseDef>
		SnapToActionPoint	TRUE;
		TutorialCategory	TUTORIAL_CATEGORY_CHEST;
		IgnoreActionPoints	FALSE;
	<\CActionUseDef>

	Components.Add("CTCEntityEvents");	
	Components.Add("CTCPhysicsStandard");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS; // | PHYSICS_IMMOVEABLE;
		Mass				10.0;
	<\CPhysicsDef>
	
	AlwaysFrameUpdate		FALSE;
	
	Components.Add("CTCCameraCollision");
	<CCameraCollisionDef>
		CameraCollisionMesh			CMESH_CHEST_CAM_01;
	<\CCameraCollisionDef>
	
//	CanComeBetweenCameraAndObservedThing	FALSE;

	Components.Add("CTCHitLocations");
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_PHYSICS_MESH);
	<\CHitLocationsDef>

	GroupDef				GO_GAMEPLAY;
	
#end_definition

//*******************************************************************************************
#definition_template		OBJECT			OBJECT_SARCOPHAGUS_OPENABLE_TPL

	IsDrawable				TRUE;
	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type			TARGETING_USABLE;
		TargetArc		90;
		
		TargetingRanges[TARGETING_USABLE]		4.0;
		TargetingRanges[TARGETING_TALKABLE]		6.0;
		TargetingRanges[TARGETING_STAB]			2.5;
		TargetingRanges[TARGETING_SHOOTABLE]	28.0;
		TargetingRanges[TARGETING_MELEE]		14.0;
	<\CTargetingDef>
	
	Components.Add("CTCGraphicAppearance");
	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	Components.Add("CTCAnimationComplex");
	PersistenceFlags		EPF_MOVING;
	Material				MATERIAL_METAL;

	Components.Add("CTCChest");
	<CChestDef>
		PersistOnOpening	TRUE;
		OpenParticleEffect	CHEST_OPEN_01;
	<\CChestDef>
	
	Components.Add("CTCActionUseActivateQuest");
	<CActivateQuestDef>
		ScriptName			"Global_OpenChest";
		LoadResources		FALSE;
	<\CActivateQuestDef>

	<CActionUseDef>
		SnapToActionPoint	TRUE;
		TutorialCategory	TUTORIAL_CATEGORY_CHEST;
		IgnoreActionPoints	FALSE;
	<\CActionUseDef>

	Components.Add("CTCEntityEvents");	
	Components.Add("CTCPhysicsStandard");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS;
		Mass				10.0;
	<\CPhysicsDef>
	
	CanComeBetweenCameraAndObservedThing	FALSE;

	AlwaysFrameUpdate		TRUE;
	GroupDef				GO_GAMEPLAY;
	
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_DEEDS_TEMPLATE		specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE

					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Graphic.BankIndex			MESH_QUEST_SCROLL;
					Material					MATERIAL_METAL;

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type					TARGETING_USABLE;
					<\CTargetingDef>

					Property					THING_OBJECT_PROPERTY_AUTO_PICKUP;
					<CPhysicsDef>
						InteractionFlags		PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_INTERACT_THINGS;
						Diameter				1.0;
					<\CPhysicsDef>

					Components.Add("CTCActionUsePutInInventory");
					Components.Add("CTCCarriedActionUseShow");

					Components.Add("CTCStockItem");
					<CStockItemDef>
					<\CStockItemDef>

					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot			CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
					<\CCarryableDef>

					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type			ENGINE_GRAPHIC_SPRITE;
						Graphic.BankIndex		HUD_ICON_SCROLL;
						Graphic.RenderSizeX		1.0;
						Graphic.AnimStep		1;
						Graphic.AdditiveAlpha	FALSE;

						ItemDescription			TXT_OBJT_HOUSE_DEEDS;
						InventoryCategory		INVENTORY_CATEGORY_QUEST_ITEMS;
						SlotIndex				2;
						MaxNumberItems			5;
						UseButtonAction			INVENTORY_ACTION_CALL_EXISTING_THING_TC;
					<\CInventoryItemDef>

					GroupDef					GO_INVENTORY_ITEMS;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT		OBJECT_SCRIPT_OBJECT_TEMPLATE		specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE
		Components.Add("CTCTargeted");
		<CTargetingDef>
			Type					TARGETING_USABLE;
		<\CTargetingDef>

		Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
		Graphic.BankIndex			MESH_QUEST_SCROLL;
		Material					MATERIAL_METAL;

		<CPhysicsDef>
			InteractionFlags		PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		<\CPhysicsDef>

		GameStatePersisted			TRUE;

		Components.Add("CTCActionUsePutInInventory");
		Components.Add("CTCCarriedActionUseShow");

		<CStockItemDef>
		<\CStockItemDef>

		Components.Add("CTCCarryable");
		<CCarryableDef>
			ActiveCarrySlot			CARRY_SLOT_RIGHT_HAND;
			PassiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
		<\CCarryableDef>

		Components.Add("CTCInventoryItem");
		<CInventoryItemDef>
			Graphic.Type			ENGINE_GRAPHIC_SPRITE;
			Graphic.BankIndex		HUD_ICON_SCROLL;
			Graphic.RenderSizeX		1.0;
			Graphic.AnimStep		1;
			Graphic.AdditiveAlpha	FALSE;

			ItemDescription			TXT_OBJT_HOUSE_DEEDS;
			InventoryCategory		INVENTORY_CATEGORY_QUEST_ITEMS;
			SlotIndex				2;
			MaxNumberItems			5;
			UseButtonAction			INVENTORY_ACTION_CALL_EXISTING_THING_TC;
		<\CInventoryItemDef>

		GroupDef				GO_SCRIPT_ITEMS;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_TREASURE_CLUE_BASE	specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE

 					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Graphic.BankIndex			MESH_SCROLL_01;
					Material					MATERIAL_METAL;

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type				TARGETING_USABLE;
					<\CTargetingDef>

					Components.Add("CTCActionUsePutInInventory");
					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot	CARRY_SLOT_RIGHT_HAND;
					<\CCarryableDef>

					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type			ENGINE_GRAPHIC_SPRITE;
						Graphic.BankIndex		HUD_ICON_SCROLL;
						Graphic.RenderSizeX		1.0;
						Graphic.AnimStep		1;
						Graphic.AdditiveAlpha	FALSE;

						InventoryCategory		INVENTORY_CATEGORY_QUEST_ITEMS;
						SlotIndex				1;
						MaxNumberItems			1;
						UseButtonAction			INVENTORY_ACTION_NULL;
						Orientation				INVENTORY_ORIENTATION_BACKWARDS_45_DEGREES;
					<\CInventoryItemDef>
					
					GroupDef					GO_INVENTORY_ITEMS;		
#end_definition

//*******************************************************************************************
//************ CRATES TEMPLATE **************************************************************
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_CRATE_TEMPLATE	 specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Components.Add("CTCCarryable");
					Components.Add("CTCObstacle");

					<CPhysicsDef>
						InteractionFlags	PHYSICS_ANGLED_WITH_GROUND|PHYSICS_COLLIDE_LANDSCAPE|PHYSICS_COLLIDE_THINGS_ONEWAY;
						Diameter			0.1;
					<\CPhysicsDef>

					<CCarryableDef>
						ActiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot	CARRY_SLOT_RIGHT_HAND;
					<\CCarryableDef>
					
					Components.Add("CTCSingleUserActionPoints");
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_CRATE_HERO_USABLE_TEMPLATE	 specialises OBJECT_CRATE_TEMPLATE
					Components.Add("CTCActionUsePickUpGenericBox");
					Components.Add("CTCCarriedActionUseDropGenericBox");

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
						TargetArc		360.0;
					<\CTargetingDef>
					
					<CActionUseDef>
						SnapToActionPoint	TRUE;
					<\CActionUseDef>
#end_definition

//*******************************************************************************************
// SIGN POST TEMPLATE
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_SIGNPOST_TEMPLATE    specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_USABLE;
					<\CTargetingDef>

					IsVulnerableToMelee		FALSE;
					Damageable				FALSE;
					
					Components.Add("CTCActionUseReadable");
					<CReadableDef>
						UseInfoDisplay		FALSE;
					<\CReadableDef>

					IsFragile				FALSE;

					OnDeathObject			NULL;			

					GroupDef				GO_REGION_BRIGHTWOOD;

                    Health                  6000;
					DieOffTimer				0;
					IsSelfIlluminating		FALSE;
					Property				THING_OBJECT_PROPERTY_SIGNPOST;
					
					GameStatePersisted		TRUE;					
#end_definition

//*******************************************************************************************
// OBJECT BREAKABLE BARREL TEMPLATE
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BREAKABLE_BARREL_TEMPLATE    specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
					IsVulnerableToMelee		TRUE;
					Damageable				TRUE;

					OnDeathObject			NULL;

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
					<\CTargetingDef>

					Components.Add("CTCSinglePersonOccupiable");		
					<COccupiableDef>
						TypeFlags			OCCUPY_TYPE_COVER;
					<\COccupiableDef>

					Components.Add("CTCSmashableBarrier");
					<CSmashableDef>
						Smashable				TRUE;
						//ReplacementObject		"OBJECT_BANDIT_BARREL_SMASHED_01";
						SmashParticleEmitter	SMASH_BARREL_OUTSIDE_01;
					<\CSmashableDef>
					
					Components.Add("CTCContainerRewardHero");

					Components.Add("CTCVillageMember");
					<CVillageMemberDef>
						NeedsVillageToFunctionCorrectly		FALSE;
					<\CVillageMemberDef>

					Material				MATERIAL_WOOD;
 					Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
					Graphic.BankIndex		BANDIT_BARREL_01;
					
					GroupDef				GO_GAMEPLAY;
					
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_AUGMENTATION_TEMPLATE specialises OBJECT_BASE
	Components.Add("CTCGraphicAppearance");
	Components.Add("CTCGraphicAppearanceStaticMesh");
	
	Components.Add("CTCPhysicsStandard");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_IMMOVEABLE | PHYSICS_COLLIDE_THINGS;
		Diameter			0.2;
	<\CPhysicsDef>
	
	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type					TARGETING_USABLE;
	<\CTargetingDef>
	
	RenderFadeDistance		THING_FADE_DIST_MEDIUM;
	PersistenceFlags		EPF_MOVING;

	IsVulnerableToMelee		FALSE;
	Damageable				FALSE;
	Material				MATERIAL_METAL;
	
	Components.Add("CTCInventoryItem");
	
	<CInventoryItemDef>
		Graphic.Type			ENGINE_GRAPHIC_SPRITE;
		Graphic.BankIndex		HUD_ICON_GEM_DIAMOND;
		Graphic.RenderSizeX		1.0;
		Graphic.AnimStep		1;
		Graphic.AdditiveAlpha	FALSE;

		InventoryType			TCI_INVENTORY_WEAPONS;
		InventoryCategory		INVENTORY_CATEGORY_AUGMENTATIONS;
		SlotIndex				-1;
		MaxNumberItems			9999;
		UseButtonAction			INVENTORY_ACTION_NULL;
		Orientation				INVENTORY_ORIENTATION_LEFT_45_DEGREES;
	<\CInventoryItemDef>
	
	GroupDef				GO_AUGMENTATIONS;

#end_definition


//*******************************************************************************************
#definition_template	OBJECT	OBJECT_HEAD_DECAP_TEMPLATE specialises OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
	DieOffTimer				400;
	<CPhysicsDef>
		Diameter			0.3;
		Elasticity			0.8;
		Friction			0.7;
		AirResistance		0.03;
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE| PHYSICS_COLLIDE_THINGS_ONEWAY;
	<\CPhysicsDef>
	Material				MATERIAL_FLESH_HUMAN;
	FloorMaterial			MATERIAL_FLESH_HUMAN;
	AlwaysFrameUpdate		TRUE;
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_SHOT_DEFAULT);
	<\CHitLocationsDef>
		
	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type			TARGETING_STAB;
	<\CTargetingDef>
	Components.Add("CTCWeaponTrail");
	<CKickableDef>
		BaseDistanceToTravel	7.0;
		StrengthScaleRange		20.0;
		SpeedScaleRange			20.0;
		BaseSpeedScaleRange		20.0;
		RandomBase				0.8;
		RandomRange				0.4;
		ShotToAttach			SHOT_KICKED_HEAD;
		
		OpinionDeedType				OPINION_DEED_TYPE_EXPRESSION_FART;
		OpinionDeedTypeToEnemies	OPINION_DEED_TYPE_GENERIC_INCOMPREHENSION;
	<\CKickableDef>
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_BOOK_STORY_TEMPLATE	specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE

		Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
		Graphic.BankIndex			MESH_BOOK_OPEN_02;
		Material					MATERIAL_CLOTH;

		Property					THING_OBJECT_PROPERTY_AUTO_PICKUP;
		<CPhysicsDef>
			InteractionFlags		PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_INTERACT_THINGS;
			Diameter				1.0;
		<\CPhysicsDef>

		Components.Add("CTCTargeted");
		<CTargetingDef>
			Type					TARGETING_USABLE;
		<\CTargetingDef>

		Components.Add("CTCActionUsePutInInventory");
		Components.Add("CTCCarryable");
		<CCarryableDef>
			ActiveCarrySlot			CARRY_SLOT_RIGHT_HAND;
			PassiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
		<\CCarryableDef>

		<CCarriedReadableDef>
		<\CCarriedReadableDef>

		Components.Add("CTCInventoryItem");
		<CInventoryItemDef>
			Graphic.Type			ENGINE_GRAPHIC_SPRITE;
			Graphic.RenderSizeX		1.0;
			Graphic.AnimStep		1;
			Graphic.AdditiveAlpha	FALSE;

			InventoryCategory		INVENTORY_CATEGORY_DESIGNS;
			SlotIndex				6;
			MaxNumberItems			1;
			UseButtonAction			INVENTORY_ACTION_NULL; //INVENTORY_ACTION_CALL_EXISTING_THING_TC;
			Orientation				INVENTORY_ORIENTATION_LEFT_45_DEGREES;
			UIInventoryCategory		UI_INVENTORY_CATEGORY_OTHER;
			IsSellable				FALSE;
		<\CInventoryItemDef>

		GroupDef					GO_INVENTORY_ITEMS;
#end_definition

//*******************************************************************************************
#definition_template	OBJECT	OBJECT_NAME_TEMPLATE	specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE
		Graphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
		Graphic.BankIndex		MESH_BOOK_OPEN_02;
		Material				MATERIAL_CLOTH;

		Components.Add("CTCTargeted");
		<CTargetingDef>
			Type				TARGETING_USABLE;
		<\CTargetingDef>

		Components.Add("CTCActionUsePutInInventory");
		Components.Add("CTCCarryable");
		<CCarryableDef>
			ActiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
			PassiveCarrySlot	CARRY_SLOT_RIGHT_HAND;
		<\CCarryableDef>

		<CCarriedReadableDef>
		<\CCarriedReadableDef>

		Components.Add("CTCInventoryItem");
		<CInventoryItemDef>
			Graphic.Type			ENGINE_GRAPHIC_SPRITE;
			Graphic.RenderSizeX		1.0;
			Graphic.AnimStep		1;
			Graphic.AdditiveAlpha	FALSE;

			InventoryCategory		INVENTORY_CATEGORY_DESIGNS;
			SlotIndex				6;
			MaxNumberItems			1;
			UseButtonAction			INVENTORY_ACTION_CALL_EXISTING_THING_TC;
			Orientation				INVENTORY_ORIENTATION_LEFT_45_DEGREES;
			UIInventoryCategory		UI_INVENTORY_CATEGORY_OTHER;
		<\CInventoryItemDef>

		GroupDef				GO_INVENTORY_ITEMS;
#end_definition

//*******************************************************************************************
#definition_template OBJECT	OBJECT_POTION_TEMPLATE	specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type					TARGETING_USABLE;
					<\CTargetingDef>

					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Material					MATERIAL_METAL;

					Components.Add("CTCActionUsePutInInventory");
					Components.Add("CTCCarriedActionUsePotion");
					Components.Add("CTCStockItem");
					
					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot			CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
					<\CCarryableDef>

					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type			ENGINE_GRAPHIC_SPRITE;
						Graphic.RenderSizeX		1.0;
						Graphic.AnimStep		1;
						Graphic.AdditiveAlpha	FALSE;

						InventoryCategory		INVENTORY_CATEGORY_FOOD;
						SlotIndex				0;
						MaxNumberItems			9999;
						UseButtonAction			INVENTORY_ACTION_CALL_EXISTING_THING_TC_WITHOUT_INVENTORY_CLOSE;
						UIInventoryCategory		UI_INVENTORY_CATEGORY_POTIONS;
						TutorialCategory		TUTORIAL_CATEGORY_POTION;
					<\CInventoryItemDef>

					GroupDef					GO_INVENTORY_ITEMS;
#end_definition

//*******************************************************************************************
//************ ARENA AUDIENCE TEMPLATE ******************************************************
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_ARENA_AUDIENCE_TEMPLATE	specialises		OBJECT_VILLAGE_SOLID_FURNITURE_TEMPLATE
 					Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;
					Graphic.BankIndex		MESH_ARENA_AUDIENCE_01;
					RenderFadeDistance			THING_FADE_DIST_LONG;

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type			TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
					<\CTargetingDef>

					Components.Add("CTCEntityEvents");
					
					<CAppearanceDef>
						Animation.Add("DEFAULT",					ANIM_ARENA_AUDIENCE_IDLE_BREATHE_01);
						Animation.Add("CHEER_INTO_01",				ANIM_ARENA_AUDIENCE_CHEER_INTO_01);
						Animation.Add("CHEER_INTO_02",				ANIM_ARENA_AUDIENCE_CHEER_INTO_02);
						Animation.Add("CHEER_LOOP_01",				ANIM_ARENA_AUDIENCE_CHEER_LOOP_01);
						Animation.Add("CHEER_LOOP_02",				ANIM_ARENA_AUDIENCE_CHEER_LOOP_02);
						Animation.Add("CHEER_OUTOF_01",				ANIM_ARENA_AUDIENCE_CHEER_OUTOF_01);
						Animation.Add("CHEER_OUTOF_02",				ANIM_ARENA_AUDIENCE_CHEER_OUTOF_02);
						Animation.Add("CLAP_INTO_02",				ANIM_ARENA_AUDIENCE_CLAP_INTO_02);
						Animation.Add("CLAP_LOOP_02",				ANIM_ARENA_AUDIENCE_CLAP_LOOP_02);
						Animation.Add("CLAP_OUTOF_02",				ANIM_ARENA_AUDIENCE_CLAP_OUTOF_02);
						Animation.Add("IDLE_BREATHE_01",			ANIM_ARENA_AUDIENCE_IDLE_BREATHE_01);
						Animation.Add("IDLE_WEIGHT_SHIFT_INTO_01",	ANIM_ARENA_AUDIENCE_IDLE_WEIGHT_SHIFT_INTO_01);
						Animation.Add("IDLE_WEIGHT_SHIFT_LOOP_01",	ANIM_ARENA_AUDIENCE_IDLE_WEIGHT_SHIFT_LOOP_01);
						Animation.Add("IDLE_WEIGHT_SHIFT_OUTOF_01",	ANIM_ARENA_AUDIENCE_IDLE_WEIGHT_SHIFT_OUTOF_01);
						Animation.Add("SHOUT_INTO_01",				ANIM_ARENA_AUDIENCE_SHOUT_INTO_01);
						Animation.Add("SHOUT_LOOP_01",				ANIM_ARENA_AUDIENCE_SHOUT_LOOP_01);
						Animation.Add("SHOUT_OUTOF_01",				ANIM_ARENA_AUDIENCE_SHOUT_OUTOF_01);
						Animation.Add("THUMBS_DOWN_INTO_01",		ANIM_ARENA_AUDIENCE_THUMBS_DOWN_INTO_01);
						Animation.Add("THUMBS_DOWN_LOOP_01",		ANIM_ARENA_AUDIENCE_THUMBS_DOWN_LOOP_01);
						Animation.Add("THUMBS_DOWN_OUTOF_01",		ANIM_ARENA_AUDIENCE_THUMBS_DOWN_OUTOF_01);
						Animation.Add("WAVE_INTO_01",				ANIM_ARENA_AUDIENCE_WAVE_INTO_01);
						Animation.Add("WAVE_LOOP_01",				ANIM_ARENA_AUDIENCE_WAVE_LOOP_01);
						Animation.Add("WAVE_OUTOF_01",				ANIM_ARENA_AUDIENCE_WAVE_OUTOF_01);
					<\CAppearanceDef>
					
					<CAnimatingObjectDef>
						Animation.Add("DEFAULT",					ANIM_ARENA_AUDIENCE_IDLE_BREATHE_01);
						Animation.Add("CHEER_INTO_01",				ANIM_ARENA_AUDIENCE_CHEER_INTO_01);
						Animation.Add("CHEER_INTO_02",				ANIM_ARENA_AUDIENCE_CHEER_INTO_02);
						Animation.Add("CHEER_LOOP_01",				ANIM_ARENA_AUDIENCE_CHEER_LOOP_01);
						Animation.Add("CHEER_LOOP_02",				ANIM_ARENA_AUDIENCE_CHEER_LOOP_02);
						Animation.Add("CHEER_OUTOF_01",				ANIM_ARENA_AUDIENCE_CHEER_OUTOF_01);
						Animation.Add("CHEER_OUTOF_02",				ANIM_ARENA_AUDIENCE_CHEER_OUTOF_02);
						Animation.Add("CLAP_INTO_02",				ANIM_ARENA_AUDIENCE_CLAP_INTO_02);
						Animation.Add("CLAP_LOOP_02",				ANIM_ARENA_AUDIENCE_CLAP_LOOP_02);
						Animation.Add("CLAP_OUTOF_02",				ANIM_ARENA_AUDIENCE_CLAP_OUTOF_02);
						Animation.Add("IDLE_BREATHE_01",			ANIM_ARENA_AUDIENCE_IDLE_BREATHE_01);
						Animation.Add("IDLE_WEIGHT_SHIFT_INTO_01",	ANIM_ARENA_AUDIENCE_IDLE_WEIGHT_SHIFT_INTO_01);
						Animation.Add("IDLE_WEIGHT_SHIFT_LOOP_01",	ANIM_ARENA_AUDIENCE_IDLE_WEIGHT_SHIFT_LOOP_01);
						Animation.Add("IDLE_WEIGHT_SHIFT_OUTOF_01",	ANIM_ARENA_AUDIENCE_IDLE_WEIGHT_SHIFT_OUTOF_01);
						Animation.Add("SHOUT_INTO_01",				ANIM_ARENA_AUDIENCE_SHOUT_INTO_01);
						Animation.Add("SHOUT_LOOP_01",				ANIM_ARENA_AUDIENCE_SHOUT_LOOP_01);
						Animation.Add("SHOUT_OUTOF_01",				ANIM_ARENA_AUDIENCE_SHOUT_OUTOF_01);
						Animation.Add("THUMBS_DOWN_INTO_01",		ANIM_ARENA_AUDIENCE_THUMBS_DOWN_INTO_01);
						Animation.Add("THUMBS_DOWN_LOOP_01",		ANIM_ARENA_AUDIENCE_THUMBS_DOWN_LOOP_01);
						Animation.Add("THUMBS_DOWN_OUTOF_01",		ANIM_ARENA_AUDIENCE_THUMBS_DOWN_OUTOF_01);
						Animation.Add("WAVE_INTO_01",				ANIM_ARENA_AUDIENCE_WAVE_INTO_01);
						Animation.Add("WAVE_LOOP_01",				ANIM_ARENA_AUDIENCE_WAVE_LOOP_01);
						Animation.Add("WAVE_OUTOF_01",				ANIM_ARENA_AUDIENCE_WAVE_OUTOF_01);
					<\CAnimatingObjectDef>

					
					Components.Add("CTCAnimatingObject");
					Components.Add("CTCAnimationComplex");
					Components.Remove("CTCGraphicAppearanceStaticMesh");
					Components.Add("CTCGraphicAppearanceAnimatedMesh");

					
					Material				MATERIAL_STRAW;

					GroupDef				GO_REGION_ARENA;	
#end_definition

//*******************************************************************************************
//************ GENERIC TATTOO CARDS *********************************************************
//*******************************************************************************************
#definition_template	OBJECT	OBJECT_TATTOO_CARD_TEMPLATE	specialises OBJECT_ITEM_NONHOLDABLE_TEMPLATE

					Graphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
					Graphic.BankIndex			MESH_TATTOO_CARD_01;
					Material					MATERIAL_WOOD;

					Property					THING_OBJECT_PROPERTY_AUTO_PICKUP;
					<CPhysicsDef>
						InteractionFlags		PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY | PHYSICS_INTERACT_THINGS;
						Diameter				1.0;
					<\CPhysicsDef>

					Components.Add("CTCInventoryItem");
					<CInventoryItemDef>
						Graphic.Type			ENGINE_GRAPHIC_SPRITE;
						Graphic.BankIndex		HUD_ICON_CARD_TATTOO;
						Graphic.RenderSizeX		1.0;
						Graphic.AnimStep		1;
						Graphic.AdditiveAlpha	FALSE;

						ItemDescription			TEXT_GUI_TATTOO;
						InventoryCategory		INVENTORY_CATEGORY_DESIGNS;
						SlotIndex				6;
						MaxNumberItems			1;
						UseButtonAction			INVENTORY_ACTION_NULL; //INVENTORY_ACTION_CALL_EXISTING_THING_TC;
						Orientation				INVENTORY_ORIENTATION_BACKWARDS_45_DEGREES;
						UIInventoryCategory		UI_INVENTORY_CATEGORY_OTHER;
						TutorialCategory		TUTORIAL_CATEGORY_TATTOO;
					<\CInventoryItemDef>

					Components.Add("CTCStockItem");
					<CStockItemDef>
						DefaultPrice			50;
					<\CStockItemDef>

					<CTattooDef>
						TextureLayer			6;
						ReplacingTextureIndex	HERO_SKIN_TORSO;
						BankIndex				COMP_HERO_SKIN_TORSO_TATTOO;
						
						CoversBodyAreaFlags		COVERS_BODY_AREA_BODY;
						Attractiveness			0.0;
						Scariness				0.0;
						Goodstrength			0.0;
						VisibilityMultiplier	1.01;
					<\CTattooDef>

					Components.Add("CTCTargeted");
					<CTargetingDef>
						Type					TARGETING_USABLE;
					<\CTargetingDef>

					Components.Add("CTCActionUsePutInInventory");
					Components.Add("CTCCarriedActionUseShow");
					Components.Add("CTCCarryable");
					<CCarryableDef>
						ActiveCarrySlot			CARRY_SLOT_RIGHT_HAND;
						PassiveCarrySlot		CARRY_SLOT_RIGHT_HAND;
					<\CCarryableDef>

					GroupDef					GO_INVENTORY_ITEMS;
#end_definition
