#pragma once

#ifndef __KEYBOARD_KEYS_H__
#define __KEYBOARD_KEYS_H__

//-------------------------------------------------------------------------------------------------
enum EInputKey
{
    KB_NULL = 0,
	KB_ESC,
	KB_1,
	KB_2,
	KB_3,
	KB_4,
	KB_5,
	KB_6,
	KB_7,
	KB_8,
	KB_9,
	KB_0,
	KB_MINUS,			// - on main keyboard
	KB_EQUALS,
	KB_BACKSPACE,		// backspace
	KB_TAB,
	KB_Q,
	KB_W,
	KB_E,
	KB_R,
	KB_T,
	KB_Y,
	KB_U,
	KB_I,
	KB_O,
	KB_P,
	KB_LBRACKET,
	KB_RBRACKET,
	KB_RETURN,			// Enter on main keyboard
	KB_LCONTROL,
	KB_A,
	KB_S,
	KB_D,
	KB_F,
	KB_G,
	KB_H,
	KB_J,
	KB_K,
	KB_L,
	KB_SEMICOLON,
	KB_APOSTROPHE,
	KB_HASH,			// accent grave
	KB_LSHIFT,
	KB_BACKSLASH,
	KB_Z,
	KB_X,
	KB_C,
	KB_V,
	KB_B,
	KB_N,
	KB_M,
	KB_COMMA,
	KB_FULLSTOP,		// . on main keyboard
	KB_SLASH,			// / on main keyboard
	KB_RSHIFT,
	KB_PMULTIPLY,		// * on numeric keypad
	KB_LALT,			// left Alt
	KB_SPACE,
	KB_CAPSLOCK,
	KB_F1,
	KB_F2,
	KB_F3,
	KB_F4,
	KB_F5,
	KB_F6,
	KB_F7,
	KB_F8,
	KB_F9,
	KB_F10,
	KB_NUMLOCK,
	KB_SCROLLLOCK,		// Scroll Lock
	KB_P7,
	KB_P8,
	KB_P9,
	KB_PMINUS,			// - on numeric keypad
	KB_P4,
	KB_P5,
	KB_P6,
	KB_PPLUS,			// + on numeric keypad
	KB_P1,
	KB_P2,
	KB_P3,
	KB_P0,
	KB_PFULLSTOP,		// . on numeric keypad
	KB_F11,
	KB_F12,
	KB_F13,				//                     (NEC PC98)
	KB_F14,				//                     (NEC PC98)
	KB_F15,				//                     (NEC PC98)
	KB_KANA,			// (Japanese keyboard)
	KB_CONVERT,			// (Japanese keyboard)
	KB_NOCONVERT,		// (Japanese keyboard)
	KB_YEN,				// (Japanese keyboard)
	KB_PEQUALS,			// = on numeric keypad (NEC PC98)
	KB_CIRCUMFLEX,		// (Japanese keyboard)
	KB_AT,				//                     (NEC PC98)
	KB_COLON,			//                     (NEC PC98)
	KB_UNDERLINE,		//                     (NEC PC98)
	KB_KANJI,			// (Japanese keyboard)
	KB_STOP,			//                     (NEC PC98)
	KB_AX,				//                     (Japan AX)
	KB_UNLABELED,		//                        (J3100)
	KB_PENTER,			// Enter on numeric keypad
	KB_RCONTROL,
	KB_PCOMMA,			// , on numeric keypad (NEC PC98)
	KB_PDIVIDE,			// / on numeric keypad
	KB_SYSRQ,
	KB_RALT,			// right Alt
	KB_HOME,			// Home on arrow keypad
	KB_UP,				// UpArrow on arrow keypad
	KB_PAGEUP,			// PgUp on arrow keypad
	KB_LEFT,			// LeftArrow on arrow keypad
	KB_RIGHT,			// RightArrow on arrow keypad
	KB_END,				// End on arrow keypad
	KB_DOWN,			// DownArrow on arrow keypad
	KB_PAGEDOWN,		// PgDn on arrow keypad
	KB_INSERT,			// Insert on arrow keypad
	KB_DELETE,			// Delete on arrow keypad
	KB_LWIN,			// Left Windows key
	KB_RWIN,			// Right Windows key
	KB_APPS,			// AppMenu key

	NO_INPUT_KEYS
};


#endif //__KEYBOARD_KEYS_H__