#pragma once
#ifndef __INVENTORY_H__
#define __INVENTORY_H__

//---------------------------------------------------------------------------
enum EInventoryActionType
{
	INVENTORY_ACTION_NULL,
	INVENTORY_ACTION_CALL_EXISTING_THING_TC,
	INVENTORY_ACTION_CALL_EXISTING_THING_TC_WITHOUT_INVENTORY_CLOSE,
};

//---------------------------------------------------------------------------
enum EInventoryObjectOrientation
{
	INVENTORY_ORIENTATION_DEFAULT,
	INVENTORY_ORIENTATION_45_DEGREES,
	INVENTORY_ORIENTATION_RIGHT_45_DEGREES,
	INVENTORY_ORIENTATION_LEFT_45_DEGREES,
	INVENTORY_ORIENTATION_UPSIDE_DOWN,
	INVENTORY_ORIENTATION_UPSIDE_DOWN_45_DEGREES,
	INVENTORY_ORIENTATION_UPSIDE_DOWN_RIGHT_45_DEGREES,
	INVENTORY_ORIENTATION_UPSIDE_DOWN_LEFT_45_DEGREES,
	INVENTORY_ORIENTATION_BACKWARDS,
	INVENTORY_ORIENTATION_BACKWARDS_45_DEGREES,
	INVENTORY_ORIENTATION_BACKWARDS_RIGHT_45_DEGREES,
	INVENTORY_ORIENTATION_BACKWARDS_LEFT_45_DEGREES,
};

namespace NInventory
{
	enum EInventoryIdentifier
	{
		INVENTORY_IDENTIFIER_NONE,

		INVENTORY_IDENTIFIER_INVENTORY,
		INVENTORY_IDENTIFIER_CLOTHING,
		INVENTORY_IDENTIFIER_WEAPONS,
		INVENTORY_IDENTIFIER_ABILITIES,
		INVENTORY_IDENTIFIER_MAP,
		INVENTORY_IDENTIFIER_MAGIC,
		INVENTORY_IDENTIFIER_STATS,
		INVENTORY_IDENTIFIER_EXPERIENCE,
		INVENTORY_IDENTIFIER_TRADE,
		INVENTORY_IDENTIFIER_AUGMENT,
		INVENTORY_IDENTIFIER_QUEST_SELECT,
		INVENTORY_IDENTIFIER_QUEST_REVIEW,

		INVENTORY_IDENTIFIER_MAX_IDENTIFIERS
	};

	enum EInventoryCategoryIdentifier
	{
		INVENTORY_CATEGORY_NONE,

		INVENTORY_CATEGORY_IDENTIFIER_EXPERIENCE_STRENGTH,
		INVENTORY_CATEGORY_IDENTIFIER_EXPERIENCE_SKILL,
		INVENTORY_CATEGORY_IDENTIFIER_EXPERIENCE_WILL_WEAPON_MAGIC,
		INVENTORY_CATEGORY_IDENTIFIER_EXPERIENCE_WILL_ABILITY_MAGIC,
		INVENTORY_CATEGORY_IDENTIFIER_EXPERIENCE_WILL_PURE_MAGIC,

		INVENTORY_CATEGORY_IDENTIFIER_MAP_WORLD_MAP,
		INVENTORY_CATEGORY_IDENTIFIER_MAP_REGIONS,
		INVENTORY_CATEGORY_IDENTIFIER_MAP_QUESTS,
		INVENTORY_CATEGORY_IDENTIFIER_MAP_TELEPORTS,
		INVENTORY_CATEGORY_IDENTIFIER_MAP_HOUSES,

		INVENTORY_CATEGORY_IDENTIFIER_TRADE_BUY,
		INVENTORY_CATEGORY_IDENTIFIER_TRADE_SELL,

		INVENTORY_CATEGORY_IDENTIFIER_AUGMENT_FLAME,
		INVENTORY_CATEGORY_IDENTIFIER_AUGMENT_EXTRA_DAMAGE,
		INVENTORY_CATEGORY_IDENTIFIER_AUGMENT_SILVER,
		INVENTORY_CATEGORY_IDENTIFIER_AUGMENT_LIGHTNING,
		INVENTORY_CATEGORY_IDENTIFIER_AUGMENT_DIAMOND,
		INVENTORY_CATEGORY_IDENTIFIER_AUGMENT_ADD_SLOT,

		INVENTORY_CATEGORY_MAX_IDENTIFIERS
	};
}

#endif //__INVENTORY_H__
