#pragma once
#ifndef __CREATURE_ANIM_H__
#define __CREATURE_ANIM_H__

//-------------------------------------------------------------------------------------------------
enum EAnimationFlags
{
	ANIM_FLAG_CANNOT_BLEND_OUT				= 1<<0,
	ANIM_FLAG_PRELOAD						= 1<<2,
	ANIM_FLAG_DISALLOW_COMBINATION_ANIMS	= 1<<3,
	ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT	= 1<<4,
};

//-------------------------------------------------------------------------------------------------
enum ECombatAnimationHandedness
{
	HANDED_RIGHT,
	HANDED_LEFT,
	HANDED_NONE,
};

//-------------------------------------------------------------------------------------------------
enum ECombatStrikeRecoilStyle
{
	RECOIL_BREAK_HANDEDNESS = 0,
	RECOIL_MAINTATIN_HANDEDNESS,
	RECOIL_NONE,
	MAX_NUMBER_OF_RECOIL_TYPES,
};

//-------------------------------------------------------------------------------------------------
namespace NCreatureMode
{
	enum EMode
	{
		MODE_NULL=0,
		MODE_STAND,
		MODE_STAND_HAPPY,
		MODE_STAND_BORED,
		MODE_CARRYING_WEAPON_STAND,
		MODE_CARRYING_PLATE_STAND,
		MODE_CARRYING_GOODS_STAND,
		MODE_SNEAK,
		MODE_SIT_CHAIR,
		MODE_SIT_BENCH,
		MODE_SIT_FLOOR,
		MODE_SIT_TAVERN_STOOL,
		MODE_BLOCK,
		MODE_SLEEP_BED,
		MODE_COOK,
		MODE_SCARED,
		MODE_OUTRAGED,
		MODE_CREEPING,
		MODE_CHEERING,
		MODE_HECKLING,
		MODE_SAD,
		MODE_ATTRACTED,
		MODE_HERO_IMITATION,
		MODE_CURIOUS,
		MODE_BULLY,
		MODE_STRAFE,
		MODE_HOVER,
		MODE_CONVERSATION,
		MODE_STAND_IN_ALL_DIRECTIONS,
		MODE_STUNNED,
		MODE_UNDERGROUND,
		MODE_KNOCKED_DOWN,
		MODE_FORCE_PUSHED,
		MODE_FISHING,
		MODE_CARRYING_GENERIC_BOX,
		MODE_BATTLE_CHARGE,
		MODE_BERSERK,
		MODE_ASSASSIN_RUSH,
		MODE_WADING,
		MODE_DRINKING_FROM_TANKARD,
		MODE_EATING_AT_TABLE,
		MODE_HOLD_JUG,
		MODE_SERVE_CUSTOMER,
		MODE_FILL_JUG,
		MODE_DRUNK,
		MODE_ARMS_OFF_TABLE,
		MODE_HANDS_BOUND,
		MODE_SCORPION_KING_TAIL_PLUNGE,
		MODE_JACK_OF_BLADES_SUMMON,
		MODE_JACK_OF_BLADES_FLOAT,
		MODE_JACK_OF_BLADES_FLASH,
		MODE_JACK_OF_BLADES_SCREAM,
		MODE_JACK_OF_BLADES_VULNERABLE,
		MODE_JACK_OF_BLADES_DEATH,
		MODE_THUNDER_LIGHTNING_STORM,
		MODE_SCORPION_KING_VULNERABLE,
		MODE_SCORPION_KING_EXHAUSTED,
		MODE_CREATURE_IS_PROJECTILE,
		MODE_ROCK_TROLL_VULNERABLE,
		MODE_GUILDMASTER_CONCENTRATE,
		MODE_GUILDMASTER_POWERUP_HEAL,
		MODE_GUILDMASTER_POWERUP_SHIELD,
		MODE_GUILDMASTER_POWERUP_SPEED,
		MODE_BRIAR_ROSE_CONCENTRATE,
		MODE_BRIAR_ROSE_INVULNERABLE,
		MODE_BRIAR_ROSE_INTANGIBLE,
		MODE_EXPLOSIVE_FORCE_PUSHED,
		MODE_DAZED,
		MODE_SCREAMER_AGGRESSIVE,
		MODE_DRAINED,
		MODE_ROLL,
		MODE_DRAGON_HOVER,
		MODE_DRAGON_SWOOP,
		MODE_DRAGON_DEFAULT,
		MODE_DRAGON_REAR_UP,
		MODE_DRAGON_FIRE_BEAM,
		MODE_DRAGON_STRAFE,
		MODE_DRAGON_STRAFE_BURNINATE,
		MODE_DRAGON_LANDED,
		MODE_DRAGON_GET_HIT,
		MODE_DRAGON_FLYING,
		MODE_INTANGIBLE,
		MODE_DRAGON_HOVER_NAPALM_GROUND,
		MODE_VULNERABLE,
		MODE_UNDERWATER,
		MODE_DRAGON_HOVER_CHARGE_UP_NAPALM_GROUND,
		MODE_CAGED,
		MODE_SCRIPTED,
		MODE_BASIC,
		MODE_SUMMONER_SUMMON,
		MODE_SUMMONER_LIGHTNING_ORB,
		MODE_CHARGE_FORCE_PUSH,
		MODE_SUMMONER_DIE,
		MODE_ICE_TROLL_ICICLE_ASSAULT,
		MODE_SCREAMER_SUPER_ATTACK,
		MODE_HIT_BY_EPIC_SPELL,
	};
};

//-------------------------------------------------------------------------------------------------
enum EActionRegisteredType
{
	ACTION_NULL = 0,
	ACTION_JACK_OF_BLADES_HIT_RESPONSE,
	ACTION_SCORPION_KING_HIT_RESPONSE,
	ACTION_MAZE_CAUSE_FORCE_PUSH_HIT_RESPONSE,
	ACTION_ROCK_TROLL_DEATH,
	ACTION_KING_SCORPION_DEATH,
	ACTION_WASP_QUEEN_DEATH,
	ACTION_COMBAT_GENERIC_PROJECTILE_WEAPON_AIM,
	ACTION_COMBAT_GENERIC_PROJECTILE_WEAPON_FIRE,
	ACTION_COMBAT_GENERIC_PROJECTILE_WEAPON_LOAD,
	ACTION_COMBAT_GENERIC_LEADER_COMMAND,
	ACTION_COMBAT_GENERIC_BOAST,
	ACTION_COMBAT_UNBLOCKABLE_ATTACK,
	ACTION_COMBAT_HOP_BACK,
	ACTION_COMBAT_STRAFE_FORWARD,
	ACTION_COMBAT_STRAFE_BACKWARD,
	ACTION_COMBAT_STRAFE_LEFT,
	ACTION_COMBAT_STRAFE_RIGHT,
	ACTION_COMBAT_STRAFE_BACK_LEFT,
	ACTION_COMBAT_STRAFE_BACK_RIGHT,
	ACTION_COMBAT_CHARGE,
	ACTION_COMBAT_IDLE,
	ACTION_BREAK_INTO_MELEE,
	ACTION_COMBAT_SUMMON_CREATURES,
	ACTION_COMBAT_ATTACK_LUNGE,
	ACTION_COMBAT_ATTACK_MAIN,
	ACTION_COMBAT_ATTACK_KNOCKDOWN,
	ACTION_COMBAT_ATTACK_SIDE,
	ACTION_COMBAT_ATTACK_SHORT_RANGE,
	ACTION_BANDIT_KING_HIT_RESPONSE,
	ACTION_BANDIT_KING_STUCK_HIT_RESPONSE,
	ACTION_HOBBE_SPELLCASTER_AIM,
	ACTION_HOBBE_SPELLCASTER_FIRE,
	ACTION_HOBBE_LUNGE,
	ACTION_TENTACLE_HIT_RESPONSE,
	ACTION_SCREAMER_DIE,
	ACTION_SCREAMER_DRAIN_ATTACK,
	ACTION_SCREAMER_DRAIN_OUT_OF,
	ACTION_SCREAMER_ADVANCE,
	ACTION_SCREAMER_BACK_OFF,
	ACTION_SCREAMER_IDLE,
	ACTION_COMBAT_BODGE_SIDE_ATTACK,
	ACTION_COMBAT_TURN_STRIKE_LEFT,
	ACTION_COMBAT_TURN_STRIKE_RIGHT,
	ACTION_COMBAT_CHARGE_STRIKE,
	ACTION_NYMPH_GET_HIT,
	ACTION_NYMPH_GET_HIT_DIE,
	ACTION_BALVERINE_LUNGE_ATTACK,
	ACTION_BALVERINE_BREAK_OFF_FROM_COMBAT,
	ACTION_BALVERINE_BREAK_OFF_FROM_COMBAT_LONG,
	ACTION_SUMMONER_FLAME_SLICE,
	ACTION_SUMMONER_UNSHEATHE_STRIKE,
	ACTION_SUMMONER_STRIKE,
	ACTION_BATTLE_CHARGE,
	ACTION_SUMMONER_DIE,
};

#endif //__CREATURE_ANIM_H__
