//*************************************************************************************************
#definition_template CREATURE CREATURE_BASE_TEMPLATE

	Components.Add("CTCAnimationComplex");
	Components.Add("CTCGraphicAppearance");
	Components.Add("CTCTalk");
	Components.Add("CTCCreatureNavigation");
	Components.Add("CTCAvoidRegionExit");
	<CCreatureNavigationDef>
		MinPathCost			1.0;
		MaxPathCost			10.0;
		Radius				0.5;
	<\CCreatureNavigationDef>
	Components.Add("CTCScriptedControl");
	Components.Add("CTCCreatureModeManager");
	Components.Add("CTCEntityEvents");
	Components.Add("CTCDayOrNightOnlySupport");
	Components.Add("CTCVolumeContainmentTracker");
	
	<CTCVolumeContainmentTrackerDef>
		CalculateBlendedLightingChannel FALSE;
		UpdateEveryFrame FALSE;
	<\CTCVolumeContainmentTrackerDef>	
	
	Components.Add("CTCHitLocations");
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_CREATURE_DEFAULT);
	<\CHitLocationsDef>

	IsDrawable				TRUE;
	Components.Add("CTCEmoteIcon");
	
//	RenderFadeDistance		THING_FADE_DIST_MEDIUM;
	RenderFadeDistance		THING_FADE_DIST_CREATURES;
	PersistenceFlags		EPF_MOVING;
	
	LeaveDeadCreature		TRUE;
	
	<CWeaponDef>
		FlourishParticles										CObjectAugmentationParticleSet(0,1,FLOURISH_WISP_SHORT_01, FLOURISH_WISP_LONG_01, 0, 0, "AUG_01", "AUG_02");
		FlourishSpecialWeaponTrail									CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FLOURISH_01, SPRITE_WEAPON_TRAIL_FLOURISH_01);
		WeaponTrails[AUGMENTATION_NULL]								CWeaponTrailGraphicSet(GRAPHIC_WEAPON_TRAIL, GRAPHIC_WEAPON_TRAIL2);
		WeaponTrails[AUGMENTATION_FLAME]							CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_01, SPRITE_WEAPON_TRAIL_FIRE_01);
		WeaponTrails[AUGMENTATION_LIGHTNING]						CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_LIGHTNING_01, SPRITE_WEAPON_TRAIL_LIGHTNING_01);
		WeaponTrails[AUGMENTATION_LIGHTNING|AUGMENTATION_FLAME]		CWeaponTrailGraphicSet(SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01, SPRITE_WEAPON_TRAIL_FIRE_LIGHTNING_01);
	<\CWeaponDef>
	
	<CTargetingDef>
		Type				TARGETING_MELEE | TARGETING_SHOOTABLE | TARGETING_ZTARGETING;
		
//		RangeSpecialAbility		20.0;
		TargetingRanges[TARGETING_USABLE]		4.0;
		TargetingRanges[TARGETING_TALKABLE]		6.0;
		TargetingRanges[TARGETING_STAB]			2.5;
		TargetingRanges[TARGETING_SHOOTABLE]	28.0;
		TargetingRanges[TARGETING_MELEE]		14.0;
		
		PreferPlayerWeight						1.25;
		PreferNonCombatantsWeight				2.0;
		PreferLastAttackerWeight				2.1;	// prefer your last attacker over hero
		PreferCurrentBestEnemyWeight			3.0;	// prefer your current target
	<\CTargetingDef>
	
	DeadBodyDecayEffect		DEATH_CRUMBLE_HUMAN;

	<CLookDef>
		EyesTurnRangeXY		20.0;
		EyesTurnRangeYZ		0.0;
		HeadTurnRangeXY		135.0;
		HeadTurnRangeYZUp	45.0;
		HeadTurnRangeYZDown	45.0;
		CutOffNoLooking		14.0;
	<\CLookDef>

	Components.Add("CTCOverheadDisplay");
	<COverheadDisplayDef>
		DisplayDamage		TRUE;
		DisplayRepair		TRUE;
		DisplayRenown		FALSE;
	<\COverheadDisplayDef>

	<CCreatureModeDef>
		DefaultCreatureMode				MODE_STAND;
		InitialCreatureMode				MODE_NULL;
		DefaultWeaponCreatureMode		MODE_CARRYING_WEAPON_STAND;
	<\CCreatureModeDef>

	<CEntitySoundDef>
		SoundMap.AddCriteria("FIRE_DEFAULT", "ON_FIRE");
	<\CEntitySoundDef>	

	Components.Add("CTCAIScratchpad");
	<CAIScratchpadDef>
		ThankingPhrase					TEXT_AI_SHOP_CUSTOMER_THANKING; //TEXT_AI_THANKING_PHRASE_BS_VILLAGER;
		IgnoringPhrase					TEXT_AI_SHOP_CUSTOMER_IGNORED; //TEXT_AI_IGNORING_PHRASE_BS_VILLAGER;
		WanderCentrePoint.X				0.0;
		WanderCentrePoint.Y				0.0;
		WanderCentrePoint.Z				0.0;
		WanderMinDistance				0.0;
		WanderMaxDistance				3.0;
		GossipCounter					0;
		MaxGossipPhrase					0;
		ScriptingStateGroup				ESSG_NONE;
		FollowDistance					1.0;
		MaxHeroReactionDistance			0.0;
		ActionFrequency					-1;
		ActionFrequencyVariation		0.0;
		Action							"";
		FaceHeroForAction				BTRUE;
		TargetName						"TestTarget";
		BeerRequestPhrase				TEXT_AI_TAVERN_REQUEST_BEER; //TEXT_AI_BEER_REQUEST_PHRASE;
	<\CAIScratchpadDef>
	
	<CCreatureDef>
		Stats.ExperienceWorth	0;
		Stats.RenownWorth		0;

		Stats.MoralityForKill		0;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		RespawnWaitInDaysMin	0;
		RespawnWaitInDaysMax	0;
		RespawnWaitInFramesMin	0;
		RespawnWaitInFramesMax	0;
	<\CCreatureDef>
	
	<CDecapitationDef>
		Head				OBJECT_SEVERED_HEAD;
		BodyParticleEffect	BLOOD_SPURT;
	<\CDecapitationDef>
	
	AbleToStrafe		FALSE;	
	
	Components.Add("CTCSummonableCreature");
	<CSummonableCreatureDef>
		Rank								-100;
		SummonedBrain						"BRAIN_SUMMONED_HORNET";
	<\CSummonableCreatureDef>
	
	Components.Add("CTCTurncoat");
	<CTurncoatDef>
		Turncoatable							BFALSE;
		TurncoatedEffect						TURNCOAT_ACTIVE;
		TurncoatActivateEffect					TURNCOAT_TURNED;
		TurncoatDeactivateEffect				TURNCOAT_DEACTIVATE;
		MinimumResistance						5.0;
		TimeDelayBeforeResistanceRecoverySecs	2.0;
		ResistanceRecoveryPerSec				2.0;
		
		TurncoatStageEffects[0]					TURNCOAT_LEVEL_01;
		TurncoatStageEffects[1]					TURNCOAT_LEVEL_02;
		TurncoatStageEffects[2]					TURNCOAT_LEVEL_03;
		TurncoatStageEffects[3]					TURNCOAT_LEVEL_04;
		TurncoatStageEffects[4]					TURNCOAT_LEVEL_05;
		
		PercentageOfHealthAsResistance			1.0;
		ExtraResistance							0.0;
	<\CTurncoatDef>
	
	Components.Add("CTCSleep");

	Health 1;
	AddToComboMultiplierOnHit		TRUE;
	GiveHeroStatChangesOnBeingHit	TRUE;

	<CPerceivedThingDef>
		SightRadius 10;
		FieldOfView 120;
		SoundRadius 8;
	<\CPerceivedThingDef>
#end_definition

//*************************************************************************************************
#definition_template CREATURE CREATURE_AI_BASE_TEMPLATE specialises CREATURE_BASE_TEMPLATE

	Components.Add("CTCFamilyMember");
	Components.Add("CTCWaterWader");

	Components.Add("CTCContainerRewardHero");
	<CContainerRewardHeroDef>
//		ObjectFamilies.Add("GOLD_FAMILY_01");
	<\CContainerRewardHeroDef>

	<CEntitySoundDef>
		SoundIdentifier	"SI_HUMAN";
	<\CEntitySoundDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("DRAIN_LIFE",				WILL_LEECH_VICTIM);
		SpecialEffects.Add("BLOOD_SPURT",				BLOOD_SPRAY_UP);
	<\CSpecialEffectsDef>	
	
#end_definition

//*************************************************************************************************
//************ VILLAGERS **************************************************************************
//*************************************************************************************************
#definition_template CREATURE CREATURE_VILLAGER_TEMPLATE specialises CREATURE_AI_BASE_TEMPLATE

	Health						12;
	
	StunHealthThreshold			8;
	StunTimeMin					3;
	StunTimeMax					3;

	SpeedRandomisationFactor	0.1;
	CombatTypeDef				VILLAGER_COMBAT_TYPE;

	MaxAcceleration				0.1;
	<CLookDef>
		MaxTurnSpeed			15.0;
	<\CLookDef>

	GroupDef					G_CREATURES_BOWERSTONE;

	FOV							90;
	Property					NULL;

	GameStatePersisted			FALSE;
	CreateDummyOnDeath			TRUE;

	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type					TARGETING_TALKABLE | TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>

	<CEnemyDef>
		Faction					FACTION_VILLAGERS;
	<\CEnemyDef>
	
	<CWeaponDef>
		DamageType				DAMAGE_MELEE_UNARMED;
	<\CWeaponDef>
	
	Components.Add("CTCCreatureOpinionOfHero");
	<COpinionOfHeroDef>
		ThreatenGift		"OBJECT_CHOCOLATE_BOX_01";
		Personality			OPINION_PERSONALITY_NONE;
		ReactionMask		OPINION_REACTION_MASK_DEFAULT;
	<\COpinionOfHeroDef>

	StunnedParticle				DAZED01STAR;
	
	StunHealthThreshold			10;
	StunTimeMin					5;
	StunTimeMax					5;


	Components.Add("CTCCarrying");
	<CCarryingDef>
		AvailableCarrySlots.Add(CARRY_SLOT_RIGHT_HAND);
		AvailableCarrySlots.Add(CARRY_SLOT_LEFT_HAND);
	<\CCarryingDef>

	IsWillable					TRUE;
	IsVulnerableToMelee			TRUE;
	Damageable					TRUE;
	IsIndestructible			FALSE;
	CreatureType				HUMAN_ADULT;
	PBrain 						BRAIN_BAR_STAFF;
	Sex							SEX_MALE;
	CreatureInteractionType		CREATURE_INTERACTION_CONVERSATION;

	NavigatorTypes.Add(NAV_INIT_GROUND);

	Damage						1.0;

	DefaultOwner				0;

	Components.Add("CTCPhysicsNavigator");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Elasticity			0;
		Friction			1;
		AirResistance		0;
		Mass				75;
		Diameter			0.8;	// Was 0.8 changed by MikeD for the navigation
	<\CPhysicsDef>
	
	<CCreatureNavigationDef>
		Radius				0.3;
	<\CCreatureNavigationDef>

	<CCreatureDef>
		Stats.ExperienceWorth		1;
		Stats.RenownWorth			8;
		Stats.MoralityForKill		-14;
		Stats.MoralityForWeaponHit	-2;
		Stats.MoralityForPunch		-1;

		Inventory					INVENTORY_TYPE_MAIN;
	<\CCreatureDef>

	Components.Add("CTCEnemy");
	Components.Add("CTCTargetingAI");
	Components.Add("CTCVillageMember");
	
	Components.Add("CTCPerceiveThing");
	<CPerceivedThingDef>
		FieldOfView							120;
		SightRadius							10;
		SoundRadius							8;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						10.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
	<\CPerceivedThingDef>

	Components.Add("CTCLook");
	Components.Add("CTCWeaponTrail");

	<CCreatureDef>
		CreatureGroup			CREATURE_GROUP_VILLAGER;
		RespawnWaitInDaysMin	2;
		RespawnWaitInDaysMax	3;

		PickPocketable			TRUE;
	<\CCreatureDef>

	<CFlammableDef>
		EffectCreationSet.Add("weapon_pos_right_hand", ENFLAME_SMALLER);
		EffectCreationSet.Add("weapon_pos_left_hand", ENFLAME_SMALLER);
//		EffectCreationSet.Add("weapon_pos_right_hand", TORCHFIRE_01);
//		EffectCreationSet.Add("weapon_pos_left_hand", TORCHFIRE_01);
	<\CFlammableDef>

	Components.Add("CTCGossip");
	Components.Add("CTCGold");

	Components.Add("CTCIdleScheduler");
	<CIdleSchedulerDef>
		// Only the relative magnitudes of these values are significant.  Double a number to half the frequency of the state
		Period[ISG_CLEAN_HOME]					40;
		Period[ISG_SIT_HOME]					30;
		Period[ISG_SIT_OUTSIDE]					90;
		Period[ISG_SIT_AROUND_FIRE]				30;
		Period[ISG_WATCH_FIRE]					20;
		Period[ISG_GAZE_HOME]					10;
		Period[ISG_GAZE_OUTSIDE]				60;
		Period[ISG_LOOK_AT_INTERESTING_THINGS] 100;
		Period[ISG_WANDER_AROUND_SHOPS]			80;
		Period[ISG_KID_WANDER_NEAR_KIDS]		60;
	<\CIdleSchedulerDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("SINGE",				SINGE_MEDIUM_01);
		SpecialEffects.Add("CS_BACKSHOT",		BLOOD_BACK);
	<\CSpecialEffectsDef>	

	<CContainerRewardHeroDef>
		ObjectFamilies.Add("REWARD_VILLAGER_01");
	<\CContainerRewardHeroDef>
#end_definition

//*************************************************************************************************
#definition_template CREATURE CREATURE_GENERIC_ADULT_MALE_VILLAGER_TEMPLATE specialises CREATURE_VILLAGER_TEMPLATE

	Components.Add("CTCCombat");

	<CCreatureModeDef>
		AvailableIdleModes.Add(MODE_STAND);
		AvailableIdleModes.Add(MODE_STAND_HAPPY);
		AvailableIdleModes.Add(MODE_STAND_BORED);
	<\CCreatureModeDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("BLACKSMITH_SPARKS",	BLACKSMITH_SPARKS);
	<\CSpecialEffectsDef>

	<CCarryingDef>
		AvailableCarrySlots.Add(CARRY_SLOT_ARROW_IN_BACK);
	<\CCarryingDef>

	<CEntitySoundDef>
		SoundIdentifier	"SI_HUMAN_MALE";
	<\CEntitySoundDef>

	<CCreatureDef>
		DialogueVoices.Add("AM1");
		DialogueVoices.Add("AM2");
		DialogueVoices.Add("AM3");
	<\CCreatureDef>
	
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_CREATURE_HEAD);
	<\CHitLocationsDef>	
	
	<CDecapitationDef>
		Head				OBJECT_BS_MALE_DECAP_HEAD_01;
		BodyParticleEffect	BLOOD_SPURT;
	<\CDecapitationDef>

	<CLookDef>
		EyesTurnRangeXY		20.0;
		EyesTurnRangeYZ		0.0;
		HeadTurnRangeXY		130.0;
		HeadTurnRangeYZUp	50.0;
		HeadTurnRangeYZDown	35.0;
	<\CLookDef>

	<CAppearanceDef>

		Animation.Add("TURNING_AC90",				ANIM_VILLAGER_TURN_90_LEFT_01);
		Animation.Add("TURNING_C90",				ANIM_VILLAGER_TURN_90_RIGHT_01);
		Animation.Add("TURNING_AC180",				ANIM_VILLAGER_TURN_180_LEFT_01);
		Animation.Add("TURNING_C180",				ANIM_VILLAGER_TURN_180_RIGHT_01);

		Animation.StartGroup("TABLELAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_MALE_LAMP_LIGHT_TABLE_01);
		Animation.EndGroup();
		Animation.StartGroup("BOWERSTONE");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_MALE_LAMP_LIGHT_EXTERIOR_01);
		Animation.EndGroup();
		Animation.StartGroup("BANDITCAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_MALE_LAMP_LIGHT_EXTERIOR_01);
		Animation.EndGroup();
		Animation.StartGroup("GENERIC");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_MALE_LAMP_LIGHT_EXTERIOR_01);
		Animation.EndGroup();
		Animation.StartGroup("STREETLAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_MALE_LAMP_LIGHT_EXTERIOR_01);
		Animation.EndGroup();
		Animation.StartGroup("CUPBOARDLAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_MALE_LAMP_LIGHT_CUPBOARD_01);
		Animation.EndGroup();
		
		Animation.StartGroup("EAT_AT_TABLE");
			Animation.Add("ST_SITTING",					ANIM_VILLAGER_SAT_EAT_LOOP_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_SAT_EAT_LOOP_01);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_SAT_EAT_LOOP_01);
		Animation.EndGroup();
	
		Animation.Add("ST_SEATED_ON_LOG_IDLE",			ANIM_VILLAGER_MALE_SIT_ON_LOG_IDLE_01);
		Animation.Add("ST_SIT_ON_LOG",					ANIM_VILLAGER_MALE_SIT_ON_LOG_01);
		Animation.Add("ST_STAND_FROM_LOG",				ANIM_VILLAGER_MALE_STAND_FROM_LOG_01);
		Animation.Add("ST_DISAPPROVAL_STAMP",			ANIM_VILLAGER_MALE_DISAPPROVAL_STAMP_01);
		
		Animation.Add("ST_WASH_FLOOR_INTO",				ANIM_VILLAGER_MALE_WASH_FLOOR_INTO_01);
		Animation.Add("ST_WASH_FLOOR_LOOP",				ANIM_VILLAGER_MALE_WASH_FLOOR_LOOP_01);
		Animation.Add("ST_WASH_FLOOR_OUTOF",			ANIM_VILLAGER_MALE_WASH_FLOOR_OUTOF_01);
		
		Animation.Add("RUFFLE_CHILD_HAIR",				ANIM_VILLAGER_MALE_RUFFLE_CHILD_HAIR_01);
		Animation.Add("ST_TALK_TO_CHILD",				ANIM_VILLAGER_MALE_TALK_TO_CHILD_01);
		Animation.Add("ST_TALK_TO_CHILD",				ANIM_VILLAGER_MALE_TALK_TO_CHILD_02);
		Animation.Add("ST_CROUCH_TALK_TO_CHILD_INTO",	ANIM_VILLAGER_MALE_CROUCH_TALK_TO_CHILD_INTO_01);
		Animation.Add("ST_CROUCH_TALK_TO_CHILD_LOOP",	ANIM_VILLAGER_MALE_CROUCH_TALK_TO_CHILD_01);
		Animation.Add("ST_CROUCH_TALK_TO_CHILD_OUTOF",	ANIM_VILLAGER_MALE_CROUCH_TALK_TO_CHILD_OUTOF_01);
		Animation.Add("ST_KNEEL_TALK_TO_CHILD_INTO",	ANIM_VILLAGER_MALE_KNEEL_TALK_TO_CHILD_INTO_01);
		Animation.Add("ST_KNEEL_TALK_TO_CHILD_LOOP",	ANIM_VILLAGER_MALE_KNEEL_TALK_TO_CHILD_01);
		Animation.Add("ST_KNEEL_TALK_TO_CHILD_OUTOF",	ANIM_VILLAGER_MALE_KNEEL_TALK_TO_CHILD_OUTOF_01);

		Animation.Add("E3ONLY_SCARED",			E3ONLY_ANIM_BIPED_GENERIC_MAN_SCARED);
		Animation.Add("E3ONLY_BELCH",			E3ONLY_ANIM_VILLAGER_MALE_BELCH);

		Animation.Add("DEFAULT",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD|ANIM_FLAG_DISALLOW_COMBINATION_ANIMS), TransTime(4), Delay(2), Combo(0, 0));
		Animation.Add("ST_POSE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_WALK",				ANIM_BIPED_GENERIC_MAN_WALK, Flags(ANIM_FLAG_PRELOAD));
//		Animation.Add("ST_WALK",				ANIM_BIPED_GENERIC_MAN_WALK_SAD, Flags(ANIM_FLAG_PRELOAD));
//		Animation.Add("ST_WALK",				ANIM_BIPED_GENERIC_MAN_STRUT_WALK, Flags(ANIM_FLAG_PRELOAD));
//		Animation.Add("ST_WALK",				ANIM_BIPED_GENERIC_MAN_RELAXED_WALK, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_DRUNK_WALK",			ANIM_BIPED_GENERIC_MAN_DRUNK_WALK_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_DRUNK_WALK",			ANIM_BIPED_GENERIC_MAN_DRUNK_WALK_02, Flags(ANIM_FLAG_PRELOAD));
//		Animation.Add("ST_SLOW_WALK",			ANIM_BIPED_GENERIC_MAN_SLOW_WALK, Flags(ANIM_FLAG_PRELOAD)); // fucked - causes stupid stretching glitch
		Animation.Add("ST_RUN",					ANIM_VILLAGER_MALE_RUN_01, Flags(ANIM_FLAG_PRELOAD));
   		Animation.Add("STANDARD_WAVE",			ANIM_VILLAGER_FRIENDLY_GREET_01);
   		Animation.Add("STANDARD_WAVE_INFO",		ANIM_VILLAGER_FRIENDLY_GREET_01);
		Animation.Add("STANDARD_HEAD_SCRATCH",	ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
		Animation.Add("PICKING_CROPS",			ANIM_VILLAGER_MALE_PICKING_CROPS_01);
		Animation.Add("ST_CHEER_INTO",			ANIM_VILLAGER_MALE_CHEER_INTO_01);
		Animation.Add("ST_CHEER_LOOP",			ANIM_VILLAGER_MALE_CHEER_LOOP_01);
		Animation.Add("ST_CHEER_LOOP",			ANIM_VILLAGER_MALE_CHEER_LOOP_02);
		Animation.Add("ST_CHEER_OUTOF",			ANIM_VILLAGER_MALE_CHEER_OUT_01);
		Animation.Add("ST_WHISTLE_INTO",		ANIM_VILLAGER_MALE_WHISTLE_INTO_01);
		Animation.Add("ST_WHISTLE_LOOP",		ANIM_VILLAGER_MALE_WHISTLE_LOOP_01);
		Animation.Add("ST_WHISTLE_OUTOF",		ANIM_VILLAGER_MALE_WHISTLE_OUT_01);
		Animation.Add("ST_AGGRESSIVE",			ANIM_VILLAGER_MALE_AGGRESSIVE_01);
		Animation.Add("ST_DISGUSTED",			ANIM_VILLAGER_MALE_DISGUSTED_01);
		Animation.Add("ST_CLEAN_WINDOWS",		ANIM_VILLAGER_MALE_CLEAN_WINDOWS_01);
		Animation.Add("ST_BLOW_HORN",			ANIM_VILLAGER_HORN_BLOW_01);
		Animation.Add("ST_GATE_CLOSE",			ANIM_VILLAGER_GATE_CLOSE_01);
		Animation.Add("ST_LIGHT_LAMP",			ANIM_VILLAGER_LIGHT_LAMP_01);
		Animation.Add("ST_ASK_FOR_BEER",		ANIM_VILLAGER_MALE_ASK_FOR_BEER_01);
		Animation.Add("ST_GHOST_MOVE_FORWARD",	ANIM_VILLAGER_MALE_GHOST_MOVE_FORWARD_01);
		Animation.Add("ST_GHOST_HOVER_IDLE",	ANIM_VILLAGER_MALE_GHOST_HOVER_IDLE);
		Animation.Add("ST_KICKED_WHEN_DEAD",	ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
		
		
		Animation.Add("ST_DECAPITATED_01",				ANIM_VILLAGER_MALE_DECAPITATED_01);
		Animation.Add("ST_DECAPITATED_02",				ANIM_VILLAGER_MALE_DECAPITATED_02);
		Animation.Add("ST_DECAPITATED_DEAD_POSE_01",	ANIM_VILLAGER_MALE_DECAPITATED_DEAD_POSE_01);
		Animation.Add("ST_DECAPITATED_DEAD_POSE_02",	ANIM_VILLAGER_MALE_DECAPITATED_DEAD_POSE_02);
		Animation.Add("ST_DECAPITATED_STUNNED_FOR",		ANIM_VILLAGER_DECAP_STUNNED_01);

		Animation.Add("ST_ON_BLOCK_INTO_01",			ANIM_VILLAGER_ON_BLOCK_INTO_01);
		Animation.Add("ST_ON_BLOCK_LOOP_01",			ANIM_VILLAGER_ON_BLOCK_LOOP_01);
		Animation.Add("ST_ON_BLOCK_OUTOF_01",			ANIM_VILLAGER_ON_BLOCK_OUTOF_01);
		Animation.Add("ST_ON_BLOCK_EXECUTED_01",		ANIM_VILLAGER_ON_BLOCK_EXECUTED_01);
		
		Animation.Add("DISABLED_TURNING_C90",	ANIM_VILLAGER_TURN_90CW);
		Animation.Add("DISABLED_TURNING_AC90",	ANIM_VILLAGER_MALE_TURN_90ACW);
		Animation.Add("DISABLED_TURNING_C180",	ANIM_VILLAGER_TURN_90CW);
		Animation.Add("DISABLED_TURNING_AC180",	ANIM_VILLAGER_MALE_TURN_90ACW);

		Animation.Add("ST_TEACH_INTO",			ANIM_VILLAGER_MALE_TEACH_INTO_01);
		Animation.Add("ST_TEACH_LOOP",			ANIM_VILLAGER_MALE_TEACH_LOOP_01);
		Animation.Add("ST_TEACH_LOOP",			ANIM_VILLAGER_MALE_TEACH_LOOP_02);
		Animation.Add("ST_TEACH_LOOP",			ANIM_VILLAGER_MALE_TEACH_LOOP_03);
		Animation.Add("ST_TEACH_OUTOF",			ANIM_VILLAGER_MALE_TEACH_OUTOF_01);
		
		Animation.Add("ST_TEACH_DESK_INTO",		ANIM_VILLAGER_TEACHER_DESK_BEHIND_INTO_01);
		Animation.Add("ST_TEACH_DESK_LOOP",		ANIM_VILLAGER_TEACHER_DESK_BEHIND_LOOP_01);		
		Animation.Add("ST_TEACH_DESK_LOOP",		ANIM_VILLAGER_TEACHER_DESK_BEHIND_LOOP_02);
		Animation.Add("ST_TEACH_DESK_OUTOF",	ANIM_VILLAGER_TEACHER_DESK_BEHIND_OUTOF_01);
		Animation.Add("ST_TEACH_DESK_BREAKOFF",	ANIM_VILLAGER_TEACHER_DESK_BEHIND_BREAKOFF_01);
		Animation.Add("ST_TEACH_DESK_BREAKOFF",	ANIM_VILLAGER_TEACHER_DESK_BEHIND_BREAKOFF_02);
		
		Animation.Add("ST_SAWING_INTO",			ANIM_VILLAGER_SAWING_INTO_01);
		Animation.Add("ST_SAWING_LOOP",			ANIM_VILLAGER_SAWING_LOOP_01);
		Animation.Add("ST_SAWING_OUTOF",		ANIM_VILLAGER_SAWING_OUTOF_01);		
		
		Animation.Add("ST_SAT_EATING_INTO",		ANIM_VILLAGER_SAT_EAT_INTO_01);
		Animation.Add("ST_SAT_EATING_LOOP",		ANIM_VILLAGER_SAT_EAT_LOOP_01);
		Animation.Add("ST_SAT_EATING_OUTOF",	ANIM_VILLAGER_SAT_EAT_OUTOF_01);	
		
		Animation.Add("ST_DRUNK_TURN_90_LEFT",		ANIM_VILLAGER_DRUNK_TURN_90_LEFT_01);
		Animation.Add("ST_DRUNK_TURN_180_LEFT",		ANIM_VILLAGER_DRUNK_TURN_180_LEFT_01);
		Animation.Add("ST_DRUNK_TURN_90_RIGHT",		ANIM_VILLAGER_DRUNK_TURN_90_RIGHT_01);
		Animation.Add("ST_DRUNK_TURN_180_RIGHT",	ANIM_VILLAGER_DRUNK_TURN_180_RIGHT_01);
		
		Animation.Add("ST_PRAY_INTO",			ANIM_VILLAGER_MALE_PRAY_INTO_01);
		Animation.Add("ST_PRAY_LOOP",			ANIM_VILLAGER_MALE_PRAY_LOOP_01);
		Animation.Add("ST_PRAY_OUTOF",			ANIM_VILLAGER_MALE_PRAY_OUTOF_01);

		Animation.Add("ST_PRAY_STANDING_INTO",	ANIM_VILLAGER_MALE_PRAY_STAND_UP_INTO_01);
		Animation.Add("ST_PRAY_STANDING_LOOP",	ANIM_VILLAGER_MALE_PRAY_STAND_UP_LOOP_01);
		Animation.Add("ST_PRAY_STANDING_OUTOF",	ANIM_VILLAGER_MALE_PRAY_STAND_UP_OUTOF_01);
		
		Animation.StartGroup("HANDS_BOUND");
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_HOSTAGE_BREATHE_LOOP_01);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_HOSTAGE_BREATHE_LOOP_01);
			Animation.Add("ST_WALK",					ANIM_VILLAGER_HOSTAGE_WALK_01);
			Animation.Add("ST_RUN",						ANIM_VILLAGER_HOSTAGE_WALK_01);
		Animation.EndGroup();
		
		Animation.Add("ST_HOSTAGE_IDLE",			ANIM_VILLAGER_HOSTAGE_IDLE_01);
		Animation.Add("ST_HOSTAGE_WALK_LOOP",		ANIM_VILLAGER_HOSTAGE_WALK_LOOP_01);
		Animation.Add("ST_HOSTAGE_WALK_LOOP",		ANIM_VILLAGER_HOSTAGE_WALK_LOOP_02);
		Animation.Add("ST_HOSTAGE_WALK",			ANIM_VILLAGER_HOSTAGE_WALK_01);

		Animation.Add("ST_HOSTAGE_INTO",			ANIM_VILLAGER_HOSTAGE_INTO_01);
		Animation.Add("ST_HOSTAGE_OUTOF",			ANIM_VILLAGER_HOSTAGE_OUTOF_01);
		Animation.Add("ST_HOSTAGE_BREATHE_LOOP",		ANIM_VILLAGER_HOSTAGE_BREATHE_LOOP_01);
				
		Animation.Add("ST_BOOK_LOOK_FOR",			ANIM_VILLAGER_BOOK_LOOK_FOR_01);
		Animation.Add("ST_BOOK_POCKET_PUT_IN",		ANIM_VILLAGER_BOOK_POCKET_PUT_IN_01);
		Animation.Add("ST_BOOK_SHELF_PUT_ON",		ANIM_VILLAGER_BOOK_SHELF_RETURN_TO_01);
		Animation.Add("ST_BOOK_POCKET_TAKE_FROM",	ANIM_VILLAGER_BOOK_POCKET_TAKE_FROM_01);
		Animation.Add("ST_BOOK_SHELF_TAKE_FROM",	ANIM_VILLAGER_BOOK_SHELF_TAKE_FROM_01);
		
		Animation.Add("ST_READ_INTO",						ANIM_VILLAGER_READ_INTO_01);
		Animation.Add("ST_READ_LOOP",						ANIM_VILLAGER_READ_LOOP_01);
		Animation.Add("ST_READ_OUTOF",						ANIM_VILLAGER_READ_OUTOF_01);	

		Animation.Add("ST_LAMP_LIGHT_CUPBOARD_01",			ANIM_VILLAGER_MALE_LAMP_LIGHT_CUPBOARD_01);
		Animation.Add("ST_LAMP_LIGHT_EXTERIOR_01",			ANIM_VILLAGER_MALE_LAMP_LIGHT_EXTERIOR_01);
		Animation.Add("ST_LAMP_LIGHT_TABLE_01",				ANIM_VILLAGER_MALE_LAMP_LIGHT_TABLE_01);	
				
		Animation.Add("ST_LIFT_SWORD_TRY_INTO",				ANIM_VILLAGER_LIFT_SWORD_TRY_INTO_01);
		Animation.Add("ST_LIFT_SWORD_TRY_REST_INTO",		ANIM_VILLAGER_LIFT_SWORD_TRY_REST_INTO_01);
		Animation.Add("ST_LIFT_SWORD_TRY_LOOP",				ANIM_VILLAGER_LIFT_SWORD_TRY_LOOP_01);
		Animation.Add("ST_LIFT_SWORD_TRY_LOOP",				ANIM_VILLAGER_LIFT_SWORD_TRY_LOOP_02);
		Animation.Add("ST_LIFT_SWORD_TRY_REST1",			ANIM_VILLAGER_LIFT_SWORD_TRY_REST_01);
		Animation.Add("ST_LIFT_SWORD_TRY_REST2",			ANIM_VILLAGER_LIFT_SWORD_TRY_REST_02);
		Animation.Add("ST_LIFT_SWORD_TRY_REST_INTO_GIVEUP",	ANIM_VILLAGER_LIFT_SWORD_TRY_REST_INTO_GIVEUP_01);
		Animation.Add("ST_LIFT_SWORD_TRY_REST_INTO_REST",	ANIM_VILLAGER_LIFT_SWORD_TRY_REST_INTO_REST_01);

//	MS8 ANIMS TO BE SORTED
		Animation.Add("ST_BEG_INTO",						ANIM_VILLAGER_BEG_INTO_01);
		Animation.Add("ST_BEG_LOOP",						ANIM_VILLAGER_BEG_LOOP_01);
		Animation.Add("ST_BEG_OUTOF",						ANIM_VILLAGER_BEG_OUTOF_01);	

		Animation.Add("ST_BLOCK_LOOP",						ANIM_VILLAGER_BLOCK_LOOP_01);	
		Animation.Add("ST_BLOCK_RECOIL_LEFT",				ANIM_VILLAGER_BLOCK_RECOIL_LEFT_01);	
		Animation.Add("ST_BLOCK_RECOIL_RIGHT",				ANIM_VILLAGER_BLOCK_RECOIL_RIGHT_01);	
		Animation.Add("ST_BUMP_INTO",						ANIM_VILLAGER_BUMP_INTO_01);	
		Animation.Add("ST_DECAPITATED_03",					ANIM_VILLAGER_DECAPITATED_03);	
		Animation.Add("ST_UNARMED_STRAFE_BACK",				ANIM_VILLAGER_UNARMED_STRAFE_BACK_01);	
		Animation.Add("ST_UNARMED_STRAFE_LEFT",				ANIM_VILLAGER_UNARMED_STRAFE_LEFT_01);	
		Animation.Add("ST_UNARMED_STRAFE_FRONT",			ANIM_VILLAGER_UNARMED_STRAFE_FRONT_01);	
		Animation.Add("ST_UNARMED_PUNCH_UNBLOCKABLE",		ANIM_VILLAGER_UNARMED_PUNCH_UNBLOCKABLE_01);	
//	END OF MS8 ANIMS
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//the complete set of generic responses and dead and stunned etc idles
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",								ANIM_VILLAGER_MALE_KNOCK_DOWN_IDLE_BREATHE_01);
			Animation.Add("ST_IDLE_SUBTLE",							ANIM_VILLAGER_MALE_KNOCK_DOWN_IDLE_BREATHE_01);
			Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",	ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
		Animation.EndGroup();
		
		Animation.AddCombat("DAZED_IDLE",							ANIM_VILLAGER_DAZED_IDLE);
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_DAZED_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_DAZED_IDLE);
			Animation.Add("DAZED_RECOVER",			ANIM_VILLAGER_DAZED_IDLE);
		Animation.EndGroup();
		
		Animation.StartGroup("MORTALLY_WOUNDED");
			Animation.Add("ST_IDLE",										CS_GUILDMASTER_DYING_CYCLE);
			Animation.Add("ST_IDLE_SUBTLE",									CS_GUILDMASTER_DYING_CYCLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				CS_GUILDMASTER_DYING_CYCLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				CS_GUILDMASTER_DYING_CYCLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				CS_GUILDMASTER_DYING_CYCLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		CS_GUILDMASTER_DYING_CYCLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		CS_GUILDMASTER_DYING_CYCLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		CS_GUILDMASTER_DYING_CYCLE);
		Animation.EndGroup();
		
		Animation.Add("KNOCKDOWN_IDLE",			ANIM_VILLAGER_MALE_KNOCK_DOWN_IDLE_BREATHE_01);
		Animation.Add("STANDARD_DEAD",			ANIM_VILLAGER_MALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.Add("STANDARD_DIE",			ANIM_VILLAGER_MALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.Add("STABBED_TO_DEAD",		ANIM_VILLAGER_MALE_STABBED_TO_DEAD_01);
		Animation.Add("STABBED_ALREADY_DEAD",	ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
		Animation.Add("ST_DEAD",				ANIM_VILLAGER_DEAD_POSE);
		Animation.Add("VILLAGER_MALE_DYING",		VILLAGER_MALE_DYING);
		
	// CUT SCENE ANIMATION START
		Animation.Add("CS_SNIGGER",					CS_VILLAGER_RIDICULE_SNIGGER_NOSOUND);
		Animation.Add("CS_DEAD_DAD",				CS_OAKVALE_DEAD_DAD_MALE_VILAGER_DEAD_DAD,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_LEFT_LOOKING_DOWN",		CS_FALLING_DOWN_A_CLIFF_MALE_VILLAGER_LEFT_LOOKING_DOWN,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_RIGHT_LOOKING_DOWN",		CS_FALLING_DOWN_A_CLIFF_MALE_VILLAGER_RIGHT_LOOKING_DOWN,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_OAKVALE_RUN_SCARED",		CS_OAKVALE_INTROFEET_VILLAGER_MALE_RUN_SCARED,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_OAKVALE_RUN_SCARED_LOOK",	CS_OAKVALE_INTROFEET_VILLAGER_MALE_RUN_SCARED_LOOK_BEHIND,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_OAKVALE_RUN_SCARED_SINGLE",CS_OAKVALE_INTROFEET_VILLAGER_MALE_RUN_SCARED_SINGLE,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_SHOT_IN_BACK",			CS_OAKVALE_INTROFEET_VILLAGER_MALE_SHOT_IN_BACK,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_CHEER_LOOP",				ANIM_VILLAGER_MALE_CHEER_LOOP_02);

		Animation.Add("CS_TEACH_1",					ANIM_VILLAGER_MALE_TEACH_LOOP_01);
		Animation.Add("CS_TEACH_2",					ANIM_VILLAGER_MALE_TEACH_LOOP_02);
		Animation.Add("CS_TEACH_3",					ANIM_VILLAGER_MALE_TEACH_LOOP_03);
		
		Animation.Add("CS_CONV_HAPPY_LOOP",			ANIM_VILLAGER_CONVERSATION_HAPPY_BASE_01);
		Animation.Add("CS_CONV_HAPPY_BR1",			ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_01);
		Animation.Add("CS_CONV_HAPPY_BR2",			ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_02);
		Animation.Add("CS_CONV_HAPPY_BR3",			ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_03);
		Animation.Add("CS_CONV_HAPPY_BR4",			ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.Add("CS_CONV_HAPPY_HEAD_SHAKE",	CS_CONV_HAPPY_HEAD_SHAKE);

		Animation.Add("CS_CONV_SAD_LOOP",			ANIM_VILLAGER_CONVERSATION_SAD_BASE_01);
		Animation.Add("CS_CONV_SAD_BR1",			ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_01);
		Animation.Add("CS_CONV_SAD_BR2",			ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_02);
		Animation.Add("CS_CONV_SAD_BR3",			ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_03);
		Animation.Add("CS_CONV_SAD_BR4",			ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_04);

		Animation.Add("CS_CONV_FEAR_LOOP",			ANIM_VILLAGER_CONVERSATION_SCARED_BASE_01, TransTime(0));
		Animation.Add("CS_CONV_FEAR_BR1",			ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_01);
		Animation.Add("CS_CONV_FEAR_BR2",			ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_02);
		Animation.Add("CS_CONV_FEAR_BR3",			ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_03);
		Animation.Add("CS_CONV_FEAR_BR4",			ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_04);
		
		Animation.Add("CS_CONV_ANGRY_LOOP",			ANIM_VILLAGER_CONVERSATION_ANGRY_BASE_01);
		Animation.Add("CS_CONV_ANGRY_BR1",			ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_01);
		Animation.Add("CS_CONV_ANGRY_BR2",			ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_02);
		Animation.Add("CS_CONV_ANGRY_BR3",			ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_03);
		Animation.Add("CS_CONV_ANGRY_BR4",			ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_04);

		Animation.Add("CS_COMBAT_IDLE",				ANIM_VILLAGER_MALE_COMBAT_IDLE_01);
		Animation.Add("CS_COMBAT_STRIKE",			ANIM_VILLAGER_MALE_STRIKE_RIGHT_01);
		Animation.Add("CS_COMBAT_RECOIL",			ANIM_VILLAGER_MALE_STRIKE_RIGHT_RECOIL_01);

		Animation.Add("CS_REACTION_DISGUSTED",		ANIM_VILLAGER_MALE_DISGUSTED_01);
		Animation.Add("CS_LOOKS_RIGHT",				ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_02);	
		Animation.Add("CS_POINT_LEFT",				ANIM_VILLAGER_MALE_POINTING_01);
		Animation.Add("CS_LOOK_RIGHT",				ANIM_VILLAGER_MALE_RESPONSE_SHOUT_01);

		Animation.Add("CS_SCARED_INTO",				ANIM_VILLAGER_MALE_INTERACT_DENIAL_HEAD_SHAKE_INTO_01);
		Animation.Add("CS_SCARED_LOOP",				ANIM_VILLAGER_MALE_INTERACT_DENIAL_HEAD_SHAKE_LOOP_01);
		Animation.Add("CS_SCARED_OUTOF",			ANIM_VILLAGER_MALE_INTERACT_DENIAL_HEAD_SHAKE_OUTOF_01);

		Animation.Add("CS_SKY_GAZE",				ANIM_VILLAGER_MALE_GAZE_SKY_01);

		Animation.Add("CS_DROP_TO_KNEES",			ANIM_VILLAGER_SAD_02);

		Animation.Add("CS_SCARED_LOOK_AWAY",		ANIM_VILLAGER_FEAR_IDLE_02);
		Animation.Add("CS_SCARED_UPRIGHT",			ANIM_VILLAGER_FEAR_IDLE_UPRIGHT_01);
		
		// Used in Arena Hero souls
		Animation.Add("CS_VILLAGER_DYING_CYCLE",			CS_GUILDMASTER_DYING_CYCLE);
		
		// Used in Sick Child script for new teenage kid
		Animation.Add("CS_SICK_CHILD_SHIVER",		CS_SICK_CHILD_SHIVER);
		
		Animation.StartGroup("SKIP");
			Animation.Add("ST_WALK",				CS_SICK_CHILD_SKIP);
		Animation.EndGroup();
		
		// PUNCH CLUB ANIM GROUPS
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_HOMICIDAL_INTRO);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_OUTRAGED_02);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_OUTRAGED_04);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_OUTRAGED_05);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_MALE_DISGUSTED_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_ATTRACTED_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_ATTRACTED_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_FRIENDLY_GREET_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_FRIENDLY_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_CROWD_HECKLE_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_SURPRISE_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_RIDICULE_01);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_RIDICULE_02);
		Animation.Add("CS_PC_FIGHTSTART",			ANIM_VILLAGER_RIDICULE_03);

		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_MALE_DISGUSTED_01);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_MALE_AGGRESSIVE_01);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_OUTRAGED_02);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_OUTRAGED_04);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_OUTRAGED_05);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_AWE_01);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_CROWD_HECKLE_01);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_CROWD_HECKLE_02);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_CURIOSITY,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_MALE_DISAPPROVAL_STAMP_01);
		Animation.Add("CS_PC_FIGHTEND",				ANIM_VILLAGER_SURPRISE_01);
		Animation.Add("CS_TALK_FEAR",				ANIM_VILLAGER_FEAR_INTRO_01);
		Animation.Add("CS_TALK_POSE",				ANIM_VILLAGER_FEAR_IDLE_01);
		
		// RANSOM VICTIM
		Animation.Add("CS_MALE_WHISPERING_INTO",			CS_MALE_WHISPERING_INTO);
		Animation.Add("CS_MALE_WHISPERING_LOOP",			CS_MALE_WHISPERING_LOOP);
		Animation.Add("CS_MALE_WHISPERING_OUTOF",			CS_MALE_WHISPERING_OUTOF);
		
		//TRAVELLING HERO
		Animation.Add("CS_BARTENDER_HIDES_INTO",				CS_BARTENDER_HIDES_INTO);
		Animation.Add("CS_BARTENDER_HIDES_LOOP",				CS_BARTENDER_HIDES_LOOP);
		
		// FIREHEART PROPHETS
		Animation.Add("CS_PROPHET_DEATH_01_INTO",				CS_PROPHET_DEATH_01_INTO);
		Animation.Add("CS_PROPHET_DEATH_02_INTO",				CS_PROPHET_DEATH_02_INTO);
		Animation.Add("CS_PROPHET_DEATH_03_INTO",				CS_PROPHET_DEATH_03_INTO);
		Animation.Add("CS_PROPHET_DEATH_01_LOOP",				CS_PROPHET_DEATH_01_LOOP);
		Animation.Add("CS_PROPHET_DEATH_02_LOOP",				CS_PROPHET_DEATH_02_LOOP);
		Animation.Add("CS_PROPHET_DEATH_03_LOOP",				CS_PROPHET_DEATH_03_LOOP);
		
		// CHICKEN KICKING CROWD
		Animation.Add("CHICK_KICK_LOW",							ANIM_VILLAGER_RIDICULE_01);
		Animation.Add("CHICK_KICK_LOW",							ANIM_VILLAGER_RIDICULE_02);
		Animation.Add("CHICK_KICK_LOW",							ANIM_VILLAGER_RIDICULE_03);
		Animation.Add("CHICK_KICK_LOW",							ANIM_VILLAGER_GENERIC_IDLE_02);
		Animation.Add("CHICK_KICK_LOW",							ANIM_VILLAGER_CROWD_HECKLE_01);
		Animation.Add("CHICK_KICK_LOW_LOOP",					ANIM_VILLAGER_GENERIC_IDLE_02);

		Animation.Add("CHICK_KICK_MID",							ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
		Animation.Add("CHICK_KICK_MID",							ANIM_VILLAGER_MALE_YAWN_01);
		Animation.Add("CHICK_KICK_MID",							ANIM_VILLAGER_GENERIC_IDLE_01a);
		Animation.Add("CHICK_KICK_MID",							ANIM_VILLAGER_MALE_GAZE_SKY_01);
		Animation.Add("CHICK_KICK_MID",							ANIM_VILLAGER_AWE_01);
		Animation.Add("CHICK_KICK_MID_LOOP",					ANIM_VILLAGER_AWE_01);
		
		Animation.Add("CHICK_KICK_HIGH",						ANIM_VILLAGER_AWE_02);
		Animation.Add("CHICK_KICK_HIGH",						ANIM_VILLAGER_AWE_03);
		Animation.Add("CHICK_KICK_HIGH",						ANIM_VILLAGER_MALE_INTERACT_WAVE_PEOPLE_IN_STREET_01);
		Animation.Add("CHICK_KICK_HIGH",						ANIM_VILLAGER_SURPRISE_01);
		Animation.Add("CHICK_KICK_HIGH_LOOP",					ANIM_VILLAGER_AWE_02);
		Animation.Add("CHICK_KICK_HIGH_LOOP",					ANIM_VILLAGER_AWE_03);
		
	// CUT SCENE ANIMATION END 
		
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_GET_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_GET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_GET_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_VILLAGER_MALE_KNOCK_DOWN_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_VILLAGER_MALE_KNOCK_DOWN_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_VILLAGER_MALE_KNOCK_DOWN_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_TURN_01);//ANIM_VILLAGER_KNOCKED_OUT_RECOVER);
		
		// Removed for now as they don't match the dead pose.
//		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_VILLAGER_MALE_DECAPITATED_01);
//		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_VILLAGER_MALE_DECAPITATED_02);
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_VILLAGER_MALE_KNOCK_DOWN_LEFT_01);
		
		Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",			ANIM_VILLAGER_MALE_KICKED_WHEN_DEAD);
		
//		Animation.AddCombat("SPECIAL_IDLE",					ANIM_VILLAGER_MALE_BREATHE_IDLE_01); 
		
		Animation.AddCombat("FALL_DEAD",					ANIM_VILLAGER_MALE_KNOCK_DOWN_RIGHT_01);
		
		Animation.AddCombat("FALL_UNCONSCIOUS",				ANIM_VILLAGER_MALE_KNOCK_DOWN_RIGHT_01);
		Animation.AddCombat("UNCONSCIOUS_RECOVER",			ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_TURN_01);//ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_01);
//		Animation.AddCombat("UNCONSCIOUS_RECOVER_TEST",		ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_TURN_01);
	<\CAppearanceDef>

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////   	                                     

	<CAppearanceDef>
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_RIDICULE_01);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_RIDICULE_02);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_RIDICULE_03);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_SURPRISE_01);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_FASCINATION_01);

		Animation.Add("ST_HOMICIDAL_INTRO",			ANIM_VILLAGER_HOMICIDAL_INTRO);
		Animation.Add("ST_SURPRISE",				ANIM_VILLAGER_SURPRISE_01);
		Animation.Add("ST_CALL_OVER",				ANIM_VILLAGER_FASCINATION_01);
		Animation.Add("ST_LOOK_AROUND",				ANIM_VILLAGER_CURIOSITY,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		
		Animation.Add("ST_TORTURE_LEVITATION",	ANIM_MALE_TORTURE_LEVITATE);
		Animation.Add("ST_TORTURE_TRANSITION",	ANIM_MALE_TORTURE_LEVITATE_INTO_LOOP);
		Animation.Add("ST_TORTURE_LOOP",		ANIM_MALE_TORTURE_LOOP);

		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_GENERIC_MAN_TALK_IDLE_01);
		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_GENERIC_MAN_TALK_IDLE_02);
		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_GENERIC_MAN_TALK_IDLE_03);
		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_GENERIC_MAN_TALK_IDLE_04);
		Animation.Add("STANDARD_TALK_LOVE",			ANIM_VILLAGER_ATTRACTED_02);
		Animation.Add("STANDARD_TALK_ANGER",		ANIM_VILLAGER_OUTRAGED_04);
		Animation.Add("STANDARD_TALK_ANGER",		ANIM_VILLAGER_OUTRAGED_05);
		Animation.Add("STANDARD_TALK_FEAR",			ANIM_VILLAGER_FEAR_INTRO_01);
		Animation.Add("STANDARD_TALK_FEAR",			ANIM_VILLAGER_FEAR_INTRO_02);
		Animation.Add("STANDARD_TALK_GLEE",			ANIM_VILLAGER_FRIENDLY_01);
		Animation.Add("STANDARD_TALK_SADNESS",		ANIM_VILLAGER_SAD_01);
		Animation.Add("STANDARD_TALK_FRIENDLY",		ANIM_VILLAGER_FRIENDLY_01);
		Animation.Add("STANDARD_TALK_RIDICULE",		ANIM_VILLAGER_RIDICULE_03);
		
		Animation.Add("INTERACTION_CONTEMPT",		ANIM_VILLAGER_OUTRAGED_04);
		Animation.Add("INTERACTION_FRIENDLINESS",	ANIM_VILLAGER_FRIENDLY_01);
		Animation.Add("INTERACTION_RESPECT",		ANIM_VILLAGER_ATTRACTED_01);
		Animation.Add("INTERACTION_AWE_IDOLISE",	ANIM_VILLAGER_AWE_03);
		Animation.Add("INTERACTION_AWE_HATRED",		ANIM_VILLAGER_CROWD_HECKLE_02);
		Animation.Add("INTERACTION_AWE_IDOLISE",	ANIM_VILLAGER_AWE_01);
		Animation.Add("SCRIPT_CHEER_1",				ANIM_VILLAGER_AWE_01);
		Animation.Add("SCRIPT_CHEER_3",				ANIM_VILLAGER_AWE_02);
		Animation.Add("SCRIPT_CHEER_2",				ANIM_VILLAGER_AWE_03);
		Animation.Add("SCRIPT_BOO_1",				ANIM_VILLAGER_CROWD_HECKLE_01);
		Animation.Add("SCRIPT_BOO_2",				ANIM_VILLAGER_CROWD_HECKLE_02);
		Animation.Add("SCRIPT_BOO_3",				ANIM_VILLAGER_CROWD_HECKLE_02);
		
		Animation.Add("STANDARD_YAWN",				ANIM_VILLAGER_MALE_YAWN_01);
		
		Animation.StartGroup("SCARED");
//			Animation.Add("ST_RUN",						ANIM_BIPED_GENERIC_MAN_SCARED_RUN_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
//			Animation.Add("ST_RUN",						ANIM_BIPED_GENERIC_MAN_SCARED_RUN_02, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_RUN",						ANIM_VILLAGER_SCARED_RUN_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_SLOW_WALK",				ANIM_VILLAGER_FEAR_WALK_03);
			Animation.Add("ST_WALK",					ANIM_VILLAGER_FEAR_WALK_03);
//			Animation.Add("ST_WALK",					ANIM_VILLAGER_FEAR_WALK_02);
			Animation.Add("ST_WALK_BACK_OFF",			ANIM_VILLAGER_FEAR_WALK_02);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_FEAR_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE_COMB",				ANIM_VILLAGER_FEAR_LOOK_BACK_UPP_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_FEAR_IDLE_02);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_FEAR_INTRO_01);	
			Animation.Add("ST_INTRO",					ANIM_VILLAGER_FEAR_INTRO_02);	
		Animation.EndGroup();

		Animation.StartGroup("OUTRAGED");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_GENERIC_IDLE_01a);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_OUTRAGED_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_OUTRAGED_02);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_OUTRAGED_03);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_OUTRAGED_04);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_OUTRAGED_05);
			
			Animation.Add("ANGRY_WAVE_FIST",			ANIM_VILLAGER_OUTRAGED_04);	
		Animation.EndGroup();

		Animation.StartGroup("CREEPING");	
			Animation.Add("ST_WALK",					ANIM_VILLAGER_UPRIGHT_SNEAK);
		Animation.EndGroup();

		Animation.StartGroup("CURIOUS");		// currently used for podium neutral
//			Animation.Add("ST_WALK",					ANIM_VILLAGER_FASCINATION_WALK);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_SURPRISE_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_FASCINATION_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_RIDICULE_03);
		Animation.EndGroup();	

		Animation.StartGroup("CHEERING");	
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_AWE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_AWE_02);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_AWE_03);
		Animation.EndGroup();	

		Animation.StartGroup("HECKLING");	
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_GENERIC_IDLE_02);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_04);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_03);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_02);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_05);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_CROWD_HECKLE_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_CROWD_HECKLE_02);
		Animation.EndGroup();	

		Animation.StartGroup("ATTRACTED");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_SAD_IDLE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_ATTRACTED_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_ATTRACTED_02);
			
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_ATTRACTED_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_ATTRACTED_02);
		Animation.EndGroup();

		Animation.StartGroup("SAD");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_CONCERN_IDLE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_SAD_01);
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_SAD_01);
			
			Animation.Add("DROP_TO_KNEES",				ANIM_VILLAGER_SAD_02);
		Animation.EndGroup();

		Animation.StartGroup("BULLY");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_GENERIC_IDLE_02);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_OUTRAGED_02);
			
			Animation.Add("ST_EMOTE",					ANIM_VILLAGER_OUTRAGED_02);
		Animation.EndGroup();

		Animation.StartGroup("VIOLENT");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_HOMICIDAL_IDLE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_HOMICIDAL_IDLE_01);
		Animation.EndGroup();

		Animation.StartGroup("COOK");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_BIPED_GENERIC_MAN_HOMELIFE_COOK);
			Animation.Add("ST_IDLE",					ANIM_BIPED_GENERIC_MAN_HOMELIFE_COOK);
		Animation.EndGroup();

			Animation.Add("ST_PICK_UP_GENERIC_BOX",		ANIM_VILLAGER_MALE_FLAT_CRATE_PICK_UP_01);
			Animation.Add("SCRIPT_HOLD_BOX_PUT_DOWN",	ANIM_VILLAGER_MALE_FLAT_CRATE_PUT_DOWN_01);
		Animation.StartGroup("CARRYING_GENERIC_BOX");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_FLAT_CRATE_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_FLAT_CRATE_IDLE_01);
			Animation.Add("ST_STAND",				ANIM_VILLAGER_MALE_FLAT_CRATE_IDLE_01);
			Animation.Add("ST_RUN",					ANIM_VILLAGER_MALE_FLAT_CRATE_WALK_01);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_MALE_FLAT_CRATE_WALK_01);
			Animation.Add("ST_HOLD_BOX_PUT_DOWN",	ANIM_VILLAGER_MALE_FLAT_CRATE_PUT_DOWN_01);
		Animation.EndGroup();
		
		Animation.Add("ST_HEAD_TURN_V",				ANIM_BIPED_GENERIC_MAN_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_HEAD_TURN_H",				ANIM_BIPED_GENERIC_MAN_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));
	<\CAppearanceDef>

//-------------------------------- Adam's remapped anim tags for opinion reactions -------------------------

	<CAppearanceDef>
		Animation.Add("ST_OPINION_APPROVAL_CHEERING_BOTH_ARMS_UP", ANIM_VILLAGER_AWE_03);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_ARMS_UP", ANIM_VILLAGER_AWE_02);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_NORMAL", ANIM_VILLAGER_AWE_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_INTO", ANIM_VILLAGER_MALE_CHEER_INTO_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_LOOP", ANIM_VILLAGER_MALE_CHEER_LOOP_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_OUTOF", ANIM_VILLAGER_MALE_CHEER_OUT_01);
		Animation.Add("ST_OPINION_APPROVAL_REACTION_ARMS_WIDE_GREET", ANIM_VILLAGER_FRIENDLY_01);
		Animation.Add("ST_OPINION_APPROVAL_WAVING_AT_DISTANCE", ANIM_VILLAGER_MALE_INTERACT_WAVE_PEOPLE_IN_STREET_01);
		Animation.Add("ST_OPINION_ATTRACTED_HANDS_CLASPED_SWAYING", ANIM_VILLAGER_ATTRACTED_02);
		Animation.Add("ST_OPINION_ATTRACTED_PREENING_SELF", ANIM_VILLAGER_ATTRACTED_01);
//		Animation.Add("ST_OPINION_ATTRACTED_SHOUTING_AT", ANIM_VILLAGER_);
//		Animation.Add("ST_OPINION_ATTRACTED_WAVING_AT", ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_DISAPPROVAL_BOOING", ANIM_VILLAGER_CROWD_HECKLE_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_CALLING_OVER_FOR_FIGHT", ANIM_VILLAGER_HOMICIDAL_INTRO);
		Animation.Add("ST_OPINION_DISAPPROVAL_DISMISSING_HAND_SWIPE", ANIM_VILLAGER_OUTRAGED_05);
//		Animation.Add("ST_OPINION_DISAPPROVAL_NYAH_NYAH", ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINT_AT", ANIM_VILLAGER_OUTRAGED_02);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINTING_AWAY_GET_OUT", ANIM_VILLAGER_OUTRAGED_03);
		Animation.Add("ST_OPINION_DISAPPROVAL_SHAKE_FIST", ANIM_VILLAGER_OUTRAGED_04);
		Animation.Add("ST_OPINION_DISAPPROVAL_STAMP_FOOT", ANIM_VILLAGER_MALE_DISAPPROVAL_STAMP_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_THUMBS_DOWN", ANIM_VILLAGER_CROWD_HECKLE_02);
		Animation.Add("ST_OPINION_FEAR_IDLE_COWERING", ANIM_VILLAGER_FEAR_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("ST_OPINION_FEAR_REACTION_SHRINKING_AWAY", ANIM_VILLAGER_FEAR_INTRO_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SURPRISED", ANIM_VILLAGER_FEAR_INTRO_02);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_FRONT", ANIM_VILLAGER_FEAR_RUN_02);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_UP", ANIM_VILLAGER_FEAR_RUN_01);
//combat anim for movement : Animation.Add("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_VILLAGER_FEAR_WALK_02);
		Animation.Add("ST_OPINION_NEUTRAL_POINT_AT", ANIM_VILLAGER_SURPRISE_01);
		Animation.Add("ST_OPINION_NEUTRAL_POINTING_CALLING_FRIEND", ANIM_VILLAGER_FASCINATION_01);
		Animation.Add("ST_OPINION_NEUTRAL_REACTION_HAND_UP_GREET", ANIM_VILLAGER_FRIENDLY_GREET_01);
		Animation.Add("ST_OPINION_NEUTRAL_SHOUTING_WITH_HANDS_CUPPED", ANIM_VILLAGER_MALE_SHOUT_HANDS_01);
//		Animation.Add("ST_OPINION_NEUTRAL_SURPRISE", ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_NEUTRAL_WALK_NERVOUS_LOOKING_BACK", ANIM_VILLAGER_FEAR_WALK_01);
		Animation.Add("ST_OPINION_RIDICULE_BELLY_LAUGH", ANIM_VILLAGER_RIDICULE_01);
		Animation.Add("ST_OPINION_RIDICULE_POINT_AND_LAUGH", ANIM_VILLAGER_RIDICULE_02);
		Animation.Add("ST_OPINION_RIDICULE_SNIGGER", ANIM_VILLAGER_RIDICULE_03);

		Animation.AddCombat("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_VILLAGER_FEAR_WALK_02);
	<\CAppearanceDef>

/********************************************************************************************************
*	Ollie's animation directory - these are new names for all the animations grouped sensibly for AI	*
********************************************************************************************************/

	<CAppearanceDef>
		Animation.StartGroup("_INTERACTIONS");
			Animation.Add("VM_ARGUE_MORE_AGGRESSIVE_INTO", ANIM_VILLAGER_MALE_ARGUE_AGGRESSIVE_STRONG_INTO_01);
			Animation.Add("VM_ARGUE_MORE_AGGRESSIVE_LOOP", ANIM_VILLAGER_MALE_ARGUE_AGGRESSIVE_STRONG_LOOP_01);
			Animation.Add("VM_ARGUE_MORE_AGGRESSIVE_OUTOF", ANIM_VILLAGER_MALE_ARGUE_AGGRESSIVE_STRONG_OUTOF_01);
			Animation.Add("VM_ARGUING_AGGRESSIVE_GESTURE_INTO", ANIM_VILLAGER_MALE_ARGUE_AGGRESSIVE_GESTURE_INTO_01);
			Animation.Add("VM_ARGUING_AGGRESSIVE_GESTURE_LOOP", ANIM_VILLAGER_MALE_ARGUE_AGGRESSIVE_GESTURE_LOOP_01);
			Animation.Add("VM_ARGUING_AGGRESSIVE_GESTURE_OUTOF", ANIM_VILLAGER_MALE_ARGUE_AGGRESSIVE_GESTURE_OUTOF_01);	

			//un-paired
			Animation.Add("VM_BEING_SLAPPED", ANIM_VILLAGER_MALE_BEING_SLAPPED_01);
			Animation.Add("VM_CHATTING_UP_INTO", ANIM_VILLAGER_MALE_INTERACT_CHATUP_INTO_01);
			Animation.Add("VM_CHATTING_UP_LOOP", ANIM_VILLAGER_MALE_INTERACT_CHATUP_LOOP_01);
			Animation.Add("VM_CHATTING_UP_OUTOF", ANIM_VILLAGER_MALE_INTERACT_CHATUP_OUTOF_01);
		Animation.EndGroup();

		Animation.StartGroup("_IDLES");
			//standing	
			Animation.Add("VM_BREATH", ANIM_VILLAGER_MALE_IDLE_BREATHE_01);
			Animation.Add("VM_CLASP_HANDS", ANIM_VILLAGER_CONCERN_IDLE_01);
			Animation.Add("VM_COMBAT_BREATHE_IDLE", ANIM_VILLAGER_MALE_BREATHE_IDLE_01);
			Animation.Add("VM_FOLD_ARMS_IDLE", ANIM_VILLAGER_GENERIC_IDLE_01a);
			Animation.Add("VM_FOLD_ARMS_IN", ANIM_VILLAGER_GENERIC_IDLE_01b);
			Animation.Add("VM_FOLD_ARMS_OUT", ANIM_VILLAGER_GENERIC_IDLE_01c);
			Animation.Add("VM_GAZING_AT_SKY", ANIM_VILLAGER_MALE_GAZE_SKY_01);
			Animation.Add("VM_HANDS_BEHIND_BACK_IDLE", ANIM_VILLAGER_FRIENDLY_IDLE_01);
			Animation.Add("VM_HANDS_IN_FRONT_IDLE", ANIM_VILLAGER_SAD_IDLE_01);
			Animation.Add("VM_HANDS_ON_HIPS_IDLE", ANIM_VILLAGER_GENERIC_IDLE_02);
			Animation.Add("VM_SCRATCHING_HEAD", ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
			Animation.Add("VM_STEPPED_IN_SOMETHING", ANIM_VILLAGER_MALE_STEP_IN_SOMETHING_01);

			//sitting
			Animation.Add("VM_BREATH_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_IDLE_01);
			Animation.Add("VM_CLEAN_EAR_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_CLEAN_EAR_01);
			Animation.Add("VM_FIGHT_SLEEP_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_SLEEP_FIGHT_01);
			Animation.Add("VM_RUB_BACK_OF_HEAD_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_RUB_HEAD_01);
			Animation.Add("VM_SIT_WITH_HEAD_ON_HANDS_INTO", ANIM_VILLAGER_MALE_SEATED_HEAD_ON_HANDS_INTO_01);
			Animation.Add("VM_SIT_WITH_HEAD_ON_HANDS_LOOP", ANIM_VILLAGER_MALE_SEATED_HEAD_ON_HANDS_LOOP_01);
			Animation.Add("VM_SIT_WITH_HEAD_ON_HANDS_OUTOF", ANIM_VILLAGER_MALE_SEATED_HEAD_ON_HANDS_OUTOF_01);
		Animation.EndGroup();

		Animation.StartGroup("_COMBAT_RELATED");
			Animation.Add("VM_DEAD_POSE", ANIM_VILLAGER_DEAD_POSE);
			Animation.Add("VM_GET_HIT_KNOCK_DOWN_RIGHT", ANIM_VILLAGER_MALE_KNOCK_DOWN_RIGHT_01);
			Animation.Add("VM_GET_HIT_KNOCK_DOWN_LEFT", ANIM_VILLAGER_MALE_KNOCK_DOWN_LEFT_01);
			Animation.Add("VM_GET_HIT_KNOCK_DOWN_BACK", ANIM_VILLAGER_MALE_KNOCK_DOWN_BACK_01);
			Animation.Add("VM_GET_UP_FROM_UNCONSCIOUS", ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_01);
			Animation.Add("VM_GET_UP_FROM_UNCONSCIOUS_TURN", ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_TURN_01);
			Animation.Add("VM_HIT_BY_ARROW_01", ANIM_VILLAGER_HIT_BY_ARROW_01);
			Animation.Add("VM_HIT_BY_ARROW_02", ANIM_VILLAGER_HIT_BY_ARROW_02);
			Animation.Add("VM_HIT_BY_WILL", ANIM_VILLAGER_RESPOND_WILL_FORCE);
			Animation.Add("VM_KICK", ANIM_VILLAGER_HOMICIDAL_01);
			Animation.Add("VM_KNOCKOUT_01_IDLE", ANIM_VILLAGER_MALE_KNOCK_DOWN_IDLE_BREATHE_01);
			Animation.Add("VM_KNOCKOUT_01_RECOVER", ANIM_VILLAGER_MALE_UNCONSCIOUS_GET_UP_01);
			Animation.Add("VM_KNOCKOUT_01", ANIM_VILLAGER_MALE_KNOCK_DOWN_RIGHT_01);
			Animation.Add("VM_KNOCK_DOWN_BREATHE_IDLE", ANIM_VILLAGER_MALE_KNOCK_DOWN_IDLE_BREATHE_01);
			Animation.Add("VM_NORMAL_GET_HIT_RIGHT", ANIM_VILLAGER_MALE_GET_HIT_RIGHT_01);
			Animation.Add("VM_NORMAL_GET_HIT_LEFT", ANIM_VILLAGER_MALE_GET_HIT_LEFT_01);
			Animation.Add("VM_NORMAL_GET_HIT_BACK", ANIM_VILLAGER_MALE_GET_HIT_BACK_01);
			Animation.Add("VM_ON_FIRE_01", ANIM_VILLAGER_ON_FIRE_01);
			Animation.Add("VM_PUNCH_01", ANIM_VILLAGER_HOMICIDAL_02);
			Animation.Add("VM_PUNCH_02", ANIM_VILLAGER_HOMICIDAL_03);
			Animation.Add("VM_PUNCH_IDLE", ANIM_VILLAGER_HOMICIDAL_IDLE_01);
			Animation.Add("VM_STABBED_DEAD_TWITCH", ANIM_VILLAGER_DEAD_STABBED);
			Animation.Add("VM_STABBED_TO_DEAD", ANIM_VILLAGER_MALE_STABBED_TO_DEAD_01);
			Animation.Add("VM_UNCONSCIOUS_TO_DEATH", ANIM_VILLAGER_MALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.EndGroup();

		Animation.StartGroup("_JOBS");
			//home
			Animation.Add("VM_CLEANING_SURFACES_INTO", ANIM_VILLAGER_MALE_CLEANING_SURFACE_INTO_01);
			Animation.Add("VM_CLEANING_SURFACES_LOOP", ANIM_VILLAGER_MALE_CLEANING_SURFACE_LOOP_01);
			Animation.Add("VM_CLEANING_SURFACES_OUTOF", ANIM_VILLAGER_MALE_CLEANING_SURFACE_OUTOF_01);
			
			//handyman
			Animation.Add("VM_HAMMERING", ANIM_VILLAGER_MALE_HAMMERING_01);
			Animation.Add("VM_MENDING_INTO", ANIM_VILLAGER_MALE_MENDING_INTO_01);
			Animation.Add("VM_MENDING_LOOP", ANIM_VILLAGER_MALE_MENDING_LOOP_01);
			Animation.Add("VM_MENDING_OUTOF", ANIM_VILLAGER_MALE_MENDING_OUTOF_01);

			//crop picker
			Animation.Add("VM_PICKING_CROPS", ANIM_VILLAGER_MALE_PICKING_CROPS_01);
		Animation.EndGroup();

		Animation.StartGroup("_NON_OPINION_EMOTIONS");
			//sadness
			Animation.Add("VM_DISPAIR", ANIM_VILLAGER_SAD_02);
		Animation.EndGroup();

		Animation.StartGroup("_ACTIONS");
			//standing
			Animation.Add("VM_DRINKING", ANIM_VILLAGER_MALE_DRINKING_01);
			Animation.Add("VM_EATING", ANIM_VILLAGER_MALE_EATING_01);
			Animation.Add("VM_POINTING", ANIM_VILLAGER_MALE_POINTING_01);
			Animation.Add("VM_PUSH", ANIM_VILLAGER_HOMICIDAL_04);
			Animation.Add("VM_RESPONSE_TO_SHOUT", ANIM_VILLAGER_MALE_RESPONSE_SHOUT_01);
			Animation.Add("VM_RETURNING_WAVE", ANIM_VILLAGER_MALE_INTERACT_WAVE_RETURN_01);
			Animation.Add("VM_RUN_ON_FIRE_01", ANIM_VILLAGER_ON_FIRE_RUN_01);
			Animation.Add("VM_SHAKE_HEAD_IN_DENIAL_INTO", ANIM_VILLAGER_MALE_INTERACT_DENIAL_HEAD_SHAKE_INTO_01);
			Animation.Add("VM_SHAKE_HEAD_IN_DENIAL_LOOP", ANIM_VILLAGER_MALE_INTERACT_DENIAL_HEAD_SHAKE_LOOP_01);
			Animation.Add("VM_SHAKE_HEAD_IN_DENIAL_OUTOF", ANIM_VILLAGER_MALE_INTERACT_DENIAL_HEAD_SHAKE_OUTOF_01);
			Animation.Add("VM_TELLING_OFF_KID", ANIM_VILLAGER_MALE_TELL_OFF_KID_01);
			Animation.Add("VM_TIE_LACES", ANIM_VILLAGER_MALE_TIE_LACES_01);
			Animation.Add("VM_TOUCHING_BOTTOM", ANIM_VILLAGER_MALE_INTERACT_TOUCH_BOTTOM_01);
			Animation.Add("VM_UPRIGHT_SNEAK", ANIM_VILLAGER_UPRIGHT_SNEAK);
			Animation.Add("VM_UPRIGHT_SNEAK_POSE", ANIM_VILLAGER_UPRIGHT_SNEAK_POSE);
			Animation.Add("VM_WHISTLE_INTO", ANIM_VILLAGER_MALE_WHISTLE_INTO_01);
			Animation.Add("VM_WHISTLE_LOOP", ANIM_VILLAGER_MALE_WHISTLE_LOOP_01);
			Animation.Add("VM_WHISTLE_OUTOF", ANIM_VILLAGER_MALE_WHISTLE_OUT_01);
			Animation.Add("VM_WIPE_EYES", ANIM_VILLAGER_SAD_01);
			Animation.Add("VM_YAWN", ANIM_VILLAGER_MALE_YAWN_01);

			//sitting
			Animation.Add("VM_EATING_FROM_BOWL_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_EATING_01);
			Animation.Add("VM_EAT_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_IDLE_02);
			Animation.Add("VM_GET_OFF_CHAIR", ANIM_VILLAGER_MALE_SEATED_GET_UP_01);
			Animation.Add("VM_SIT_ON_CHAIR", ANIM_VILLAGER_MALE_SIT_ON_CHAIR_01);
			Animation.Add("VM_SLEEP_ON_CHAIR", ANIM_VILLAGER_MALE_SLEEP_ON_CHAIR_01);
			Animation.Add("VM_WARM_HANDS_WHILST_SITTING_INTO", ANIM_VILLAGER_MALE_SEATED_WARM_HANDS_INTO_01);
			Animation.Add("VM_WARM_HANDS_WHILST_SITTING_LOOP", ANIM_VILLAGER_MALE_SEATED_WARM_HANDS_LOOP_01);
			Animation.Add("VM_WARM_HANDS_WHILST_SITTING_OUTOF", ANIM_VILLAGER_MALE_SEATED_WARM_HANDS_OUTOF_01);
			Animation.Add("VM_WASHING_WINDOWS", ANIM_VILLAGER_MALE_CLEAN_WINDOWS_01);
			Animation.Add("VM_YAWN_ON_CHAIR", ANIM_VILLAGER_MALE_SEATED_YAWN_01);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_ANGRY");
			//angry
			Animation.Add("VM_ANGRY_REACTION", ANIM_VILLAGER_OUTRAGED_05);
			Animation.Add("VM_BEING_AGGRESSIVE", ANIM_VILLAGER_MALE_AGGRESSIVE_01);
			Animation.Add("VM_GET_OUT", ANIM_VILLAGER_OUTRAGED_03);
			Animation.Add("VM_GO_AWAY", ANIM_VILLAGER_OUTRAGED_01);
			Animation.Add("VM_SHOUTING_WITH_HANDS", ANIM_VILLAGER_MALE_SHOUT_HANDS_01);
//duplicate of above Animation.Add("VM_SHOUTING_WITH_HANDS", E3ONLY_ANIM_VILLAGER_MALE_BELCH);
			Animation.Add("VM_SWEAR", ANIM_VILLAGER_OUTRAGED_02);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_FEAR");
			//fear
			Animation.Add("VM_ARGUE_TERRIFIED_INTO", ANIM_VILLAGER_MALE_ARGUE_TERRIFIED_INTO_01);
			Animation.Add("VM_ARGUE_TERRIFIED_LOOP", ANIM_VILLAGER_MALE_ARGUE_TERRIFIED_LOOP_01);
			Animation.Add("VM_ARGUE_TERRIFIED_OUTOF", ANIM_VILLAGER_MALE_ARGUE_TERRIFIED_OUTOF_01);
			Animation.Add("VM_CAUTIOUS_APPROACH", ANIM_VILLAGER_SUSPICIOUS_WALK);
			Animation.Add("VM_CAUTIOUS_BACK_OFF", ANIM_VILLAGER_FEAR_WALK_02);
			Animation.Add("VM_FEAR_IDLE", ANIM_VILLAGER_FEAR_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("VM_FEAR_REACTION", ANIM_VILLAGER_FEAR_INTRO_01);
			Animation.Add("VM_FEAR_SURPRISED", ANIM_VILLAGER_FEAR_INTRO_02);
			Animation.Add("VM_IGNORE_FEAR", ANIM_VILLAGER_FEAR_IDLE_02);
			Animation.Add("VM_RUN_IN_FEAR_01", ANIM_VILLAGER_FEAR_RUN_01);
			Animation.Add("VM_RUN_IN_FEAR_02", ANIM_VILLAGER_FEAR_RUN_02);
			Animation.Add("VM_RUN_SCARED", ANIM_VILLAGER_SCARED_RUN_01);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_ATTRACTION");
			//attraction
			Animation.Add("VM_ATTRACTED", ANIM_VILLAGER_ATTRACTED_01);
			Animation.Add("VM_COY_SHIMMY", ANIM_VILLAGER_ATTRACTED_02);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_FUNNY");
			//funny
			Animation.Add("VM_BELLY_LAUGH", ANIM_VILLAGER_RIDICULE_01);
			Animation.Add("VM_POINT_AND_LAUGH", ANIM_VILLAGER_RIDICULE_02);
			Animation.Add("VM_SNIGGER", ANIM_VILLAGER_RIDICULE_03);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_DISLIKE");
			//dislike
			Animation.Add("VM_BOO", ANIM_VILLAGER_CROWD_HECKLE_01);
			Animation.Add("VM_DISGUSTED", ANIM_VILLAGER_MALE_DISGUSTED_01);
			Animation.Add("VM_THUMBS_DOWN", ANIM_VILLAGER_CROWD_HECKLE_02);
			Animation.Add("VM_WAVE_FIST", ANIM_VILLAGER_OUTRAGED_04);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_LIKE");
			//like
			Animation.Add("VM_CASUAL_CLAP", ANIM_VILLAGER_AWE_01);
			Animation.Add("VM_CHEER_ARMS_ALOFT", ANIM_VILLAGER_AWE_03);
			Animation.Add("VM_CHEER_CLAP", ANIM_VILLAGER_AWE_02);
			Animation.Add("VM_CHEER_FULL_ON_INTO", ANIM_VILLAGER_MALE_CHEER_INTO_01);
			Animation.Add("VM_CHEER_FULL_ON_LOOPA", ANIM_VILLAGER_MALE_CHEER_LOOP_01);
			Animation.Add("VM_CHEER_FULL_ON_LOOPB", ANIM_VILLAGER_MALE_CHEER_LOOP_02);
			Animation.Add("VM_CHEER_FULL_ON_OUTOF", ANIM_VILLAGER_MALE_CHEER_OUT_01);
			Animation.Add("VM_FRIENDLY_GREET", ANIM_VILLAGER_FRIENDLY_01);
			Animation.Add("VM_GREET_01", ANIM_VILLAGER_FRIENDLY_GREET_01);
			Animation.Add("VM_WAVING_TO_PEOPLE_IN_STREET", ANIM_VILLAGER_MALE_INTERACT_WAVE_PEOPLE_IN_STREET_01);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_DEED_REACTIONS");
			//deed reactions
			Animation.Add("VM_COME_AND_FIGHT", ANIM_VILLAGER_HOMICIDAL_INTRO);
			Animation.Add("VM_PICKIN_A_FIGHT", ANIM_VILLAGER_MALE_PICKING_A_FIGHT_01);
		Animation.EndGroup();

		Animation.StartGroup("_OPINION_REACTIONS_LOOK");
			//look
			Animation.Add("VM_LOOK_AROUND", ANIM_VILLAGER_CURIOSITY);
			Animation.Add("VM_POINT", ANIM_VILLAGER_SURPRISE_01);
			Animation.Add("VM_POINT_COME_OVER", ANIM_VILLAGER_FASCINATION_01);
			Animation.Add("VM_WALK_LOOKING_BACK", ANIM_VILLAGER_FEAR_WALK_01);
		Animation.EndGroup();
	<\CAppearanceDef>
	
/*	<CEntitySoundDef>
		SoundMap.AddSingle("INTERACTION_AWE", SND_VILLAGER_49);
		SoundMap.AddSingle("INTERACTION_AWE_IDOLISE", SND_VILLAGER_49);
		SoundMap.AddSingle("INTERACTION_AWE_HATRED", SND_VILLAGER_13);
		SoundMap.AddSingle("INTERACTION_RESPECT", SND_VILLAGER_05);
		SoundMap.AddSingle("INTERACTION_FRIENDLINESS", SND_VILLAGER_43);
		SoundMap.AddSingle("INTERACTION_CONTEMPT", SND_VILLAGER_08);
		
		SoundMap.AddSingle("OBSTRUCTED_CONTEMPT", SND_VILLAGER_27);
		SoundMap.AddSingle("OBSTRUCTED_FRIENDLINESS", SND_VILLAGER_48);
		SoundMap.AddSingle("OBSTRUCTED_RESPECT", SND_VILLAGER_48);
		SoundMap.AddSingle("OBSTRUCTED_AWE", SND_VILLAGER_48);
		
		SoundMap.AddSingle("WELCOME_FRIENDLINESS", SND_VILLAGER_63);
		SoundMap.AddSingle("INTERACTION_RIDICULE", SND_VILLAGER_32);
		
		SoundMap.AddSingle("BOO_HERO", SND_VILLAGER_61);
		SoundMap.AddSingle("CHEER_HERO", SND_VILLAGER_34);
	<\CEntitySoundDef>	
*/
	<CAppearanceDef>
		Animation.Add("PUT_AWAY",						ANIM_VILLAGER_MALE_PUT_AWAY_01);
		Animation.Add("GET_OUT",						ANIM_VILLAGER_MALE_GET_OUT_01);
	
		Animation.AddCombat("PUSH_OUT",					ANIM_VILLAGER_HOMICIDAL_04);
		Animation.AddCombat("STRIKE_SHORT_FRONT",		ANIM_VILLAGER_HOMICIDAL_01);
		Animation.AddCombat("STRIKE_SHORT_FRONT",		ANIM_VILLAGER_HOMICIDAL_02);
		Animation.AddCombat("STRIKE_SHORT_FRONT",		ANIM_VILLAGER_HOMICIDAL_03);

		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_VILLAGER_FIGHT_HOOK_LEFT_01, Combo(0, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_VILLAGER_BLOCK_RECOIL_LEFT_01));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_VILLAGER_FIGHT_HOOK_RIGHT_01, Combo(1, 0), Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_VILLAGER_BLOCK_RECOIL_RIGHT_01));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_KNOCKDOWN", ANIM_VILLAGER_UNARMED_PUNCH_UNBLOCKABLE_01);
		
		Animation.AddCombat("BLOCK_IDLE",				ANIM_HERO_UNARMED_COMBAT_BLOCK_IDLE_01);
		Animation.AddCombat("BLOCK_FRONT_RESPONSE",		ANIM_HERO_UNARMED_COMBAT_BLOCK_LEFT_01);
		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",		ANIM_HERO_UNARMED_COMBAT_BLOCK_RIGHT_01);
		Animation.AddCombat("BLOCK_LEFT_RESPONSE",		ANIM_HERO_UNARMED_COMBAT_BLOCK_LEFT_01);

		Animation.AddCombat("STRAFE_IDLE",				ANIM_VILLAGER_HOMICIDAL_IDLE_01);
//		Animation.AddCombat("SPECIAL_IDLE",				ANIM_VILLAGER_HOMICIDAL_IDLE_01);
		Animation.AddCombat("SPECIAL_IDLE",				ANIM_VILLAGER_OUTRAGED_04);
		
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",	ANIM_VILLAGER_UNARMED_STRAFE_FRONT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",	ANIM_VILLAGER_UNARMED_STRAFE_BACK_01);
		Animation.AddCombat("MOVEMENT_STRAFE_LEFT",		ANIM_VILLAGER_UNARMED_STRAFE_LEFT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_RIGHT",	ANIM_VILLAGER_UNARMED_STRAFE_RIGHT_01);

		Animation.AddCombat("STRAFE_MOVEMENT_FORWARD",	ANIM_VILLAGER_UNARMED_STRAFE_FRONT_01);
		Animation.AddCombat("STRAFE_MOVEMENT_BACK",		ANIM_VILLAGER_UNARMED_STRAFE_BACK_01);
		Animation.AddCombat("STRAFE_MOVEMENT_LEFT",		ANIM_VILLAGER_UNARMED_STRAFE_LEFT_01);
		Animation.AddCombat("STRAFE_MOVEMENT_RIGHT",	ANIM_VILLAGER_UNARMED_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_UPPER_BODY",				ANIM_VILLAGER_MALE_STRAFE_UPPERBODY_UNARMED);
		
		Animation.Add("STANDARD_UNSHEATHE",				ANIM_BANDIT_WEAPON_UNSHEATHE_01);
		Animation.Add("STANDARD_SHEATHE",				ANIM_BANDIT_WEAPON_SHEATHE_01);


		
		// Armed versions of the above
		Animation.StartGroup("SWORD");
			Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_VILLAGER_MALE_STRIKE_LEFT_01, Combo(0, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_VILLAGER_MALE_STRIKE_LEFT_RECOIL_01));
			Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_VILLAGER_MALE_STRIKE_RIGHT_01, Combo(1, 0), Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_VILLAGER_MALE_STRIKE_RIGHT_RECOIL_01));
			Animation.AddCombat("STRIKE_MEDIUM_FRONT_KNOCKDOWN", ANIM_VILLAGER_MALE_UNBLOCKABLE_ATTACK_01);
			
			Animation.AddCombat("STRIKE_RECOIL", ANIM_VILLAGER_MALE_STRIKE_LEFT_RECOIL_01, Handedness(HANDED_RIGHT, HANDED_LEFT));
			Animation.AddCombat("STRIKE_RECOIL", ANIM_VILLAGER_MALE_STRIKE_RIGHT_RECOIL_01, Handedness(HANDED_LEFT, HANDED_RIGHT));
	
			Animation.AddCombat("BLOCK_IDLE", ANIM_VILLAGER_MALE_COMBAT_IDLE_01);
			Animation.AddCombat("BLOCK_FRONT_RESPONSE",	ANIM_VILLAGER_MALE_BLOCK_LEFT_01);
			Animation.AddCombat("BLOCK_LEFT_RESPONSE",	ANIM_VILLAGER_MALE_BLOCK_LEFT_01);
			Animation.AddCombat("BLOCK_RIGHT_RESPONSE",	ANIM_VILLAGER_MALE_BLOCK_RIGHT_01);

			Animation.AddCombat("ST_IDLE",					ANIM_VILLAGER_MALE_COMBAT_IDLE_01);
			Animation.AddCombat("STRAFE_IDLE",				ANIM_VILLAGER_MALE_COMBAT_IDLE_01);
			Animation.AddCombat("SPECIAL_IDLE",				ANIM_VILLAGER_MALE_COMBAT_IDLE_01);
//			Animation.AddCombat("SPECIAL_IDLE",				ANIM_VILLAGER_MALE_THREATEN_IDLE_01);
//			Animation.AddCombat("SPECIAL_IDLE",				ANIM_VILLAGER_MALE_THREATEN_IDLE_02);
//			Animation.AddCombat("SPECIAL_IDLE",				ANIM_VILLAGER_MALE_SHOUT_01);

			Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",	ANIM_VILLAGER_MALE_STRAFE_FRONT_01);
			Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD", ANIM_VILLAGER_MALE_STRAFE_BACK_01);
			Animation.AddCombat("MOVEMENT_STRAFE_LEFT", ANIM_VILLAGER_MALE_STRAFE_LEFT_01);
			Animation.AddCombat("MOVEMENT_STRAFE_RIGHT", ANIM_VILLAGER_MALE_STRAFE_RIGHT_01);

			Animation.AddCombat("STRAFE_MOVEMENT_FORWARD",	ANIM_VILLAGER_MALE_STRAFE_FRONT_01);
			Animation.AddCombat("STRAFE_MOVEMENT_BACK", ANIM_VILLAGER_MALE_STRAFE_BACK_01);
			Animation.AddCombat("STRAFE_MOVEMENT_LEFT", ANIM_VILLAGER_MALE_STRAFE_LEFT_01);
			Animation.AddCombat("STRAFE_MOVEMENT_RIGHT", ANIM_VILLAGER_MALE_STRAFE_RIGHT_01);
			
			Animation.Add("STRAFE_UPPER_BODY",				ANIM_VILLAGER_MALE_STRAFE_UPPERBODY);
		Animation.EndGroup();
		
	<\CAppearanceDef>
	
	<CCreatureDef>	
		Stats.ExperienceWorth	1;
		Stats.RenownWorth		10;
	<\CCreatureDef>

	<CAppearanceDef>
		Animation.Add("ST_GET_OBJECT",						ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_OBJECT);
		Animation.Add("ST_PUT_OBJECT",						ANIM_BIPED_GENERIC_MAN_HOMELIFE_PUT_OBJECT);
		Animation.Add("ST_GET_OBJECT_CUPBOARD",				ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_CUPBOARD);
		Animation.Add("ST_PUT_OBJECT_CUPBOARD",				ANIM_BIPED_GENERIC_MAN_HOMELIFE_PUT_CUPBOARD);
		Animation.Add("ST_GET_OBJECT_BENCH",				ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_BENCH);
		Animation.Add("ST_PUT_OBJECT_BENCH",				ANIM_BIPED_GENERIC_MAN_HOMELIFE_PUT_BENCH);
		Animation.Add("ST_HOLDING_PLATE",					ANIM_BIPED_GENERIC_MAN_HOMELIFE_HOLDING);
		Animation.Add("ST_WORK_GET_CRATE",					ANIM_BIPED_GENERIC_MAN_WORK_GET_CRATE);
		Animation.Add("ST_WORK_PUT_CRATE",					ANIM_BIPED_GENERIC_MAN_WORK_PUT_CRATE);
		Animation.Add("ST_HOLDING_CRATE",					ANIM_BIPED_GENERIC_MAN_WORK_HOLDING);

		Animation.Add("ST_FILL_ITEM",						ANIM_BIPED_GENERIC_MAN_HOMELIFE_FILL_ITEM);
		Animation.Add("ST_EATING",							ANIM_BIPED_GENERIC_MAN_HOMELIFE_EATING);
		Animation.Add("ST_EATING",							ANIM_BIPED_GENERIC_MAN_HOMELIFE_EATING_02);
//		Animation.Add("ST_CLEANING",						ANIM_BIPED_GENERIC_MAN_SCRUB_01);
		Animation.Add("ST_CLEANING",						ANIM_BIPED_GENERIC_MAN_SCRUB_02);
//		Animation.Add("ST_CLEANING",						ANIM_BIPED_GENERIC_MAN_HOMELIFE_CLEANING);
		Animation.Add("ST_WIPE_TABLE",						ANIM_BIPED_GENERIC_MAN_HOMELIFE_WIPE_TABLE);
		Animation.Add("ST_LIGHT_CANDLE",					ANIM_BIPED_GENERIC_MAN_HOMELIFE_LIGHT_CANDLE);
		Animation.Add("ST_UNLIGHT_CANDLE",					ANIM_BIPED_GENERIC_MAN_HOMELIFE_UNLIGHT_CANDLE);
		Animation.Add("STANDARD_SCARED",					ANIM_BIPED_GENERIC_MAN_SCARED_01);

		Animation.Add("ST_GET_IN_BED_LEFT",					ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_INTO_BED);
		Animation.Add("ST_SLEEPING_IN_BED",					ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_INTO_BED_SLEEP, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("ST_GET_OUT_OF_BED_LEFT",				ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_OUT_BED);
		Animation.Add("ST_GET_OUT_OF_BED_LEFT_FAST",		ANIM_BIPED_GENERIC_MAN_HOMELIFE_GET_OUT_BED_FAST);

		Animation.Add("ST_SNEAK",							ANIM_VILLAGER_UPRIGHT_SNEAK_POSE);
		Animation.Add("ST_UPRIGHT_SNEAK",					ANIM_VILLAGER_UPRIGHT_SNEAK);

		Animation.StartGroup("CROUCH");
 			Animation.Add("ST_SNEAK",						ANIM_VILLAGER_UPRIGHT_SNEAK);
			Animation.Add("ST_SNEAK_POSE",					ANIM_VILLAGER_UPRIGHT_SNEAK_POSE);
			Animation.Add("ST_SNEAK_UPRIGHT",				ANIM_VILLAGER_UPRIGHT_SNEAK);
			Animation.Add("ST_SNEAK_UPRIGHT_POSE",			ANIM_VILLAGER_UPRIGHT_SNEAK_POSE);
		Animation.EndGroup();

		Animation.StartGroup("SLEEP_FLOOR_BED_MIDDLE");	
			Animation.Add("ST_GET_IN_FLOOR_BED",			ANIM_BIPED_GENERIC_MAN_LIE_ON_FLOOR);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",		ANIM_BIPED_GENERIC_MAN_ON_FLOOR_SLEEP);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",		ANIM_BIPED_GENERIC_MAN_ON_FLOOR_RISE);
		Animation.EndGroup();

		Animation.StartGroup("SLEEP_FLOOR_BED_RIGHT");
			Animation.Add("ST_GET_IN_FLOOR_BED",			ANIM_BIPED_GENERIC_MAN_LIE_ON_FLOOR_RIGHT);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",		ANIM_BIPED_GENERIC_MAN_ON_FLOOR_RIGHT_SLEEP);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",		ANIM_BIPED_GENERIC_MAN_ON_FLOOR_RIGHT_RISE);
		Animation.EndGroup();

		Animation.StartGroup("SLEEP_FLOOR_BED_LEFT");
			Animation.Add("ST_GET_IN_FLOOR_BED",			ANIM_BIPED_GENERIC_MAN_LIE_ON_FLOOR_LEFT);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",		ANIM_BIPED_GENERIC_MAN_ON_FLOOR_LEFT_SLEEP);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",		ANIM_BIPED_GENERIC_MAN_ON_FLOOR_LEFT_RISE);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_HAPPY");
			Animation.Add("DEFAULT", ANIM_VILLAGER_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_BELLIGERENT");
			Animation.Add("DEFAULT", ANIM_VILLAGER_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_ANGRY");
			Animation.Add("DEFAULT", ANIM_VILLAGER_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_FEAR");
			Animation.Add("DEFAULT", ANIM_VILLAGER_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_CONVERSATION_SCARED_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SCARED_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_SAD");
			Animation.Add("DEFAULT", ANIM_VILLAGER_CONVERSATION_SAD_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_CONVERSATION_SAD_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_CONVERSATION_SAD_BREAKOFF_04);
		Animation.EndGroup();

//		Animation.Add("CONV_GENERAL", ANIM_VILLAGER_MALE_TALK_TO_CHILD_01);
//		Animation.Add("CONV_GENERAL", ANIM_VILLAGER_MALE_TALK_TO_CHILD_02);

		// For testing
		Animation.Add("SHAKE_HANDS_1",			ANIM_VILLAGER_MALE_SHAKE_HANDS_1, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("SHAKE_HANDS_2",			ANIM_VILLAGER_MALE_SHAKE_HANDS_2, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("GIVE_MONEY",				ANIM_VILLAGER_MALE_GIVE_MONEY_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("RECEIVE_MONEY",			ANIM_VILLAGER_MALE_RECEIVE_MONEY_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));

		Animation.Add("GIVE_HUG",				ANIM_VILLAGER_MALE_GIVE_HUG_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("GIVE_KISS",				ANIM_VILLAGER_MALE_GIVE_KISS_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("RECEIVE_KISS",			ANIM_VILLAGER_MALE_RECEIVE_KISS_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));

		Animation.StartGroup("CARRYING_GOODS");
			Animation.Add("ST_WALK",			ANIM_VILLAGER_MALE_WALK_WITH_LARGE_CRATE);
			Animation.Add("ST_RUN",				ANIM_VILLAGER_MALE_WALK_WITH_LARGE_CRATE);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_MALE_BREATHE_LOOP_LARGE_CRATE);
			Animation.Add("ST_IDLE_SUBTLE",		ANIM_VILLAGER_MALE_BREATHE_LOOP_LARGE_CRATE);
		Animation.EndGroup();

		Animation.Add("VM_WALK_WITH_LARGE_CRATE",		ANIM_VILLAGER_MALE_WALK_WITH_LARGE_CRATE);
		Animation.Add("VM_BREATHE_LOOP_LARGE_CRATE",	ANIM_VILLAGER_MALE_BREATHE_LOOP_LARGE_CRATE);
		Animation.Add("VM_PICK_UP_LARGE_CRATE_LEVEL1",	ANIM_VILLAGER_MALE_PICK_UP_LARGE_CRATE_LEVEL1);
		Animation.Add("VM_PUT_DOWN_LARGE_CRATE_LEVEL1",	ANIM_VILLAGER_MALE_PUT_DOWN_LARGE_CRATE_LEVEL1);
		Animation.Add("VM_PICK_UP_LARGE_CRATE_LEVEL2",	ANIM_VILLAGER_MALE_PICK_UP_LARGE_CRATE_LEVEL2);
		Animation.Add("VM_PUT_DOWN_LARGE_CRATE_LEVEL2",	ANIM_VILLAGER_MALE_PUT_DOWN_LARGE_CRATE_LEVEL2);
	<\CAppearanceDef>

	<CCreatureDef>
		PhonemeAnim["AH"]				ANIM_VILLAGER_MALE_PHONEME_AH;
		PhonemeAnim["EE"]				ANIM_VILLAGER_MALE_PHONEME_EE;
		PhonemeAnim["MM"]				ANIM_VILLAGER_MALE_PHONEME_MM;
		PhonemeAnim["OH"]				ANIM_VILLAGER_MALE_PHONEME_OH;
		PhonemeAnim["SZ"]				ANIM_VILLAGER_MALE_PHONEME_SZ;
		PhonemeAnim["WW"]				ANIM_VILLAGER_MALE_PHONEME_WW;
	<\CCreatureDef>

	<CAppearanceDef>
		Animation.StartGroup("STAND");
			Animation.Add("ST_IDLE_BREATHE",		ANIM_VILLAGER_MALE_IDLE_BREATHE_01);
			
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_UPP_IDLE_04);		

		/*DONT USE AS THESE ARE ONLY MEANT TO BE USED FOR STANDING STILL 
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_IDLE_02);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_01);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_02);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_03);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_04);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_05);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_06);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_07);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_LOOK_IDLE_08);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_RUB_HANDS);
		*/
			Animation.Add("DEFAULT",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));

			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));
			
			Animation.Add("ST_POSE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));
			
   			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_GAZE_SKY_01);
   			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
// 			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_STEP_IN_SOMETHING_01);
// 			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_TIE_LACES_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_YAWN_01);
		Animation.EndGroup();

		Animation.StartGroup("STAND_HAPPY");
			Animation.Add("ST_POSE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_DRINKING_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_EATING_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_GAZE_SKY_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_STEP_IN_SOMETHING_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_TIE_LACES_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_YAWN_01);
		Animation.EndGroup();

		Animation.StartGroup("STAND_BORED");
			Animation.Add("ST_POSE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_IDLE_BREATHE_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_DRINKING_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_EATING_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_GAZE_SKY_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SCRATCH_HEAD_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_STEP_IN_SOMETHING_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_TIE_LACES_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_YAWN_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR");
//			Animation.Add("ST_SIT_ON_CHAIR",		ANIM_VILLAGER_MALE_SIT_ON_CHAIR_01);
//			Animation.Add("ST_SEATED_GET_UP",		ANIM_VILLAGER_MALE_SEATED_GET_UP_01);

			Animation.Add("ST_SIT_ON_SEAT",			ANIM_VILLAGER_MALE_SIT_ON_CHAIR_01);

			Animation.Add("ST_SITTING",				ANIM_BIPED_GENERIC_MAN_SIT_ON_BENCH_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_SEATED_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SEATED_IDLE_02);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_UPP_IDLE_04);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_BACK_01);

		Animation.EndGroup();
		Animation.Add("ST_STAND_UP_FROM_SEAT",	ANIM_VILLAGER_MALE_SEATED_GET_UP_01);

		Animation.StartGroup("SIT_CHAIR_NORMAL");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_SEATED_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR_BORED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_SEATED_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SEATED_IDLE_02);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SEATED_EATING_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR_SLEEPING");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_SEATED_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SEATED_SLEEP_FIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_BENCH");
//			Animation.Add("ST_SIT_ON_BENCH",		ANIM_BIPED_GENERIC_MAN_SIT_ON_BENCH);
			Animation.Add("ST_SITTING",				ANIM_BIPED_GENERIC_MAN_SIT_ON_BENCH_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_SEATED_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_SEATED_IDLE_02);
//			Animation.Add("ST_STAND_UP_FROM_BENCH",	ANIM_BIPED_GENERIC_MAN_SIT_OFF_BENCH);
			Animation.Add("ST_IDLE_COMB",			ANIM_BIPED_GENERIC_MAN_UPP_IDLE_04);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		//ANIMS FOR *BED* TO PLAY
		Animation.Add("BED_GET_IN_LEFT",			ANIM_OBJECT_BED_01_GET_IN);
		Animation.Add("BED_GET_OUT_LEFT",			ANIM_OBJECT_BED_01_GET_OUT);
		Animation.Add("BED_GET_OUT_LEFT_FAST",		ANIM_OBJECT_BED_01_GET_OUT_FAST);
		Animation.Add("BED_SLEEP",					ANIM_OBJECT_BED_01_SLEEP);

		//ANIMS FOR *CUPBOARD* TO PLAY
//		Animation.Add("CUPBOARD_GET",				ANIM_OBJECT_CABINET_TALL_GET);
//		Animation.Add("CUPBOARD_PUT",				ANIM_OBJECT_CABINET_TALL_PUT);
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.Add("HAMMER",						ANIM_VILLAGER_MALE_HAMMERING_01);
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.Add("DRINK_AT_TABLE_INTO", ANIM_VILLAGER_MALE_TAVERN_DRINK_AT_TABLE_INTO_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("DRINK_AT_TABLE_OUTOF", ANIM_VILLAGER_MALE_TAVERN_DRINK_AT_TABLE_OUTOF_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("FALLING_ASLEEP_INTO", ANIM_VILLAGER_MALE_TAVERN_FALLING_ASLEEP_INTO_01);
		Animation.Add("FALLING_ASLEEP_LOOP", ANIM_VILLAGER_MALE_TAVERN_FALLING_ASLEEP_LOOP_01);
		Animation.Add("FALLING_ASLEEP_OUTOF", ANIM_VILLAGER_MALE_TAVERN_FALLING_ASLEEP_OUTOF_01);
		Animation.Add("SIT_AT_TABLE_INTO", ANIM_VILLAGER_MALE_TAVERN_SIT_AT_TABLE_INTO_01);
		Animation.Add("SIT_AT_TABLE_LOOP", ANIM_VILLAGER_MALE_TAVERN_SIT_AT_TABLE_LOOP_01);
		Animation.Add("SIT_AT_TABLE_OUTOF", ANIM_VILLAGER_MALE_TAVERN_SIT_AT_TABLE_OUTOF_01);
		Animation.Add("LISTENING_INTO", ANIM_VILLAGER_MALE_TAVERN_LISTENING_INTO_01);
		Animation.Add("LISTENING_LOOP", ANIM_VILLAGER_MALE_TAVERN_LISTENING_LOOP_01);
		Animation.Add("LISTENING_OUTOF", ANIM_VILLAGER_MALE_TAVERN_LISTENING_OUTOF_01);
		Animation.Add("SEATED_TAVERN_LAUGH", ANIM_VILLAGER_MALE_TAVERN_LAUGH_01);
		Animation.Add("SEATED_TAVERN_LAUGH", ANIM_VILLAGER_MALE_TAVERN_LAUGH_02);
		Animation.Add("SLUMPED_DRUNK_AT_TABLE_INTO", ANIM_VILLAGER_MALE_TAVERN_SLUMPED_DRUNK_AT_TABLE_INTO_01);
		Animation.Add("SLUMPED_DRUNK_AT_TABLE_LOOP", ANIM_VILLAGER_MALE_TAVERN_SLUMPED_DRUNK_AT_TABLE_LOOP_01);
		Animation.Add("SLUMPED_DRUNK_AT_TABLE_OUTOF", ANIM_VILLAGER_MALE_TAVERN_SLUMPED_DRUNK_AT_TABLE_OUTOF_01);
		Animation.Add("TELLING_STORY_INTO", ANIM_VILLAGER_MALE_TAVERN_TELLING_STORY_INTO_01);
		Animation.Add("TELLING_STORY_LOOP", ANIM_VILLAGER_MALE_TAVERN_TELLING_STORY_LOOP_01);
		Animation.Add("TELLING_STORY_OUTOF", ANIM_VILLAGER_MALE_TAVERN_TELLING_STORY_OUTOF_01);
		Animation.Add("PAY_AT_BAR", ANIM_VILLAGER_MALE_PAY_AT_BAR_01);

		Animation.Add("BLACKSMITH_HAMMER_INTO",		ANIM_VILLAGER_MALE_BLACKSMITH_HAMMER_INTO_01);
		Animation.Add("BLACKSMITH_HAMMER_LOOP",		ANIM_VILLAGER_MALE_BLACKSMITH_HAMMER_LOOP_01);
		Animation.Add("BLACKSMITH_HAMMER_OUTOF",	ANIM_VILLAGER_MALE_BLACKSMITH_HAMMER_OUTOF_01);
		Animation.Add("ACKNOWLEDGE_BARMAID", ANIM_VILLAGER_MALE_ACKNOWLEDGE_BARMAID_01);
		Animation.Add("BARMAN_LEAN_INTO", ANIM_VILLAGER_MALE_BARMAN_LEAN_INTO_01);
		Animation.Add("BARMAN_LEAN_LOOP", ANIM_VILLAGER_MALE_BARMAN_LEAN_LOOP_01);
		Animation.Add("BARMAN_LEAN_OUTOF", ANIM_VILLAGER_MALE_BARMAN_LEAN_OUTOF_01);
//		Animation.Add("SHOUT_FOR_BEER", ANIM_VILLAGER_MALE_SHOUT_FOR_BEER_01);
		Animation.Add("SHOUT_FOR_BEER", ANIM_VILLAGER_MALE_ASK_FOR_BEER_01);
		Animation.Add("OFFER_GAME", ANIM_VILLAGER_MALE_OFFER_GAME_01);
		
		Animation.StartGroup("SIT_TAVERN_STOOL");
			Animation.Add("ST_SITTING",				ANIM_VILLAGER_MALE_TAVERN_SIT_AT_TABLE_LOOP_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_TAVERN_SIT_AT_TABLE_LOOP_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_TAVERN_SIT_AT_TABLE_LOOP_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_MALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("DRINKING_FROM_TANKARD");
			Animation.Add("ST_SITTING",				ANIM_VILLAGER_MALE_TAVERN_DRINK_AT_TABLE_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_TAVERN_DRINK_AT_TABLE_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_TAVERN_DRINK_AT_TABLE_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.EndGroup();

		Animation.StartGroup("DRUNK");
			Animation.Add("ST_WALK",				ANIM_VILLAGER_MALE_DRUNK_WALK_01);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_MALE_DRUNK_WALK_02);
			Animation.Add("ST_SLOW_WALK",			ANIM_VILLAGER_MALE_DRUNK_WALK_01);
			Animation.Add("ST_SLOW_WALK",			ANIM_VILLAGER_MALE_DRUNK_WALK_02);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_DRUNK_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_DRUNK_IDLE_01);
			Animation.Add("TURNING_AC90",			ANIM_VILLAGER_DRUNK_TURN_90_LEFT_01);
			Animation.Add("TURNING_C90",			ANIM_VILLAGER_DRUNK_TURN_90_RIGHT_01);
			Animation.Add("TURNING_AC180",			ANIM_VILLAGER_DRUNK_TURN_180_LEFT_01);
			Animation.Add("TURNING_C180",			ANIM_VILLAGER_DRUNK_TURN_180_RIGHT_01);
		Animation.EndGroup();

		Animation.StartGroup("ARMS_OFF_TABLE");
			Animation.Add("ST_SITTING",				ANIM_VILLAGER_MALE_ARMS_OFF_TABLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_MALE_ARMS_OFF_TABLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_MALE_ARMS_OFF_TABLE_01);
		Animation.EndGroup();

	<\CAppearanceDef>

	<CAppearanceDef>
//		Animation.StartGroup("FILL_JUG");
//			Animation.Add("ST_IDLE",		ANIM_BARMAN_FILL_JUG_LOOP_01);
//			Animation.Add("ST_IDLE_SUBTLE",	ANIM_BARMAN_FILL_JUG_LOOP_01);
//		Animation.EndGroup();

		Animation.Add("FILL_JUG_INTO",	ANIM_BARMAN_FILL_JUG_INTO_01);
		Animation.Add("FILL_JUG_LOOP",	ANIM_BARMAN_FILL_JUG_LOOP_01);
		Animation.Add("FILL_JUG_OUTOF",	ANIM_BARMAN_FILL_JUG_OUTOF_01);

		Animation.Add("RECEIVE_MONEY_AT_BAR",	ANIM_BARMAN_RECEIVE_MONEY_AT_BAR_01);

		Animation.Add("PUSHED_FORWARD", ANIM_VILLAGER_MALE_PUSHED_FORWARD_01, TransTime(0), Delay(0));
		Animation.Add("PUSHED_BACKWARD", ANIM_VILLAGER_MALE_PUSHED_BACKWARD_01, TransTime(0), Delay(0));
		
		Animation.Add("GENERATE_DROP", ANIM_VILLAGER_UPRIGHT_SNEAK_POSE);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_VILLAGER_MALE_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_VILLAGER_MALE_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
		
	<\CAppearanceDef>

	CombatDiameter			0.8;
	
	Components.Add("CTCDrunkenness");
	<CDrunkennessDef>
		DrunkennessThresholdMult	2.0;
	<\CDrunkennessDef>
#end_definition

//*************************************************************************************************
#definition_template CREATURE CREATURE_GENERIC_ADULT_FEMALE_VILLAGER_TEMPLATE specialises CREATURE_VILLAGER_TEMPLATE

	CombatTypeDef			FEMALE_VILLAGER_COMBAT_TYPE;
	Components.Add("CTCCombat");

	<CEntitySoundDef>
		SoundIdentifier		"SI_HUMAN_FEMALE";
	<\CEntitySoundDef>

	Components.Add("CTCWife");
	<CWifeDef>
		Dowry				1000;
	<\CWifeDef>

	<CCreatureDef>
		DialogueVoices.Add("AF1");
		DialogueVoices.Add("AF3");
	<\CCreatureDef>
	
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_CREATURE_HEAD);
	<\CHitLocationsDef>
	
	<CDecapitationDef>
		Head				OBJECT_BS_FEMALE_DECAP_HEAD_01;
		BodyParticleEffect	BLOOD_SPURT;
	<\CDecapitationDef>

	<CLookDef>
		EyesTurnRangeXY		20.0;
		EyesTurnRangeYZ		0.0;
		HeadTurnRangeXY		170.0;
		HeadTurnRangeYZUp	50.0;
		HeadTurnRangeYZDown	50.0;
	<\CLookDef>
	
	<CAppearanceDef>
		Animation.StartGroup("CAGED");
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
			Animation.Add("ST_IDLE",						ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_IN_CAGE_HIT_TO_DIE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_IN_CAGE_HIT_TO_DIE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_IN_CAGE_HIT_TO_DIE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_VILLAGER_FEMALE_IN_CAGE_HIT_TO_DIE_02);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_VILLAGER_FEMALE_IN_CAGE_HIT_TO_DIE_02);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_VILLAGER_FEMALE_IN_CAGE_HIT_TO_DIE_02);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
		Animation.EndGroup();
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.Add("ST_HIT_BY_FORCE_PUSH",			ANIM_VILLAGER_FEMALE_HIT_BY_FORCE_PUSH_01);
		Animation.Add("ST_HIT_BY_FORCE_PUSH_IMPACT",	ANIM_VILLAGER_FEMALE_HIT_BY_FORCE_PUSH_IMPACT_01);

		Animation.StartGroup("TABLELAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LIGHT_LAMP_01);
		Animation.EndGroup();

		Animation.StartGroup("BOWERSTONE");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LAMP_LIGHT_STREET_01);
		Animation.EndGroup();

		Animation.StartGroup("BANDITCAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LAMP_LIGHT_STREET_01);
		Animation.EndGroup();

		Animation.StartGroup("GENERIC");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LAMP_LIGHT_STREET_01);
		Animation.EndGroup();
		
		Animation.StartGroup("CUPBOARDLAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LAMP_LIGHT_CUPBOARD_01);
		Animation.EndGroup();
		
		Animation.StartGroup("STREETLAMP");
			Animation.Add("LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LAMP_LIGHT_STREET_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_TAVERN_STOOL");
			Animation.Add("ST_SITTING",					ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.Add("ST_SAT_EATING_INTO",				ANIM_VILLAGER_FEMALE_SAT_EAT_INTO_01);
		Animation.Add("ST_SAT_EATING_LOOP",				ANIM_VILLAGER_FEMALE_SAT_EAT_LOOP_01);
		Animation.Add("ST_SAT_EATING_OUTOF",			ANIM_VILLAGER_FEMALE_SAT_EAT_OUTOF_01);		
		Animation.StartGroup("EAT_AT_TABLE");
			Animation.Add("ST_SITTING",					ANIM_VILLAGER_FEMALE_SAT_EAT_LOOP_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_FEMALE_SAT_EAT_LOOP_01);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_FEMALE_SAT_EAT_LOOP_01);
		Animation.EndGroup();

		Animation.Add("PUT_FOOD_ON_TABLE",				ANIM_VILLAGER_FEMALE_FOOD_PICK_UP_01);
		Animation.Add("TAKE_FOOD_FROM_TABLE",			ANIM_VILLAGER_FEMALE_FOOD_PUT_DOWN_01);

		Animation.Add("RUFFLE_CHILD_HAIR",				ANIM_VILLAGER_FEMALE_RUFFLE_CHILD_HAIR_01);
		Animation.Add("GIVE_CHILD_HUG",					ANIM_VILLAGER_FEMALE_GIVE_CHILD_HUG_01);
		
		Animation.Add("ST_DECAPITATED",					ANIM_VILLAGER_FEMALE_DECAPITATED_01);
		Animation.Add("ST_DECAPITATED",					ANIM_VILLAGER_FEMALE_DECAPITATED_02);
		Animation.Add("ST_DECAPITATED",					ANIM_VILLAGER_FEMALE_DECAPITATED_03);

		Animation.Add("ST_TALK_TO_CHILD",				ANIM_VILLAGER_FEMALE_TALK_TO_CHILD_01);
		Animation.Add("ST_TALK_TO_CHILD",				ANIM_VILLAGER_FEMALE_TALK_TO_CHILD_02);
		Animation.Add("ST_CROUCH_TALK_TO_CHILD_INTO",	ANIM_VILLAGER_FEMALE_CROUCH_TALK_TO_CHILD_INTO_01);
		Animation.Add("ST_CROUCH_TALK_TO_CHILD_LOOP",	ANIM_VILLAGER_FEMALE__CROUCH_TALK_TO_CHILD_01);
		Animation.Add("ST_CROUCH_TALK_TO_CHILD_OUTOF",	ANIM_VILLAGER_FEMALE__CROUCH_TALK_TO_CHILD_OUTOF_01);
		Animation.Add("ST_KNEEL_TALK_TO_CHILD_INTO",	ANIM_VILLAGER_FEMALE_KNEEL_TALK_TO_CHILD_INTO_01);
		Animation.Add("ST_KNEEL_TALK_TO_CHILD_LOOP",	ANIM_VILLAGER_FEMALE_KNEEL_TALK_TO_CHILD_01);
		Animation.Add("ST_KNEEL_TALK_TO_CHILD_OUTOF",	ANIM_VILLAGER_FEMALE_KNEEL_TALK_TO_CHILD_OUTOF_01);

		Animation.Add("DEFAULT",						ANIM_VILLAGER_FEMALE_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_POSE",						ANIM_VILLAGER_FEMALE_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE_SUBTLE",					ANIM_VILLAGER_FEMALE_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_WALK",						ANIM_BIPED_NEW_VILLAGER_FEMALE_WALK, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_SLOW_WALK",					ANIM_BIPED_NEW_VILLAGER_FEMALE_SLOW_WALK, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_RUN",							ANIM_BIPED_NEW_VILLAGER_FEMALE_RUN, Flags(ANIM_FLAG_PRELOAD));
	
		Animation.Add("ST_WALK_ARMS_CROSSED",			ANIM_VILLAGER_FEMALE_WALK_ARMS_CROSSED_01);
		Animation.Add("ST_WALK_ELEGANT",				ANIM_VILLAGER_FEMALE_WALK_ELEGANT_01);
		Animation.Add("ST_WALK_FAST",					ANIM_VILLAGER_FEMALE_WALK_FAST_01);
		Animation.Add("ST_WALK_STANDARD",				ANIM_VILLAGER_FEMALE_WALK_STANDARD_01);
		
		Animation.Add("ST_BEG_INTO",					ANIM_VILLAGER_FEMALE_BEG_INTO_01);
		Animation.Add("ST_BEG_LOOP",					ANIM_VILLAGER_FEMALE_BEG_LOOP_01);

		Animation.Add("ST_BUMP_INTO",					ANIM_VILLAGER_FEMALE_BUMP_INTO_01);
		
		Animation.Add("ST_GHOST_HOVER_IDLE",			ANIM_VILLAGER_FEMALE_GHOST_HOVER_IDLE);
		Animation.Add("ST_KICKED_WHEN_DEAD",			ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//the complete set of generic responses and dead and stunned etc idles
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////

		Animation.Add("STANDARD_DEAD",				ANIM_VILLAGER_FEMALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.Add("STANDARD_DIE",				ANIM_VILLAGER_FEMALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.Add("STABBED_TO_DEAD",			ANIM_VILLAGER_FEMALE_STABBED_TO_DEAD_01);
		Animation.Add("STABBED_ALREADY_DEAD",		ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
		
		Animation.Add("TURNING_C90",		ANIM_VILLAGER_FEMALE_TURN_90_RIGHT_01);
		Animation.Add("TURNING_AC90",		ANIM_VILLAGER_FEMALE_TURN_90_LEFT_01);
		Animation.Add("TURNING_C180",		ANIM_VILLAGER_FEMALE_TURN_180_RIGHT_01);
		Animation.Add("TURNING_AC180",		ANIM_VILLAGER_FEMALE_TURN_180_LEFT_01);

		Animation.AddCombat("STANDARD_WAVE",		ANIM_VILLAGER_FEMALE_ATTRACT_WAVE_01);
		Animation.AddCombat("STANDARD_WAVE_INFO",	ANIM_VILLAGER_FEMALE_ATTRACT_WAVE_INFO_01);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_VILLAGER_FEMALE_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_VILLAGER_FEMALE_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_VILLAGER_FEMALE_GET_UP_FROM_UNCONSCIOUS_01);

		Animation.AddCombat("FALL_DEAD",								ANIM_VILLAGER_FEMALE_KNOCKED_OUT_KNOCKOUT); //need replacing
		Animation.AddCombat("FALL_UNCONSCIOUS",							ANIM_VILLAGER_FEMALE_KNOCKED_OUT_KNOCKOUT); //need replacing

		// MS4 - START
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",				ANIM_VILLAGER_FEMALE_STRAFE_FRONT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",				ANIM_VILLAGER_FEMALE_STRAFE_BACK_01);
		Animation.AddCombat("MOVEMENT_STRAFE_LEFT",					ANIM_VILLAGER_FEMALE_STRAFE_LEFT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_RIGHT",				ANIM_VILLAGER_FEMALE_STRAFE_RIGHT_01);

		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",			ANIM_VILLAGER_FEMALE_GET_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",			ANIM_VILLAGER_FEMALE_GET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",			ANIM_VILLAGER_FEMALE_GET_HIT_RIGHT_01);

		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",	ANIM_VILLAGER_FEMALE_GET_HIT_KO_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",	ANIM_VILLAGER_FEMALE_GET_HIT_KO_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",	ANIM_VILLAGER_FEMALE_GET_HIT_KO_RIGHT_01);

		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_VILLAGER_FEMALE_GET_HIT_KO_LEFT_01);
		Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",	ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);

		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",								ANIM_VILLAGER_FEMALE_KNOCK_DOWN_IDLE_BREATHE_01);
			Animation.Add("ST_IDLE_SUBTLE",							ANIM_VILLAGER_FEMALE_KNOCK_DOWN_IDLE_BREATHE_01);
			Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",	ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_VILLAGER_FEMALE_KICKED_WHEN_DEAD);
		Animation.EndGroup();
		
		Animation.AddCombat("DAZED_IDLE",							ANIM_VILLAGER_FEMALE_DAZED_IDLE);
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_DAZED_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_DAZED_IDLE);
			Animation.Add("DAZED_RECOVER",			ANIM_VILLAGER_FEMALE_DAZED_IDLE);
		Animation.EndGroup();

		Animation.AddCombat("KNOCKDOWN_IDLE",						ANIM_VILLAGER_FEMALE_KNOCK_DOWN_IDLE_BREATHE_01);
		// MS4 - END

		Animation.AddCombat("STRIKE_MEDIUM_FRONT",	ANIM_VILLAGER_FEMALE_HOMICIDAL_01);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",	ANIM_VILLAGER_FEMALE_HOMICIDAL_02);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_KNOCKDOWN",	ANIM_VILLAGER_FEMALE_HOMICIDAL_03);
	<\CAppearanceDef>

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////

	<CCreatureDef>				
		Stats.ExperienceWorth	1;
		Stats.RenownWorth		10;
	<\CCreatureDef>

	<CAppearanceDef>
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_FEMALE_RIDICULE_01);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_FEMALE_RIDICULE_02);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_FEMALE_RIDICULE_03);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_FEMALE_OUTRAGED_02);
		Animation.Add("ST_RIDICULE",				ANIM_VILLAGER_FEMALE_FASCINATION_01);

		Animation.Add("ST_HOMICIDAL_INTRO",			ANIM_VILLAGER_FEMALE_HOMICIDAL_INTRO);
		Animation.Add("ST_SURPRISE",				ANIM_VILLAGER_FEMALE_SURPRISE_01);

		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_NEW_VILLAGER_FEMALE_TALK_IDLE_01);
		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_NEW_VILLAGER_FEMALE_TALK_IDLE_02);
		Animation.Add("STANDARD_TALK_GENERIC",		ANIM_BIPED_NEW_VILLAGER_FEMALE_TALK_IDLE_03);
		Animation.Add("STANDARD_TALK_LOVE",			ANIM_VILLAGER_FEMALE_ATTRACTED_01);
		Animation.Add("STANDARD_TALK_ANGER",		ANIM_VILLAGER_FEMALE_OUTRAGED_03);
		Animation.Add("STANDARD_TALK_ANGER",		ANIM_VILLAGER_FEMALE_OUTRAGED_04);
		Animation.Add("STANDARD_TALK_FEAR",			ANIM_VILLAGER_FEMALE_FEAR_01);
		Animation.Add("STANDARD_TALK_FEAR",			ANIM_VILLAGER_FEMALE_SURPRISE_01);
		Animation.Add("STANDARD_TALK_SADNESS",		ANIM_VILLAGER_FEMALE_SAD_01);
		Animation.Add("STANDARD_TALK_FRIENDLY",		ANIM_VILLAGER_FEMALE_FRIENDLY_01);
		Animation.Add("STANDARD_TALK_RIDICULE",		ANIM_VILLAGER_FEMALE_RIDICULE_02);

		Animation.Add("SCRIPT_CHEER_1",				ANIM_VILLAGER_FEMALE_AWE_01);
		Animation.Add("SCRIPT_CHEER_2",				ANIM_VILLAGER_FEMALE_AWE_02);
		Animation.Add("SCRIPT_CHEER_3",				ANIM_VILLAGER_FEMALE_AWE_03);
		Animation.Add("SCRIPT_BOO_1",				ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		Animation.Add("SCRIPT_BOO_2",				ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		Animation.Add("SCRIPT_BOO_3",				ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		
		Animation.Add("ST_HEAD_TURN_V",				ANIM_BIPED_NEW_VILLAGER_FEMALE_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_HEAD_TURN_H",				ANIM_BIPED_NEW_VILLAGER_FEMALE_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));

		Animation.Add("STANDARD_YAWN",				ANIM_VILLAGER_FEMALE_YAWN_01);
		Animation.Add("ST_HOLDING_PLATE",			ANIM_BIPED_NEW_VILLAGER_FEMALE_HOLDING_PLATE);
		Animation.Add("ST_WORK_GET_CRATE",			ANIM_BIPED_NEW_VILLAGER_FEMALE_WORK_GET_CRATE);
		Animation.Add("ST_WORK_PUT_CRATE",			ANIM_BIPED_NEW_VILLAGER_FEMALE_WORK_PUT_CRATE);
		Animation.Add("ST_HOLDING_CRATE",			ANIM_BIPED_NEW_VILLAGER_FEMALE_HOLDING_CRATE);
		Animation.Add("ST_PICK_CROPS",				ANIM_VILLAGER_FEMALE_PICK_CROPS_LOOP_01);

		Animation.Add("ST_FILL_ITEM",					ANIM_BIPED_NEW_VILLAGER_FEMALE_FILL_ITEM);
		Animation.Add("ST_STAND_EATING_LOOP",			ANIM_VILLAGER_FEMALE_STAND_EATING_LOOP_01);
		Animation.Add("ST_WASH_FLOOR_LOOP",				ANIM_VILLAGER_FEMALE_WASH_FLOOR_LOOP_01);
		Animation.Add("ST_CLEANING_WAISTHEIGHT_LOOP",	ANIM_VILLAGER_FEMALE_CLEANING_WAISTHEIGHT_LOOP_01);
		Animation.Add("ST_LIGHT_CANDLE",				ANIM_BIPED_NEW_VILLAGER_FEMALE_LIGHT_CANDLE);
		Animation.Add("ST_UNLIGHT_CANDLE",				ANIM_BIPED_NEW_VILLAGER_FEMALE_LIGHT_CANDLE);
		Animation.Add("STANDARD_SCARED",				ANIM_VILLAGER_FEMALE_FEAR_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));

		Animation.Add("ST_SNEAK",						ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK_POSE);
		Animation.Add("ST_UPRIGHT_SNEAK",				ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK);
		
		Animation.Add("ST_TORTURE_LEVITATION",	ANIM_FEMALE_TORTURE_LEVITATE);
		Animation.Add("ST_TORTURE_TRANSITION",	ANIM_FEMALE_TORTURE_LEVITATE_INTO_LOOP);
		Animation.Add("ST_TORTURE_LOOP",		ANIM_FEMALE_TORTURE_LOOP);

		Animation.Add("ST_ARGUING_DENIAL",				ANIM_VILLAGER_FEMALE_ARGUING_DENIAL_01);
		Animation.Add("ST_ARGUING_DENIAL_STRONG",		ANIM_VILLAGER_FEMALE_ARGUING_DENIAL_STRONG_01);
		Animation.Add("ST_ARGUING_POINT_AWAY",			ANIM_VILLAGER_FEMALE_ARGUING_POINTING_AWAY_01);
		Animation.Add("ST_ARGUING_POINT_AT",			ANIM_VILLAGER_FEMALE_ARGUING_POINTING_AT_01);
		Animation.Add("ST_CHECK_APPEARANCE",			ANIM_VILLAGER_FEMALE_CHECK_APPEARANCE_01);
		Animation.Add("ST_CHECK_APPEARANCE_EYE",		ANIM_VILLAGER_FEMALE_CHECK_APPEARANCE_EYE_01);
		Animation.Add("ST_POINTING",					ANIM_VILLAGER_FEMALE_POINTING_01);
		Animation.Add("ST_RESPONSE_SHOUT",				ANIM_VILLAGER_FEMALE_RESPONSE_SHOUT_01);
		Animation.Add("ST_RESPONSE_WAVE",				ANIM_VILLAGER_FEMALE_RESPONSE_WAVE_01);
		Animation.Add("ST_SHOUT_INSULT",				ANIM_VILLAGER_FEMALE_SHOUT_INSULT_01);
		Animation.Add("ST_SLAP",						ANIM_VILLAGER_FEMALE_SLAP_01);
		Animation.Add("ST_ATTRACT_SHOUT",				ANIM_VILLAGER_FEMALE_ATTRACT_SHOUT_01);
		Animation.Add("ST_ATTRACT_WAVE",				ANIM_VILLAGER_FEMALE_ATTRACT_WAVE_01);
		Animation.Add("ST_CHEER_JUMP",					ANIM_VILLAGER_FEMALE_CHEERING_JUMPING_01);
		Animation.Add("ST_TELLING_OFF_KID",				ANIM_VILLAGER_FEMALE_TELL_OFF_KID_01);
		Animation.Add("ST_BOTTOM_TOUCHED",				ANIM_VILLAGER_FEMALE_BOTTOM_TOUCHED_01);

	//	NEED GROUPING
		Animation.Add("ST_BEING_CHATTED_UP_INTO",		ANIM_VILLAGER_FEMALE_BEING_CHATTED_UP_INTO_01);
		Animation.Add("ST_BEING_CHATTED_UP_LOOP",		ANIM_VILLAGER_FEMALE_BEING_CHATTED_UP_LOOP_01);
		Animation.Add("ST_BEING_CHATTED_UP_OUTOF",		ANIM_VILLAGER_FEMALE_BEING_CHATTED_UP_OUTOF_01);
		Animation.Add("ST_INLOVE_HANDS_INTO",			ANIM_VILLAGER_FEMALE_INLOVE_HANDS_INTO_01);
		Animation.Add("ST_INLOVE_HANDS_LOOP",			ANIM_VILLAGER_FEMALE_INLOVE_HANDS_LOOP_01);
		Animation.Add("ST_INLOVE_HANDS_OUTOF",			ANIM_VILLAGER_FEMALE_INLOVE_HANDS_OUT_01);
		Animation.Add("ST_BLOW_KISS_INTO",				ANIM_VILLAGER_FEMALE_BLOW_KISS_INTO_01);
		Animation.Add("ST_BLOW_KISS_LOOP",				ANIM_VILLAGER_FEMALE_BLOW_KISS_LOOP_01);
		Animation.Add("ST_BLOW_KISS_OUTOF",				ANIM_VILLAGER_FEMALE_BLOW_KISS_OUT_01);
		Animation.Add("ST_PICK_CROPS_INTO",				ANIM_VILLAGER_FEMALE_PICK_CROPS_INTO_01);
		Animation.Add("ST_PICK_CROPS_LOOP",				ANIM_VILLAGER_FEMALE_PICK_CROPS_LOOP_01);
		Animation.Add("ST_PICK_CROPS_OUTOF",			ANIM_VILLAGER_FEMALE_PICK_CROPS_OUT_01);
		Animation.Add("ST_CLEANING_WAISTHEIGHT_INTO",	ANIM_VILLAGER_FEMALE_CLEANING_WAISTHEIGHT_INTO_01);
		Animation.Add("ST_CLEANING_WAISTHEIGHT_LOOP",	ANIM_VILLAGER_FEMALE_CLEANING_WAISTHEIGHT_LOOP_01);
		Animation.Add("ST_CLEANING_WAISTHEIGHT_OUTOF",	ANIM_VILLAGER_FEMALE_CLEANING_WAISTHEIGHT_OUT_01);
		Animation.Add("ST_COOKING_INTO",				ANIM_VILLAGER_FEMALE_COOKING_INTO_01);
		Animation.Add("ST_COOKING_LOOP",				ANIM_VILLAGER_FEMALE_COOKING_LOOP_01);
		Animation.Add("ST_COOKING_OUTOF",				ANIM_VILLAGER_FEMALE_COOKING_OUT_01);
		Animation.Add("ST_STAND_EATING_INTO",			ANIM_VILLAGER_FEMALE_STAND_EATING_INTO_01);
		Animation.Add("ST_STAND_EATING_LOOP",			ANIM_VILLAGER_FEMALE_STAND_EATING_LOOP_01);
		Animation.Add("ST_STAND_EATING_OUTOF",			ANIM_VILLAGER_FEMALE_STAND_EATING_OUT_01);
		Animation.Add("ST_HAMMERING_INTO",				ANIM_VILLAGER_FEMALE_HAMMERING_INTO_01);
		Animation.Add("ST_HAMMERING_LOOP",				ANIM_VILLAGER_FEMALE_HAMMERING_LOOP_01);
		Animation.Add("ST_HAMMERING_OUTOF",				ANIM_VILLAGER_FEMALE_HAMMERING_OUT_01);
		Animation.Add("ST_SEATED_SLEEP_INTO",			ANIM_VILLAGER_FEMALE_SEATED_SLEEP_NOD_OFF_01);
		Animation.Add("ST_SEATED_SLEEP_LOOP",			ANIM_VILLAGER_FEMALE_SEATED_SLEEPING_01);
		Animation.Add("ST_SEATED_SLEEP_OUTOF",			ANIM_VILLAGER_FEMALE_SEATED_SLEEP_WAKING_01);
		Animation.Add("ST_SEATED_DAYDREAM_INTO",		ANIM_VILLAGER_FEMALE_SEATED_DAYDREAM_INTO_01);
		Animation.Add("ST_SEATED_DAYDREAM_LOOP",		ANIM_VILLAGER_FEMALE_SEATED_DAYDREAM_LOOP_01);
		Animation.Add("ST_SEATED_DAYDREAM_OUTOF",		ANIM_VILLAGER_FEMALE_SEATED_DAYDREAM_OUT_01);
		Animation.Add("ST_SEATED_EAT_INTO",				ANIM_VILLAGER_FEMALE_SEATED_EAT_INTO_01);
		Animation.Add("ST_SEATED_EAT_LOOP",				ANIM_VILLAGER_FEMALE_SEATED_EAT_LOOP_01);
		Animation.Add("ST_SEATED_EAT_OUTOF",			ANIM_VILLAGER_FEMALE_SEATED_EAT_OUT_01);
		Animation.Add("ST_SEATED_EAT_SOUP_INTO",		ANIM_VILLAGER_FEMALE_SEATED_EAT_SOUP_INTO_01);
		Animation.Add("ST_SEATED_EAT_SOUP_LOOP",		ANIM_VILLAGER_FEMALE_SEATED_EAT_SOUP_LOOP_01);
		Animation.Add("ST_SEATED_EAT_SOUP_OUTOF",		ANIM_VILLAGER_FEMALE_SEATED_EAT_SOUP_OUT_01);
		Animation.Add("ST_SURPRISE_INTO",				ANIM_VILLAGER_FEMALE_SURPRISE_INTO_01);
		Animation.Add("ST_SURPRISE_LOOP",				ANIM_VILLAGER_FEMALE_SURPRISE_LOOP_01);
		Animation.Add("ST_SURPRISE_OUTOF",				ANIM_VILLAGER_FEMALE_SURPRISE_OUT_01);
		Animation.Add("ST_WASH_FLOOR_INTO",				ANIM_VILLAGER_FEMALE_WASH_FLOOR_INTO_01);
		Animation.Add("ST_WASH_FLOOR_LOOP",				ANIM_VILLAGER_FEMALE_WASH_FLOOR_LOOP_01);
		Animation.Add("ST_WASH_FLOOR_OUTOF",			ANIM_VILLAGER_FEMALE_WASH_FLOOR_OUT_01);
		Animation.Add("ST_WASH_WINDOWS_INTO",			ANIM_VILLAGER_FEMALE_WASH_WINDOWS_INTO_01);
		Animation.Add("ST_WASH_WINDOWS_LOOP",			ANIM_VILLAGER_FEMALE_WASH_WINDOWS_LOOP_01);
		Animation.Add("ST_WASH_WINDOWS_OUTOF",			ANIM_VILLAGER_FEMALE_WASH_WINDOWS_OUT_01);
		Animation.Add("ST_SAT_EAT_INTO",				ANIM_VILLAGER_FEMALE_SAT_EAT_INTO_01);
		Animation.Add("ST_SAT_EAT_LOOP",				ANIM_VILLAGER_FEMALE_SAT_EAT_LOOP_01);
		Animation.Add("ST_SAT_EAT_OUTOF",				ANIM_VILLAGER_FEMALE_SAT_EAT_OUTOF_01);
		Animation.Add("ST_FOOD_PICK_UP",				ANIM_VILLAGER_FEMALE_FOOD_PICK_UP_01);
		Animation.Add("ST_FOOD_PUT_DOWN",				ANIM_VILLAGER_FEMALE_FOOD_PUT_DOWN_01);
		Animation.Add("ST_KICK",						ANIM_VILLAGER_FEMALE_KICK_01);
		Animation.Add("ST_KO_GET_HIT_FALL_BACK",		ANIM_VILLAGER_FEMALE_KO_GET_HIT_FALL_BACK_01);
		Animation.Add("ST_KO_GET_HIT_FALL_LEFT",		ANIM_VILLAGER_FEMALE_KO_GET_HIT_FALL_LEFT_01);
		Animation.Add("ST_KO_GET_HIT_FALL_RIGHT",		ANIM_VILLAGER_FEMALE_KO_GET_HIT_FALL_RIGHT_01);
		Animation.Add("ST_LIGHT_LAMP",					ANIM_VILLAGER_FEMALE_LIGHT_LAMP_01);
		Animation.Add("ST_GHOST_MOVE_FORWARD",			ANIM_VILLAGER_FEMALE_GHOST_MOVE_FORWARD_01);
		Animation.Add("ST_DRINK_INTO",					ANIM_VILLAGER_FEMALE_DRINK_INTO_01);
		Animation.Add("ST_DRINK_LOOP",					ANIM_VILLAGER_FEMALE_DRINK_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("ST_DRINK_OUTOF",					ANIM_VILLAGER_FEMALE_DRINK_OUTOF_01);
	//	GROUPED ANIMS END
	
		Animation.StartGroup("SCARED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_FEAR_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_RUN",					ANIM_BIPED_NEW_VILLAGER_FEMALE_SCARED_RUN, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_RUN",					ANIM_VILLAGER_FEMALE_FEAR_RUN_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_WALK_BACK_OFF",		ANIM_VILLAGER_FEAR_WALK_01);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_FEMALE_FEAR_WALK_02);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_FEAR_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_FEAR_02);
			Animation.Add("ST_INTRO",				ANIM_VILLAGER_FEMALE_FEAR_01);
			Animation.Add("ST_INTRO",				ANIM_VILLAGER_FEMALE_SURPRISE_01);
		Animation.EndGroup();
	
		Animation.StartGroup("OUTRAGED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_GENERIC_IDLE_01a);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_03);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_04);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_05);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_06);

			Animation.Add("ANGRY_WAVE_FIST",		ANIM_VILLAGER_FEMALE_OUTRAGED_03);	
		Animation.EndGroup();

		Animation.StartGroup("CREEPING");	
			Animation.Add("ST_WALK",				ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_FEMALE_CREEP_01);
		Animation.EndGroup();

		Animation.StartGroup("CURIOUS");
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_RIDICULE_02);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_FASCINATION_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_02);
		Animation.EndGroup();	

		Animation.StartGroup("CHEERING");	
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_AWE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_AWE_03);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_AWE_02);
		Animation.EndGroup();	

		Animation.StartGroup("HECKLING");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_IDLE_HANDS_ON_HIPS);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_OUTRAGED_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_OUTRAGED_03);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_OUTRAGED_04);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_OUTRAGED_06);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_OUTRAGED_05);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		Animation.EndGroup();	
			
		Animation.StartGroup("ATTRACTED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_ATTRACTED_02);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_ATTRACTED_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_ATTRACTED_03);

			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_ATTRACTED_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_ATTRACTED_03);
		Animation.EndGroup();
	
		Animation.StartGroup("SAD");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_CONCERN_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SAD_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_SAD_01);

			Animation.Add("DROP_TO_KNEES",			ANIM_VILLAGER_FEMALE_SAD_02);
		Animation.EndGroup();
			
		Animation.StartGroup("BULLY");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_IDLE_HANDS_ON_HIPS);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_OUTRAGED_05);

			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_FEMALE_OUTRAGED_05);
		Animation.EndGroup();

		Animation.StartGroup("VIOLENT");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_HOMICIDAL_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_HOMICIDAL_IDLE_01);
		Animation.EndGroup();

		Animation.StartGroup("COOK");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_COOKING_LOOP_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_COOKING_LOOP_01);
		Animation.EndGroup();

		Animation.StartGroup("CROUCH");
 			Animation.Add("ST_SNEAK",				ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK);
			Animation.Add("ST_SNEAK_POSE",			ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK_POSE);
			Animation.Add("ST_SNEAK_UPRIGHT",		ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK);
			Animation.Add("ST_SNEAK_UPRIGHT_POSE",	ANIM_VILLAGER_FEMALE_UPRIGHT_SNEAK_POSE);
		Animation.EndGroup();

			Animation.Add("ST_GET_IN_BED_LEFT",		ANIM_BIPED_NEW_VILLAGER_FEMALE_GET_IN_BED);
			Animation.Add("ST_SLEEPING_IN_BED",		ANIM_BIPED_NEW_VILLAGER_FEMALE_SLEEP_IN_BED, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_GET_OUT_OF_BED_LEFT",	ANIM_BIPED_NEW_VILLAGER_FEMALE_GET_OUT_OF_BED);
			Animation.Add("ST_GET_OUT_OF_BED_LEFT_FAST",	ANIM_BIPED_NEW_VILLAGER_FEMALE_GET_OUT_OF_BED_FAST);

		Animation.StartGroup("SLEEP_FLOOR_BED_MIDDLE");	
			Animation.Add("ST_GET_IN_FLOOR_BED",		ANIM_BIPED_NEW_VILLAGER_FEMALE_LIE_ON_FLOOR);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",	ANIM_BIPED_NEW_VILLAGER_FEMALE_ON_FLOOR_SLEEP);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",	ANIM_BIPED_NEW_VILLAGER_FEMALE_ON_FLOOR_RISE);
		Animation.EndGroup();

		Animation.StartGroup("SLEEP_FLOOR_BED_RIGHT");
			Animation.Add("ST_GET_IN_FLOOR_BED",		ANIM_BIPED_NEW_VILLAGER_FEMALE_LIE_ON_FLOOR_RIGHT);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",	ANIM_BIPED_NEW_VILLAGER_FEMALE_ON_FLOOR_RIGHT_SLEEP);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",	ANIM_BIPED_NEW_VILLAGER_FEMALE_ON_FLOOR_RIGHT_RISE);
		Animation.EndGroup();

		Animation.StartGroup("SLEEP_FLOOR_BED_LEFT");
			Animation.Add("ST_GET_IN_FLOOR_BED",		ANIM_BIPED_NEW_VILLAGER_FEMALE_LIE_ON_FLOOR_LEFT);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",	ANIM_BIPED_NEW_VILLAGER_FEMALE_ON_FLOOR_LEFT_SLEEP);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",	ANIM_BIPED_NEW_VILLAGER_FEMALE_ON_FLOOR_LEFT_RISE);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_HAPPY");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_BELLIGERENT");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_ANGRY");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_FEAR");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_SAD");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_04);
		Animation.EndGroup();
		
		Animation.StartGroup("CONVERSATION_CAGED");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
		Animation.EndGroup();

		Animation.StartGroup("STAND");
			Animation.Add("ST_IDLE_SUBTLE",		ANIM_VILLAGER_FEMALE_IDLE_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_FEMALE_GAZE_SKY_01);
//			Animation.Add("ST_IDLE",			ANIM_VILLAGER_FEMALE_DRINKING_01); // Adam taken out for MS3 Oakvale
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR");
			Animation.Add("ST_SIT_ON_SEAT",			ANIM_VILLAGER_FEMALE_SIT_ON_CHAIR_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.Add("ST_STAND_UP_FROM_SEAT",	ANIM_VILLAGER_FEMALE_SEATED_GET_UP_01);

		Animation.StartGroup("SIT_CHAIR_NORMAL");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_SEATED_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SEATED_CHECK_STAINS_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SEATED_TOUCH_HEAD_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();
			
		Animation.StartGroup("SIT_CHAIR_BORED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_SEATED_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SEATED_WARM_HANDS_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SEATED_CHECK_SHOES_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SEATED_DRINKING_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR_SLEEPING");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_SEATED_SLEEP_FIGHTING_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SEATED_YAWNING_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_BENCH");
			Animation.Add("ST_SIT_ON_BENCH",		ANIM_BIPED_NEW_VILLAGER_FEMALE_SIT_ON_BENCH);
			Animation.Add("ST_SITTING",				ANIM_BIPED_NEW_VILLAGER_FEMALE_SITTING_ON_BENCH);
			Animation.Add("ST_STAND_UP_FROM_BENCH",	ANIM_BIPED_NEW_VILLAGER_FEMALE_GET_UP_FROM_BENCH);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_FLOOR");
			Animation.Add("ST_SIT_ON_FLOOR",		ANIM_BIPED_NEW_VILLAGER_FEMALE_SIT_ON_FLOOR);
			Animation.Add("ST_SITTING",				ANIM_BIPED_NEW_VILLAGER_FEMALE_SIT_ON_FLOOR_IDLE);
			Animation.Add("ST_STAND_UP_FROM_FLOOR",	ANIM_BIPED_NEW_VILLAGER_FEMALE_GET_UP_FROM_SITTING_ON_FLOOR);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);	
		Animation.EndGroup();

		Animation.Add("GIVE_MONEY",					ANIM_VILLAGER_FEMALE_GIVE_MONEY_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("RECEIVE_MONEY",				ANIM_VILLAGER_FEMALE_RECEIVE_MONEY_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));

		Animation.Add("GIVE_HUG",					ANIM_VILLAGER_FEMALE_GIVE_HUG_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("RECEIVE_HUG",				ANIM_VILLAGER_FEMALE_RECEIVE_HUG_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("GIVE_KISS",					ANIM_VILLAGER_FEMALE_GIVE_KISS_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("RECEIVE_KISS",				ANIM_VILLAGER_FEMALE_RECEIVE_KISS_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));

		//ANIMS FOR *BED* TO PLAY
		Animation.Add("BED_GET_IN_LEFT",			ANIM_OBJECT_BED_01_GET_IN);
		Animation.Add("BED_GET_OUT_LEFT",			ANIM_OBJECT_BED_01_GET_OUT);
		Animation.Add("BED_GET_OUT_LEFT_FAST",		ANIM_OBJECT_BED_01_GET_OUT_FAST);
		Animation.Add("BED_SLEEP",					ANIM_OBJECT_BED_01_SLEEP);
		
		// CUTSCENE / SCRIPT ANIMATIONS
		Animation.Add("CS_DISAPPOINTED",			ANIM_VILLAGER_FEMALE_IN_CAGE_DISAPPOINTED_01);
		Animation.Add("CS_CAGED",					ANIM_VILLAGER_FEMALE_IN_CAGE_IDLE_01);
		Animation.Add("CS_FREED",					ANIM_VILLAGER_FEMALE_IN_CAGE_FREED_01);
		Animation.Add("CS_SHOUT_FOR_HELP",			ANIM_VILLAGER_FEMALE_IN_CAGE_SHOUT_HELP_01);
		Animation.Add("CS_SHOUT_ENCOURAGEMENT",		ANIM_VILLAGER_FEMALE_IN_CAGE_SHOUT_ENCOURAGE_01);
		Animation.Add("CS_LOOK_LEFT",				CS_FEMALE_VILLAGER_LOOK_LEFT);
		Animation.Add("CS_LOOK_RIGHT",				CS_FEMALE_VILLAGER_LOOK_RIGHT);

		Animation.Add("CS_CONV_ANGRY_LOOP",			ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
		Animation.Add("CS_CONV_ANGRY_BR1",			ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_01);
		Animation.Add("CS_CONV_ANGRY_BR2",			ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_02);
		Animation.Add("CS_CONV_ANGRY_BR3",			ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_03);
		Animation.Add("CS_CONV_ANGRY_BR4",			ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_04);
		
		Animation.Add("CS_CONV_SAD_LOOP",			ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BASE_01);
		Animation.Add("CS_CONV_SAD_BR1",			ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_01);
		Animation.Add("CS_CONV_SAD_BR2",			ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_02);
		Animation.Add("CS_CONV_SAD_BR3",			ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_03);
		Animation.Add("CS_CONV_SAD_BR4",			ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_04);

		Animation.Add("CS_CONV_HAPPY_LOOP",			ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BASE_01);
		Animation.Add("CS_CONV_HAPPY_BR1",			ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_01);
		Animation.Add("CS_CONV_HAPPY_BR2",			ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_02);
		Animation.Add("CS_CONV_HAPPY_BR3",			ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_03);
		Animation.Add("CS_CONV_HAPPY_BR4",			ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_04);

		Animation.Add("CS_DRUNK_IDLE",				ANIM_VILLAGER_FEMALE_DRUNK_IDLE_01);
		
		Animation.Add("CS_SICK_MOTHER_INTO",		CS_SICK_MOTHER_INTO);
		Animation.Add("CS_SICK_MOTHER_LOOP1",		CS_SICK_MOTHER_LOOP1);
		Animation.Add("CS_SICK_MOTHER_LOOP2",		CS_SICK_MOTHER_LOOP2);
		Animation.Add("CS_SICK_MOTHER_LOOP3",		CS_SICK_MOTHER_LOOP3);
		Animation.Add("CS_SICK_MOTHER_BREAKOFF",	CS_SICK_MOTHER_BREAKOFF);
		Animation.Add("CS_SICK_MOTHER_BREAKOFF2",	CS_SICK_MOTHER_BREAKOFF2);
		Animation.Add("CS_SICK_MOTHER_OUTOF",		CS_SICK_MOTHER_OUTOF);
		Animation.Add("CS_SICK_MOTHER_WITCH_COOKING",					CS_SICK_MOTHER_WITCH_COOKING);
		Animation.Add("CS_SICK_MOTHER_WITCH_COOKING_BREAK_OFF",			CS_SICK_MOTHER_WITCH_COOKING_BREAK_OFF);
		Animation.Add("CS_SICK_MOTHER_WITCH_COOKING_TALKING_BEHIND",	CS_SICK_MOTHER_WITCH_COOKING_TALKING_BEHIND);
		Animation.Add("CS_SICK_MOTHER_WITCH_BACK_TO_COOKING",			CS_SICK_MOTHER_WITCH_BACK_TO_COOKING);
		Animation.Add("CS_SICK_WITCH_SPOON_DROP",						CS_SICK_WITCH_SPOON_DROP);

		// Chat
		Animation.Add("CS_IDLE_CHAT_1",				ANIM_BIPED_NEW_VILLAGER_FEMALE_TALK_IDLE_01);
		Animation.Add("CS_IDLE_CHAT_2",				ANIM_BIPED_NEW_VILLAGER_FEMALE_TALK_IDLE_02);
		Animation.Add("CS_IDLE_CHAT_3",				ANIM_BIPED_NEW_VILLAGER_FEMALE_TALK_IDLE_03);

		// CHICKEN KICKING CROWD
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_IDLE_HANDS_ON_HIPS);
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_OUTRAGED_02);
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_RIDICULE_01);
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_RIDICULE_02);
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_RIDICULE_03);
		Animation.Add("CHICK_KICK_LOW",				ANIM_VILLAGER_FEMALE_THUMBS_DOWN_01);
		Animation.Add("CHICK_KICK_LOW_LOOP",		ANIM_VILLAGER_FEMALE_IDLE_HANDS_ON_HIPS);

		Animation.Add("CHICK_KICK_MID",				ANIM_VILLAGER_FEMALE_AWE_01);
		Animation.Add("CHICK_KICK_MID",				ANIM_VILLAGER_FEMALE_GREET_01);
		Animation.Add("CHICK_KICK_MID",				ANIM_VILLAGER_FEMALE_GENERIC_IDLE_01a);
		Animation.Add("CHICK_KICK_MID",				ANIM_VILLAGER_FEMALE_GAZE_SKY_01);
		Animation.Add("CHICK_KICK_MID",				CS_FEMALE_VILLAGER_LOOK_LEFT);
		Animation.Add("CHICK_KICK_MID",				CS_FEMALE_VILLAGER_LOOK_RIGHT);
		Animation.Add("CHICK_KICK_MID_LOOP",		ANIM_VILLAGER_FEMALE_AWE_01);
		
		Animation.Add("CHICK_KICK_HIGH",			ANIM_VILLAGER_FEMALE_AWE_02);
		Animation.Add("CHICK_KICK_HIGH",			ANIM_VILLAGER_FEMALE_AWE_03);
		Animation.Add("CHICK_KICK_HIGH",			ANIM_VILLAGER_FEMALE_ATTRACT_WAVE_01);
		Animation.Add("CHICK_KICK_HIGH",			ANIM_VILLAGER_FEMALE_CHECK_APPEARANCE_01);
		Animation.Add("CHICK_KICK_HIGH",			ANIM_VILLAGER_FEMALE_CHEERING_JUMPING_01);
		Animation.Add("CHICK_KICK_HIGH_LOOP",		ANIM_VILLAGER_FEMALE_AWE_02);
		Animation.Add("CHICK_KICK_HIGH_LOOP",		ANIM_VILLAGER_FEMALE_AWE_03);

	<\CAppearanceDef>

//-------------------------------- Adam's remapped anim tags for opinion reactions -------------------------

	<CAppearanceDef>
		Animation.Add("ST_OPINION_APPROVAL_CHEERING_BOTH_ARMS_UP", ANIM_VILLAGER_FEMALE_AWE_02);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_ARMS_UP", ANIM_VILLAGER_FEMALE_AWE_03);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_NORMAL", ANIM_VILLAGER_FEMALE_AWE_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_INTO", ANIM_VILLAGER_FEMALE_BLOW_KISS_INTO_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_LOOP", ANIM_VILLAGER_FEMALE_BLOW_KISS_LOOP_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_OUTOF", ANIM_VILLAGER_FEMALE_BLOW_KISS_OUT_01);
		Animation.Add("ST_OPINION_APPROVAL_REACTION_ARMS_WIDE_GREET", ANIM_VILLAGER_FEMALE_FRIENDLY_01);
		Animation.Add("ST_OPINION_APPROVAL_WAVING_AT_DISTANCE", ANIM_VILLAGER_FEMALE_RESPONSE_WAVE_01);
		Animation.Add("ST_OPINION_ATTRACTED_HANDS_CLASPED_SWAYING", ANIM_VILLAGER_FEMALE_ATTRACTED_02);
		Animation.Add("ST_OPINION_ATTRACTED_PREENING_SELF", ANIM_VILLAGER_FEMALE_CHECK_APPEARANCE_01);
		Animation.Add("ANIM_VILLAGER_FEMALE_ATTRACT_SHOUT_01", ANIM_VILLAGER_FEMALE_ATTRACT_SHOUT_01);
		Animation.Add("ST_OPINION_ATTRACTED_WAVING_AT", ANIM_VILLAGER_FEMALE_ATTRACT_WAVE_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_BOOING", ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_CALLING_OVER_FOR_FIGHT", ANIM_VILLAGER_FEMALE_HOMICIDAL_INTRO);
		Animation.Add("ST_OPINION_DISAPPROVAL_DISMISSING_HAND_SWIPE", ANIM_VILLAGER_FEMALE_OUTRAGED_06);
		//Animation.Add("ST_OPINION_DISAPPROVAL_NYAH_NYAH", ANIM_VILLAGER_FEMALE_);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINT_AT", ANIM_VILLAGER_FEMALE_OUTRAGED_05);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINTING_AWAY_GET_OUT", ANIM_VILLAGER_FEMALE_OUTRAGED_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_SHAKE_FIST", ANIM_VILLAGER_FEMALE_OUTRAGED_03);
		Animation.Add("ST_OPINION_DISAPPROVAL_STAMP_FOOT", ANIM_VILLAGER_FEMALE_OUTRAGED_04);
		Animation.Add("ST_OPINION_DISAPPROVAL_THUMBS_DOWN", ANIM_VILLAGER_FEMALE_THUMBS_DOWN_01);
		Animation.Add("ST_OPINION_FEAR_IDLE_COWERING", ANIM_VILLAGER_FEMALE_AFRAID_LOOP_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SHRINKING_AWAY", ANIM_VILLAGER_FEMALE_FEAR_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SURPRISED", ANIM_VILLAGER_FEMALE_SURPRISE_01);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_FRONT", ANIM_BIPED_NEW_VILLAGER_FEMALE_SCARED_RUN);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_UP", ANIM_VILLAGER_FEMALE_FEAR_RUN_01);
		Animation.Add("ST_OPINION_NEUTRAL_POINT_AT", ANIM_VILLAGER_FEMALE_OUTRAGED_02);
		Animation.Add("ST_OPINION_NEUTRAL_POINTING_CALLING_FRIEND", ANIM_VILLAGER_FEMALE_FASCINATION_01);
		Animation.Add("ST_OPINION_NEUTRAL_REACTION_HAND_UP_GREET", ANIM_VILLAGER_FEMALE_GREET_01);
		Animation.Add("ST_OPINION_NEUTRAL_SHOUTING_WITH_HANDS_CUPPED", ANIM_VILLAGER_FEMALE_SHOUT_INSULT_01);
		Animation.Add("ST_OPINION_NEUTRAL_SURPRISE", ANIM_VILLAGER_FEMALE_SURPRISE_LOOP_01);
		Animation.Add("ST_OPINION_NEUTRAL_WALK_NERVOUS_LOOKING_BACK", ANIM_VILLAGER_FEMALE_FEAR_WALK_02);
		Animation.Add("ST_OPINION_RIDICULE_BELLY_LAUGH", ANIM_VILLAGER_FEMALE_RIDICULE_03);
		Animation.Add("ST_OPINION_RIDICULE_POINT_AND_LAUGH", ANIM_VILLAGER_FEMALE_RIDICULE_01);
		Animation.Add("ST_OPINION_RIDICULE_SNIGGER", ANIM_VILLAGER_FEMALE_RIDICULE_02);

		Animation.AddCombat("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_VILLAGER_FEMALE_FEAR_WALK_01);
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.StartGroup("HOLD_JUG");
			Animation.Add("ST_IDLE",			ANIM_BARMAID_BREATHE_WITH_JUG_01);
			Animation.Add("ST_IDLE_SUBTLE",		ANIM_BARMAID_BREATHE_WITH_JUG_01);
			Animation.Add("ST_WALK",			ANIM_BARMAID_WALK_WITH_JUG_01);
			Animation.Add("ST_JOG",				ANIM_BARMAID_WALK_WITH_JUG_01);
			Animation.Add("ST_RUN",				ANIM_BARMAID_WALK_WITH_JUG_01);
		Animation.EndGroup();

		Animation.StartGroup("SERVE_CUSTOMER");
			Animation.Add("ST_IDLE",			ANIM_BARMAID_FILL_GLASS_LOOP_01);
			Animation.Add("ST_IDLE_SUBTLE",		ANIM_BARMAID_FILL_GLASS_LOOP_01);
		Animation.EndGroup();
		
		Animation.StartGroup("ARMS_OFF_TABLE");
			Animation.Add("ST_SITTING",			ANIM_VILLAGER_FEMALE_ARMS_OFF_TABLE_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_FEMALE_ARMS_OFF_TABLE_01);
			Animation.Add("ST_IDLE_SUBTLE",		ANIM_VILLAGER_FEMALE_ARMS_OFF_TABLE_01);
		Animation.EndGroup();

		Animation.Add("COLLECT_JUG_FROM_BAR",	ANIM_BARMAID_COLLECT_JUG_FROM_BAR_01);
		Animation.Add("FILL_GLASS_INTO",		ANIM_BARMAID_FILL_GLASS_INTO_01);
		Animation.Add("FILL_GLASS_OUTOF",		ANIM_BARMAID_FILL_GLASS_OUTOF_01);
		Animation.Add("PUT_EMPTY_JUG_ON_BAR",	ANIM_BARMAID_PUT_EMPTY_JUG_ON_BAR_01);

		Animation.Add("CONV_LISTENING_INTO",				ANIM_VILLAGER_FEMALE_LISTEN_BASE_INTO_01);
		Animation.Add("CONV_LISTENING_LOOP",				ANIM_VILLAGER_FEMALE_LISTEN_BASE_LOOP_01);
		Animation.Add("CONV_LISTENING_OUTOF",				ANIM_VILLAGER_FEMALE_LISTEN_BASE_OUTOF_01);

		Animation.Add("ST_REACT_TO_BURNING_HOUSE_INTO",		ANIM_VILLAGER_FEMALE_REACT_TO_BURNING_HOUSE_INTO_01);
		Animation.Add("ST_REACT_TO_BURNING_HOUSE_LOOP",		ANIM_VILLAGER_FEMALE_REACT_TO_BURNING_HOUSE_LOOP_01);
		Animation.Add("ST_REACT_TO_BURNING_HOUSE_OUTOF",	ANIM_VILLAGER_FEMALE_REACT_TO_BURNING_HOUSE_OUTOF_01);

		Animation.Add("ST_LISTEN_BREAK_OFF",				ANIM_VILLAGER_FEMALE_LISTEN_BREAK_OFF_01);
		Animation.Add("ST_LISTEN_BREAK_OFF",				ANIM_VILLAGER_FEMALE_LISTEN_BREAK_OFF_02);
		Animation.Add("ST_LISTEN_SAT_DOWN",					ANIM_VILLAGER_FEMALE_LISTEN_SAT_DOWN_01);

		Animation.Add("ST_TELL_STORY",						ANIM_VILLAGER_FEMALE_TELL_STORY_01);
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.Add("DRINK_AT_TABLE_INTO", ANIM_VILLAGER_FEMALE_DRINK_INTO_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("DRINK_AT_TABLE_OUTOF", ANIM_VILLAGER_FEMALE_DRINK_OUTOF_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("FALLING_ASLEEP_INTO", ANIM_VILLAGER_FEMALE_TAVERN_FALLING_ASLEEP_INTO_01);
		Animation.Add("FALLING_ASLEEP_LOOP", ANIM_VILLAGER_FEMALE_TAVERN_FALLING_ASLEEP_LOOP_01);
		Animation.Add("FALLING_ASLEEP_OUTOF", ANIM_VILLAGER_FEMALE_TAVERN_FALLING_ASLEEP_OUTOF_01);
		Animation.Add("SIT_AT_TABLE_INTO", ANIM_VILLAGER_FEMALE_SITTING_AT_TABLE_01);
		Animation.Add("SIT_AT_TABLE_LOOP", ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);
		Animation.Add("SIT_AT_TABLE_OUTOF", ANIM_VILLAGER_FEMALE_STAND_FROM_TABLE_01);
		Animation.Add("LISTENING_INTO", ANIM_VILLAGER_FEMALE_TAVERN_LISTENING_INTO_01);
		Animation.Add("LISTENING_LOOP", ANIM_VILLAGER_FEMALE_TAVERN_LISTENING_LOOP_01);
		Animation.Add("LISTENING_OUTOF", ANIM_VILLAGER_FEMALE_TAVERN_LISTENING_OUTOF_01);

		Animation.Add("SEATED_TAVERN_LAUGH", ANIM_VILLAGER_FEMALE_SAT_DOWN_LAUGH_01);
		Animation.Add("SEATED_TAVERN_LAUGH", ANIM_VILLAGER_FEMALE_SAT_DOWN_LAUGH_02);
		Animation.Add("SLUMPED_DRUNK_AT_TABLE_INTO", ANIM_VILLAGER_FEMALE_TAVERN_SLUMPED_DRUNK_AT_TABLE_INTO_01);
		Animation.Add("SLUMPED_DRUNK_AT_TABLE_LOOP", ANIM_VILLAGER_FEMALE_TAVERN_SLUMPED_DRUNK_AT_TABLE_LOOP_01);
		Animation.Add("SLUMPED_DRUNK_AT_TABLE_OUTOF", ANIM_VILLAGER_FEMALE_TAVERN_SLUMPED_DRUNK_AT_TABLE_OUTOF_01);
		Animation.Add("TELLING_STORY_INTO", ANIM_VILLAGER_FEMALE_TAVERN_TELLING_STORY_INTO_01);
		Animation.Add("TELLING_STORY_LOOP", ANIM_VILLAGER_FEMALE_TAVERN_TELLING_STORY_LOOP_01);
		Animation.Add("TELLING_STORY_OUTOF", ANIM_VILLAGER_FEMALE_TAVERN_TELLING_STORY_OUTOF_01);
		Animation.Add("PAY_AT_BAR", ANIM_VILLAGER_FEMALE_PAY_AT_BAR_01);
		Animation.Add("ACKNOWLEDGE_BARMAID", ANIM_VILLAGER_FEMALE_ACKNOWLEDGE_BARMAID_01);
		Animation.Add("SHOUT_FOR_BEER", ANIM_VILLAGER_FEMALE_ASK_FOR_BEER_01);

		Animation.Add("PUSHED_FORWARD", ANIM_VILLAGER_FEMALE_PUSHED_FORWARD_01, TransTime(0), Delay(0));
		Animation.Add("PUSHED_BACKWARD", ANIM_VILLAGER_FEMALE_PUSHED_BACKWARD_01, TransTime(0), Delay(0));
		
		Animation.Add("SKIP",			ANIM_VILLAGER_FEMALE_SKIP_01);

		Animation.StartGroup("SIT_TAVERN_STOOL");
			Animation.Add("ST_SITTING",				ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_SAT_DOWN_BREATHE_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_RIGHT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_LEFT_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_FEMALE_SEATED_GET_HIT_BACK_01);
		Animation.EndGroup();

		Animation.StartGroup("DRINKING_FROM_TANKARD");
			Animation.Add("ST_SITTING",				ANIM_VILLAGER_FEMALE_DRINK_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_DRINK_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_DRINK_LOOP_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.EndGroup();

		Animation.StartGroup("DRUNK");
			Animation.Add("ST_WALK",				ANIM_VILLAGER_FEMALE_DRUNK_WALK_01);
			Animation.Add("ST_SLOW_WALK",			ANIM_VILLAGER_FEMALE_DRUNK_WALK_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_DRUNK_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_DRUNK_IDLE_01);
			Animation.Add("TURNING_AC90",			ANIM_VILLAGER_FEMALE_DRUNK_TURN_90_LEFT_01);
			Animation.Add("TURNING_C90",			ANIM_VILLAGER_FEMALE_DRUNK_TURN_90_RIGHT_01);
			Animation.Add("TURNING_AC180",			ANIM_VILLAGER_FEMALE_DRUNK_TURN_180_LEFT_01);
			Animation.Add("TURNING_C180",			ANIM_VILLAGER_FEMALE_DRUNK_TURN_180_RIGHT_01);
		Animation.EndGroup();

		Animation.StartGroup("ARMS_OFF_TABLE");
			Animation.Add("ST_SITTING",				ANIM_VILLAGER_FEMALE_ARMS_OFF_TABLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_FEMALE_ARMS_OFF_TABLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_FEMALE_ARMS_OFF_TABLE_01);
		Animation.EndGroup();
	<\CAppearanceDef>

//----------------------------------------------------------------------------------------------------------

	CombatDiameter			0.8;

	<CCreatureDef>
		PhonemeAnim["AH"]				ANIM_VILLAGER_FEMALE_PHONEME_AH;
		PhonemeAnim["EE"]				ANIM_VILLAGER_FEMALE_PHONEME_EE;
		PhonemeAnim["MM"]				ANIM_VILLAGER_FEMALE_PHONEME_MM;
		PhonemeAnim["OH"]				ANIM_VILLAGER_FEMALE_PHONEME_OH;
		PhonemeAnim["SZ"]				ANIM_VILLAGER_FEMALE_PHONEME_SZ;
		PhonemeAnim["WW"]				ANIM_VILLAGER_FEMALE_PHONEME_WW;
	<\CCreatureDef>

	Components.Add("CTCDrunkenness");
	<CDrunkennessDef>
		DrunkennessThresholdMult	1.5;
	<\CDrunkennessDef>
#end_definition

//*************************************************************************************************
#definition_template CREATURE CREATURE_GENERIC_CHILD_VILLAGER_TEMPLATE specialises CREATURE_VILLAGER_TEMPLATE

	// Make damn sure that we don't have any kids accidentally dying!
	Damageable				FALSE;
	IsIndestructible		TRUE;

	<CEntitySoundDef>
		SoundIdentifier	"SI_HUMAN_CHILD";
	<\CEntitySoundDef>

	<COpinionOfHeroDef>
		Personality		OPINION_PERSONALITY_CHILD;
		ReactionMask	OPINION_REACTION_MASK_CHILD;
		DeedMask		OPINION_DEED_MASK_CHILD;
	<\COpinionOfHeroDef>

	<CCreatureDef>
		DialogueVoices.Add("CF1");
		DialogueVoices.Add("CM1");
	<\CCreatureDef>

	<CCreatureModeDef>
		AvailableIdleModes.Add(MODE_STAND);
		AvailableIdleModes.Add(MODE_STAND_HAPPY);
		//AvailableIdleModes.Add(MODE_STAND_BORED);
	<\CCreatureModeDef>

	<CCreatureDef>		
		Stats.ExperienceWorth	3;
		Stats.RenownWorth		12;
		Stats.MoralityForKill		-20;
		Stats.MoralityForWeaponHit	-6;
		Stats.MoralityForPunch		-3;
		Short					TRUE;
	<\CCreatureDef>

	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_CHILD);
	<\CHitLocationsDef>

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////   	                                     
	
	<CCreatureDef>
		PhonemeAnim["AH"]	ANIM_BIPED_BOY_01_PHONEME_AH;
		PhonemeAnim["EE"]	ANIM_BIPED_BOY_01_PHONEME_EE;
		PhonemeAnim["MM"]	ANIM_BIPED_BOY_01_PHONEME_MM;
		PhonemeAnim["OH"]	ANIM_BIPED_BOY_01_PHONEME_OH;
		PhonemeAnim["SZ"]	ANIM_BIPED_BOY_01_PHONEME_SZ;
		PhonemeAnim["WW"]	ANIM_BIPED_BOY_01_PHONEME_WW;
	<\CCreatureDef>
	
	<CLookDef>
		EyesTurnRangeXY		20.0;
		EyesTurnRangeYZ		0.0;
		HeadTurnRangeXY		170.0;
		HeadTurnRangeYZUp	65.0;
		HeadTurnRangeYZDown	45.0;
	<\CLookDef>

	<CAppearanceDef>
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_VILLAGER_BOY_HIT_BY_ARROW_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_VILLAGER_BOY_HIT_BY_ARROW_02);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_BIPED_BOY_01_SCARED);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_VILLAGER_BOY_KNOCKDOWN_GET_UP_01);
		
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_RIGHT_01);
		
		
		Animation.AddCombat("FALL_DEAD",				ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_RIGHT_01);
		Animation.AddCombat("FALL_UNCONSCIOUS",			ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_RIGHT_01);
		
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_VILLAGER_BOY_HOMICIDAL_01);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_VILLAGER_BOY_HOMICIDAL_02);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_VILLAGER_BOY_HOMICIDAL_03);

		Animation.Add("BOY_SIT_SLEEPING_IDLE_01",			ANIM_VILLAGER_BOY_SIT_SLEEPING_IDLE_01);
		Animation.Add("BOY_BALANCING_ON_ONE_LEG_01",		ANIM_VILLAGER_BOY_BALANCING_ON_ONE_LEG_01);
	//	Animation.Add("BOY_BEING_TOLD_OFF_01",				ANIM_VILLAGER_BOY_BEING_TOLD_OFF_01);	//DELETE
		Animation.Add("BOY_BORED_SHIMMY_01",				ANIM_VILLAGER_BOY_BORED_SHIMMY_01);
	//	Animation.Add("BOY_HIDE_AND_SEEK_COUNTING_01",		ANIM_VILLAGER_BOY_HIDE_AND_SEEK_COUNTING_01);	//DELETE
	//	Animation.Add("BOY_CRYING_ON_THE_SPOT_01",			ANIM_VILLAGER_BOY_CRYING_ON_THE_SPOT_01);	//DELETE
	//	Animation.Add("BOY_DRINKING_01",					ANIM_VILLAGER_BOY_DRINKING_01);	//DELETE
	//	Animation.Add("BOY_EATING_01",						ANIM_VILLAGER_BOY_EATING_01);	//DELETE
		Animation.Add("BOY_SIT_FIGHTING_SLEEP_01",			ANIM_VILLAGER_BOY_SIT_FIGHTING_SLEEP_01);
		Animation.Add("BOY_GAZING_AT_SKY_01",				ANIM_VILLAGER_BOY_GAZING_AT_SKY_01);
		Animation.Add("BOY_SIT_GET_UP_01",					ANIM_VILLAGER_BOY_SEATED_CHAIR_GET_UP_01);
		Animation.Add("BOY_TRIP_GET_UP_01",					ANIM_VILLAGER_BOY_TRIP_GET_UP_01);
		Animation.Add("BOY_HITTING_OBJECT_ON_GROUND_01",	ANIM_VILLAGER_BOY_HITTING_OBJECT_ON_GROUND_01);
		Animation.Add("BOY_KICKING_OBJECT_ON_GROUND_01",	ANIM_VILLAGER_BOY_KICKING_OBJECT_ON_GROUND_01);
		Animation.Add("BOY_PICKING_NOSE_01",				ANIM_VILLAGER_BOY_PICKING_NOSE_01);
		Animation.Add("BOY_SIT_PICKING_NOSE_01",			ANIM_VILLAGER_BOY_SEATED_CHAIR_PICK_NOSE_01);
		Animation.Add("BOY_HOPSCOTCH_01",					ANIM_VILLAGER_BOY_HOPSCOTCH_01);
		Animation.Add("BOY_PULLING_FACES_01",				ANIM_VILLAGER_BOY_PULLING_FACES_01);
		Animation.Add("BOY_SIT_HAND_UP_01",					ANIM_VILLAGER_BOY_SEATED_CHAIR_RAISE_HAND_01);
		Animation.Add("BOY_RUN_02",							ANIM_VILLAGER_BOY_RUN_02);
	//	Animation.Add("BOY_SCRATCHING_HEAD_01",				ANIM_VILLAGER_BOY_SCRATCHING_HEAD_01);	//DELETE
		Animation.Add("BOY_SHOUTING_WITH_HANDS_01",			ANIM_VILLAGER_BOY_SHOUTING_WITH_HANDS_01);
		Animation.Add("BOY_SKIP_01",						ANIM_VILLAGER_BOY_SKIP_01);
		Animation.Add("BOY_STEPPED_IN_SOMETHING_01",		ANIM_VILLAGER_BOY_STEPPED_IN_SOMETHING_01);
		Animation.Add("BOY_SUCKING_THUMB_01",				ANIM_VILLAGER_BOY_SUCKING_THUMB_01);
	//	Animation.Add("BOY_TANTRUM_01",						ANIM_VILLAGER_BOY_TANTRUM_01);	//DELETE
		Animation.Add("BOY_TRIP_FALL_OVER_01",				ANIM_VILLAGER_BOY_TRIP_FALL_OVER_01);
		Animation.Add("BOY_WALK_BORED_01",					ANIM_VILLAGER_BOY_WALK_BORED_01);
		Animation.Add("BOY_WALK_HAPPY_01",					ANIM_VILLAGER_BOY_WALK_HAPPY_01);
		Animation.Add("BOY_WALK_NORMAL_01",					ANIM_VILLAGER_BOY_WALK_NORMAL_01);
	//	Animation.Add("BOY_WANTING_TOILET_01",				ANIM_VILLAGER_BOY_WANTING_TOILET_01);	//DELETE
	//	Animation.Add("BOY_YAWNING_01",						ANIM_VILLAGER_BOY_YAWNING_01);
		Animation.Add("STANDARD_YAWN",						ANIM_VILLAGER_BOY_YAWNING_01);
		Animation.Add("BOY_SIT_BORED_01",					ANIM_VILLAGER_BOY_SIT_BORED_01);
		Animation.Add("BOY_SIT_EATING_FROM_BOWL_01",		ANIM_VILLAGER_BOY_SIT_EATING_FROM_BOWL_01);
		
		Animation.Add("ST_BEING_TOLD_OFF_INTO",				ANIM_VILLAGER_BOY_BEING_TOLD_OFF_INTO_01);
		Animation.Add("ST_BEING_TOLD_OFF_LOOP",				ANIM_VILLAGER_BOY_BEING_TOLD_OFF_LOOP_01);
		Animation.Add("ST_BEING_TOLD_OFF_OUTOF",			ANIM_VILLAGER_BOY_BEING_TOLD_OFF_OUTOF_01);
		Animation.Add("ST_COUNTING_HIDE_AND_SEEK_INTO",		ANIM_VILLAGER_BOY_COUNTING_HIDE_AND_SEEK_INTO_01);
		Animation.Add("ST_COUNTING_HIDE_AND_SEEK_LOOP",		ANIM_VILLAGER_BOY_COUNTING_HIDE_AND_SEEK_LOOP_01);
		Animation.Add("ST_COUNTING_HIDE_AND_SEEK_OUTOF",	ANIM_VILLAGER_BOY_COUNTING_HIDE_AND_SEEK_OUTOF_01);
		Animation.Add("ST_CRYING_ON_THE_SPOT_INTO",			ANIM_VILLAGER_BOY_CRYING_ON_THE_SPOT_INTO_01);
		Animation.Add("ST_CRYING_ON_THE_SPOT_LOOP",			ANIM_VILLAGER_BOY_CRYING_ON_THE_SPOT_LOOP_01);
		Animation.Add("ST_CRYING_ON_THE_SPOT_OUTOF",		ANIM_VILLAGER_BOY_CRYING_ON_THE_SPOT_OUTOF_01);
		Animation.Add("ST_DRINKING_INTO",					ANIM_VILLAGER_BOY_DRINKING_INTO_01);
		Animation.Add("ST_DRINKING_LOOP",					ANIM_VILLAGER_BOY_DRINKING_LOOP_01);
		Animation.Add("ST_DRINKING_OUTOF",					ANIM_VILLAGER_BOY_DRINKING_OUTOF_01);
		Animation.Add("ST_EATING_INTO",						ANIM_VILLAGER_BOY_EATING_INTO_01);
		Animation.Add("ST_EATING_LOOP",						ANIM_VILLAGER_BOY_EATING_LOOP_01);
		Animation.Add("ST_EATING_OUTOF",					ANIM_VILLAGER_BOY_EATING_OUTOF_01);
		Animation.Add("ST_SCRATCH_HEAD_INTO",				ANIM_VILLAGER_BOY_SCRATCH_HEAD_INTO_01);
		Animation.Add("ST_SCRATCH_HEAD_LOOP",				ANIM_VILLAGER_BOY_SCRATCH_HEAD_LOOP_01);
		Animation.Add("ST_SCRATCH_HEAD_OUTOF",				ANIM_VILLAGER_BOY_SCRATCH_HEAD_OUTOF_01);
		Animation.Add("ST_TANTRUM_INTO",					ANIM_VILLAGER_BOY_TANTRUM_INTO_01);
		Animation.Add("ST_TANTRUM_LOOP",					ANIM_VILLAGER_BOY_TANTRUM_LOOP_01);
		Animation.Add("ST_TANTRUM_OUTOF",					ANIM_VILLAGER_BOY_TANTRUM_OUTOF_01);
		Animation.Add("ST_WANTING_TOILET_INTO",				ANIM_VILLAGER_BOY_WANTING_TOILET_INTO_01);
		Animation.Add("ST_WANTING_TOILET_LOOP",				ANIM_VILLAGER_BOY_WANTING_TOILET_LOOP_01);
		Animation.Add("ST_WANTING_TOILET_OUTOF",			ANIM_VILLAGER_BOY_WANTING_TOILET_OUTOF_01);
		
		//Animation.Add("ST_STOOL_GET_DOWN",					ANIM_VILLAGER_BOY_STOOL_GET_DOWN_01);
		//Animation.Add("ST_STOOL_GET_ON",					ANIM_VILLAGER_BOY_STOOL_GET_ON_01);
		//Animation.Add("ST_STOOL_EAT_INTO",					ANIM_VILLAGER_BOY_ON_STOOL_EAT_INTO_01);
		//Animation.Add("ST_STOOL_EAT_LOOP",					ANIM_VILLAGER_BOY_ON_STOOL_EAT_LOOP_01);
		//Animation.Add("ST_STOOL_EAT_OUTOF",					ANIM_VILLAGER_BOY_ON_STOOL_EAT_OUTOF_01);
		
		Animation.StartGroup("EAT_AT_TABLE");
			Animation.Add("ST_SITTING",						ANIM_VILLAGER_BOY_ON_STOOL_EAT_LOOP_01);
			Animation.Add("ST_IDLE",						ANIM_VILLAGER_BOY_ON_STOOL_EAT_LOOP_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_VILLAGER_BOY_ON_STOOL_EAT_LOOP_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_TAVERN_STOOL");
			Animation.Add("ST_SITTING",					ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01);
		Animation.EndGroup();

		Animation.Add("ST_SAT_EATING_INTO",					ANIM_VILLAGER_BOY_ON_STOOL_EAT_INTO_01);
		Animation.Add("ST_SAT_EATING_LOOP",					ANIM_VILLAGER_BOY_ON_STOOL_EAT_LOOP_01);
		Animation.Add("ST_SAT_EATING_OUTOF",				ANIM_VILLAGER_BOY_ON_STOOL_EAT_OUTOF_01);	
		Animation.Add("SIT_AT_TABLE_INTO",					ANIM_VILLAGER_BOY_STOOL_GET_ON_01);
		Animation.Add("SIT_AT_TABLE_LOOP",					ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01); // PLACEHOLDER!!!
		Animation.Add("SIT_AT_TABLE_OUTOF",					ANIM_VILLAGER_BOY_STOOL_GET_DOWN_01);

		Animation.Add("ST_SAT_ON_FLOOR_GET_UP",				ANIM_VILLAGER_BOY_SAT_ON_FLOOR_GET_UP_01);
		Animation.Add("ST_SAT_ON_FLOOR_SIT_DOWN",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_SIT_DOWN_01);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_INTO",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_INTO_01);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_LOOP",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_LOOP_01);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_OUTOF",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_OUTOF_01);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_INTO",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_INTO_02);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_LOOP",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_LOOP_02);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_OUTOF",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_OUTOF_02);
		Animation.Add("ST_SAT_ON_FLOOR_IDLE_BREATHE",		ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_BREATHE_01);
		Animation.Add("ST_SAT_ON_FLOOR_PICK_NOSE_INTO",		ANIM_VILLAGER_BOY_SAT_ON_FLOOR_PICK_NOSE_INTO_01);
		Animation.Add("ST_SAT_ON_FLOOR_PICK_NOSE_LOOP",		ANIM_VILLAGER_BOY_SAT_ON_FLOOR_PICK_NOSE_LOOP_01);
		Animation.Add("ST_SAT_ON_FLOOR_PICK_NOSE_OUTOF",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_PICK_NOSE_OUTOF_01);
		Animation.Add("ST_SAT_ON_FLOOR_RAISE_HAND_INTO",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_RAISE_HAND_INTO_01);
		Animation.Add("ST_SAT_ON_FLOOR_RAISE_HAND_LOOP",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_RAISE_HAND_LOOP_01);
		Animation.Add("ST_SAT_ON_FLOOR_RAISE_HAND_OUTOF",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_RAISE_HAND_OUTOF_01);
		Animation.Add("ST_SAT_ON_FLOOR_SCRATCH_BUM_INTO",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_SCRATCH_BUM_INTO_01);
		Animation.Add("ST_SAT_ON_FLOOR_SCRATCH_BUM_LOOP",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_SCRATCH_BUM_LOOP_01);
		Animation.Add("ST_SAT_ON_FLOOR_SCRATCH_BUM_OUTOF",	ANIM_VILLAGER_BOY_SAT_ON_FLOOR_SCRATCH_BUM_OUTOF_01);
		Animation.Add("ST_SAT_ON_FLOOR_WIPE_NOSE",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_WIPE_NOSE_01);
		
		
		Animation.Add("ST_APPROVAL_ECSTATIC_GESTURING_INTO",	ANIM_VILLAGER_BOY_APPROVAL_ECSTATIC_GESTURING_INTO_01);
		Animation.Add("ST_APPROVAL_ECSTATIC_GESTURING_LOOP",	ANIM_VILLAGER_BOY_APPROVAL_ECSTATIC_GESTURING_LOOP_01);
		Animation.Add("ST_APPROVAL_ECSTATIC_GESTURING_OUTOF",	ANIM_VILLAGER_BOY_APPROVAL_ECSTATIC_GESTURING_OUTOF_01);
		Animation.Add("ST_DISAPPROVAL_BOOING_INTO",				ANIM_VILLAGER_BOY_DISAPPROVAL_BOOING_INTO_01);
		Animation.Add("ST_DISAPPROVAL_BOOING_LOOP",				ANIM_VILLAGER_BOY_DISAPPROVAL_BOOING_LOOP_01);
		Animation.Add("ST_DISAPPROVAL_BOOING_OUTOF",			ANIM_VILLAGER_BOY_DISAPPROVAL_BOOING_OUTOF_01);
		Animation.Add("ST_DISAPPROVAL_BOOING_THUMBSDOWN",		ANIM_VILLAGER_BOY_DISAPPROVAL_BOOING_THUMBS_DOWN_01);
		Animation.Add("ST_FEAR_EDGE_BACKWARDS_INTO",			ANIM_VILLAGER_BOY_FEAR_EDGE_BACKWARDS_INTO_01);
		Animation.Add("ST_FEAR_EDGE_BACKWARDS_LOOP",			ANIM_VILLAGER_BOY_FEAR_EDGE_BACKWARDS_LOOP_01);
		Animation.Add("ST_GREET",								ANIM_VILLAGER_BOY_GREET);
		Animation.Add("ST_LISTENING",							ANIM_VILLAGER_BOY_LISTENING_01);
		Animation.Add("ST_POINT_AWAY_GET_OUT",					ANIM_VILLAGER_BOY_POINT_AWAY_GET_OUT_01);
		Animation.Add("ST_FEAR_RUNNING_ARMS_UP",				ANIM_VILLAGER_BOY_FEAR_RUNNING_ARMS_UP_01);
		Animation.Add("ST_TURN_AC90",							ANIM_VILLAGER_BOY_TURN_90_LEFT_01);
		Animation.Add("ST_TURN_C90",							ANIM_VILLAGER_BOY_TURN_90_RIGHT_01);
		Animation.Add("ST_TURN_AC180",							ANIM_VILLAGER_BOY_TURN_180_LEFT_01);
		Animation.Add("ST_TURN_C180",							ANIM_VILLAGER_BOY_TURN_180_RIGHT_01);
		
		Animation.Add("ST_TELLING_YOU_TO_COME",					ANIM_VILLAGER_BOY_TELLING_YOU_TO_COME);
		
		Animation.Add("RECEIVE_HUG",							ANIM_VILLAGER_BOY_RECEIVE_HUG_01);
		Animation.Add("HAVE_HAIR_RUFFLED",						ANIM_VILLAGER_BOY_HAVE_HAIR_RUFFLED_01);
		
		Animation.Add("CONVERSATION_ANGRY_BASE_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_LOOP_01);
		Animation.Add("CONVERSATION_ANGRY_BASE_LOOP_BREAKOFF",	ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_LOOP_BREAKOFF_01);
		Animation.Add("CONVERSATION_ANGRY_BASE_LOOP_BREAKOFF",	ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_LOOP_BREAKOFF_02);
		Animation.Add("CONVERSATION_ANGRY_BASE_LOOP_INTO",		ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_LOOP_INTO_01);
		Animation.Add("CONVERSATION_ANGRY_BASE_LOOP_OUTOF",		ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_LOOP_OUTOF_01);
		Animation.Add("CONVERSATION_BELLIG_BASE_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_01);
		Animation.Add("CONVERSATION_BELLIG_BASE_LOOP_BREAKOFF",	ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_BREAKOFF_01);
		Animation.Add("CONVERSATION_BELLIG_BASE_LOOP_BREAKOFF",	ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_BREAKOFF_02);
		Animation.Add("CONVERSATION_BELLIG_BASE_LOOP_INTO",		ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_INTO_01);
		Animation.Add("CONVERSATION_BELLIG_BASE_LOOP_OUTOF",	ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_OUTOF_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_A_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_BREAKAWAY",	ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_A_BREAKAWAY_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_BREAKAWAY",	ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_A_BREAKAWAY_02);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_INTO",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_A_INTO_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_OUTOF",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_A_OUTOF_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_B_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_BREAKAWAY",	ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_B_BREAKAWAY_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_BREAKAWAY",	ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_B_BREAKAWAY_02);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_INTO",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_B_INTO_01);
		Animation.Add("CONVERSATION_HAPPY_BASE_LOOP_OUTOF",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_LOOP_B_OUTOF_01);
		Animation.Add("CONVERSATION_SAD_BASE_LOOP",				ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_LOOP_C_01);
		Animation.Add("CONVERSATION_SAD_BASE_LOOP_BREAKAWAY",	ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_LOOP_C_BREAKOFF_01);
		Animation.Add("CONVERSATION_SAD_BASE_LOOP_BREAKAWAY",	ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_LOOP_C_BREAKOFF_02);
		Animation.Add("CONVERSATION_SAD_BASE_LOOP_INTO",		ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_LOOP_C_INTO_01);
		Animation.Add("CONVERSATION_SAD_BASE_LOOP_OUTOF",		ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_LOOP_C_OUTOF_01);
		Animation.Add("CONVERSATION_SCARED_BASE_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_LOOP_01);
		Animation.Add("CONVERSATION_SCARED_BASE_LOOP_BREAKOFF",	ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_LOOP_BREAKOFF_01);
		Animation.Add("CONVERSATION_SCARED_BASE_LOOP_BREAKOFF",	ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_LOOP_BREAKOFF_02);
		Animation.Add("CONVERSATION_SCARED_BASE_LOOP_INTO",		ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_LOOP_INTO_01);
		Animation.Add("CONVERSATION_SCARED_BASE_LOOP_OUTOF",	ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_LOOP_OUTOF_01);
		Animation.Add("FALL_FROM_PUSHED",						ANIM_VILLAGER_BOY_FALL_FROM_PUSHED_01);
		Animation.Add("GET_HIT_NORMAL_BACK",					ANIM_VILLAGER_BOY_GET_HIT_NORMAL_BACK_01);
		Animation.Add("GET_HIT_NORMAL_LEFT",					ANIM_VILLAGER_BOY_GET_HIT_NORMAL_LEFT_01);
		Animation.Add("GET_HIT_NORMAL_RIGHT",					ANIM_VILLAGER_BOY_GET_HIT_NORMAL_RIGHT_01);
		Animation.Add("GET_UP_FROM_PUSHED",						ANIM_VILLAGER_BOY_GET_UP_FROM_PUSHED_01);
		Animation.Add("PUNCH_ANOTHER_BOY_LEFT",					ANIM_VILLAGER_BOY_PUNCH_ANOTHER_BOY_LEFT_01);
		Animation.Add("PUNCH_ANOTHER_BOY_RIGHT",				ANIM_VILLAGER_BOY_PUNCH_ANOTHER_BOY_RIGHT_01);
		Animation.Add("PUSH_ANOTHER",							ANIM_VILLAGER_BOY_PUSH_ANOTHER_01);
		
		//---------------------------------------------------------

		Animation.Add("DEFAULT",			ANIM_BIPED_BOY_01_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_POSE",			ANIM_BIPED_BOY_01_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE_SUBTLE",		ANIM_BIPED_BOY_01_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_SLOW_WALK",		ANIM_BIPED_BOY_01_SLOW_WALK, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_WALK",			ANIM_BIPED_BOY_01_WALK_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_WALK",			ANIM_BIPED_BOY_01_WALK_02, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_WALK",			ANIM_VILLAGER_BOY_WALK_NORMAL_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_RUN",				ANIM_BIPED_BOY_01_RUN, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_RUN",				ANIM_BIPED_BOY_01_RUN_02, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_RUN",				ANIM_VILLAGER_BOY_RUN_02, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("TAG",				ANIM_BIPED_BOY_01_TAG);
		
		Animation.Add("TURNING_AC90",		ANIM_VILLAGER_BOY_TURN_90_LEFT_01);
		Animation.Add("TURNING_C90",		ANIM_VILLAGER_BOY_TURN_90_RIGHT_01);
		Animation.Add("TURNING_AC180",		ANIM_VILLAGER_BOY_TURN_180_LEFT_01);
		Animation.Add("TURNING_C180",		ANIM_VILLAGER_BOY_TURN_180_RIGHT_01);
	
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//the complete set of generic responses and dead and stunned etc idles
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
		Animation.EndGroup();
		
		Animation.AddCombat("DAZED_IDLE",			ANIM_VILLAGER_BOY_DAZED_IDLE);
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_DAZED_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_DAZED_IDLE);
			Animation.Add("DAZED_RECOVER",			ANIM_VILLAGER_BOY_DAZED_IDLE);
		Animation.EndGroup();
		
		Animation.Add("KNOCKDOWN_IDLE",			ANIM_VILLAGER_BOY_KNOCKDOWN_GET_HIT_IDLE_01);
		Animation.Add("STANDARD_DEAD",			ANIM_VILLAGER_BOY_KNOCKDOWN_DEAD_POSE_01);
		Animation.Add("STANDARD_DIE",			ANIM_VILLAGER_BOY_KNOCKDOWN_DEAD_POSE_01);
		Animation.Add("STABBED_TO_DEAD",		ANIM_VILLAGER_BOY_KNOCKDOWN_STAB_TO_DEAD_01);
		Animation.Add("STABBED_ALREADY_DEAD",	ANIM_VILLAGER_BOY_KNOCKDOWN_DEAD_POSE_01);

		Animation.Add("ST_SNEAK",				ANIM_BOY_UPRIGHT_SNEAK);
		Animation.Add("ST_UPRIGHT_SNEAK",		ANIM_BOY_UPRIGHT_SNEAK);
		
		Animation.Add("ST_GET_OBJECT_CUPBOARD",	ANIM_BIPED_BOY_01_GET_CUPBOARD);
		Animation.Add("ST_PUT_OBJECT_CUPBOARD",	ANIM_BIPED_BOY_01_PUT_CUPBOARD);
		Animation.Add("ST_GET_OBJECT_BENCH",	ANIM_BIPED_BOY_01_GET_BENCH);
		Animation.Add("ST_PUT_OBJECT_BENCH",	ANIM_BIPED_BOY_01_PUT_BENCH);
		Animation.Add("ST_HOLDING_PLATE",		ANIM_BIPED_BOY_01_HOLDING);
		Animation.Add("ST_FILL_ITEM",			ANIM_BIPED_BOY_01_FILL_ITEM);
		Animation.Add("ST_EATING",				ANIM_BIPED_BOY_01_EATING);
		
		Animation.Add("ST_RIDICULE",			ANIM_VILLAGER_BOY_RIDICULE_01);
		Animation.Add("ST_RIDICULE",			ANIM_VILLAGER_BOY_RIDICULE_02);
		Animation.Add("ST_RIDICULE",			ANIM_VILLAGER_BOY_RIDICULE_03);
		Animation.Add("ST_RIDICULE",			ANIM_VILLAGER_BOY_SURPRISE_01);
		Animation.Add("ST_RIDICULE",			ANIM_VILLAGER_BOY_FASCINATION_01);
	
		Animation.Add("ST_BULLY_EMOTE",			ANIM_VILLAGER_BOY_OUTRAGED_01);
		Animation.Add("ST_HOMICIDAL_INTRO",		ANIM_VILLAGER_BOY_HOMICIDAL_INTRO);
		Animation.Add("ST_SURPRISE",			ANIM_VILLAGER_BOY_SURPRISE_01);
		
		Animation.Add("SCRIPT_CHEER_1",			ANIM_VILLAGER_BOY_AWE_01);
		Animation.Add("SCRIPT_CHEER_3",			ANIM_VILLAGER_BOY_AWE_02);
		Animation.Add("SCRIPT_CHEER_2",			ANIM_VILLAGER_BOY_AWE_03);

		Animation.StartGroup("CONVERSATION_HAPPY");
			Animation.Add("DEFAULT", ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_BELLIGERENT");
			Animation.Add("DEFAULT", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_ANGRY");
			Animation.Add("DEFAULT", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_FEAR");
			Animation.Add("DEFAULT", ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_SAD");
			Animation.Add("DEFAULT", ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_01);
			Animation.Add("ST_IDLE", ANIM_VILLAGER_BOY_CONVERSATION_SAD_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SAD_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SAD_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SAD_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_VILLAGER_BOY_CONVERSATION_SAD_BREAKOFF_04);
		Animation.EndGroup();

		Animation.Add("STANDARD_TALK_GENERIC",	ANIM_BIPED_BOY_01_TALK_IDLE_01);
		Animation.Add("STANDARD_TALK_GENERIC",	ANIM_BIPED_BOY_01_TALK_IDLE_02);
		Animation.Add("STANDARD_TALK_GENERIC",	ANIM_BIPED_BOY_01_TALK_IDLE_03);
		Animation.Add("STANDARD_TALK_LOVE",		ANIM_VILLAGER_BOY_ATTRACTED_01);
		Animation.Add("STANDARD_TALK_ANGER",	ANIM_VILLAGER_BOY_OUTRAGED_03);
		Animation.Add("STANDARD_TALK_FEAR",		ANIM_VILLAGER_BOY_FEAR_INTRO_01);
		Animation.Add("STANDARD_TALK_FEAR",		ANIM_VILLAGER_BOY_SURPRISE_02);
//		Animation.Add("STANDARD_TALK_GLEE",		ANIM);
		Animation.Add("STANDARD_TALK_SADNESS",	ANIM_VILLAGER_BOY_SAD_02);
		Animation.Add("STANDARD_TALK_FRIENDLY",	ANIM_VILLAGER_BOY_FRIENDLY_01);
		Animation.Add("STANDARD_TALK_RIDICULE",	ANIM_VILLAGER_BOY_RIDICULE_02);

		Animation.StartGroup("SCARED");
			Animation.Add("ST_INTRO",				ANIM_VILLAGER_BOY_FEAR_INTRO_01);
			Animation.Add("ST_INTRO",				ANIM_VILLAGER_BOY_SURPRISE_02);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_BOY_FEAR_WALK_02);
			Animation.Add("ST_WALK_BACK_OFF",		ANIM_VILLAGER_BOY_FEAR_WALK_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_FEAR_IDLE_02);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_SCARED, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_RUN",					ANIM_VILLAGER_BOY_FEAR_RUN_01);
		Animation.EndGroup();
	
		Animation.StartGroup("OUTRAGED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_IDLE_HANDS_ON_HIPS);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_OUTRAGED_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_OUTRAGED_02);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_OUTRAGED_03);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_OUTRAGED_04);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_OUTRAGED_05);

			Animation.Add("ANGRY_WAVE_FIST",		ANIM_VILLAGER_OUTRAGED_04);	
		Animation.EndGroup();

		Animation.StartGroup("CHEERING");	
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_AWE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_AWE_03);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_AWE_02);
		Animation.EndGroup();	

		Animation.StartGroup("HECKLING");	
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_GENERIC_IDLE_01a);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_OUTRAGED_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_OUTRAGED_02);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_OUTRAGED_03);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_OUTRAGED_04);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_CROWD_HECKLE_01);
		Animation.EndGroup();	

		Animation.StartGroup("CURIOUS");
//			Animation.Add("ST_WALK",				ANIM_VILLAGER_BOY_FASCINATION_WALK);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_SURPRISE_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_FASCINATION_01);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_RIDICULE_02);
		Animation.EndGroup();	

		Animation.StartGroup("HERO_IMITATION");
			Animation.Add("ST_WALK",				ANIM_VILLAGER_BOY_AWE_WALK);
			Animation.Add("ST_SLOW_WALK",			ANIM_VILLAGER_BOY_AWE_WALK);
		Animation.EndGroup();	
	
		Animation.StartGroup("ATTRACTED");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_ATTRACTED_02);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_ATTRACTED_03);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_ATTRACTED_01);

			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_ATTRACTED_03);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_ATTRACTED_01);
		Animation.EndGroup();
			
		Animation.StartGroup("SAD");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_FEAR_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_SAD_02);
			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_SAD_02);

			Animation.Add("DROP_TO_KNEES",			ANIM_VILLAGER_BOY_SAD_01);
		Animation.EndGroup();
	
		Animation.StartGroup("BULLY");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_IDLE_HANDS_ON_HIPS);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_OUTRAGED_04);

			Animation.Add("ST_EMOTE",				ANIM_VILLAGER_BOY_OUTRAGED_04);
		Animation.EndGroup();

		Animation.StartGroup("VIOLENT");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_VILLAGER_BOY_HOMICIDAL_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_HOMICIDAL_IDLE_01);
		Animation.EndGroup();

		Animation.StartGroup("CROUCH");
 			Animation.Add("ST_SNEAK",				ANIM_BOY_UPRIGHT_SNEAK);
			Animation.Add("ST_SNEAK_POSE",			ANIM_BOY_UPRIGHT_SNEAK_POSE);
			Animation.Add("ST_SNEAK_UPRIGHT",		ANIM_BOY_UPRIGHT_SNEAK);
			Animation.Add("ST_SNEAK_UPRIGHT_POSE",	ANIM_BOY_UPRIGHT_SNEAK_POSE);
		Animation.EndGroup();

		Animation.StartGroup("STAND");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_IDLE_BREATHE_01);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_IDLE_02);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_IDLE_03);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_IDLE_04);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_IDLE_05);
			Animation.Add("ST_IDLE",				ANIM_BIPED_BOY_01_IDLE_06);
		Animation.EndGroup();
			
		Animation.StartGroup("STAND_HAPPY");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_IDLE_BREATHE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_BALANCING_ON_ONE_LEG_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_SCRATCHING_HEAD_01);	//DELETE
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_STEPPED_IN_SOMETHING_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_SUCKING_THUMB_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_GAZING_AT_SKY_01);

//			Animation.Add("ST_RUN",					ANIM_VILLAGER_BOY_SKIP_01);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_BOY_WALK_HAPPY_01);	
		Animation.EndGroup();
			
		Animation.StartGroup("SKIP");
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_IDLE_BREATHE_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_BALANCING_ON_ONE_LEG_01);
//			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_SCRATCHING_HEAD_01);	//DELETE
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_STEPPED_IN_SOMETHING_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_SUCKING_THUMB_01);
			Animation.Add("ST_IDLE",				ANIM_VILLAGER_BOY_GAZING_AT_SKY_01);
			Animation.Add("ST_WALK",				ANIM_VILLAGER_BOY_SKIP_01);	
		Animation.EndGroup();
			
		Animation.StartGroup("STAND_BORED");
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_BOY_IDLE_BREATHE_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_BOY_BORED_SHIMMY_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_BOY_YAWNING_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_BOY_KICKING_OBJECT_ON_GROUND_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_BOY_PICKING_NOSE_01);
			Animation.Add("ST_IDLE",			ANIM_VILLAGER_BOY_GAZING_AT_SKY_01);

			Animation.Add("ST_WALK",			ANIM_VILLAGER_BOY_WALK_BORED_01);
		Animation.EndGroup();
	
		Animation.Add("HOPSCOTCH_IDLE",			ANIM_BIPED_BOY_01_HOPSCOTCH_IDLE);
		Animation.Add("PLAY_HOPSCOTCH",			ANIM_BIPED_BOY_01_HOPSCOTCH);
		Animation.Add("STANDARD_EXCITED",		ANIM_BIPED_BOY_01_HAPPY_JUMP);
		Animation.Add("STANDARD_SCARED",		ANIM_BIPED_BOY_01_SCARED);
		Animation.Add("STANDARD_WAVE",			ANIM_BIPED_BOY_01_WAVE);
		Animation.Add("STANDARD_WAVE_INFO",		ANIM_BIPED_BOY_01_WAVE_INFO);
		Animation.Add("STANDARD_POINT",			ANIM_BIPED_BOY_01_POINT);
		Animation.Add("ST_HEAD_TURN_H",			ANIM_BIPED_BOY_01_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_HEAD_TURN_V",			ANIM_BIPED_BOY_01_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));

		Animation.Add("PUNCH",					ANIM_BIPED_BOY_01_ATTACK);
		Animation.Add("KICK",					ANIM_BIPED_BOY_01_ATTACK);

		Animation.Add("ST_GET_IN_BED_LEFT",		ANIM_BIPED_BOY_01_GET_INTO_BED);
		Animation.Add("ST_SLEEPING_IN_BED",		ANIM_BIPED_BOY_01_GET_INTO_BED_IDLE, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS)); 
		Animation.Add("ST_GET_OUT_OF_BED_LEFT",	ANIM_BIPED_BOY_01_GET_OUT_BED);

	//ANIMS FOR *BED* TO PLAY
		Animation.Add("BED_GET_IN_LEFT",			ANIM_OBJECT_BED_01_GET_IN);
		Animation.Add("BED_GET_OUT_LEFT",			ANIM_OBJECT_BED_01_GET_OUT);
		Animation.Add("BED_GET_OUT_LEFT_FAST",		ANIM_OBJECT_BED_01_GET_OUT_FAST);
		Animation.Add("BED_SLEEP",					ANIM_OBJECT_BED_01_SLEEP);

	//ANIMS FOR *CUPBOARD* TO PLAY
		Animation.Add("CUPBOARD_GET",			ANIM_OBJECT_CABINET_TALL_GET_BOY);
		Animation.Add("CUPBOARD_PUT",			ANIM_OBJECT_CABINET_TALL_PUT_BOY);
		
		Animation.StartGroup("SIT_CHAIR");
			Animation.Add("ST_SIT_ON_SEAT",				ANIM_VILLAGER_BOY_SIT_ON_CHAIR_01);

//			Animation.Add("ST_SIT_ON_CHAIR",			ANIM_VILLAGER_BOY_SIT_ON_CHAIR_01);
//			Animation.Add("ST_SEATED_CHAIR_BREATHE",	ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01);
//			Animation.Add("ST_SEATED_CHAIR_PICK_NOSE",	ANIM_VILLAGER_BOY_SEATED_CHAIR_PICK_NOSE_01);
//			Animation.Add("ST_SEATED_CHAIR_GET_UP",		ANIM_VILLAGER_BOY_SEATED_CHAIR_GET_UP_01);

			Animation.Add("ST_SEATED_CHAIR_RAISE_HAND",	ANIM_VILLAGER_BOY_SEATED_CHAIR_RAISE_HAND_01);
		Animation.EndGroup();
		Animation.Add("ST_STAND_UP_FROM_SEAT",		ANIM_VILLAGER_BOY_SEATED_CHAIR_GET_UP_01);

		Animation.StartGroup("SIT_CHAIR_NORMAL");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SEATED_CHAIR_PICK_NOSE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SIT_SWINGING_LEGS_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR_STUDIOUS");
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SEATED_CHAIR_RAISE_HAND_01);
		Animation.EndGroup();
	
		Animation.StartGroup("SIT_CHAIR_BORED");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SIT_FIGHTING_SLEEP_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SIT_BORED_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_CHAIR_SLEEPING");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_BOY_SIT_SLEEPING_IDLE_01);	
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SIT_FIGHTING_SLEEP_01);	
		Animation.EndGroup();

		Animation.StartGroup("SIT_BENCH");
			Animation.Add("ST_SIT_ON_BENCH",			ANIM_BIPED_BOY_01_SIT_ON_BENCH);
			Animation.Add("ST_SITTING",					ANIM_BIPED_BOY_01_SIT_ON_BENCH_IDLE);
			Animation.Add("ST_STAND_UP_FROM_BENCH",		ANIM_BIPED_BOY_01_SIT_OFF_BENCH);
		Animation.EndGroup();

		Animation.StartGroup("SIT_FLOOR_1");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_BOY_SEATED_FLOOR_BREATHE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SEATED_FLOOR_BREATHE_01);

			Animation.Add("ST_SIT_ON_FLOOR",				ANIM_VILLAGER_BOY_SIT_ON_FLOOR_01);
			Animation.Add("ST_SIT_ON_FLOOR_BREATHE",		ANIM_VILLAGER_BOY_SEATED_FLOOR_BREATHE_01);
			Animation.Add("ST_SIT_ON_FLOOR_SCRATCH_HEAD",	ANIM_VILLAGER_BOY_SEATED_FLOOR_SCRATCH_HEAD_01);
			Animation.Add("ST_SIT_ON_FLOOR_GET_UP",			ANIM_VILLAGER_BOY_SEATED_FLOOR_GET_UP_01);
			Animation.Add("ST_STAND_UP_FROM_FLOOR",			ANIM_VILLAGER_BOY_SEATED_FLOOR_GET_UP_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_FLOOR_2");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_VILLAGER_BOY_SEATED_FLOOR_BREATHE_01);
			Animation.Add("ST_IDLE",					ANIM_VILLAGER_BOY_SEATED_FLOOR_BREATHE_01);

			Animation.Add("ST_SIT_ON_FLOOR",			ANIM_BIPED_BOY_01_SIT_ON_FLOOR_02);
			Animation.Add("ST_SITTING",					ANIM_BIPED_BOY_01_SITTING_ON_FLOOR_02);
			Animation.Add("ST_STAND_UP_FROM_FLOOR",		ANIM_BIPED_BOY_01_STAND_FROM_FLOOR_02);
		Animation.EndGroup();

		Animation.StartGroup("SLEEP_FLOOR_BED_1");
			Animation.Add("ST_GET_IN_FLOOR_BED",		ANIM_BIPED_BOY_01_LIE_ON_FLOOR_01);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",	ANIM_BIPED_BOY_01_SLEEP_FLOOR);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",	ANIM_BIPED_BOY_01_GET_UP_FROM_FLOOR_01);
		Animation.EndGroup();
		
		Animation.Add("ST_SLEEPING_IN_FLOOR_BED",	ANIM_BIPED_BOY_01_SLEEP_FLOOR);

		Animation.StartGroup("SLEEP_FLOOR_BED_2");
			Animation.Add("ST_GET_IN_FLOOR_BED",		ANIM_BIPED_BOY_01_LIE_ON_FLOOR_02);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",	ANIM_BIPED_BOY_01_SLEEP_FLOOR);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",	ANIM_BIPED_BOY_01_GET_UP_FROM_FLOOR_02);
		Animation.EndGroup();

		Animation.Add("CONV_LISTENING_INTO",			ANIM_VILLAGER_BOY_CONVERSATION_LISTENING_INTO_01);
		Animation.Add("CONV_LISTENING_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_LISTENING_LOOP_01);
		Animation.Add("CONV_LISTENING_OUTOF",			ANIM_VILLAGER_BOY_CONVERSATION_LISTENING_OUTOF_01);

		Animation.Add("ST_CONV_HAPPY_01_BREAKAWAY",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_BREAKAWAY_01);
		Animation.Add("ST_CONV_HAPPY_01_BREAKAWAY",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_BREAKAWAY_02);
		Animation.Add("ST_CONV_HAPPY_01_INTO",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_INTO_01);
		Animation.Add("ST_CONV_HAPPY_01_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_LOOP_01);
		Animation.Add("ST_CONV_HAPPY_01_OUTOF",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_OUTOF_01);

		Animation.Add("ST_CONV_HAPPY_02_BREAKAWAY",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_02_BREAKAWAY_01);
		Animation.Add("ST_CONV_HAPPY_02_BREAKAWAY",		ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_02_BREAKAWAY_02);
		Animation.Add("ST_CONV_HAPPY_02_INTO",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_02_INTO_01);
		Animation.Add("ST_CONV_HAPPY_02_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_02_LOOP_01);
		Animation.Add("ST_CONV_HAPPY_02_OUTOF",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_02_OUTOF_01);
		
		// CUTSCENE ANIMATIONS
		Animation.Add("CS_BOY_SCARED",					ANIM_VILLAGER_BOY_FEAR_IDLE_01);
		
		Animation.Add("CS_CONV_HAPPY_LOOP",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01);
		Animation.Add("CS_CONV_HAPPY_BR1",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_01);
		Animation.Add("CS_CONV_HAPPY_BR2",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_02);
		Animation.Add("CS_CONV_HAPPY_BR3",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_03);
		Animation.Add("CS_CONV_HAPPY_BR4",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BREAKOFF_04);

		Animation.Add("CS_CONV_HAPPY2_BR1",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_BREAKAWAY_01);
		Animation.Add("CS_CONV_HAPPY2_BR2",				ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_BREAKAWAY_02);
		Animation.Add("CS_CONV_HAPPY2_INTO",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_INTO_01);
		Animation.Add("CS_CONV_HAPPY2_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_LOOP_01);
		Animation.Add("CS_CONV_HAPPY2_OUTOF",			ANIM_VILLAGER_BOY_CONVERSATION_HAPPY_BASE_01_OUTOF_01);

		Animation.Add("CS_CONV_ANGRY_LOOP",				ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BASE_01);
		Animation.Add("CS_CONV_ANGRY_BR1",				ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_01);
		Animation.Add("CS_CONV_ANGRY_BR2",				ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_02);
		Animation.Add("CS_CONV_ANGRY_BR3",				ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_03);
		Animation.Add("CS_CONV_ANGRY_BR4",				ANIM_VILLAGER_BOY_CONVERSATION_ANGRY_BREAKOFF_04);

		Animation.Add("CS_CONV_STROPPY_LOOP",			ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_01);
		Animation.Add("CS_CONV_STROPPY_BR1",			ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_BREAKOFF_01);
		Animation.Add("CS_CONV_STROPPY_BR2",			ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_BREAKOFF_02);
		Animation.Add("CS_CONV_STROPPY_INTO",			ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_INTO_01);
		Animation.Add("CS_CONV_STROPPY_OUTOF",			ANIM_VILLAGER_BOY_CONVERSATION_BELLIG_BASE_LOOP_OUTOF_01);

		Animation.Add("CS_SIT_IDLE",					ANIM_VILLAGER_BOY_SEATED_CHAIR_BREATHE_01, TransTime(0));
		Animation.Add("CS_SIT_SWING_LEGS",				ANIM_VILLAGER_BOY_SIT_SWINGING_LEGS_01);
		Animation.Add("CS_SIT_CHAIR_CHEER",				CS_SIT_CHAIR_CHEER);
		Animation.Add("CS_SIT_CHAIR_CLAP",				CS_SIT_CHAIR_CLAP);
		Animation.Add("CS_SIT_CHAIR_LAUGH",				CS_SIT_CHAIR_LAUGH);
		Animation.Add("CS_CHILD_FART",					CS_CHILD_FART);
		Animation.Add("CS_CHILD_BURP",					CS_CHILD_BURP);

		Animation.Add("CS_SIT_ON_FLOOR_1",				ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_LOOP_01);
		Animation.Add("CS_SIT_ON_FLOOR_2",				ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_LOOP_02);
		Animation.Add("CS_SIT_ON_FLOOR_INTO1",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_INTO_01);
		Animation.Add("CS_SIT_ON_FLOOR_INTO2",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_INTO_02);
		Animation.Add("CS_SIT_ON_FLOOR_OUTOF1",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_OUTOF_01);
		Animation.Add("CS_SIT_ON_FLOOR_OUTOF2",			ANIM_VILLAGER_BOY_SAT_ON_FLOOR_IDLE_OUTOF_02);
		Animation.Add("CS_SIT_FLOOR_LOOP",				ANIM_VILLAGER_BOY_SEATED_FLOOR_BREATHE_01);
		Animation.Add("CS_SIT_FLOOR_CLAP",				CS_SIT_FLOOR_CLAP);
		Animation.Add("CS_SIT_FLOOR_LAUGH",				CS_SIT_FLOOR_LAUGH);
		Animation.Add("CS_SIT_FLOOR_CHEER",				CS_SIT_FLOOR_CHEER);
		Animation.Add("CS_SIT_FLOOR_SHOCK",				CS_SIT_FLOOR_SHOCK);

		Animation.Add("CS_JUMP_CHEER",					ANIM_VILLAGER_BOY_AWE_02);

		Animation.Add("CS_SLEEP_FLOOR_LOOP",			ANIM_BIPED_BOY_01_SLEEP_FLOOR);
		Animation.Add("CS_SLEEP_FLOOR_OUTOF",			ANIM_BIPED_BOY_01_GET_UP_FROM_FLOOR_01);
	<\CAppearanceDef>

//-------------------------------- Adam's remapped anim tags for opinion reactions -------------------------

	<CAppearanceDef>
		Animation.Add("ST_OPINION_APPROVAL_CHEERING_BOTH_ARMS_UP", ANIM_VILLAGER_BOY_AWE_02);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_ARMS_UP", ANIM_VILLAGER_BOY_AWE_03);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_NORMAL", ANIM_VILLAGER_BOY_AWE_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_INTO", ANIM_VILLAGER_BOY_APPROVAL_ECSTATIC_GESTURING_INTO_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_LOOP", ANIM_VILLAGER_BOY_APPROVAL_ECSTATIC_GESTURING_LOOP_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_OUTOF", ANIM_VILLAGER_BOY_APPROVAL_ECSTATIC_GESTURING_OUTOF_01);
		Animation.Add("ST_OPINION_APPROVAL_REACTION_ARMS_WIDE_GREET", ANIM_VILLAGER_BOY_FRIENDLY_01);
		Animation.Add("ST_OPINION_APPROVAL_WAVING_AT_DISTANCE", ANIM_BIPED_BOY_01_WAVE);
		Animation.Add("ST_OPINION_ATTRACTED_HANDS_CLASPED_SWAYING", ANIM_VILLAGER_BOY_ATTRACTED_02);
//		Animation.Add("ST_OPINION_ATTRACTED_PREENING_SELF", ANIM_VILLAGER_BOY_);			// adult female only
//		Animation.Add("ST_OPINION_ATTRACTED_SHOUTING_AT", ANIM_VILLAGER_BOY_);				// adult female only
//		Animation.Add("ST_OPINION_ATTRACTED_WAVING_AT", ANIM_VILLAGER_BOY_);				// adult female only
		Animation.Add("ST_OPINION_DISAPPROVAL_BOOING", ANIM_VILLAGER_BOY_DISAPPROVAL_BOOING_LOOP_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_CALLING_OVER_FOR_FIGHT", ANIM_VILLAGER_BOY_HOMICIDAL_INTRO);
//		Animation.Add("ST_OPINION_DISAPPROVAL_DISMISSING_HAND_SWIPE", ANIM_VILLAGER_BOY_);	// adults only - kids have nyah nyah
		Animation.Add("ST_OPINION_DISAPPROVAL_DISMISSING_HAND_SWIPE", ANIM_VILLAGER_BOY_OUTRAGED_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_NYAH_NYAH", ANIM_VILLAGER_BOY_OUTRAGED_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINT_AT", ANIM_VILLAGER_BOY_OUTRAGED_05);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINTING_AWAY_GET_OUT", ANIM_VILLAGER_BOY_POINT_AWAY_GET_OUT_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_SHAKE_FIST", ANIM_VILLAGER_BOY_OUTRAGED_04);
		Animation.Add("ST_OPINION_DISAPPROVAL_STAMP_FOOT", ANIM_VILLAGER_BOY_OUTRAGED_02);
		Animation.Add("ST_OPINION_DISAPPROVAL_THUMBS_DOWN", ANIM_VILLAGER_BOY_DISAPPROVAL_BOOING_THUMBS_DOWN_01);
		Animation.Add("ST_OPINION_FEAR_IDLE_COWERING", ANIM_VILLAGER_BOY_FEAR_IDLE_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SHRINKING_AWAY", ANIM_VILLAGER_BOY_FEAR_IDLE_02);
		Animation.Add("ST_OPINION_FEAR_REACTION_SURPRISED", ANIM_VILLAGER_BOY_FEAR_INTRO_01);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_FRONT", ANIM_VILLAGER_BOY_FEAR_RUN_01);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_UP", ANIM_VILLAGER_BOY_FEAR_RUNNING_ARMS_UP_01);
//combat anim for movement : Animation.Add("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_VILLAGER_BOY_FEAR_EDGE_BACKWARDS_LOOP_01);
		Animation.Add("ST_OPINION_NEUTRAL_POINT_AT", ANIM_VILLAGER_BOY_SURPRISE_01);
		Animation.Add("ST_OPINION_NEUTRAL_POINTING_CALLING_FRIEND", ANIM_VILLAGER_BOY_FASCINATION_01);
		Animation.Add("ST_OPINION_NEUTRAL_REACTION_HAND_UP_GREET", ANIM_VILLAGER_BOY_GREET);
		Animation.Add("ST_OPINION_NEUTRAL_SHOUTING_WITH_HANDS_CUPPED", ANIM_VILLAGER_BOY_SHOUT_CUPPED_HANDS_01); //, ANIM_VILLAGER_BOY_SHOUTING_WITH_HANDS_01);
		Animation.Add("ST_OPINION_NEUTRAL_SURPRISE", ANIM_VILLAGER_BOY_NEUTRAL_SURPRISE_01);
		Animation.Add("ST_OPINION_NEUTRAL_WALK_NERVOUS_LOOKING_BACK", ANIM_VILLAGER_BOY_FEAR_WALK_02);
		Animation.Add("ST_OPINION_RIDICULE_BELLY_LAUGH", ANIM_VILLAGER_BOY_RIDICULE_03);
		Animation.Add("ST_OPINION_RIDICULE_POINT_AND_LAUGH", ANIM_VILLAGER_BOY_RIDICULE_01);
		Animation.Add("ST_OPINION_RIDICULE_SNIGGER", ANIM_VILLAGER_BOY_RIDICULE_02);

		Animation.AddCombat("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_VILLAGER_BOY_FEAR_EDGE_BACKWARDS_LOOP_01);

		Animation.Add("PUSHED_FORWARD", ANIM_VILLAGER_BOY_PUSHED_FORWARD_01, TransTime(0), Delay(0));
		Animation.Add("PUSHED_BACKWARD", ANIM_VILLAGER_BOY_PUSHED_BACKWARD_01, TransTime(0), Delay(0));
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_VILLAGER_BOY_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_VILLAGER_BOY_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	<\CAppearanceDef>

//----------------------------------------------------------------------------------------------------------

//	Components.Add("CTCCreatureExpression");
//	<CCreatureDef>
//		Expressions.Add(EXPRESSION_DEFAULT,			ANIM_BIPED_BOY_01_FACIAL_DEFAULT);
//	<\CCreatureDef>

	CombatDiameter			0.5;
#end_definition

//*************************************************************************************************
//************ COMBATANTS & ENEMIES ***************************************************************
//*************************************************************************************************
#definition_template CREATURE CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE  specialises CREATURE_BASE_TEMPLATE

	Health						5;

	MaxAcceleration				0.1;
	<CLookDef>
		MaxTurnSpeed 			10.0;
	<\CLookDef>

	Property					NULL;

	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type					TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING | TARGETING_TALKABLE;
	<\CTargetingDef>

	Components.Add("CTCCarrying");
	<CCarryingDef>
		AvailableCarrySlots.Add(CARRY_SLOT_RIGHT_HAND);
		AvailableCarrySlots.Add(CARRY_SLOT_LEFT_HAND);
		AvailableCarrySlots.Add(CARRY_SLOT_PRIMARY_SHEATHE);
		AvailableCarrySlots.Add(CARRY_SLOT_SECONDARY_SHEATHE);
	<\CCarryingDef>

	<CEnemyDef>
		Faction					FACTION_BANDITS;
	<\CEnemyDef>	

	IsWillable					TRUE;
	IsVulnerableToMelee			TRUE;
	Damageable					TRUE;
	IsIndestructible			FALSE;

	CreatureType				HUMAN_ADULT;
	PBrain						BRAIN_NULL;
	Sex							SEX_MALE;

	NavigatorTypes.Add(NAV_INIT_GROUND);

	Damage						1.0;

	Components.Add("CTCCombat");
	Components.Add("CTCEnemy");
	Components.Add("CTCTargetingAI");
	Components.Add("CTCWaterWader");

	Components.Add("CTCPerceiveThing");
	<CPerceivedThingDef>
		FieldOfView							160;
		SightRadius							12;
		SoundRadius							10;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						15.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
	<\CPerceivedThingDef>

	Components.Add("CTCPhysicsNavigator");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Diameter			1.0;

		Elasticity			0;
		Friction			1;
		AirResistance		0;
		Mass				75;
		Diameter			0.8;
	<\CPhysicsDef>

	DefaultOwner			2;

	Components.Add("CTCContainerRewardHero");
	<CContainerRewardHeroDef>
//		ObjectFamilies.Add("GOLD_FAMILY_01");
	<\CContainerRewardHeroDef>

	Components.Add("CTCLook");

	<CCreatureDef>
		Stats.ExperienceWorth		10;
		Stats.RenownWorth			4;

		Stats.MoralityForKill		2;	// Dene's default setup
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		PickPocketable				TRUE;
	<\CCreatureDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("SINGE",	SINGE_MEDIUM_01);
	<\CSpecialEffectsDef>
#end_definition

//*******************************************************************************************************************
#definition_template	CREATURE	CREATURE_BANDIT_SKELETON_COMMON_BASE specialises CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE

	AbleToStrafe		TRUE;
	
	<CEntitySoundDef>
		SoundIdentifier	"SI_HUMAN_MALE";
	<\CEntitySoundDef>
	
	<CLookDef>
		AllowTurningViaAnimation		TRUE;
	<\CLookDef>	
	
	<CAppearanceDef>
		Animation.Add("STANDARD_CROSSBOW_SEARCH",		ANIM_BIPED_NEW_GUARD_CROSSBOW_SEARCH);
		
		Animation.StartGroup("CROSSBOW");
			Animation.Add("PROJECTILE_WEAPON_FIRE",	ANIM_BANDIT_CROSSBOW_FIRING_01);
			Animation.Add("PROJECTILE_WEAPON_LOAD",	ANIM_BANDIT_CROSSBOW_LOAD_01);
//			Animation.Add("PROJECTILE_WEAPON_AIM",	ANIM_BANDIT_CROSSBOW_AIMING_01);
			Animation.Add("PROJECTILE_WEAPON_INTO_AIM",	ANIM_BANDIT_CROSSBOW_INTO_AIMING_01,TransTime(5));
			Animation.Add("ST_IDLE",				ANIM_BANDIT_WITH_CROSSBOW_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_WITH_CROSSBOW_IDLE_01);
			Animation.Add("ST_WALK",				ANIM_BANDIT_CROSSBOW_WALK_01, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("ST_RUN",					ANIM_BANDIT_CROSSBOW_RUN_01, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("DIVE_FOR_COVER",			ANIM_BANDIT_HIDE_FOR_COVER_01);
			Animation.Add("JUMP_OUT_RIGHT",			ANIM_BANDIT_JUMP_RIGHT_01);
			Animation.Add("JUMP_OUT_LEFT",			ANIM_BANDIT_JUMP_LEFT_01);
			Animation.Add("CROUCH",					ANIM_BANDIT_CROSSBOW_CROUCH_01,TransTime(7));
			
			Animation.Add("PROJECTILE_WEAPON_AIM",	ANIM_BANDIT_STRAFE_UPPER_BODY_CROSSBOW);
			
			Animation.Add("STANDARD_UNSHEATHE",				ANIM_BANDIT_CROSSBOW_UNSHEATHE_01);
			Animation.Add("STANDARD_SHEATHE",				ANIM_BANDIT_CROSSBOW_SHEATHE_01);
		Animation.EndGroup();
		
		Animation.StartGroup("SWORD");
			Animation.Add("ST_IDLE",						ANIM_BANDIT_IDLE_05);
			Animation.Add("ST_RUN",							ANIM_BANDIT_RUN_WITH_SWORD_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.EndGroup();
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_BANDIT_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_BANDIT_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
		
		Animation.Add("PROJECTILE_WEAPON_INTO_AIM",	ANIM_BANDIT_CROSSBOW_INTO_AIMING_01,TransTime(5));
		Animation.AddCombat("PROJECTILE_WEAPON_AIM", ANIM_BANDIT_CROSSBOW_AIMING_01);
		Animation.AddCombat("PROJECTILE_WEAPON_LOAD", ANIM_BANDIT_CROSSBOW_LOAD_01);
		Animation.AddCombat("PROJECTILE_WEAPON_FIRE", ANIM_BANDIT_CROSSBOW_FIRING_01);
	<\CAppearanceDef>

	<CLookDef>
		EyesTurnRangeXY		20.0;
		EyesTurnRangeYZ		0.0;
		HeadTurnRangeXY		170.0;
		HeadTurnRangeYZUp	55.0;
		HeadTurnRangeYZDown	55.0;
	<\CLookDef>

	<CAppearanceDef>
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_BANDIT_LEFT_NORMAL_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_BANDIT_RIGHT_NORMAL_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_BANDIT_BACK_NORMAL_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_BANDIT_RIGHT_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_BANDIT_LEFT_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_BANDIT_COMBAT_KNOCKDOWN_RECOVER_1_2);
		Animation.AddCombat("RESPONSE_DRAIN_LIFE_HIT",					ANIM_BANDIT_DRAIN_LIFE_GET_HIT_01);
		Animation.AddCombat("RESPONSE_TIMED_FORWARD_SUMMERSAULT",		ANIM_BANDIT_RESPONSE_TIMED_SLASH_SUMMERSAULT_01);
		Animation.AddCombat("RESPONSE_TIMED_RIGHT_SERVE_SLASH",			ANIM_BANDIT_RESPONSE_TIMED_SERVE_SLASH_01);
		Animation.AddCombat("RESPONSE_TIMED_BACK_BACK_STAB",			ANIM_BANDIT_RESPONSE_TIMED_BACK_STAB_01);
		Animation.AddCombat("RESPONSE_TIMED_LEFT_CRICKET_BAT_SMASH",	ANIM_BANDIT_RESPONSE_TIMED_CRICKET_BAT_SMASH_01);
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_BANDIT_DECAPITATED_01, NextAnimFilter("KNOCKED_ON_FRONT"));
		Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",			ANIM_BANDIT_KICKED_WHEN_DEAD);

		Animation.AddCombat("BLOCK_BROKEN_RESPONSE_RIGHT",				ANIM_BANDIT_ATTACK_LEFT_RECOIL_1);
		Animation.AddCombat("BLOCK_BROKEN_RESPONSE_LEFT",				ANIM_BANDIT_ATTACK_LEFT_RECOIL_1);
		
		Animation.AddCombat("FALL_DEAD",								ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1); //need replacing
		Animation.AddCombat("FALL_UNCONSCIOUS",							ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1); //need replacing
		
		Animation.StartGroup("KNOCKED_ON_FRONT");
			Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.Add("STANDARD_DEAD",									ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.Add("STANDARD_DIE",									ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.Add("STABBED_TO_DEAD",								ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.Add("STABBED_ALREADY_DEAD",							ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.Add("UNCONSCIOUS_TO_DEAD",							ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.Add("ST_KICKED_WHEN_DEAD",							ANIM_BANDIT_DECAPITATED_DEAD_POSE);
			Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",			ANIM_BANDIT_DECAPITATED_DEAD_POSE);
		Animation.EndGroup();
		
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",									ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
			Animation.Add("ST_IDLE_SUBTLE",								ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
			Animation.AddCombat("RESPONSE_GET_KICKED_ON_GROUND",		ANIM_BANDIT_KICKED_WHEN_DEAD);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_BANDIT_KICKED_WHEN_DEAD);
		Animation.EndGroup();
		
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_BIPED_BANDIT_DAZED_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BIPED_BANDIT_DAZED_IDLE);
			Animation.Add("DAZED_RECOVER",			ANIM_BANDIT_COMBAT_IDLE_1_2);
		Animation.EndGroup();
		
		Animation.Add("ST_TORTURE_LEVITATION",	ANIM_BANDIT_TORTURE_LEVITATE);
		Animation.Add("ST_TORTURE_TRANSITION",	ANIM_BANDIT_TORTURE_LEVITATE_INTO_LOOP);
		Animation.Add("ST_TORTURE_LOOP",		ANIM_BANDIT_TORTURE_LOOP);
	
		Animation.Add("DIVE_FOR_COVER",			ANIM_BANDIT_HIDE_FOR_COVER_01);
		Animation.Add("CROUCH",					ANIM_BANDIT_CROSSBOW_CROUCH_01,TransTime(7));
			
		Animation.AddCombat("DAZED_IDLE",								ANIM_BIPED_BANDIT_DAZED_IDLE);
		Animation.AddCombat("KNOCKDOWN_IDLE",							ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
		Animation.AddCombat("STANDARD_DEAD",							ANIM_BANDIT_DEAD_POSE);
		Animation.Add("STANDARD_DIE",									ANIM_BANDIT_DEAD_POSE);
		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//the complete set of generic responses and dead and stunned etc idles
		//all enemy bandit skeletoned creatures should use this
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		Animation.Add("STABBED_TO_DEAD",				ANIM_BANDIT_STABBED_TO_DEAD);
		Animation.Add("STABBED_ALREADY_DEAD",			ANIM_BANDIT_KICKED_WHEN_DEAD);
		Animation.Add("UNCONSCIOUS_TO_DEAD",			ANIM_BANDIT_UNCONSCIOUS_TO_DEAD_01);
		
		Animation.Add("ST_KICKED_WHEN_DEAD",			ANIM_BANDIT_KICKED_WHEN_DEAD);

		Animation.Add("RESPONSE_MULTISTRIKE_TWITCH_01",	ANIM_BANDIT_MULTISTRIKE_TWITCH_01);
		Animation.Add("RESPONSE_MULTISTRIKE_TWITCH_02",	ANIM_BANDIT_MULTISTRIKE_TWITCH_02);

		Animation.StartGroup("FORCE_PUSHED");
			Animation.Add("ST_IDLE",					ANIM_BANDIT_FORCEPUSH_GET_HIT_01);
			Animation.Add("ST_IDLE",					ANIM_BANDIT_HIT_BY_FORCE_PUSH_01);
			Animation.Add("ST_IDLE",					ANIM_BANDIT_HIT_BY_FORCE_PUSH_IMPACT_01);
		Animation.EndGroup();
		
		Animation.AddCombat("GENERIC_RESPONSE_EXPLOSIVE_FORCE_PUSHED",	ANIM_BANDIT_HIT_BY_FORCE_PUSH_01);
		Animation.StartGroup("EXPLOSIVE_FORCE_PUSH");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_HIT_BY_FORCE_PUSH_01);
		Animation.EndGroup();
	<\CAppearanceDef>
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////

	Health 							10;
	PBrain							BRAIN_BANDIT_VILLAGER_BASE;
 	Graphic.Type					ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 				MESH_BANDIT_01;
	PrimaryMeleeWeaponDef			OBJECT_IRON_LONGSWORD;
	StunnedParticle					DAZED01STAR;

//	Sound["STF_PAIN"] 				SND_MANHIT_01;			Sound["STL_PAIN"] 				SND_MANHIT_04;
//	Sound["STF_FLESH_HIT"]			SND_PUNCH_01;			Sound["STL_FLESH_HIT"]			SND_PUNCH_11;				
//	Sound["STF_SWORD_SWING"]		SND_WEAPONSWIPE_01;		Sound["STL_SWORD_SWING"]		SND_WEAPONSWIPE_07;
//	Sound["STF_DEATH"] 				SND_MANDYING_01;		Sound["STL_DEATH"] 				SND_MANDYING_07;

	Components.Add("CTCVillageMember");
	Components.Add("CTCWeaponTrail");
	
	MaxWalkingSpeed 		0;
	MaxRunningSpeed 		0;
	
	<CPhysicsDef>
		Diameter			1.2;	// Changed by MikeD from 1.2
	<\CPhysicsDef>

	<CCreatureNavigationDef>
		Radius				0.3;
	<\CCreatureNavigationDef>

	CombatTypeDef			BANDIT_GRUNT_ATTACK_STYLE;
		
	<CCreatureDef>
		PhonemeAnim["AH"]				ANIM_BANDIT_PHONEME_AH;
		PhonemeAnim["EE"]				ANIM_BANDIT_PHONEME_EE;
		PhonemeAnim["MM"]				ANIM_BANDIT_PHONEME_MM;
		PhonemeAnim["OH"]				ANIM_BANDIT_PHONEME_OH;
		PhonemeAnim["SZ"]				ANIM_BANDIT_PHONEME_SZ;
		PhonemeAnim["WW"]				ANIM_BANDIT_PHONEME_WW;
	<\CCreatureDef>

	<CAppearanceDef>
		Animation.Add("SCRIPT_THREATEN",				ANIM_BANDIT_THREATEN_02);

		Animation.Add("DEFAULT",						ANIM_BANDIT_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE_SUBTLE",					ANIM_BANDIT_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE",						ANIM_BANDIT_IDLE_01);
		Animation.Add("ST_IDLE",						ANIM_BANDIT_IDLE_02);
		Animation.Add("ST_IDLE",						ANIM_BANDIT_IDLE_03);
		Animation.Add("ST_IDLE",						ANIM_BANDIT_IDLE_04);
		
		Animation.Add("ST_CHALLENGE",								ANIM_BANDIT_CHALLENGE_01);
		Animation.Add("ST_CHECK_OUT",								ANIM_BANDIT_CHECKING_OUT_01);
		Animation.Add("ST_HELLO",									ANIM_BANDIT_HELLO_01);
		Animation.Add("ST_HELLO",									ANIM_BANDIT_HELLO_02);
		Animation.Add("ST_LOOK_BEHIND",								ANIM_BANDIT_LOOK_BEHIND_01);
		Animation.Add("ST_POINT",									ANIM_BANDIT_POINT_01);
		Animation.Add("ST_SALUTE",									ANIM_BANDIT_SALUTE_01);
		Animation.Add("ST_WAKE_KO_KICK",							ANIM_BANDIT_WAKE_KO_KICK_01);
		
		Animation.Add("ST_WEAPON_SHEATHE",							ANIM_BANDIT_WEAPON_SHEATHE_01);
		Animation.Add("ST_WEAPON_UNSHEATHE",						ANIM_BANDIT_WEAPON_UNSHEATHE_01);
		
		// Warning!  I'm not certain that these 2 are the correct anims.
		Animation.Add("STANDARD_SHEATHE",							ANIM_BANDIT_WEAPON_SHEATHE_01);
	
		Animation.Add("STANDARD_UNSHEATHE",							ANIM_BANDIT_CROSSBOW_UNSHEATHE_01);
		Animation.Add("ST_UNSHEATHE_TO_COMBAT_POSE",				ANIM_BANDIT_CROSSBOW_UNSHEATHE_01);
		
		Animation.Add("ST_YAWN",									ANIM_BANDIT_YAWN_01);
		Animation.Add("ST_JUMP_FROM_BUSH_LEFT",						ANIM_BANDIT_JUMP_BUSH_LEFT_01);
		Animation.Add("ST_JUMP_FROM_BUSH_RIGHT",					ANIM_BANDIT_JUMP_BUSH_RIGHT_01);
		Animation.Add("ST_JUMP_FROM_TREE_LEFT",						ANIM_BANDIT_JUMP_TREE_LEFT_01);
		Animation.Add("ST_JUMP_FROM_TREE_RIGHT",					ANIM_BANDIT_JUMP_TREE_RIGHT_01);
		Animation.Add("ST_RUN_ON_FIRE",								ANIM_BANDIT_RUN_ON_FIRE_01);
		Animation.Add("ST_RUN_WITH_SWORD",							ANIM_BANDIT_RUN_WITH_SWORD_01);
		Animation.Add("ST_COME_ON",									ANIM_BANDIT_COME_ON_01);
		Animation.Add("ST_BEING_HELD",								ANIM_BANDIT_BEING_HELD_01);
		Animation.Add("ST_HOLDING_ANOTHER",							ANIM_BANDIT_HOLDING_ANOTHER_01);
		Animation.Add("ST_BEING_PUSHED",							ANIM_BANDIT_BEING_PUSHED_01);
		Animation.Add("ST_PUSHING_ANOTHER",							ANIM_BANDIT_PUSHING_ANOTHER_01);
		
		Animation.Add("ST_POINTING_AT_LAUGHING_INTO",				ANIM_BANDIT_POINTING_AT_LAUGHING_INTO_01);
		Animation.Add("ST_POINTING_AT_LAUGHING_LOOP",				ANIM_BANDIT_POINTING_AT_LAUGHING_LOOP_01);
		Animation.Add("ST_POINTING_AT_LAUGHING_OUTOF",				ANIM_BANDIT_POINTING_AT_LAUGHING_OUTOF_01);
		Animation.Add("ST_STOOD_DRINKING_LOOP",						ANIM_BANDIT_STOOD_DRINKING_LOOP_01);
		Animation.Add("ST_STOOD_PASSING_BOTTLE_BACK",				ANIM_BANDIT_STOOD_PASSING_BOTTLE_BACK_01);
		Animation.Add("ST_STOOD_RECEIVE_BOTTLE_BACK",				ANIM_BANDIT_STOOD_RECEIVE_BOTTLE_BACK_01);
		Animation.Add("ST_STOOD_SING_SONG_DRUNK_INTO",				ANIM_BANDIT_STOOD_SING_SONG_DRUNK_INTO_01);
		Animation.Add("ST_STOOD_SING_SONG_DRUNK_LOOP",				ANIM_BANDIT_STOOD_SING_SONG_DRUNK_LOOP_01);
		Animation.Add("ST_STOOD_SING_SONG_DRUNK_OUTOF",				ANIM_BANDIT_STOOD_SING_SONG_DRUNK_OUTOF_01);
		Animation.Add("ST_STOOD_TAKE_BOTTLE_FROM_POCKET",			ANIM_BANDIT_STOOD_TAKE_BOTTLE_FROM_POCKET_01);
		Animation.Add("ST_STOOD_THROW_BOTTLE_AWAY",					ANIM_BANDIT_STOOD_THROW_BOTTLE_AWAY_01);
		Animation.Add("ST_WALK_ANGRY_REVISION",						ANIM_BANDIT_WALK_ANGRY_REVISION_01);
		Animation.Add("ST_WALK_REVISION",							ANIM_BANDIT_WALK_REVISION_01);
		Animation.Add("ST_WALK_SWAGGER_REVISION",					ANIM_BANDIT_WALK_SWAGGER_REVISION_01);
		Animation.Add("ST_SITTING_SING_SONG_DRUNK_INTO",			ANIM_BANDIT_SITTING_SING_SONG_DRUNK_INTO_01);
		Animation.Add("ST_SITTING_SING_SONG_DRUNK_LOOP",			ANIM_BANDIT_SITTING_SING_SONG_DRUNK_LOOP_01);
		Animation.Add("ST_SITTING_SING_SONG_DRUNK_OUTOF",			ANIM_BANDIT_SITTING_SING_SONG_DRUNK_OUTOF_01);
		Animation.Add("ST_TELLING_OFF_ANOTHER_DRUNK_GIVING",		ANIM_BANDIT_DRUNK_TELLING_OFF_GIVING_01);
		Animation.Add("ST_TELLING_OFF_ANOTHER_DRUNK_RECEIVING",		ANIM_BANDIT_DRUNK_TELLING_OFF_RECEIVING_01);
		Animation.Add("ST_CHICKEN_COOKING_INTO",					ANIM_BANDIT_CHICKEN_COOKING_INTO_01);	
		Animation.Add("ST_CHICKEN_COOKING_LOOP",					ANIM_BANDIT_CHICKEN_COOKING_LOOP_01);	
		Animation.Add("ST_CHICKEN_COOKING_OUTOF",					ANIM_BANDIT_CHICKEN_COOKING_OUTOF_01);
		Animation.Add("ST_CHICKEN_EATING_INTO",						ANIM_BANDIT_CHICKEN_EATING_INTO_01);
		Animation.Add("ST_CHICKEN_EATING_LOOP",						ANIM_BANDIT_CHICKEN_EATING_LOOP_01);
		Animation.Add("ST_CHICKEN_EATING_OUTOF",					ANIM_BANDIT_CHICKEN_EATING_OUTOF_01);
		Animation.Add("ST_STOOD_PUSHING_ANOTHER_ON_FLOOR",			ANIM_BANDIT_STOOD_PUSHING_ANOTHER_ON_FLOOR);
		Animation.Add("ST_SAT_ON_FLOOR_BEING_PUSHED",				ANIM_BANDIT_SIT_ON_FLOOR_BEING_PUSHED);
		Animation.Add("ST_MAKING_PLANS_ON_FLOOR_WITH_SWORD_INTO",	ANIM_BANDIT_PLANS_MAKING_ON_FLOOR_WITH_SWORD_INTO_01);
		Animation.Add("ST_MAKING_PLANS_ON_FLOOR_WITH_SWORD_LOOP",	ANIM_BANDIT_PLANS_MAKING_ON_FLOOR_WITH_SWORD_LOOP_01);
		Animation.Add("ST_MAKING_PLANS_ON_FLOOR_WITH_SWORD_OUTOF",	ANIM_BANDIT_PLANS_MAKING_ON_FLOOR_WITH_SWORD_OUTOF_01);
		Animation.Add("ST_LISTENING_TO_PLANS_INTO",					ANIM_BANDIT_PLANS_LISTENING_INTO_01);
		Animation.Add("ST_LISTENING_TO_PLANS_LOOP",					ANIM_BANDIT_PLANS_LISTENING_LOOP_01);
		Animation.Add("ST_LISTENING_TO_PLANS_BREAKDOWN",			ANIM_BANDIT_PLANS_LISTENING_BREAKDOWN_01);	
		Animation.Add("ST_LISTENING_TO_PLANS_BREAKDOWN",			ANIM_BANDIT_PLANS_LISTENING_BREAKDOWN_02);		
		Animation.Add("ST_LISTENING_TO_PLANS_OUTOF",				ANIM_BANDIT_PLANS_LISTENING_OUTOF_01);		
		Animation.Add("ST_TELLING_OFF_ANOTHER_DRUNK_GIVING",		ANIM_BANDIT_DRUNK_TELLING_OFF_GIVING_01);
		Animation.Add("ST_TELLING_OFF_ANOTHER_DRUNK_RECEIVING",		ANIM_BANDIT_DRUNK_TELLING_OFF_RECEIVING_01);
		Animation.Add("ST_CHICKEN_COOKING_INTO",					ANIM_BANDIT_CHICKEN_COOKING_INTO_01);	
		Animation.Add("ST_CHICKEN_COOKING_LOOP",					ANIM_BANDIT_CHICKEN_COOKING_LOOP_01);	
		Animation.Add("ST_CHICKEN_COOKING_OUTOF",					ANIM_BANDIT_CHICKEN_COOKING_OUTOF_01);
		Animation.Add("ST_CHICKEN_EATING_INTO",						ANIM_BANDIT_CHICKEN_EATING_INTO_01);
		Animation.Add("ST_CHICKEN_EATING_LOOP",						ANIM_BANDIT_CHICKEN_EATING_LOOP_01);
		Animation.Add("ST_CHICKEN_EATING_OUTOF",					ANIM_BANDIT_CHICKEN_EATING_OUTOF_01);
		Animation.Add("ST_STOOD_PUSHING_ANOTHER_ON_FLOOR",			ANIM_BANDIT_STOOD_PUSHING_ANOTHER_ON_FLOOR);
		Animation.Add("ST_SAT_ON_FLOOR_BEING_PUSHED",				ANIM_BANDIT_SIT_ON_FLOOR_BEING_PUSHED);
		Animation.Add("ST_MAKING_PLANS_ON_FLOOR_WITH_SWORD_INTO",	ANIM_BANDIT_PLANS_MAKING_ON_FLOOR_WITH_SWORD_INTO_01);
		Animation.Add("ST_MAKING_PLANS_ON_FLOOR_WITH_SWORD_LOOP",	ANIM_BANDIT_PLANS_MAKING_ON_FLOOR_WITH_SWORD_LOOP_01);
		Animation.Add("ST_MAKING_PLANS_ON_FLOOR_WITH_SWORD_OUTOF",	ANIM_BANDIT_PLANS_MAKING_ON_FLOOR_WITH_SWORD_OUTOF_01);
		Animation.Add("ST_LISTENING_TO_PLANS_INTO",					ANIM_BANDIT_PLANS_LISTENING_INTO_01);
		Animation.Add("ST_LISTENING_TO_PLANS_LOOP",					ANIM_BANDIT_PLANS_LISTENING_LOOP_01);
		Animation.Add("ST_LISTENING_TO_PLANS_BREAKDOWN",			ANIM_BANDIT_PLANS_LISTENING_BREAKDOWN_01);	
		Animation.Add("ST_LISTENING_TO_PLANS_BREAKDOWN",			ANIM_BANDIT_PLANS_LISTENING_BREAKDOWN_02);		
		Animation.Add("ST_LISTENING_TO_PLANS_OUTOF",				ANIM_BANDIT_PLANS_LISTENING_OUTOF_01);
		Animation.Add("ST_DICEGAME_WATCHING_INTO",					ANIM_BANDIT_DICEGAME_WATCHING_INTO_01);
		Animation.Add("ST_DICEGAME_WATCHING_OUTOF",					ANIM_BANDIT_DICEGAME_WATCHING_OUTOF_01);
		Animation.Add("ST_DICEGAME_PICKING_DICE",					ANIM_BANDIT_DICEGAME_PICKING_DICE_01);
		Animation.Add("ST_DICEGAME_PLAYING",						ANIM_BANDIT_DICEGAME_PLAYING_01);
		Animation.Add("ST_DICEGAME_PLAYING_LOSE",					ANIM_BANDIT_DICEGAME_PLAYING_LOSE_01);
		Animation.Add("ST_DICEGAME_PLAYING_WIN",					ANIM_BANDIT_DICEGAME_PLAYING_WIN_01);
		Animation.Add("ST_DICEGAME_PLAYING_THROW",					ANIM_BANDIT_DICEGAME_PLAYING_THROW_01);
		Animation.Add("ST_SITTING_TAKE_BOTTLE_FROM_POCKET",			ANIM_BANDIT_SITTING_TAKE_BOTTLE_FROM_POCKET_01);
		Animation.Add("ST_SITTING_PASSING_BOTTLE",					ANIM_BANDIT_SITTING_PASSING_BOTTLE_01);
		Animation.Add("ST_SITTING_TAKING_BOTTLE",					ANIM_BANDIT_SITTING_TAKING_BOTTLE_01);
		Animation.Add("ST_SITTING_THROW_BOTTLE_AWAY",				ANIM_BANDIT_SITTING_THROW_BOTTLE_AWAY_01);
		Animation.Add("ST_SITTING_DRINKING_LOOP",					ANIM_BANDIT_SITTING_DRINKING_LOOP_01);
		Animation.Add("ST_PISSING",									ANIM_BANDIT_PISSING_01);
		Animation.Add("ST_PUKING",									ANIM_BANDIT_PUKING_01);
		Animation.Add("ST_DRUNK_LEANING_INTO",						ANIM_BANDIT_DRUNK_LEANING_INTO_01);
		Animation.Add("ST_DRUNK_LEANING_LOOP",						ANIM_BANDIT_DRUNK_LEANING_LOOP_01);
		Animation.Add("ST_DRUNK_LEANING_OUTOF",						ANIM_BANDIT_DRUNK_LEANING_OUTOF_01);
		Animation.Add("ST_DRUNK_LEANING_INTO",						ANIM_BANDIT_DRUNK_LEANING_INTO_02);
		Animation.Add("ST_DRUNK_LEANING_LOOP",						ANIM_BANDIT_DRUNK_LEANING_LOOP_02);
		Animation.Add("ST_DRUNK_LEANING_OUTOF",						ANIM_BANDIT_DRUNK_LEANING_OUTOF_02);
		Animation.Add("ST_TAUNT_HERO_KO",							ANIM_BANDIT_TAUNT_HERO_KO_01);	
		Animation.Add("ST_BEG_INTO",								ANIM_BANDIT_BEG_INTO_01);
		Animation.Add("ST_BEG_LOOP",								ANIM_BANDIT_BEG_LOOP_01);
		Animation.Add("ST_BEG_OUTOF",								ANIM_BANDIT_BEG_OUTOF_01);
		Animation.Add("ST_BEG_INTO_DIE",							ANIM_BANDIT_BEG_INTO_DIE_01);
		
		Animation.StartGroup("CONVERSATION_HAPPY");
			Animation.Add("DEFAULT", ANIM_BANDIT_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_BANDIT_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_BELLIGERENT");
			Animation.Add("DEFAULT", ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_ANGRY");
			Animation.Add("DEFAULT", ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE", ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_FEAR");
			Animation.Add("DEFAULT", ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_IDLE", ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_SAD");
			Animation.Add("DEFAULT", ANIM_BANDIT_CONVERSATION_SAD_BASE_01);
			Animation.Add("ST_IDLE", ANIM_BANDIT_CONVERSATION_SAD_BASE_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_01);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_02);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_03);
			Animation.Add("CONV_GENERAL", ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_04);
		Animation.EndGroup();

		Animation.Add("ST_BUMP_INTO",								ANIM_BANDIT_BUMP_INTO_01);

		Animation.Add("ST_EXECUTIONER_BEHEAD",						ANIM_BANDIT_EXECUTIONER_BEHEAD_01);
		
		Animation.Add("ST_DECAPITATED",								ANIM_BANDIT_DECAPITATED_01);		
		Animation.Add("ST_STUNNED_IDLE",							ANIM_BIPED_BANDIT_STUNNED_IDLE);		

		Animation.StartGroup("DRUNK");
			Animation.Add("ST_WALK",				ANIM_BANDIT_DRUNKEN_WALK_01);
			Animation.Add("ST_WALK",				ANIM_BANDIT_DRUNKEN_WALK_02);
			Animation.Add("ST_SLOW_WALK",			ANIM_BANDIT_DRUNKEN_WALK_01);
			Animation.Add("ST_SLOW_WALK",			ANIM_BANDIT_DRUNKEN_WALK_02);
			Animation.Add("ST_IDLE",				ANIM_BANDIT_STOOD_SING_SONG_DRUNK_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_DRUNKEN_IDLE_01);
		Animation.EndGroup();

		Animation.Add("ST_WAVE_SPECIAL_01",				ANIM_BANDIT_WAVE_SPECIAL_01);
		Animation.Add("ST_WAVE_SPECIAL_02",				ANIM_BANDIT_WAVE_SPECIAL_02);

		Animation.StartGroup("HANDS_BOUND");
			Animation.Add("ST_IDLE",					ANIM_BANDIT_HOSTAGE_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_BANDIT_HOSTAGE_IDLE_01);
			Animation.Add("ST_WALK",					ANIM_BANDIT_HOSTAGE_WALK_01);
			Animation.Add("ST_RUN",						ANIM_BANDIT_HOSTAGE_WALK_01);
		Animation.EndGroup();

		Animation.Add("ST_BEING_EATEN",					ANIM_BANDIT_BEING_EATEN_01);

		Animation.Add("ST_TAUNT",						ANIM_BANDIT_TAUNTING_01);
		Animation.Add("ST_UNPERTURBED_GESTURE",			ANIM_BANDIT_UNPERTURBED_GESTURE_01);
		Animation.Add("ST_UNPERTURBED_INTO",			ANIM_BANDIT_UNPERTURBED_INTO_01);
		Animation.Add("ST_UNPERTURBED_LOOP",			ANIM_BANDIT_UNPERTURBED_LOOP_01);
		Animation.Add("ST_UNPERTURBED_OUTOF",			ANIM_BANDIT_UNPERTURBED_OUTOF_01);
		Animation.Add("ST_WOUND_UP",					ANIM_BANDIT_WOUND_UP_01);

	//	WE NEED TO CREATE "GUARD POSITION" GROUPS FOR THESE
		Animation.Add("ST_GUARD_POSITION_INTO",				ANIM_BANDIT_GUARD_POSITION_INTO_01);
		Animation.Add("ST_GUARD_POSITION_INTO",				ANIM_BANDIT_GUARD_POSITION_INTO_02);
		Animation.Add("ST_GUARD_POSITION_CYCLE",			ANIM_BANDIT_GUARD_POSITION_CYCLE_01);
		Animation.Add("ST_GUARD_POSITION_CYCLE",			ANIM_BANDIT_GUARD_POSITION_CYCLE_02);
		Animation.Add("ST_GUARD_POSITION_OUT",				ANIM_BANDIT_GUARD_POSITION_OUT_OF_01);
		Animation.Add("ST_GUARD_POSITION_OUT",				ANIM_BANDIT_GUARD_POSITION_OUT_OF_02);
		Animation.Add("ST_CROSSBOW_GUARD_POSITION_INTO",	ANIM_BANDIT_CROSSBOW_GUARD_POSITION_INTO_01);
		Animation.Add("ST_CROSSBOW_GUARD_POSITION_IDLE",	ANIM_BANDIT_CROSSBOW_GUARD_POSITION_IDLE_01);
		Animation.Add("ST_CROSSBOW_GUARD_POSITION_OUT",		ANIM_BANDIT_CROSSBOW_GUARD_POSITION_OUTOF_01);
	//	WE NEED TO CREATE "GUARD POSITION" GROUPS FOR THESE

		Animation.StartGroup("SLEEP_FLOOR_BED");	
			Animation.Add("ST_SEATED_SLEEP_ON_FLOOR_INTO",	ANIM_BANDIT_SEATED_FLOOR_SLEEP_INTO_01);
			Animation.Add("ST_SEATED_SLEEP_ON_FLOOR_IDLE",	ANIM_BANDIT_SEATED_SLEEP_IDLE_01);
			Animation.Add("ST_SEATED_SLEEP_ON_FLOOR_OUTOF",	ANIM_BANDIT_SEATED_FLOOR_SLEEP_OUT_01);
						
			// for compliance with the anim names in floor beds' CTCBedDef (matches lying down sleeping names in villager tpl)
			Animation.Add("ST_GET_IN_FLOOR_BED",			ANIM_BANDIT_SIT_TO_SLEEP_ON_FLOOR_01);
			Animation.Add("ST_SLEEPING_IN_FLOOR_BED",		ANIM_BANDIT_SLEEP_FLOOR_IDLE_01);
			Animation.Add("ST_GET_OUT_OF_FLOOR_BED",		ANIM_BANDIT_SLEEP_FLOOR_GET_UP_01);
			// was using sit sleeping anims temporarily, until movement was removed from lying sleeping anims
			//Animation.Add("ST_GET_IN_FLOOR_BED",			ANIM_BANDIT_SEATED_FLOOR_SLEEP_INTO_01);
			//Animation.Add("ST_SLEEPING_IN_FLOOR_BED",		ANIM_BANDIT_SEATED_SLEEP_IDLE_01);
			//Animation.Add("ST_GET_OUT_OF_FLOOR_BED",		ANIM_BANDIT_SEATED_FLOOR_SLEEP_OUT_01);
		Animation.EndGroup();


		
		Animation.Add("STANDARD_TALK_IDLE",			ANIM_BIPED_BANDIT_TALK_IDLE_01, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("STANDARD_TALK_IDLE",			ANIM_BIPED_BANDIT_TALK_IDLE_02, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("STANDARD_TALK_IDLE",			ANIM_BIPED_BANDIT_TALK_IDLE_03, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("STANDARD_TALK_IDLE",			ANIM_BIPED_BANDIT_TALK_IDLE_04, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("STANDARD_TALK_IDLE",			ANIM_BIPED_BANDIT_TALK_IDLE_05);
		Animation.Add("STANDARD_TALK_ANGER",		ANIM_BIPED_BANDIT_ANGRY);
		Animation.Add("STANDARD_TALK_GLEE",			ANIM_BIPED_BANDIT_ANGRY);
		Animation.Add("ST_WALK",					ANIM_BANDIT_WALK_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_WALK",					ANIM_BANDIT_WALK_02, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_WALK",					ANIM_BANDIT_WALK_03, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		//Animation.Add("ST_RUN",						ANIM_BANDIT_RUN_WITH_SWORD_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_RUN",						ANIM_BIPED_BANDIT_RUN, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_HEAD_TURN_H",				ANIM_BIPED_BANDIT_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_HEAD_TURN_V",				ANIM_BIPED_BANDIT_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("DEFAULT_FACE",				BANDIT_FACE_NEUTRAL_OVERRIDE);

		Animation.Add("STRAFE_IDLE",				ANIM_BANDIT_COMBAT_IDLE_1_1);
		Animation.Add("STRAFE_MOVEMENT_LEFT",		ANIM_BANDIT_MOVEMENT_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",		ANIM_BANDIT_MOVEMENT_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",		ANIM_BANDIT_MOVEMENT_STRAFE_BACK_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",	ANIM_BANDIT_MOVEMENT_STRAFE_FRONT_01);

	    Animation.Add("BLOCK_IDLE",					ANIM_BANDIT_BLOCK_IDLE_01);

		Animation.Add("HALT",						ANIM_BANDIT_HALT_01, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ALARM",						ANIM_BANDIT_RAISE_ALARM_01);
		Animation.Add("COCKY",						ANIM_BIPED_BANDIT_COCKY, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("SALUTE",						ANIM_BIPED_BANDIT_SALUTE, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));

		Animation.Add("WHATS_THAT",					ANIM_BANDIT_WHATS_THAT_01, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("NOD_OFF_01",					ANIM_BIPED_BANDIT_NOD_OFF_01, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("NOD_OFF_02",					ANIM_BIPED_BANDIT_NOD_OFF_02, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("LIGHT_TORCH",				ANIM_BANDIT_LIGHT_TORCH_01);
		Animation.Add("ST_LIGHT_LAMP",				ANIM_BANDIT_LIGHT_LAMP_01);
		
		// TODO: Ensure that this is the right animation for lighting the torches in the bandit village
		Animation.StartGroup("BANDITCAMP");
			Animation.Add("LIGHT_LAMP",				ANIM_BANDIT_LIGHT_LAMP_01);
		Animation.EndGroup();
		
		Animation.Add("ST_THREATEN",				ANIM_BANDIT_THREATEN_01);
		Animation.Add("ST_THREATEN",				ANIM_BANDIT_THREATEN_02);
		Animation.Add("ST_THREATEN",				ANIM_BANDIT_THREATEN_03);
		
		Animation.Add("ST_CROSSBOW_WAKE_KO_KICK",	ANIM_BANDIT_CROSSBOW_WAKE_KO_KICK_01);
		Animation.Add("ST_CROSSBOW_GREET",			ANIM_BANDIT_CROSSBOW_GREET_01);
		Animation.Add("ST_CROSSBOW_HALT",			ANIM_BANDIT_CROSSBOW_HALT_01);
		Animation.Add("ST_CROSSBOW_SALUTE",			ANIM_BANDIT_CROSSBOW_SALUTE_01);
		Animation.Add("ST_CROSSBOW_RAISE_ALARM",	ANIM_BANDIT_CROSSBOW_RAISE_ALARM_01);

		Animation.Add("ST_PICK_UP_GENERIC_BOX",		ANIM_BANDIT_FLAT_CRATE_LIFT_01);
		Animation.StartGroup("CARRYING_GENERIC_BOX");
			Animation.Add("ST_IDLE",				ANIM_BANDIT_FLAT_CRATE_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_FLAT_CRATE_IDLE_01);
			Animation.Add("ST_STAND",				ANIM_BANDIT_FLAT_CRATE_IDLE_01);
			Animation.Add("ST_RUN",					ANIM_BANDIT_FLAT_CRATE_JOG_01);
			Animation.Add("ST_WALK",				ANIM_BANDIT_FLAT_CRATE_JOG_01);
			Animation.Add("ST_HOLD_BOX_PUT_DOWN",	ANIM_BANDIT_FLAT_CRATE_PUT_DOWN_01);
		Animation.EndGroup();

		Animation.StartGroup("SIT_FLOOR");
			Animation.Add("ST_SIT_ON_FLOOR",		ANIM_BANDIT_SIT_ON_FLOOR_01);
			Animation.Add("ST_SITTING",				ANIM_BANDIT_SEATED_FLOOR_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_SEATED_FLOOR_IDLE_01);
			Animation.Add("ST_IDLE",				ANIM_BANDIT_SEATED_FLOOR_IDLE_01);
			Animation.Add("ST_STAND_UP_FROM_FLOOR",	ANIM_BANDIT_SEATED_FLOOR_GET_UP_01);
		Animation.EndGroup();

		Animation.Add("TURNING_AC90",				ANIM_BANDIT_TURN_90_LEFT_01);
		Animation.Add("TURNING_C90",				ANIM_BANDIT_TURN_90_RIGHT_01);
		Animation.Add("TURNING_AC180",				ANIM_BANDIT_TURN_180_LEFT_01);
		Animation.Add("TURNING_C180",				ANIM_BANDIT_TURN_180_RIGHT_01);

	// CUT SCENE ANIMATION START
		Animation.Add("SCRIPT_SHOUT",						ANIM_BANDIT_BOAST_SHOUT_01);
		Animation.Add("CS_WALK_BACKWARDS_01",				CS_BANDITCAMP_BANDIT_WALK_BACKWARDS_01);
		Animation.Add("CS_WALK_BACKWARD_CHEERING_01",		CS_BANDITCAMP_BANDIT_WALK_BACKWARD_CHEERING_01,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_WALK_BACKWARD_CHEERING_02",		CS_BANDITCAMP_BANDIT_WALK_BACKWARD_CHEERING_02,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_KILLED_BY_MAZE",					CS_OAKVALE_DEAD_DAD_BANDIT_KILLED_BY_MAZE,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_POINT",							CS_BANDIT_INTRO_OF_JOB_GUARD_POINT,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_COCKY",							ANIM_BIPED_BANDIT_COCKY,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_LOOK_AROUND",						ANIM_BANDIT_WHATS_THAT_01, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("CS_HOLD_SWORD",						ANIM_BANDIT_IDLE_05,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_IDLE_SUBTLE",						ANIM_BANDIT_IDLE_01);

		Animation.Add("CS_HAPPY_TALK_LOOP",					ANIM_BANDIT_CONVERSATION_HAPPY_BASE_01);
		Animation.Add("CS_HAPPY_TALK_BREAK1",				ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_01);
		Animation.Add("CS_HAPPY_TALK_BREAK2",				ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_02);
		Animation.Add("CS_HAPPY_TALK_BREAK3",				ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_03);
		Animation.Add("CS_HAPPY_TALK_BREAK4",				ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.Add("CS_HAPPY_TALK_POINTS",				CS_HAPPY_TALK_POINTS);

		Animation.Add("CS_CONV_SCARED_LOOP",				ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
		Animation.Add("CS_CONV_SCARED_BR1",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_01);
		Animation.Add("CS_CONV_SCARED_BR2",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_02);
		Animation.Add("CS_CONV_SCARED_BR3",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_03);
		Animation.Add("CS_CONV_SCARED_BR4",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_04);
		
		Animation.Add("CS_BANDIT_POINTING_BEHIND",			CS_BANDIT_POINTING_BEHIND);
		
		Animation.Add("CS_BANDIT_STRAFE_BACK",				CS_BANDIT_STRAFE_BACK);

		Animation.StartGroup("CUTSCENE");
			Animation.Add("ST_IDLE",						ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_RUN",							ANIM_BIPED_BANDIT_RUN, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.EndGroup();

		
	// CUT SCENE ANIMATION END

	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.AddCombat("SCRIPT_JUMP_FROM_CHEST",	ANIM_BANDIT_JUMP_BUSH_RIGHT_01);
		/////////////////////////////////////////////////////
		Animation.AddCombat("BLOCK_FRONT_RESPONSE",		ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_LEFT_RESPONSE",		ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",		ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_BACK_RESPONSE",		ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_START",				ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_FINISH",				ANIM_BANDIT_BLOCK_1);
		
		Animation.AddCombat("BLOCK_COUNTER_ATTACK",			ANIM_BANDIT_BLOCK_COUNTER_ATTACK_01);

	    Animation.AddCombat("COUNTER_BLOCK_RECOIL",			ANIM_BANDIT_COUNTER_BLOCK_RECOIL_01);
		Animation.AddCombat("SPECIAL_RUN",					ANIM_BIPED_BANDIT_RUN);
//		Animation.AddCombat("SPECIAL_IDLE",					ANIM_BANDIT_COMBAT_IDLE_1_1); // ** this is the breathe idle and should NOT be used in combat **
		Animation.AddCombat("SPECIAL_IDLE",					ANIM_BANDIT_COMBAT_IDLE_1_2);
		Animation.AddCombat("SPECIAL_BOAST",				ANIM_BANDIT_BOAST_THREATEN_01);
		Animation.AddCombat("SPECIAL_BOAST",				ANIM_BANDIT_BOAST_SHOUT_01);
		/////////////////////////////////////////////////////
		
		Animation.AddCombat("MOVEMENT_LONG_BACK",			ANIM_BIPED_BANDIT_BACK_JUMP);
		Animation.AddCombat("MOVEMENT_LONG_FRONT",			ANIM_BIPED_BANDIT_RUN);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_LEFT",	ANIM_BANDIT_MOVEMENT_STRAFE_FRONT_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_RIGHT",	ANIM_BANDIT_MOVEMENT_STRAFE_FRONT_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_LEFT",	ANIM_BANDIT_MOVEMENT_STRAFE_BACK_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_RIGHT",	ANIM_BANDIT_MOVEMENT_STRAFE_BACK_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",		ANIM_BANDIT_MOVEMENT_STRAFE_FORWARD);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",		ANIM_BANDIT_JUMP_BACK_01);
		
		//////////////////////////////////////////////
		//first number in AddComboStage is the combo number (ie 0, to 1, to 2, to 3 etc...)
		//second number is a unique ID for a combo 
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_BANDIT_ATTACK_LEFT_1, Combo(0, 0), Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_BANDIT_ATTACK_LEFT_RECOIL_1)); //, StrikeSpeedMultiplier(0.01));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_BANDIT_ATTACK_RIGHT_1, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_BANDIT_ATTACK_RIGHT_RECOIL_1));
		Animation.AddCombat("STRIKE_SHORT_FRONT", ANIM_BANDIT_PUNCH_RIGHT_01, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_PUNCH_RIGHT_RECOIL_01));
		Animation.AddCombat("STRIKE_LONG_FRONT", ANIM_BANDIT_LUNGE_1, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_ATTACK_LEFT_RECOIL_1));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_UNBLOCKABLE", ANIM_BANDIT_ATTACK_UNBLOCKABLE_01);
		
		Animation.AddCombat("STRIKE_MEDIUM_SIDE", ANIM_BANDIT_ATTACK_LEFT_1, Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_MEDIUM_SIDE", ANIM_BANDIT_ATTACK_RIGHT_1, Handedness(HANDED_LEFT, HANDED_RIGHT));
		
		Animation.AddCombat("STRIKE_RECOIL", ANIM_BANDIT_ATTACK_LEFT_RECOIL_1, Handedness(HANDED_LEFT, HANDED_RIGHT));
		Animation.AddCombat("STRIKE_RECOIL", ANIM_BANDIT_ATTACK_RIGHT_RECOIL_LEFT_1, Handedness(HANDED_RIGHT, HANDED_LEFT));
			
		Animation.AddCombat("GENERATE_AMBUSH_LEFT",		ANIM_BANDIT_JUMP_BUSH_LEFT_01);
		Animation.AddCombat("GENERATE_AMBUSH_RIGHT",	ANIM_BANDIT_JUMP_BUSH_RIGHT_01);

		Animation.Add("PUSHED_FORWARD", ANIM_BANDIT_PUSHED_FORWARD_01, TransTime(0), Delay(0));
		Animation.Add("PUSHED_BACKWARD", ANIM_BANDIT_PUSHED_BACKWARD_01, TransTime(0), Delay(0));
	<\CAppearanceDef>

	<CCreatureDef>
		Stats.ExperienceWorth	10;
		Stats.RenownWorth		8;
		DialogueVoices.Add("LEV1BDT1");
		DialogueVoices.Add("LEV2BDT1");
		DialogueVoices.Add("LEV3BDT1");
	<\CCreatureDef>
	
	CreatureType			HUMAN_ADULT;
	Damage					1.0;

	DefaultOwner			2;
	
	<CPerceivedThingDef>
		FieldOfView							160;
		SightRadius							12;
		GiveUpChaseRadius					6;
		ExtendedSightRadius					18;
		SoundRadius							12;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						16.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
	<\CPerceivedThingDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("DRAIN_LIFE",		WILL_LEECH_VICTIM);
		SpecialEffects.Add("LAND_DUST",			IMPACT_DUST);
		SpecialEffects.Add("CS_BANDIT_HIT",		LIGHTNING_DUMMY_EFFECT_BANDIT);
//		SpecialEffects.Add("BANDIT_PISS",		BANDIT_PISSING);
	<\CSpecialEffectsDef>	

	GroupDef				G_CREATURES_BANDIT;

#end_definition

//*******************************************************************************************************************
#definition_template 	CREATURE 	CREATURE_BANDIT_BASE	 specialises CREATURE_BANDIT_SKELETON_COMMON_BASE

	Health 					12;
	PBrain					BRAIN_BANDIT_VILLAGER_BASE;
 	Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 		MESH_BANDIT_01;
	PrimaryMeleeWeaponDef	OBJECT_IRON_LONGSWORD;
	
	StunHealthThreshold 8;
	StunTimeMin			3;
	StunTimeMax			3;

	MaxWalkingSpeed 		0;
	MaxRunningSpeed 		0;
	
	<CPhysicsDef>
		Diameter			1.2;	// Changed by MikeD from 1.2
	<\CPhysicsDef>

	<CCreatureNavigationDef>
		Radius				0.3;
	<\CCreatureNavigationDef>

	<CEnemyDef>
		Faction				FACTION_BANDITS;
	<\CEnemyDef>
	
	<CSummonableCreatureDef>
		Rank								6;
		SummonedBrain						"BRAIN_SUMMONED_BANDIT_VILLAGER_BASE";
	<\CSummonableCreatureDef>

	Components.Add("CTCBandit");
	Components.Add("CTCGossip");
	Components.Add("CTCGold");

	CombatTypeDef			BANDIT_GRUNT_ATTACK_STYLE;
	
	<CTargetingDef>
		Type				TARGETING_TALKABLE | TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>

	<CCreatureDef>
		Stats.ExperienceWorth		12;
		Stats.RenownWorth			9;
		
		Stats.MoralityForKill		2;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		DialogueVoices.clear();
		DialogueVoices.Add("LEV1BDT1");
		DialogueVoices.Add("LEV2BDT1");
		DialogueVoices.Add("LEV3BDT1");
		OpinionSourceDef			OPINION_SOURCE_BANDIT;
		CreatureGroup				CREATURE_GROUP_BANDIT;
		
		RespawnWaitInDaysMin		4;
		RespawnWaitInDaysMax		6;

		AllowedInProtectedTowns		FALSE;
	<\CCreatureDef>
	
	Components.Add("CTCSolidToThing");

	Components.Add("CTCCreatureOpinionOfHero");
	<COpinionOfHeroDef>
		Personality			OPINION_PERSONALITY_BANDIT_LEVEL1;
		ReactionMask		OPINION_REACTION_MASK_BANDIT_LEVEL1;
		DeedMask			OPINION_DEED_MASK_BANDIT_LEVEL1;
		WillAttackCriminals	TRUE;
	<\COpinionOfHeroDef>
	
	<CDecapitationDef>
		Head				OBJECT_BANDIT_HEAD_DECAP_01;
		BodyParticleEffect	BLOOD_SPURT;
	<\CDecapitationDef>
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_BANDIT);
		HitLocations.Add(HIT_LOCATION_CREATURE_HEAD);
	<\CHitLocationsDef>

	EyeGraphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex	MESH_EYE_BLUE_DARK;
	EyeGraphic.RenderSizeX	1.21;
	CreatureType			HUMAN_ADULT;
	Damage					1.0;

	DefaultOwner			2;

	GroupDef				G_CREATURES_BANDIT;
	
//-------------------------------- Adam's remapped anim tags for opinion reactions -------------------------

	<CAppearanceDef>
		Animation.Add("ST_OPINION_APPROVAL_CHEERING_BOTH_ARMS_UP", ANIM_BANDIT_DICEGAME_PLAYING_WIN_01);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_ARMS_UP", ANIM_BIPED_BANDIT_ANGRY);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_NORMAL", ANIM_BANDIT_IDLE_01); //ANIM_BANDIT_CONV_HAPPY_LOOP_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_INTO", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_MALE_CHEER_INTO_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_LOOP", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_MALE_CHEER_LOOP_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_OUTOF", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_MALE_CHEER_OUT_01);
		Animation.Add("ST_OPINION_APPROVAL_REACTION_ARMS_WIDE_GREET", ANIM_BIPED_BANDIT_SALUTE, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_APPROVAL_WAVING_AT_DISTANCE", ANIM_BIPED_BANDIT_SALUTE, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_ATTRACTED_HANDS_CLASPED_SWAYING", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_ATTRACTED_02);
		Animation.Add("ST_OPINION_ATTRACTED_PREENING_SELF", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_ATTRACTED_01);
		Animation.Add("ST_OPINION_ATTRACTED_SHOUTING_AT", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_ATTRACTED_WAVING_AT", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_DISAPPROVAL_BOOING", ANIM_BANDIT_THREATEN_02);
		Animation.Add("ST_OPINION_DISAPPROVAL_CALLING_OVER_FOR_FIGHT", ANIM_BANDIT_THREATEN_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_DISMISSING_HAND_SWIPE", ANIM_BANDIT_THREATEN_02);
//		Animation.Add("ST_OPINION_DISAPPROVAL_NYAH_NYAH", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINT_AT", ANIM_BANDIT_CHALLENGE_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINTING_AWAY_GET_OUT", ANIM_BANDIT_HALT_01, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_DISAPPROVAL_SHAKE_FIST", ANIM_BANDIT_IDLE_01); //ANIM_BANDIT_CONV_ANGRY_INTO_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_STAMP_FOOT", ANIM_BANDIT_IDLE_01); //ANIM_BANDIT_CONV_ANGRY_INTO_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_THUMBS_DOWN", ANIM_BANDIT_THREATEN_03);
		Animation.Add("ST_OPINION_FEAR_IDLE_COWERING", ANIM_BANDIT_IDLE_01); //ANIM_BANDIT_CONV_SCARED_LOOP_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SHRINKING_AWAY", ANIM_BANDIT_IDLE_01); //ANIM_BANDIT_CONV_SCARED_INTO_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SURPRISED", ANIM_BANDIT_BEG_INTO_01);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_FRONT", ANIM_BANDIT_RUN_WITH_SWORD_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_UP", ANIM_BANDIT_RUN_WITH_SWORD_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_BANDIT_WALK_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_NEUTRAL_POINT_AT", ANIM_BANDIT_HELLO_02);
		Animation.Add("ST_OPINION_NEUTRAL_POINTING_CALLING_FRIEND", ANIM_BANDIT_LOOK_BEHIND_01);
		Animation.Add("ST_OPINION_NEUTRAL_REACTION_HAND_UP_GREET", ANIM_BANDIT_HELLO_01);
		Animation.Add("ST_OPINION_NEUTRAL_SHOUTING_WITH_HANDS_CUPPED", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_MALE_SHOUT_HANDS_01);
		Animation.Add("ST_OPINION_NEUTRAL_SURPRISE", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_);
		Animation.Add("ST_OPINION_NEUTRAL_WALK_NERVOUS_LOOKING_BACK", ANIM_BANDIT_WALK_02, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_OPINION_RIDICULE_BELLY_LAUGH", ANIM_BANDIT_POINTING_AT_LAUGHING_LOOP_01);
		Animation.Add("ST_OPINION_RIDICULE_POINT_AND_LAUGH", ANIM_BANDIT_POINTING_AT_LAUGHING_LOOP_01);
		Animation.Add("ST_OPINION_RIDICULE_SNIGGER", ANIM_BIPED_BANDIT_COCKY, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));

//		Animation.AddCombat("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_BANDIT_IDLE_01); //ANIM_VILLAGER_FEAR_WALK_02);
	<\CAppearanceDef>

	Components.Add("CTCIdleScheduler");
	<CIdleSchedulerDef>
		// Only the relative magnitudes of these values are significant.  Double a number to halve the frequency of the state
		Period[ISG_CLEAN_HOME]					39;
		Period[ISG_SIT_HOME]					36;
		Period[ISG_SIT_OUTSIDE]					92;
		Period[ISG_SIT_AROUND_FIRE]				33;
		Period[ISG_WATCH_FIRE]					21;
		Period[ISG_GAZE_HOME]					15;
		Period[ISG_GAZE_OUTSIDE]				61;
		Period[ISG_LOOK_AT_INTERESTING_THINGS]	98;
		Period[ISG_WANDER_AROUND_SHOPS]			79;
		Period[ISG_KID_WANDER_NEAR_KIDS]		55;
	<\CIdleSchedulerDef>

	Components.Add("CTCDrunkenness");
	<CDrunkennessDef>
		// DrunkennessThresholdMult	5.0;
		DrunkennessThresholdMult	2.0;
	<\CDrunkennessDef>
#end_definition

//*******************************************************************************************
#definition_template	CREATURE	CREATURE_RIVAL_HERO_BASE	specialises CREATURE_BANDIT_SKELETON_COMMON_BASE

	CombatTypeDef			HERO_RIVAL_01_ATTACK_STYLE;
	Components.Add("CTCHero");

	<CEnemyDef>
		Faction				FACTION_BANDITS;
	<\CEnemyDef>

	<CCreatureDef>
		CreatureGroup		CREATURE_GROUP_RIVAL_HERO;
	<\CCreatureDef>

	GroupDef				G_CREATURES_RIVAL_HERO;
	
#end_definition

//*******************************************************************************************
#definition_template 	CREATURE 	CREATURE_GUARD_BASE  specialises CREATURE_BANDIT_SKELETON_COMMON_BASE

	PBrain					BRAIN_GUARD;
	Sex						SEX_MALE;
	CreatureInteractionType	CREATURE_INTERACTION_NULL;

	Property				THING_CREATURE_PROPERTY_GUARD;
	
	CombatTypeDef			BOWERSTONE_GUARD_ATTACK_STYLE_BLUE;

	PrimaryMeleeWeaponDef		OBJECT_IRON_LONGSWORD;
	RangedWeaponDef				OBJECT_BANDIT_CROSSBOW;

	Graphic.RenderSizeX		1.0;
//	MaxWalkingSpeed 		0.0;
//	MaxRunningSpeed 		0.6;

	Components.Add("CTCCreatureOpinionOfHero");
	<COpinionOfHeroDef>
		Personality			OPINION_PERSONALITY_GUARD;
	<\COpinionOfHeroDef>

	GameStatePersisted		FALSE;
	CreateDummyOnDeath		TRUE;

	<CLookDef>
		DrawEyePrimitives	FALSE;
	<\CLookDef>	

	<CCreatureDef>
		DialogueVoices.clear();
		DialogueVoices.Add("LEV1GRD1");
		DialogueVoices.Add("LEV1GRD1");
		DialogueVoices.Add("LEV2GRD1");

		CreatureGroup		CREATURE_GROUP_GUARD;
		
		// Guards respawn after a few seconds rather than a few days
		RespawnWaitInDaysMin			0;
		RespawnWaitInDaysMax			0;
		RespawnWaitInFramesMin			100;
		RespawnWaitInFramesMax			200;	

		Stats.ExperienceWorth 			 12;
		Stats.RenownWorth 			 10;
		Stats.MoralityForKill			-12;
		Stats.MoralityForWeaponHit		-3;
		Stats.MoralityForPunch			-2;
		Inventory			INVENTORY_TYPE_MAIN;
	<\CCreatureDef>

	<CCreatureStatsDef>
		Speed								1.0;
		Dexterity							1.0;
	<\CCreatureStatsDef>
	
	Components.Add("CTCMoneyReceiver");
	Components.Add("CTCGuard");
	<CGuardDef>
		BribeCostWeaponOut		0;
		BribeCostTrespass		30;
		BribeCostVandalism		30;
		BribeCostShoplifter		50;
		BribeCostPickPocket		50;
		BribeCostAssault		100;
		BribeCostGBH			400;
		BribeCostMurder			10000;
	<\CGuardDef>

	<CAIScratchpadDef>
//		CombatNearbyBreakOffRange	2.5;
	<\CAIScratchpadDef>

	<CEnemyDef>
		Faction				FACTION_VILLAGERS;
	<\CEnemyDef>

	<CCarryingDef>
		AvailableCarrySlots.Add(CARRY_SLOT_PRIMARY_SHEATHE);
		AvailableCarrySlots.Add(CARRY_SLOT_SECONDARY_SHEATHE);
	<\CCarryingDef>

	Health						30;

	StunHealthThreshold			6;
	StunTimeMin					3;
	StunTimeMax					3;

	SpeedRandomisationFactor	0.1;

	MaxAcceleration 			0.1;
	<CLookDef>
		MaxTurnSpeed 				15.0;
	<\CLookDef>
	
	FOV 						90;

//	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type					TARGETING_TALKABLE | TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>
	
	IsWillable					TRUE;
	IsVulnerableToMelee			TRUE;
	IsIndestructible			FALSE;
	CreatureType				HUMAN_ADULT;

	NavigatorTypes.Add(NAV_INIT_GROUND);

	//Gluttony 					0;
	//SelfPreservation 			0;

	Damage						1.0;

	<CPerceivedThingDef>
		FieldOfView							160;
		SightRadius							20;
		SoundRadius							15;
		SmellRadius							0;
		AwarenessTimer						17.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
	<\CPerceivedThingDef>
	
	<CDecapitationDef>
		Head				OBJECT_BS_GUARD_HEAD_DECAP_01;
		BodyParticleEffect	BLOOD_SPURT;
	<\CDecapitationDef>


	<CAppearanceDef>
	
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_BANDIT_LEFT_NORMAL_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_BANDIT_RIGHT_NORMAL_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_BANDIT_BACK_NORMAL_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_BANDIT_RIGHT_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_BANDIT_LEFT_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_BANDIT_COMBAT_KNOCKDOWN_RECOVER_1_2);
		
		Animation.AddCombat("FALL_DEAD",								ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1); //need replacing
		Animation.AddCombat("FALL_UNCONSCIOUS",							ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1); //need replacing
		//this is the complete set of anims for guards and all who derive from guards
        Animation.AddCombat("BLOCK_FRONT_RESPONSE",						ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("MOVEMENT_LONG_BACK",						ANIM_BIPED_BANDIT_BACK_JUMP);
		Animation.AddCombat("MOVEMENT_LONG_FRONT",						ANIM_BIPED_BANDIT_RUN);
		Animation.AddCombat("SPECIAL_RUN",								ANIM_BIPED_BANDIT_RUN);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_LEFT",				ANIM_BANDIT_MOVEMENT_STRAFE_FRONT_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_RIGHT",				ANIM_BANDIT_MOVEMENT_STRAFE_FRONT_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_LEFT",				ANIM_BANDIT_MOVEMENT_STRAFE_BACK_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_RIGHT",				ANIM_BANDIT_MOVEMENT_STRAFE_BACK_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",					ANIM_BANDIT_MOVEMENT_STRAFE_FORWARD);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",					ANIM_BANDIT_JUMP_BACK_01);
		Animation.AddCombat("SPECIAL_IDLE",								ANIM_BANDIT_COMBAT_IDLE_1_1); // ** this is the breathe idle and should NOT be used in combat **
		Animation.AddCombat("SPECIAL_IDLE",								ANIM_BANDIT_COMBAT_IDLE_1_2);
		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//first number in AddComboStage is the combo number (ie 0, to 1, to 2, to 3 etc...)
		//second number is a unique ID for a combo 
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",				ANIM_BANDIT_ATTACK_LEFT_1, Combo(0, 0), Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_ATTACK_LEFT_RECOIL_1));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",				ANIM_BANDIT_ATTACK_RIGHT_1, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_BANDIT_ATTACK_RIGHT_RECOIL_1));
		Animation.AddCombat("STRIKE_SHORT_FRONT",				ANIM_BANDIT_PUNCH_RIGHT_01, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_PUNCH_RIGHT_RECOIL_01));
		Animation.AddCombat("STRIKE_LONG_FRONT",				ANIM_BANDIT_LUNGE_1, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_ATTACK_LEFT_RECOIL_1));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_UNBLOCKABLE",	ANIM_BANDIT_ATTACK_UNBLOCKABLE_01);
	<\CAppearanceDef>

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//the complete set of generic responses and dead and stunned etc idles
	//all enemy bandit skeletoned creatures should use this
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////

	<CAppearanceDef>
		Animation.StartGroup("BOWERSTONE");
			Animation.Add("LIGHT_LAMP",						ANIM_BANDIT_LIGHT_LAMP_01);
		Animation.EndGroup();
		Animation.StartGroup("BANDITCAMP");
			Animation.Add("LIGHT_LAMP",						ANIM_BANDIT_LIGHT_LAMP_01);
		Animation.EndGroup();
		Animation.StartGroup("GENERIC");
			Animation.Add("LIGHT_LAMP",						ANIM_BANDIT_LIGHT_LAMP_01);
		Animation.EndGroup();

		Animation.StartGroup("GENERIC");
			Animation.Add("ST_RUN",							ANIM_BIPED_RANDOM_GUARD_ATTACK_RUN);
		Animation.EndGroup();

		Animation.Add("DEFAULT",							ANIM_BANDIT_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_WALK",							ANIM_BANDIT_WALK_01);
		Animation.Add("ST_SLOW_WALK",						ANIM_BIPED_RANDOM_GUARD_SLOW_WALK);
		//Animation.Add("ST_RUN",							ANIM_BANDIT_RUN_WITH_SWORD_01);
		Animation.Add("ST_RUN",								ANIM_BIPED_BANDIT_RUN);
		Animation.Add("STANDARD_YAWN",						ANIM_BANDIT_YAWN_01); 
		Animation.Add("STANDARD_SCARED",					ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
		Animation.Add("STANDARD_WAVE",						ANIM_BANDIT_HELLO_01);
		Animation.Add("STANDARD_WAVE_INFO",					ANIM_BANDIT_HELLO_01);
		Animation.Add("STANDARD_POINT",						ANIM_BANDIT_POINT_01);

//		Animation.Add("ST_HEAD_TURN_H",					ANIM_BIPED_BANDIT_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));
//		Animation.Add("ST_HEAD_TURN_V",					ANIM_BIPED_BANDIT_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));

		Animation.Add("HALT",							ANIM_BANDIT_HALT_01);
		Animation.Add("ALARM",							ANIM_BANDIT_RAISE_ALARM_01);
		Animation.Add("WHATS_THAT",						ANIM_BANDIT_WHATS_THAT_01);
		Animation.Add("ST_LIGHT_LAMP",					ANIM_BANDIT_LIGHT_LAMP_01);
		Animation.Add("WAKE_UNCONSCIOUS_PERSON",		ANIM_BANDIT_WAKE_KO_KICK_01);
		
		Animation.Add("AGGRESSIVE_POINTING",			ANIM_GUARD_AGGRESSIVE_POINTING_01);
		Animation.Add("GETTING_SHOUTED_AT",				ANIM_GUARD_GETTING_SHOUTED_AT_01);
		Animation.Add("INSPECTING",						ANIM_GUARD_INSPECTING_01);
		Animation.Add("SALUTE_STAND_TO_ATTENTION_INTO",	ANIM_GUARD_SALUTE_STAND_TO_ATTENTION_INTO_01);
		Animation.Add("SALUTE_STAND_TO_ATTENTION_LOOP",	ANIM_GUARD_SALUTE_STAND_TO_ATTENTION_LOOP_01);
		Animation.Add("SALUTE_STAND_TO_ATTENTION_OUTOF",ANIM_GUARD_SALUTE_STAND_TO_ATTENTION_OUTOF_01);
		Animation.Add("SHOUTING_AGGRESSIVELY",			ANIM_GUARD_SHOUTING_AGGRESSIVELY_01);
		Animation.Add("SHOUTING_AT_GUARD",				ANIM_GUARD_SHOUTING_AT_GUARD_01);
		Animation.Add("TAKING_BRIBE_ENOUGH",			ANIM_GUARD_TAKING_BRIBE_ENOUGH_01);
		Animation.Add("TAKING_BRIBE_INTO",				ANIM_GUARD_TAKING_BRIBE_INTO_01);
		Animation.Add("TAKING_BRIBE_LOOP",				ANIM_GUARD_TAKING_BRIBE_LOOP_01);
		Animation.Add("TAKING_BRIBE_NOT_ENOUGH",		ANIM_GUARD_TAKING_BRIBE_NOT_ENOUGH_01);
		Animation.Add("WALK_CYCLE_LOOK_AROUND",			ANIM_GUARD_WALK_CYCLE_LOOK_AROUND_01);
		
		Animation.Add("GENERATE_DROP",					ANIM_VILLAGER_UPRIGHT_SNEAK_POSE);

	<\CAppearanceDef>

	GroupDef					G_CREATURES_BOWERSTONE;

	<CTurncoatDef>
		Turncoatable						BTRUE;
	<\CTurncoatDef>	
	
	<CContainerRewardHeroDef>
		ObjectFamilies.Add("REWARD_GUARD_01");
	<\CContainerRewardHeroDef>
	
#end_definition

//*******************************************************************************************************************
#definition_template	CREATURE	CREATURE_OK_UNDEAD_TEMPLATE			specialises CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE

	Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;
	
	<CEntitySoundDef>
		SoundIdentifier		"SI_UNDEAD";
	<\CEntitySoundDef>

	PBrain					BRAIN_UNDEAD;
	
	AbleToStrafe			TRUE;
	LeaveDeadCreature		FALSE;
	
	<CPerceivedThingDef>
		FieldOfView							120;
		SightRadius							12;
		ExtendedSightRadius					15;
		SoundRadius							10;
		DayTimeVisibilityMultiplier			0.8;
		NightTimeVisibilityMultiplier		1.0;
		AwarenessTimer						8.0;
	<\CPerceivedThingDef>
	
	<CLookDef>
		DrawEyePrimitives	FALSE;
	<\CLookDef>
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_UNDEAD);
	<\CHitLocationsDef>

	<CCreatureModeDef>
		DefaultCreatureMode	MODE_STAND;
	<\CCreatureModeDef>
	
	<CCreatureDef>
		Stats.ExperienceWorth 18;
		Stats.RenownWorth 8;

		Stats.MoralityForKill		2;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		OpinionSourceDef	OPINION_SOURCE_INANIMATE_EVIL_HIGH;
		CreatureGroup		CREATURE_GROUP_UNDEAD;
	<\CCreatureDef>
	
	<CAppearanceDef>
		Animation.AddCombat("RISE_UP",						ANIM_UNDEAD_RISE_01,	Flags(ANIM_FLAG_PRELOAD));
		Animation.AddCombat("RISE_UP",						ANIM_UNDEAD_RISE_02,	Flags(ANIM_FLAG_PRELOAD));
		Animation.AddCombat("RISE_UP",						ANIM_UNDEAD_RISE_03,	Flags(ANIM_FLAG_PRELOAD));
		Animation.AddCombat("RISE_UP_STRIKE",				ANIM_UNDEAD_RISE_01,	Flags(ANIM_FLAG_PRELOAD));
		Animation.AddCombat("RISE_UP_STRIKE",				ANIM_UNDEAD_RISE_STRIKE,	Flags(ANIM_FLAG_PRELOAD));

		Animation.AddCombat("GENERATE_DROP",				ANIM_UNDEAD_RISE_01);
		
		Animation.AddCombat("GO_UNDERGROUND",				ANIM_UNDEAD_BELOW_GROUND_01);
		Animation.AddCombat("TUNNEL",						ANIM_UNDEAD_BELOW_GROUND_01);
		Animation.AddCombat("SPECIAL_IDLE",					ANIM_UNDEAD_IDLE_01);
		
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",	ANIM_UNDEAD_STRIKE_LEFT_01, Combo(0, 0), Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_UNDEAD_LEFT_STRIKE_RECOIL_01));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",	ANIM_UNDEAD_STRIKE_RIGHT_01, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_UNDEAD_RIGHT_STRIKE_RECOIL_01));

		Animation.AddCombat("BLOCK_IDLE", ANIM_UNDEAD_IDLE_01);
		Animation.AddCombat("BLOCK_FRONT_RESPONSE",	ANIM_UNDEAD_BLOCK_01);
		Animation.AddCombat("BLOCK_LEFT_RESPONSE",	ANIM_UNDEAD_BLOCK_LEFT_01);
		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",	ANIM_UNDEAD_BLOCK_RIGHT_01);

		Animation.AddCombat("BLOCK_BROKEN_RESPONSE_RIGHT",	ANIM_UNDEAD_LEFT_STRIKE_RECOIL_01);
		Animation.AddCombat("BLOCK_BROKEN_RESPONSE_LEFT",	ANIM_UNDEAD_LEFT_STRIKE_RECOIL_01);
		Animation.AddCombat("BLOCK_COUNTER_ATTACK",			ANIM_UNDEAD_CHARGE_STRIKE_01);

		Animation.AddCombat("MOVEMENT_CHARGE_FORWARD",		ANIM_UNDEAD_CHARGE_FRONT_01);
		Animation.AddCombat("STRIKE_CHARGE",				ANIM_UNDEAD_CHARGE_STRIKE_01);
		
		Animation.AddCombat("MOVEMENT_STRAFE_LEFT",			ANIM_UNDEAD_STRAFE_LEFT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_RIGHT",		ANIM_UNDEAD_STRAFE_RIGHT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",		ANIM_UNDEAD_WALK_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",		ANIM_UNDEAD_STRAFE_BACK_01);

		Animation.Add("ST_CAST_DRAIN",				ANIM_UNDEAD_DRAIN_INTO_01);
		Animation.Add("ST_BUILD_UP_DRAIN",			ANIM_UNDEAD_DRAIN_LOOP_01);
		Animation.Add("ST_RELEASE_DRAIN",			ANIM_UNDEAD_DRAIN_OUTOF_01);

		Animation.Add("DEFAULT",					ANIM_UNDEAD_IDLE_01);
//		Animation.Add("DEFAULT",					ANIM_UNDEAD_IDLE_02);
		
		Animation.Add("ST_IDLE_SUBTLE",				ANIM_UNDEAD_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE",					ANIM_UNDEAD_IDLE_01);
//		Animation.Add("ST_IDLE",					ANIM_UNDEAD_IDLE_02);
		Animation.Add("ST_WALK",					ANIM_UNDEAD_WALK_01);
		Animation.Add("ST_RUN",						ANIM_UNDEAD_WALK_01);
		
		Animation.Add("STRAFE_IDLE",				ANIM_UNDEAD_IDLE_01);
		Animation.Add("STRAFE_MOVEMENT_LEFT",		ANIM_UNDEAD_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",		ANIM_UNDEAD_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",		ANIM_UNDEAD_STRAFE_BACK_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",	ANIM_UNDEAD_WALK_01);

		Animation.Add("TURNING_AC90",				ANIM_UNDEAD_TURN_LEFT_90_01);
		Animation.Add("TURNING_C90",				ANIM_UNDEAD_TURN_RIGHT_90_01);
		Animation.Add("TURNING_AC180",				ANIM_UNDEAD_TURN_LEFT_180_01);
		Animation.Add("TURNING_C180",				ANIM_UNDEAD_TURN_RIGHT_180_01);

		Animation.Add("ST_ROAR",					ANIM_UNDEAD_ROAR_01);
		Animation.Add("SUMMON_CREATURES",			ANIM_UNDEAD_ROAR_01);

		Animation.StartGroup("UNDERGROUND");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_UNDEAD_BELOW_GROUND_01, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("ST_IDLE",				ANIM_UNDEAD_BELOW_GROUND_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.EndGroup();		
		

		Animation.AddCombat("STRIKE_LONG_FRONT",	ANIM_UNDEAD_LIEUTENANT_LEFT_STRIKE_01, Combo(0, 0), Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_UNDEAD_LEFT_STRIKE_RECOIL_01));
		Animation.AddCombat("STRIKE_LONG_FRONT",	ANIM_UNDEAD_LIEUTENANT_RIGHT_STRIKE_01, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_UNDEAD_RIGHT_STRIKE_RECOIL_01), TransTime(3));

		Animation.AddCombat("STRIKE_RECOIL", ANIM_UNDEAD_LEFT_STRIKE_RECOIL_01, Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_RECOIL", ANIM_UNDEAD_RIGHT_STRIKE_RECOIL_01, Handedness(HANDED_LEFT, HANDED_RIGHT));
		Animation.AddCombat("STRIKE_RECOIL", ANIM_UNDEAD_LEFT_STRIKE_RECOIL_01, Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_RECOIL", ANIM_UNDEAD_RIGHT_STRIKE_RECOIL_01, Handedness(HANDED_LEFT, HANDED_RIGHT));	


		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//the complete set of generic responses and dead and stunned etc idles
		//all enemy bandit skeletoned creatures should use this
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
		Animation.EndGroup();
		
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_UNDEAD_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_UNDEAD_IDLE_01);
			Animation.Add("DAZED_RECOVER",			ANIM_UNDEAD_IDLE_01);
		Animation.EndGroup();
		
		Animation.Add("DAZED_IDLE",					ANIM_UNDEAD_IDLE_01);
		Animation.Add("KNOCKDOWN_IDLE",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
		Animation.Add("STANDARD_DEAD",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
		Animation.Add("STANDARD_DIE",				ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
		Animation.Add("STABBED_TO_DEAD",			ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
		Animation.Add("STABBED_ALREADY_DEAD",		ANIM_UNDEAD_UNCONSCIOUS_IDLE_01);
		
		// CUTSCENE ANIMATIONS
		Animation.Add("CS_RISE_STRIKE",				ANIM_UNDEAD_RISE_STRIKE,TransTime(0));
	<\CAppearanceDef>

	<CAppearanceDef>
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_UNDEAD_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_UNDEAD_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_UNDEAD_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_UNDEAD_KO_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_UNDEAD_KO_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_UNDEAD_KO_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_UNDEAD_UNCONSCIOUS_RECOVER_01);
		
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_UNDEAD_KO_HIT_LEFT_01);
		
		Animation.AddCombat("FALL_DEAD",			ANIM_UNDEAD_KO_HIT_RIGHT_01); 
		Animation.AddCombat("FALL_UNCONSCIOUS",		ANIM_UNDEAD_KO_HIT_RIGHT_01);
		Animation.AddCombat("UNCONSCIOUS_RECOVER",	ANIM_UNDEAD_UNCONSCIOUS_RECOVER_01);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_UNDEAD_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_UNDEAD_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	
	<\CAppearanceDef>

	GroupDef				G_CREATURES_HOSTILE;
	
	Health 10;
#end_definition

//*******************************************************************************************************************
#definition_template	CREATURE 	CREATURE_HOBBE_TEMPLATE specialises CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE

	EyeGraphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex	MESH_HOBBE_EYE_01;
	EyeGraphic.RenderSizeX	1.0;
	
	DeadBodyDecayEffect		DEATH_CRUMBLE_SMALL;

	<CEntitySoundDef>
		SoundIdentifier		"SI_HOBBE";
	<\CEntitySoundDef>

	<CPerceivedThingDef>
		FieldOfView							160;
		SightRadius							12;
		ExtendedSightRadius					15;
		SoundRadius							10;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						8.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.9;
	<\CPerceivedThingDef>

	Health 					13;
	AbleToStrafe			TRUE;
	
	StunHealthThreshold	8;
	StunTimeMin				3;
	StunTimeMax				3;

	StunnedParticle				DAZED01STAR;
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_HOBBE);
	<\CHitLocationsDef>

	<CPhysicsDef>
		Diameter			1.2;
	<\CPhysicsDef>
	
	Components.Add("CTCSkeletalMorph");
	Components.Add("CTCRandomAppearanceMorph");

	<CTargetingDef>
		Type				TARGETING_SHOOTABLE | TARGETING_TALKABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>
	
//	<CCarryingDef>
//		AvailableCarrySlots.Add(CARRY_SLOT_RIGHT_HAND);
//		AvailableCarrySlots.Add(CARRY_SLOT_LEFT_HAND);
//		AvailableCarrySlots.Add(CARRY_SLOT_PRIMARY_SHEATHE);
//		AvailableCarrySlots.Add(CARRY_SLOT_SECONDARY_SHEATHE);
//	<\CCarryingDef>
	
	<CEnemyDef>
		Faction				FACTION_MONSTERS;
	<\CEnemyDef>
	
	<CCreatureDef>
		Stats.ExperienceWorth 12;
		Stats.RenownWorth 10;

		Stats.MoralityForKill		2;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		OpinionSourceDef	OPINION_SOURCE_HERO_EVIL_MEDIUM;                                          
		CreatureGroup		CREATURE_GROUP_HOBBE;
	<\CCreatureDef>                                          

	GroupDef				G_CREATURES_FAE;	

	PrimaryMeleeWeaponDef	OBJECT_HOBBE_WEAPON_AXE;
	PBrain					BRAIN_HOBBE_GRUNT;	
	CombatTypeDef			HOBBE_GRUNT_ATTACK_STYLE;

	<CAppearanceDef>
		Animation.Add("DEFAULT",							ANIM_CREATURE_HOBBE_IDLE_1, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE_SUBTLE",						ANIM_CREATURE_HOBBE_IDLE_1, Flags(ANIM_FLAG_PRELOAD));
	//	Animation.Add("ST_IDLE",							ANIM_CREATURE_HOBBE_IDLE_1, Flags(ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_SLOW_WALK",						ANIM_CREATURE_HOBBE_STRAFE_FRONT_01);
		Animation.Add("ST_WALK",							ANIM_CREATURE_HOBBE_STRAFE_FRONT_01);
	//	Animation.Add("ST_RUN",								ANIM_CREATURE_HOBBE_RUN_01);
		
		Animation.Add("ST_ASSASSIN_RUSH_INTO",				ANIM_CREATURE_HOBBE_ASSASSIN_RUSH_INTO_01);
		Animation.Add("ST_ASSASSIN_RUSH_LOOP",				ANIM_CREATURE_HOBBE_ASSASSIN_RUSH_LOOP_01);
		Animation.Add("ST_ASSASSIN_RUSH_OUTOF",				ANIM_CREATURE_HOBBE_ASSASSIN_RUSH_OUTOF_01);
		Animation.Add("ST_DEVOURING_APPLES_INTO",			ANIM_CREATURE_HOBBE_DEVOURING_APPLES_INTO_01);
		Animation.Add("ST_DEVOURING_APPLES_LOOP",			ANIM_CREATURE_HOBBE_DEVOURING_APPLES_LOOP_01);
		Animation.Add("ST_DEVOURING_APPLES_OUTOF",			ANIM_CREATURE_HOBBE_DEVOURING_APPLES_OUTOF_01);
		Animation.Add("ST_EATING_BONES_INTO",				ANIM_CREATURE_HOBBE_EATING_BONES_INTO_01);
		Animation.Add("ST_EATING_BONES_LOOP",				ANIM_CREATURE_HOBBE_EATING_BONES_LOOP_01);
		Animation.Add("ST_EATING_BONES_OUTOF",				ANIM_CREATURE_HOBBE_EATING_BONES_OUTOF_01);
		Animation.Add("ST_JUMP_FROM_BUSH_LEFT",				ANIM_CREATURE_HOBBE_JUMP_FROM_BUSH_LEFT_01);
		Animation.Add("ST_JUMP_FROM_BUSH_RIGHT",			ANIM_CREATURE_HOBBE_JUMP_FROM_BUSH_RIGHT_01);

	    Animation.Add("BLOCK_IDLE",							ANIM_CREATURE_HOBBE_BLOCK_IDLE_01);
		
		Animation.Add("STRAFE_IDLE",						ANIM_CREATURE_HOBBE_IDLE_1);
		Animation.Add("STRAFE_MOVEMENT_LEFT",				ANIM_CREATURE_HOBBE_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",				ANIM_CREATURE_HOBBE_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",				ANIM_CREATURE_HOBBE_STRAFE_BACK_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",			ANIM_CREATURE_HOBBE_STRAFE_FRONT_01);
		
		Animation.Add("TURNING_1", ANIM_CREATURE_HOBBE_TURN_90_LEFT);
		Animation.Add("TURNING_2", ANIM_CREATURE_HOBBE_TURN_90_RIGHT);		
		
		//ANIM_CREATURE_HOBBE_MENACING
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",				ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
		Animation.EndGroup();
		
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_CREATURE_HOBBE_IDLE_1);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_HOBBE_IDLE_1);
			Animation.Add("DAZED_RECOVER",			ANIM_CREATURE_HOBBE_IDLE_1);
		Animation.EndGroup();
		
		Animation.Add("KNOCKDOWN_IDLE",						ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
//		Animation.Add("STANDARD_DIE",						ANIM_CREATURE_HOBBE_DIE_01);
		Animation.Add("STANDARD_DEAD",						ANIM_CREATURE_HOBBE_DEAD);
		Animation.Add("STANDARD_DIE",						ANIM_CREATURE_HOBBE_DEAD);
		Animation.Add("STABBED_TO_DEAD",					ANIM_CREATURE_HOBBE_STUNNED_STAB_TODEATH_1);
		Animation.Add("STABBED_ALREADY_DEAD",				ANIM_CREATURE_HOBBE_STUNNED_IDLE_1);
				
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_CREATURE_HOBBE_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_HOBBE_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	<\CAppearanceDef>

	<CAppearanceDef>                                          
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_CREATURE_HOBBE_STRIKE_LEFT_1, Handedness(HANDED_LEFT, HANDED_RIGHT));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_CREATURE_HOBBE_STRIKE_RIGHT_1, Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_LONG_FRONT", ANIM_CREATURE_HOBBE_STRIKE_LUNGE_1, Handedness(HANDED_NONE, HANDED_LEFT));
		Animation.AddCombat("STRIKE_SHORT_FRONT", ANIM_CREATURE_HOBBE_STRIKE_PUNCH_01, Handedness(HANDED_NONE, HANDED_LEFT));

		Animation.AddCombat("STRIKE_RECOIL", ANIM_CREATURE_HOBBE_STRIKE_RIGHT_RECOIL_01);


		/////////////////////////////////////////////////////
		Animation.AddCombat("BLOCK_FRONT_RESPONSE",						ANIM_CREATURE_HOBBE_BLOCK_1);
		Animation.AddCombat("BLOCK_LEFT_RESPONSE",						ANIM_CREATURE_HOBBE_BLOCK_1);
		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",						ANIM_CREATURE_HOBBE_BLOCK_1);
		Animation.AddCombat("BLOCK_BACK_RESPONSE",						ANIM_CREATURE_HOBBE_BLOCK_1);
		Animation.AddCombat("BLOCK_START",								ANIM_CREATURE_HOBBE_BLOCK_1);
		Animation.AddCombat("BLOCK_FINISH",								ANIM_CREATURE_HOBBE_BLOCK_1);

		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",					ANIM_CREATURE_HOBBE_STRAFE_FRONT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",					ANIM_CREATURE_HOBBE_STRAFE_BACK_01);
		Animation.AddCombat("MOVEMENT_STRAFE_LEFT",						ANIM_CREATURE_HOBBE_STRAFE_LEFT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_RIGHT",					ANIM_CREATURE_HOBBE_STRAFE_RIGHT_01);
		Animation.AddCombat("SPECIAL_BOAST",							ANIM_CREATURE_HOBBE_MENACE_01);
		Animation.AddCombat("SPECIAL_BOAST",							ANIM_CREATURE_HOBBE_MENACE_02);
		Animation.AddCombat("SPECIAL_IDLE",								ANIM_CREATURE_HOBBE_IDLE_1);		

	    Animation.AddCombat("COUNTER_BLOCK_RECOIL",						ANIM_CREATURE_HOBBE_COUNTER_BLOCK_RECOIL_01);

		Animation.AddCombat("RESPONSE_TIMED_FORWARD_SUMMERSAULT",		ANIM_CREATURE_HOBBE_RESPONSE_TIMED_SLASH_SUMMERSAULT_01);
		Animation.AddCombat("RESPONSE_TIMED_RIGHT_SERVE_SLASH",			ANIM_CREATURE_HOBBE_RESPONSE_TIMED_SERVE_SLASH_01);
		Animation.AddCombat("RESPONSE_TIMED_BACK_BACK_STAB",			ANIM_CREATURE_HOBBE_RESPONSE_TIMED_BACKSTAB_01);
		Animation.AddCombat("RESPONSE_TIMED_LEFT_CRICKET_BAT_SMASH",	ANIM_CREATURE_HOBBE_RESPONSE_TIMED_CRICKET_BAT_SMASH_01);		

		////////////////////////////////
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_HOBBE_HIT_RIGHT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_HOBBE_HIT_LEFT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_HOBBE_HIT_BACK_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_HOBBE_HIT_RIGHT_KNOCKDOWN_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_HOBBE_HIT_LEFT_KNOCKDOWN_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_HOBBE_HIT_BACK_KNOCKDOWN_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_CREATURE_GETUP_FROM_UNCONSCIOUS);
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_CREATURE_HOBBE_HIT_LEFT_KNOCKDOWN_1);
		
		Animation.AddCombat("RESPONSE_LIGHTNING_HIT",					ANIM_CREATURE_HOBBE_GET_HIT_LIGHTNING_01);
		Animation.AddCombat("RESPONSE_MULTISTRIKE_HIT_INTO",			ANIM_CREATURE_HOBBE_GET_HIT_MULTISTRIKE_INTO_01);
		Animation.AddCombat("RESPONSE_MULTISTRIKE_HIT_LOOP",			ANIM_CREATURE_HOBBE_GET_HIT_MULTISTRIKE_LOOP_01);
		Animation.AddCombat("RESPONSE_MULTISTRIKE_HIT_OUTOF",			ANIM_CREATURE_HOBBE_GET_HIT_MULTISTRIKE_OUTOF_01);
		Animation.AddCombat("RESPONSE_FORCE_PUSH_HIT",					ANIM_CREATURE_HOBBE_GET_HIT_FORCE_PUSH_01);
		Animation.AddCombat("RESPONSE_LEECH_HIT_INTO",					ANIM_CREATURE_HOBBE_GET_HIT_LEECH_INTO_01);
		Animation.AddCombat("RESPONSE_LEECH_HIT_LOOP",					ANIM_CREATURE_HOBBE_GET_HIT_LEECH_LOOP_01);
		Animation.AddCombat("RESPONSE_LEECH_HIT_OUTOF",					ANIM_CREATURE_HOBBE_GET_HIT_LEECH_OUTOF_01);
		Animation.AddCombat("FALL_DEAD",								ANIM_CREATURE_HOBBE_DIE_01);
		Animation.AddCombat("FALL_UNCONSCIOUS",							ANIM_CREATURE_HOBBE_DIE_01); //need replacing
		
		Animation.AddCombat("PROJECTILE_WEAPON_AIM",	ANIM_CREATURE_HOBBE_SPELLCASTER_THUMP_GROUND_INTO_01);
		Animation.AddCombat("PROJECTILE_WEAPON_FIRE",	ANIM_CREATURE_HOBBE_SPELLCASTER_THUMP_GROUND_OUTOF_01);
		Animation.AddCombat("PROJECTILE_WEAPON_LOAD",	ANIM_CREATURE_HOBBE_IDLE_1);
		
		
		Animation.AddCombat("LEADER_IDLE",				ANIM_CREATURE_HOBBE_IDLE_1);
		Animation.AddCombat("LEADER_DISAPPOINTED",		ANIM_CREATURE_HOBBE_LIEUTENANT_DISAPPOINTED_01);
		Animation.AddCombat("LEADER_CHEER",				ANIM_CREATURE_HOBBE_LIEUTENANT_ENCOURAGE_SOLDIERS_01);
		Animation.AddCombat("LEADER_GIVE_ORDERS",		ANIM_CREATURE_HOBBE_LIEUTENANT_ENCOURAGE_SOLDIERS_01);
		
		////////////////////////////////
		Animation.AddCombat("GENERATE_AMBUSH_LEFT",		ANIM_CREATURE_HOBBE_JUMP_FROM_BUSH_LEFT_01);
		Animation.AddCombat("GENERATE_AMBUSH_RIGHT",	ANIM_CREATURE_HOBBE_JUMP_FROM_BUSH_RIGHT_01);
	<\CAppearanceDef>
	
#end_definition

//*************************************************************************************************
#definition_template  CREATURE CREATURE_COMBAT_ENEMY_ANIMAL_TEMPLATE  specialises CREATURE_BASE_TEMPLATE

	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	Components.Add("CTCContainerRewardHero");
	Health					3;

//	MaxWalkingSpeed 		0.10;
//	MaxRunningSpeed 		0.20;
//	MaxPushingSpeed			0.10;
	MaxFlyingSpeed			0.0;

	MaxAcceleration 		0.1;
	<CLookDef>
		MaxTurnSpeed 				45.0;
	<\CLookDef>
	
	Property 				NULL;

	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type				TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>

	IsWillable				TRUE;
	IsVulnerableToMelee		TRUE;
	Damageable				TRUE;
	IsIndestructible		FALSE;

	CreatureType			NOT_HUMAN;
	PBrain					BRAIN_SHEEP;
	Sex						SEX_MALE;

	NavigatorTypes.Add(NAV_INIT_GROUND);

	<CEnemyDef>
		Faction				FACTION_MONSTERS;
	<\CEnemyDef>

	IsVulnerableToMelee		TRUE;
	Damageable				TRUE;
	Damage					1.0;

	Components.Add("CTCEnemy");
	Components.Add("CTCTargetingAI");
	Components.Add("CTCCombat");
	Components.Add("CTCPerceiveThing");
	<CPerceivedThingDef>
		FieldOfView							120;
		SightRadius							15;
		SoundRadius							10;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						15.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
	<\CPerceivedThingDef>

	Components.Add("CTCLook");
	<CLookDef>
		EyesTurnRangeXY		0.0;
		EyesTurnRangeYZ		0.0;
		HeadTurnRangeXY		0.0;
		HeadTurnRangeYZUp	0.0;
		HeadTurnRangeYZDown	0.0;
	<\CLookDef>

	Components.Add("CTCPhysicsNavigator");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Elasticity		0;
		Friction		1;
		AirResistance	0;
		Mass			150;
		Diameter		0.6;
	<\CPhysicsDef>

	DefaultOwner			2;

	<CCreatureDef>
		Stats.ExperienceWorth 3;
		Stats.RenownWorth 2;

		Stats.MoralityForKill		2;	// Dene's default setup
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		OpinionSourceDef	OPINION_SOURCE_INANIMATE_EVIL_HIGH;
	<\CCreatureDef>
	
#end_definition

//*************************************************************************************************
#definition_template  CREATURE NYMPH_TEMPLATE  specialises CREATURE_COMBAT_ENEMY_ANIMAL_TEMPLATE

	Graphic.Type		ENGINE_GRAPHIC_ANIMATING_MESH;

//	Components.Add("CTCCreatureItemLevitationNymph");
	Components.Add("CTCWeaponTrail");

	Components.Add("CTCNymph");
	Components.Add("CTCAISummon");

	Components.Remove("CTCCombat");

	DeadBodyDecayEffect			DEATH_CRUMBLE_SMALL;
	NumSecondsToPersistOnDeath	0.5;
	
	<CNymphDef>
		MinAttackRange						5.0;
		MinHeight							1.0;	
		MaxHeight							4.0;
		CircleRange							10.0;
		FlyAroundTime						5;
		ShotsBeforeIdle						1;
		IdleTimeBetweenShots				2.0;
	<\CNymphDef>

	<CPerceivedThingDef>
		FieldOfView							180;
		SightRadius							15;
		SoundRadius							10;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						15.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
	<\CPerceivedThingDef>

	<CEntitySoundDef>
		SoundIdentifier	"SI_NYMPH";
		
	<\CEntitySoundDef>
	
	<CTargetingDef>
		Type			TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>

	<CEnemyDef>
		Faction			FACTION_MONSTERS;
	<\CEnemyDef>
	
	<CWeaponDef>
		Shot					FIREBALL_1;//SHOT_NYMPH_WOOD_SHOT;
	<\CWeaponDef>	
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_NYMPH);
	<\CHitLocationsDef>

//	MaxHoverSpeedSlow	0.15;
//	MaxHoverSpeedMedium 0.3;
//	MaxHoverSpeedFast	0.5;
	
	<CCreatureModeDef>
		DefaultCreatureMode	MODE_HOVER;
	<\CCreatureModeDef>
	
	Health 					15;
	RecoverEvadeHitsPercent 100;
	
	StunHealthThreshold 0;
	StunTimeMin			3;
	StunTimeMax			3;
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//the complete set of generic responses and dead and stunned etc idles
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////
	CombatTypeDef			NYMPH_ATTACK_STYLE;
	
	<CAppearanceDef>

		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",				ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
		Animation.EndGroup();
		
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_CREATURE_NYMPH_HOVER_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_NYMPH_HOVER_IDLE_01);
//			Animation.Add("DAZED_RECOVER",			ANIM_CREATURE_NYMPH_FLIRT_01);
		Animation.EndGroup();

		Animation.AddCombat("KNOCKDOWN_IDLE",			ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
		Animation.AddCombat("STANDARD_DEAD",			ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
		Animation.Add("STANDARD_DIE",					ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
		Animation.AddCombat("STABBED_TO_DEAD",			ANIM_CREATURE_NYMPH_STABBED_ON_FLOOR_01);
		Animation.AddCombat("STABBED_ALREADY_DEAD",		ANIM_CREATURE_NYMPH_ON_FLOOR_IDLE_01);
		
		Animation.AddCombat("DEFAULT",				ANIM_CREATURE_NYMPH_HOVER_IDLE_01);
		Animation.AddCombat("ST_IDLE_SUBTLE",			ANIM_CREATURE_NYMPH_HOVER_IDLE_01);
		Animation.AddCombat("ST_HOVER_IDLE",			ANIM_CREATURE_NYMPH_HOVER_IDLE_01);

		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_NYMPH_GET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_NYMPH_GET_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_NYMPH_GET_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_NYMPH_KNOCKED_DOWN_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_NYMPH_KNOCKED_DOWN_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_NYMPH_KNOCKED_DOWN_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_CREATURE_NYMPH_KNOCKED_DOWN_RECOVER_01);
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_CREATURE_NYMPH_KNOCKED_DOWN_LEFT_01);
		
		Animation.AddCombat("FALL_DEAD",					ANIM_CREATURE_NYMPH_KNOCKED_DOWN_BACK_01); //need replacing
		Animation.AddCombat("FALL_UNCONSCIOUS",				ANIM_CREATURE_NYMPH_KNOCKED_DOWN_BACK_01); //need replacing
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",			ANIM_CREATURE_NYMPH_CAST_SPELLS_01a);//ANIM_CREATURE_NYMPH_TRIPLE_STRIKE_01);
		Animation.AddCombat("TELEPORT_INTO_LIMBO",			ANIM_CREATURE_NYMPH_DISAPPEAR_01);
		Animation.AddCombat("TELEPORT_OUTOF_LIMBO",			ANIM_CREATURE_NYMPH_APPEAR_01);//ANIM_CREATURE_NYMPH_CAST_SPELLS_02);
		Animation.AddCombat("IDLE_AFTER_SHOT",				ANIM_CREATURE_NYMPH_HOVER_IDLE_01);//ANIM_CREATURE_NYMPH_GIGGLE_01);
			
		Animation.AddCombat("HOVER_IDLE",					ANIM_CREATURE_NYMPH_HOVER_IDLE_01);	
	
		Animation.AddCombat("SUMMON_CREATURES_INTO",		ANIM_CREATURE_NYMPH_LAND_ON_GROUND_01);
		Animation.AddCombat("SUMMON_CREATURES",				ANIM_CREATURE_NYMPH_SUMMON_BEETLES_01);
		Animation.AddCombat("SUMMON_CREATURES_OUTOF",		ANIM_CREATURE_NYMPH_RISE_INTO_AIR_01);
		
		// cutscene animations
		Animation.Add("CS_NYMPH_APPEAR",					CS_ANIM_CREATURE_NYMPH_APPEAR);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_CREATURE_NYMPH_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_NYMPH_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
		
	<\CAppearanceDef>

	<CCreatureDef>		
		Stats.ExperienceWorth	30;
		Stats.RenownWorth		15;

		Stats.MoralityForKill		2;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		CreatureGroup		CREATURE_GROUP_NYMPH;
	<\CCreatureDef>

	<CPhysicsDef>
		Diameter			1.2;
	<\CPhysicsDef>
	
#end_definition

//*************************************************************************************************************
#definition_template	CREATURE	CREATURE_SCORPION_TEMPLATE specialises CREATURE_COMBAT_ENEMY_ANIMAL_TEMPLATE

	Graphic.Type		ENGINE_GRAPHIC_ANIMATING_MESH;
	
	DeadBodyDecayEffect		DEATH_CRUMBLE_SMALL;
	
	<CEntitySoundDef>
		SoundIdentifier	"SI_SCORPION";
	<\CEntitySoundDef>

	PBrain 				BRAIN_SCORPION;
	Components.Add("CTCWeapon");
	<CWeaponDef>
		Damage				1.0;
	<\CWeaponDef>	

	MaxWalkingSpeed 	0.045;
	MaxRunningSpeed 	0.15;
	<CLookDef>
		MaxTurnSpeed 		15.0;

		DrawEyePrimitives	FALSE;
	<\CLookDef>
	
	<CCreatureModeDef>
		DefaultCreatureMode		MODE_STAND_IN_ALL_DIRECTIONS;
	<\CCreatureModeDef>
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_SCORPION);
	<\CHitLocationsDef>
	
	<CEnemyDef>
		Faction			FACTION_MONSTERS;
	<\CEnemyDef>
	
	CombatTypeDef		SCORPION_ATTACK_STYLE;
	
	StunHealthThreshold 0;
	StunTimeMin			5;
	StunTimeMax			5;
	
	Components.Add("CTCWeaponTrail");
	DrawWeaponTrails FALSE;
	
	AbleToStrafe		TRUE;
	
	<CPerceivedThingDef>
		FieldOfView							360;
		SightRadius							15;
		SoundRadius							10;
		SmellRadius							10;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						15.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.6;
		GiveUpChaseRadius					3.0;
	<\CPerceivedThingDef>
	
	
	
	<CAppearanceDef>
		Animation.Add("DEFAULT",					ANIM_CREATURE_SCORPION_IDLE_STATIC_01);
		Animation.Add("ST_IDLE",					ANIM_CREATURE_SCORPION_IDLE_STATIC_01);
		Animation.Add("ST_IDLE_SUBTLE",				ANIM_CREATURE_SCORPION_IDLE_STATIC_01);
	
		Animation.Add("ST_WALK",					ANIM_CREATURE_SCORPION_WALK_FORWARD_01);
		Animation.Add("ST_RUN",						ANIM_CREATURE_SCORPION_WALK_FORWARD_01);
		Animation.Add("ST_WALK_IDLE",				ANIM_CREATURE_SCORPION_IDLE_STATIC_01);
	
		Animation.Add("ST_WALK_FORWARD_SLOW",		ANIM_CREATURE_SCORPION_WALK_FORWARD_01);
		Animation.Add("ST_WALK_BACK_SLOW",			ANIM_CREATURE_SCORPION_WALK_BACK_01);
		Animation.Add("ST_WALK_LEFT_SLOW",			ANIM_CREATURE_SCORPION_STRAFE_LEFT_01);
		Animation.Add("ST_WALK_RIGHT_SLOW",			ANIM_CREATURE_SCORPION_STRAFE_RIGHT_01);

		Animation.Add("STRAFE_IDLE",				ANIM_CREATURE_SCORPION_IDLE_01);
		Animation.Add("STRAFE_MOVEMENT_LEFT",		ANIM_CREATURE_SCORPION_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",		ANIM_CREATURE_SCORPION_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",		ANIM_CREATURE_SCORPION_WALK_BACK_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",	ANIM_CREATURE_SCORPION_WALK_FORWARD_01);


		Animation.Add("ST_WALK_FORWARD_MEDIUM",		ANIM_CREATURE_SCORPION_WALK_FORWARD_01);
		Animation.Add("ST_WALK_BACK_MEDIUM",		ANIM_CREATURE_SCORPION_WALK_BACK_01);
		Animation.Add("ST_WALK_LEFT_MEDIUM",		ANIM_CREATURE_SCORPION_STRAFE_LEFT_01);
		Animation.Add("ST_WALK_RIGHT_MEDIUM",		ANIM_CREATURE_SCORPION_STRAFE_RIGHT_01);

		Animation.Add("ST_WALK_FORWARD_FAST",		ANIM_CREATURE_SCORPION_WALK_FORWARD_01);
		Animation.Add("ST_WALK_BACK_FAST",			ANIM_CREATURE_SCORPION_WALK_BACK_01);
		Animation.Add("ST_WALK_LEFT_FAST",			ANIM_CREATURE_SCORPION_STRAFE_LEFT_01);
		Animation.Add("ST_WALK_RIGHT_FAST",			ANIM_CREATURE_SCORPION_STRAFE_RIGHT_01);
	
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",				ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
		Animation.EndGroup();
		
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_CREATURE_SCORPION_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_SCORPION_IDLE_01);
			Animation.Add("DAZED_RECOVER",			ANIM_CREATURE_SCORPION_IDLE_01);
		Animation.EndGroup();
	
		Animation.Add("KNOCKDOWN_IDLE",				ANIM_CREATURE_SCORPION_WRIGGLE_ON_GROUND_01);
		Animation.Add("STANDARD_DEAD",				ANIM_CREATURE_SCORPION_DEAD_POSE_01);
		Animation.Add("STANDARD_DIE",				ANIM_CREATURE_SCORPION_DEAD_POSE_01);
		Animation.Add("STABBED_TO_DEAD",			ANIM_CREATURE_SCORPION_DIE_01);
		Animation.Add("STABBED_ALREADY_DEAD",		ANIM_CREATURE_SCORPION_DEAD_POSE_01);
		
		Animation.StartGroup("UNDERGROUND");
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_SCORPION_UNDERGROUND_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("ST_IDLE",				ANIM_CREATURE_SCORPION_UNDERGROUND_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.EndGroup();
		
	// CUT SCENE ANIMS START
		
		Animation.Add("CS_GET_HIT_LOOP",				CS_BANDIT_INTRO_OF_JOB_SCORPION_GET_HIT_LOOP);
		
	// CUT SCENE ANIMS END

		Animation.AddCombat("TUNNEL",				ANIM_CREATURE_SCORPION_BURROW_01);
		Animation.AddCombat("GO_UNDERGROUND",		ANIM_CREATURE_SCORPION_BURROW_01);
		Animation.AddCombat("RISE_UP",				ANIM_CREATURE_SCORPION_RISE_UP_01);
		
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",			ANIM_CREATURE_SCORPION_ATTACK_PINCERS_01);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",			ANIM_CREATURE_SCORPION_ATTACK_TAIL_01, Recoil(ANIM_CREATURE_SCORPION_ATTACK_PINCERS_BLOCKED_01));
		Animation.AddCombat("STRIKE_MEDIUM_SECONDARY",		ANIM_CREATURE_SCORPION_ATTACK_TAIL_01);
		Animation.AddCombat("STRIKE_MEDIUM_LUNGE",			ANIM_CREATURE_SCORPION_ATTACK_JUMP_01);
		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_SCORPION_IDLE_01); 
		
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",	ANIM_CREATURE_SCORPION_WALK_FORWARD_01);
		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_SCORPION_GET_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_SCORPION_GET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_SCORPION_KNOCK_OUT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_SCORPION_KNOCK_OUT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_SCORPION_KNOCK_OUT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_SCORPION_KNOCK_OUT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_CREATURE_SCORPION_KO_RECOVER_01);
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_CREATURE_SCORPION_KNOCK_OUT_01);
		
		Animation.AddCombat("FALL_DEAD",			ANIM_CREATURE_SCORPION_DIE_01); //need replacing
		Animation.AddCombat("FALL_UNCONSCIOUS",		ANIM_CREATURE_SCORPION_DIE_01); //need replacing
	
		Animation.AddCombat("STRIKE_RECOIL", ANIM_CREATURE_SCORPION_ATTACK_PINCERS_BLOCKED_01);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_CREATURE_SCORPION_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_SCORPION_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	
	<\CAppearanceDef>
	
	<CCreatureDef>
		Stats.ExperienceWorth	12;
		Stats.RenownWorth		5;

		Stats.MoralityForKill		0;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		CreatureGroup			CREATURE_GROUP_SCORPION;
	<\CCreatureDef>
	
	<CCreatureModeDef>
		DefaultCreatureMode				MODE_STAND;
	<\CCreatureModeDef>

	
	GroupDef					G_VILLAGE_GENERIC;

	<CSpecialEffectsDef>
		SpecialEffects.Add("BURROW", SCORPION_BURROW_DUST_01);
	<\CSpecialEffectsDef>
	
#end_definition

//************************************************************************************************************
#definition_template	CREATURE	CREATURE_LIVESTOCK_TEMPLATE	specialises CREATURE_BASE_TEMPLATE

	Health					1;

	MaxWalkingSpeed			0.08;
	MaxRunningSpeed			0.40;
	MaxPushingSpeed			0.08;
	MaxFlyingSpeed			0.0;

	MaxAcceleration 		0.1;
	<CLookDef>
		MaxTurnSpeed 				45.0;
	<\CLookDef>
	
	Property 				THING_CREATURE_PROPERTY_ANNOYABLE_BY_KIDS;
	IsWillable				TRUE;
	
	CreatureType			NOT_HUMAN;
	PBrain 					BRAIN_CHICKEN;
	Sex						SEX_MALE;
	NavigatorTypes.Add(NAV_INIT_GROUND);

	IsIndestructible		TRUE;
	IsVulnerableToMelee		TRUE;
	Damageable				TRUE;
	AddToComboMultiplierOnHit		FALSE;
	GiveHeroStatChangesOnBeingHit	FALSE;

//	Sound["STF_HIT_BLOCKING"]	SND_SWORD_01;	Sound["STL_HIT_BLOCKING"]	SND_SWORD_19;
//	Sound["STF_FLESH_HIT"]		SND_PUNCH_01;	Sound["STL_FLESH_HIT"]		SND_PUNCH_11;				

	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	Components.Add("CTCPhysicsNavigator");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Elasticity			0;
		Friction			1;
		AirResistance		0;
		Mass				25;
		Diameter			0.6;
	<\CPhysicsDef>
								  
	<CCreatureNavigationDef>
		Radius				0.3;
	<\CCreatureNavigationDef>

	DefaultOwner			0;

	Components.Add("CTCLook");
	
	 <CCreatureDef>
		Stats.RenownWorth 1;
		Stats.ExperienceWorth 1;

		Stats.MoralityForKill		-2;	// Dene's default setup
		Stats.MoralityForPunch		-1;
		Stats.MoralityForWeaponHit	-1;
	 <\CCreatureDef>
#end_definition

//************************************************************************************************************
#definition_template CREATURE CREATURE_MOUNT_TEMPLATE  specialises CREATURE_BASE_TEMPLATE

	Health 					50000;

	MaxWalkingSpeed 		0.5;
	MaxRunningSpeed 		0.5;
	MaxAcceleration 		0.1;
	MaxFlyingSpeed			0.0;
	<CLookDef>
		MaxTurnSpeed 				45.0;
	<\CLookDef>
	
	Property 				NULL;
	PBrain 					BRAIN_NULL;

	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type				TARGETING_USABLE;
	<\CTargetingDef>

	IsWillable				TRUE;
	IsVulnerableToMelee		TRUE;
	Damageable				TRUE;
	IsIndestructible		FALSE;
	CreatureType			NOT_HUMAN;
	NavigatorTypes.Add(NAV_INIT_GROUND);

	Damage					1.0;

	DefaultOwner			2;
	Components.Add("CTCPhysicsNavigator");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Elasticity			0;
		Friction			1;
		AirResistance		0;
		Mass				150;
	<\CPhysicsDef>

#end_definition

//************************************************************************************************************
#definition_template 	CREATURE 	CREATURE_SCRIPTED_TEMPLATE specialises CREATURE_BASE_TEMPLATE

	Health 					100;

	MaxAcceleration 		0.1;
	<CLookDef>
		MaxTurnSpeed 				45.0;
	<\CLookDef>
		
	Components.Add("CTCTargeted");
	<CTargetingDef>
		Type				TARGETING_TALKABLE | TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>
	
	Components.Add("CTCCarrying");
	<CCarryingDef>
		AvailableCarrySlots.Add(CARRY_SLOT_RIGHT_HAND);
		AvailableCarrySlots.Add(CARRY_SLOT_LEFT_HAND);
	<\CCarryingDef>

	IsWillable				TRUE;
	
	CreatureType			HUMAN_ADULT;
	PBrain 					BRAIN_NULL;
	Sex						SEX_MALE;
	NavigatorTypes.Add(NAV_INIT_GROUND);

	IsIndestructible		TRUE;
	IsVulnerableToMelee		TRUE;
	Damageable				TRUE;

//	Sound["STF_HIT_BLOCKING"]	SND_SWORD_01;	Sound["STL_HIT_BLOCKING"]	SND_SWORD_19;
//	Sound["STF_FLESH_HIT"]		SND_PUNCH_01;	Sound["STL_FLESH_HIT"]		SND_PUNCH_11;				

	Components.Add("CTCTargetingAI");
	Components.Add("CTCPhysicsNavigator");
	<CPhysicsDef>
		InteractionFlags	PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS | PHYSICS_INTERACT_THINGS;
		Elasticity			0;
		Friction			1;
		AirResistance		0;
		Mass				25;
		Diameter			0.6;
	<\CPhysicsDef>

	DefaultOwner			0;

	Components.Add("CTCLook");

#end_definition

//************************************************************************************************************
#definition_template 	CREATURE 	CREATURE_MINION_TEMPLATE specialises CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE

	AbleToStrafe		TRUE;
	
	<CEntitySoundDef>
		SoundIdentifier	"SI_MINION";
	<\CEntitySoundDef>

	Components.Add("CTCVillageMember");
	Components.Add("CTCWeaponTrail");

	MaxWalkingSpeed 		0;
	MaxRunningSpeed 		0;
	
	<CPhysicsDef>
		Diameter			1.2;
	<\CPhysicsDef>

	<CTargetingDef>
		Type				TARGETING_TALKABLE | TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>

	<CCreatureDef>
		Stats.ExperienceWorth	80;
		Stats.RenownWorth		40;

		Stats.MoralityForKill		2;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		PickPocketable			FALSE;

		OpinionSourceDef		OPINION_SOURCE_HERO_EVIL_HIGH;
		CreatureGroup			CREATURE_GROUP_MINION;
	<\CCreatureDef>
	
	Components.Add("CTCSolidToThing");

	PBrain							BRAIN_MINION;
	Graphic.BankIndex 				MESH_BANDIT_01;

	CombatTypeDef					MINION_ATTACK_STYLE;
	Health 							90;
	PrimaryMeleeWeaponDef			OBJECT_BANDIT_SWORD_LIEUTENANT_01;	
	
	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	
 	Graphic.Type					ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 				MESH_MINION_WARDOG_01;

//	Graphic.RenderSizeX	1.2;

	EyeGraphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex	MESH_BIPED_EYE_GREY;
	EyeGraphic.RenderSizeX	1;

	CreatureType			HUMAN_ADULT;
	Damage					1.0;

	DefaultOwner			2;

	LeaveDeadCreature		FALSE;

	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_MINION_WARDOG);
	<\CHitLocationsDef>


	<CPerceivedThingDef>
		FieldOfView							160;
		SightRadius							14;
		GiveUpChaseRadius					10;
		ExtendedSightRadius					19;
		SoundRadius							15;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						20.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.9;
	<\CPerceivedThingDef>
	
	<CAppearanceDef>
		Animation.AddCombat("GENERATE_DROP", ANIM_CREATURE_MINION_SUMMONED_01);
		Animation.AddCombat("RISE_UP", ANIM_CREATURE_MINION_SUMMONED_01);
		Animation.AddCombat("RISE_UP_STRIKE", ANIM_CREATURE_MINION_SUMMONED_01);
		Animation.AddCombat("TUNNEL", ANIM_CREATURE_MINION_SUMMONED_01);
	
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_MINION_GET_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_MINION_GET_HIT_LEFT_01);		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_MINION_GET_HIT_BACK_01);
		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_BANDIT_RIGHT_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_BANDIT_LEFT_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_BANDIT_COMBAT_KNOCKDOWN_RECOVER_1_2);
		Animation.AddCombat("RESPONSE_DRAIN_LIFE_HIT",					ANIM_BANDIT_DRAIN_LIFE_GET_HIT_01);
		Animation.AddCombat("RESPONSE_TIMED_FORWARD_SUMMERSAULT",		ANIM_BANDIT_RESPONSE_TIMED_SLASH_SUMMERSAULT_01);
		Animation.AddCombat("RESPONSE_TIMED_RIGHT_SERVE_SLASH",			ANIM_BANDIT_RESPONSE_TIMED_SERVE_SLASH_01);
		Animation.AddCombat("RESPONSE_TIMED_BACK_BACK_STAB",			ANIM_BANDIT_RESPONSE_TIMED_BACK_STAB_01);
		Animation.AddCombat("RESPONSE_TIMED_LEFT_CRICKET_BAT_SMASH",	ANIM_BANDIT_RESPONSE_TIMED_CRICKET_BAT_SMASH_01);		
		Animation.AddCombat("RESPONSE_GENERIC_REACT_TO_DECAPITATION",	ANIM_BANDIT_LEFT_KNOCKDOWN_GET_HIT_1);
		
		Animation.AddCombat("BLOCK_BROKEN_RESPONSE_RIGHT",				ANIM_CREATURE_MINION_STRIKE_LEFT_RECOIL_01);
		Animation.AddCombat("BLOCK_BROKEN_RESPONSE_LEFT",				ANIM_CREATURE_MINION_STRIKE_LEFT_RECOIL_01);
		
		Animation.AddCombat("FALL_DEAD",								ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1); //need replacing
		Animation.AddCombat("FALL_UNCONSCIOUS",							ANIM_BANDIT_BACK_KNOCKDOWN_GET_HIT_1); //need replacing
		
		Animation.StartGroup("STUNNED");
			Animation.Add("ST_IDLE",				ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_BANDIT_KICKED_WHEN_DEAD);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_BANDIT_KICKED_WHEN_DEAD);
		Animation.EndGroup();
		
		Animation.StartGroup("DAZED");
			Animation.Add("ST_IDLE",				ANIM_BANDIT_IDLE_BOUND_HANDS_01);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_BANDIT_IDLE_BOUND_HANDS_01);
			Animation.Add("DAZED_RECOVER",			ANIM_BANDIT_COMBAT_IDLE_1_1);
		Animation.EndGroup();
		
		Animation.AddCombat("DAZED_IDLE",								ANIM_BANDIT_IDLE_BOUND_HANDS_01);
		Animation.AddCombat("KNOCKDOWN_IDLE",							ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
		Animation.AddCombat("STANDARD_DEAD",							ANIM_BANDIT_DEAD_POSE);
		Animation.Add("STANDARD_DIE",				ANIM_BANDIT_DEAD_POSE);

		Animation.Add("KNOCKDOWN_IDLE",					ANIM_BANDIT_KNOCKDOWN_IDLE_1_1);
		Animation.Add("STABBED_TO_DEAD",				ANIM_BANDIT_STABBED_TO_DEAD);
		Animation.Add("STABBED_ALREADY_DEAD",			ANIM_BANDIT_KICKED_WHEN_DEAD);
		Animation.Add("UNCONSCIOUS_TO_DEAD",			ANIM_BANDIT_UNCONSCIOUS_TO_DEAD_01);

		Animation.Add("RESPONSE_MULTISTRIKE_TWITCH_01",	ANIM_BANDIT_MULTISTRIKE_TWITCH_01);
		Animation.Add("RESPONSE_MULTISTRIKE_TWITCH_02",	ANIM_BANDIT_MULTISTRIKE_TWITCH_02);

		Animation.StartGroup("FORCE_PUSHED");
			Animation.Add("ST_IDLE",					ANIM_BANDIT_FORCEPUSH_GET_HIT_01);
			Animation.Add("ST_IDLE",					ANIM_BANDIT_HIT_BY_FORCE_PUSH_01);
			Animation.Add("ST_IDLE",					ANIM_BANDIT_HIT_BY_FORCE_PUSH_IMPACT_01);
		Animation.EndGroup();

		Animation.Add("DEFAULT",						ANIM_CREATURE_MINION_COMBAT_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_MINION_COMBAT_IDLE_01, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE",						ANIM_CREATURE_MINION_COMBAT_IDLE_01);

		Animation.Add("ST_WALK",					ANIM_CREATURE_MINION_WALK_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_RUN",						ANIM_CREATURE_MINION_RUN_01, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
//		Animation.Add("ST_HEAD_TURN_H",				ANIM_BIPED_BANDIT_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));
//		Animation.Add("DEFAULT_FACE",				BANDIT_FACE_NEUTRAL_OVERRIDE);

		Animation.Add("STRAFE_IDLE",				ANIM_CREATURE_MINION_COMBAT_IDLE_01);
		Animation.Add("STRAFE_MOVEMENT_LEFT",		ANIM_CREATURE_MINION_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",		ANIM_CREATURE_MINION_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",		ANIM_CREATURE_MINION_JUMP_BACK_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",	ANIM_CREATURE_MINION_STRAFE_FORWARD_01);

	    Animation.Add("BLOCK_IDLE",					ANIM_CREATURE_MINION_BLOCK_IDLE_01);

		Animation.Add("STRIKE_TURNING_AC90",				ANIM_CREATURE_MINION_STRIKE_TURN_90_LEFT_01);
		Animation.Add("STRIKE_TURNING_C90",				ANIM_CREATURE_MINION_STRIKE_TURN_90_RIGHT_01);

		Animation.Add("TURNING_AC90",				ANIM_CREATURE_MINION_TURN_90_LEFT_01);
		Animation.Add("TURNING_C90",				ANIM_CREATURE_MINION_TURN_90_RIGHT_01);
//		Animation.Add("TURNING_AC180",				ANIM_BANDIT_TURN_180_LEFT_01);
//		Animation.Add("TURNING_C180",				ANIM_BANDIT_TURN_180_RIGHT_01);

		Animation.AddCombat("BLOCK_FRONT_RESPONSE",		ANIM_CREATURE_MINION_BLOCK_HIT_LEFT_01);
		Animation.AddCombat("BLOCK_LEFT_RESPONSE",		ANIM_CREATURE_MINION_BLOCK_HIT_LEFT_01);
		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",		ANIM_CREATURE_MINION_BLOCK_HIT_RIGHT_01);
		Animation.AddCombat("BLOCK_BACK_RESPONSE",		ANIM_CREATURE_MINION_BLOCK_HIT_RIGHT_01);
		Animation.AddCombat("BLOCK_START",				ANIM_CREATURE_MINION_BLOCK_IDLE_01);
		Animation.AddCombat("BLOCK_FINISH",				ANIM_CREATURE_MINION_BLOCK_IDLE_01);
		
		Animation.AddCombat("BLOCK_COUNTER_ATTACK",			ANIM_CREATURE_MINION_BLOCK_COUNTER_01);

	    Animation.AddCombat("COUNTER_BLOCK_RECOIL",			ANIM_BANDIT_COUNTER_BLOCK_RECOIL_01);
		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_MINION_COMBAT_IDLE_01);
		/////////////////////////////////////////////////////
		
		Animation.AddCombat("MOVEMENT_LONG_BACK",			ANIM_CREATURE_MINION_JUMP_BACK_01);
		Animation.AddCombat("MOVEMENT_LONG_FRONT",			ANIM_CREATURE_MINION_RUN_01);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_LEFT",	ANIM_CREATURE_MINION_STRAFE_LEFT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_RIGHT",	ANIM_CREATURE_MINION_STRAFE_RIGHT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_LEFT",	ANIM_CREATURE_MINION_STRAFE_LEFT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_RIGHT",	ANIM_CREATURE_MINION_STRAFE_RIGHT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",		ANIM_CREATURE_MINION_STRAFE_FORWARD_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",		ANIM_CREATURE_MINION_JUMP_BACK_01);
		
		//////////////////////////////////////////////
		//first number in AddComboStage is the combo number (ie 0, to 1, to 2, to 3 etc...)
		//second number is a unique ID for a combo 
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_CREATURE_MINION_STRIKE_RIGHT_01, Combo(0, 0), Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_CREATURE_MINION_STRIKE_RIGHT_RECOIL_01));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_CREATURE_MINION_STRIKE_LEFT_01, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_CREATURE_MINION_STRIKE_LEFT_RECOIL_01));

		Animation.AddCombat("STRIKE_MEDIUM_SIDE", ANIM_CREATURE_MINION_STRIKE_RIGHT_01, Combo(0, 0), Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_CREATURE_MINION_STRIKE_RIGHT_RECOIL_01));
		Animation.AddCombat("STRIKE_MEDIUM_SIDE", ANIM_CREATURE_MINION_STRIKE_LEFT_01, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_CREATURE_MINION_STRIKE_LEFT_RECOIL_01));

		Animation.AddCombat("MOVEMENT_CHARGE_FORWARD", ANIM_CREATURE_MINION_CHARGE_01);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_UNBLOCKABLE", ANIM_CREATURE_MINION_STRIKE_LUNGE_01);
		
		Animation.AddCombat("STRIKE_RECOIL", ANIM_CREATURE_MINION_STRIKE_LEFT_RECOIL_01, Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_RECOIL", ANIM_CREATURE_MINION_STRIKE_RIGHT_RECOIL_01, Handedness(HANDED_LEFT, HANDED_RIGHT));
				

		/////////////////////////////////////////////////////
		
		// CUTSCENE ANIMATIONS - DON'T TOUCH THIS WITHOUT TALKING TO JOHN BYE FIRST!
		Animation.Add("CS_STRIKE_MEDIUM_FRONT_LEFT",		ANIM_CREATURE_MINION_STRIKE_LEFT_01);
		Animation.Add("CS_STRIKE_MEDIUM_FRONT_RIGHT",		ANIM_CREATURE_MINION_STRIKE_RIGHT_01);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_CREATURE_MINION_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_MINION_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();
	<\CAppearanceDef>

	Components.Add("CTCSkeletalMorph");

	<CSkeletalMorphDef>
		SkeletalMorphs.Add("minion_dreadwings_set.bncfg");
	<\CSkeletalMorphDef>

	GroupDef					G_CREATURES_FAE;
#end_definition

//************************************************************************************************************
#definition_template 	CREATURE 	CREATURE_SUMMONER_TEMPLATE specialises CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE

	AbleToStrafe		TRUE;
	
	<CEntitySoundDef>	
		SoundIdentifier	"SI_SUMMONER";
	<\CEntitySoundDef>

	Components.Add("CTCWeaponTrail");
	UseMeleeWeaponAsDefault			FALSE;
	UnsheatheWeaponsAutomatically	FALSE;
//	RangedWeaponDef					NULL;

	MaxWalkingSpeed 		0;
	MaxRunningSpeed 		0;
	
	<CPhysicsDef>
		Diameter			1.4;
		PushableByHero		FALSE;
	<\CPhysicsDef>
	
	MeshHeight				2.8;

	<CTargetingDef>
		Type				TARGETING_SHOOTABLE | TARGETING_MELEE | TARGETING_ZTARGETING;
	<\CTargetingDef>

	<CCreatureDef>
		Stats.ExperienceWorth	80;
		Stats.RenownWorth		40;

		Stats.MoralityForKill		2;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		PickPocketable			FALSE;

		OpinionSourceDef		OPINION_SOURCE_HERO_EVIL_HIGH;
		CreatureGroup			CREATURE_GROUP_MINION;
		
		FlashOnHit				TRUE; // summoners don't play anim responses so flash em
	<\CCreatureDef>
	
	Components.Add("CTCAISummon");
	<CSummonDef>
		CreatureToSummon	CREATURE_MINION_WARDOG;
		NumberToSummon		3;
		MySummonLimit		3;
		SummonRadius		2.0;
		MinimumSummon		3;
	<\CSummonDef>
	
	<CTurncoatDef>
		Turncoatable						BFALSE;
	<\CTurncoatDef>
	
	Components.Add("CTCSolidToThing");

	PBrain							BRAIN_SUMMONER;
	
	Components.Add("CTCGraphicAppearanceAnimatedMesh");
 	Graphic.Type					ENGINE_GRAPHIC_ANIMATING_MESH;

	CreatureType			HUMAN_ADULT;
	Damage					1.0;
	DefaultOwner			2;
	LeaveDeadCreature		FALSE;

	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_SUMMONER);
	<\CHitLocationsDef>

	<CPerceivedThingDef>
		FieldOfView							160;
		SightRadius							14;
		GiveUpChaseRadius					10;
		ExtendedSightRadius					19;
		SoundRadius							15;
		SmellRadius							0;
		Type								PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer						20.0;
		DayTimeVisibilityMultiplier			1.0;
		NightTimeVisibilityMultiplier		0.9;
	<\CPerceivedThingDef>
	
	<CSummonerDef>
		LightningRangeForAutomaticUse		8.0;
		LightningPercentChanceForRandomUse	3.0;
		LightningPercentChanceForBoastUse	15.0;
		LightningRandomChanceTestSeconds	2.0; // test every 2 seconds
		LightningSecondsToWaitBeforeReuse	16.0;
		
		ChargeRangeNear						4.5;
		ChargeRangeFar						6.0;
		ChargeRangeAttackInterrupt			3.0;
		ChargeSecondsToWaitBeforeReuse		5.0;
		
		SummonerDeathExplosion				THING_EXPLOSION_SUMMONER_FLAME_SLICE_SPHERICAL;
		LightningOrb						OBJECT_SUMMONER_LIGHTNING_ORB;
		LightningOrbAttackFireheart			OBJECT_SUMMONER_LIGHTNING_ORB_ATTACK_FIREHEART;
//		LightningOrbLifeSeconds				10.0;
	<\CSummonerDef>
	
	<CAppearanceDef>
		Animation.Add("DEFAULT",						ANIM_CREATURE_SUMMONER_COMBAT_POSE_UNARMED);
		Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_UNARMED, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_IDLE",						ANIM_CREATURE_SUMMONER_COMBAT_POSE_UNARMED);
		Animation.Add("ST_WALK",						ANIM_CREATURE_SUMMONER_WALK_UNARMED, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		Animation.Add("ST_RUN",							ANIM_CREATURE_SUMMONER_CHARGE, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
		
		Animation.Add("TURNING_180ACW",					ANIM_CREATURE_SUMMONER_TURN_180ACW);
		Animation.Add("TURNING_180CW",					ANIM_CREATURE_SUMMONER_TURN_180CW);
		Animation.Add("TURNING_90ACW",					ANIM_CREATURE_SUMMONER_TURN_90ACW);
		Animation.Add("TURNING_90CW",					ANIM_CREATURE_SUMMONER_TURN_90CW);
		
		Animation.StartGroup("SWORD");
			Animation.Add("DEFAULT",						ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED, Flags(ANIM_FLAG_PRELOAD));
			Animation.Add("ST_IDLE",						ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
			Animation.Add("ST_WALK",						ANIM_CREATURE_SUMMONER_WALK_ARMED, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
			Animation.Add("ST_RUN",							ANIM_CREATURE_SUMMONER_CHARGE, Flags(ANIM_FLAG_PRELOAD | ANIM_FLAG_OVERRIDE_FACE_WITH_DEFAULT));
			
			Animation.AddCombat("FALL_TO_KNEES_INTO",			ANIM_CREATURE_SUMMONER_DEATH_WITH_SWORD_INTO);
		Animation.EndGroup();

		Animation.AddCombat("GENERATE_DROP",							ANIM_CREATURE_SUMMONER_SPAWN);
		Animation.AddCombat("RISE_UP",									ANIM_CREATURE_SUMMONER_SPAWN);
		Animation.AddCombat("RISE_UP_STRIKE",							ANIM_CREATURE_SUMMONER_SPAWN);
	
		// responses that aren't used
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_CREATURE_SUMMONER_GET_HIT_RIGHT);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_CREATURE_SUMMONER_GET_HIT_LEFT);		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_CREATURE_SUMMONER_GET_HIT_BACK);
		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_CREATURE_SUMMONER_GET_HIT_KO_RIGHT);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_CREATURE_SUMMONER_GET_HIT_KO_LEFT);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_CREATURE_SUMMONER_GET_HIT_KO_BACK);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
		
		Animation.AddCombat("RESPONSE_DRAIN_LIFE_HIT",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
		Animation.Add("RESPONSE_MULTISTRIKE_TWITCH_01",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
		Animation.Add("RESPONSE_MULTISTRIKE_TWITCH_02",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
		
//		Animation.AddCombat("BLOCK_FRONT_RESPONSE",		ANIM_CREATURE_SUMMONER_);
//		Animation.AddCombat("BLOCK_LEFT_RESPONSE",		ANIM_CREATURE_SUMMONER_);
//		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",		ANIM_CREATURE_SUMMONER_);
//		Animation.AddCombat("BLOCK_BACK_RESPONSE",		ANIM_CREATURE_SUMMONER_);
//		Animation.AddCombat("BLOCK_START",				ANIM_CREATURE_SUMMONER_);
//		Animation.AddCombat("BLOCK_FINISH",				ANIM_CREATURE_SUMMONER_);
		
//		Animation.AddCombat("BLOCK_COUNTER_ATTACK",		ANIM_CREATURE_SUMMONER_);
//	    Animation.AddCombat("COUNTER_BLOCK_RECOIL",		ANIM_CREATURE_SUMMONER_);

		Animation.StartGroup("FORCE_PUSHED");
			Animation.Add("ST_IDLE_SUBTLE",				ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
			Animation.Add("ST_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
		Animation.EndGroup();

	// strafing through creature mode
		Animation.Add("STRAFE_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
		Animation.Add("STRAFE_MOVEMENT_LEFT",			ANIM_CREATURE_SUMMONER_STRAFE_LEFT);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",			ANIM_CREATURE_SUMMONER_STRAFE_RIGHT);
		Animation.Add("STRAFE_MOVEMENT_BACK",			ANIM_CREATURE_SUMMONER_STRAFE_BACKWARDS);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",		ANIM_CREATURE_SUMMONER_STRAFE_FORWARDS);

//		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_POSE_ARMED);
//		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_02);
//		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_03);
		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_04);
		Animation.AddCombat("SPECIAL_IDLE",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_05);
		
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_LEFT",	ANIM_CREATURE_SUMMONER_STRAFE_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_RIGHT",	ANIM_CREATURE_SUMMONER_STRAFE_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_LEFT",	ANIM_CREATURE_SUMMONER_STRAFE_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_RIGHT",	ANIM_CREATURE_SUMMONER_STRAFE_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",		ANIM_CREATURE_SUMMONER_STRAFE_BACKWARDS);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",		ANIM_CREATURE_SUMMONER_STRAFE_FORWARDS);
		
		Animation.Add("BREATHE_IDLE",					ANIM_CREATURE_SUMMONER_BREATHE_IDLE);
		
		Animation.AddCombat("MC_SPECIAL_IDLE_1",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_04);
		Animation.AddCombat("MC_SPECIAL_IDLE_2",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_05);
		
		//////////////////////////////////////////////
		//first number in AddComboStage is the combo number (ie 0, to 1, to 2, to 3 etc...)
		//second number is a unique ID for a combo 
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_CREATURE_SUMMONER_STRIKE_LEFT, Combo(0, 0), Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_CREATURE_SUMMONER_STRIKE_RIGHT, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT));
		
//		Animation.AddCombat("STRIKE_FLAME_SLICE", ANIM_CREATURE_SUMMONER_FLAME_SLICE);
		Animation.AddCombat("STRIKE_FLAME_SLICE", ANIM_CREATURE_SUMMONER_FLAME_SLICE_02);
		
		Animation.AddCombat("STRIKE_WIDE_SWIPE", ANIM_CREATURE_SUMMONER_WIDE_SWIPE);
		
		Animation.AddCombat("STRIKE_RECOIL", ANIM_CREATURE_SUMMONER_STRIKE_RECOIL_RIGHT, Handedness(HANDED_RIGHT, HANDED_LEFT));
		Animation.AddCombat("STRIKE_RECOIL", ANIM_CREATURE_SUMMONER_STRIKE_RECOIL_LEFT, Handedness(HANDED_LEFT, HANDED_RIGHT));
		
		Animation.Add("STANDARD_UNSHEATHE",				ANIM_CREATURE_SUMMONER_UNSHEATHE);
		Animation.Add("STANDARD_SHEATHE",				ANIM_CREATURE_SUMMONER_SHEATHE);
		
		Animation.AddCombat("SUMMON_INTO", ANIM_CREATURE_SUMMONER_SUMMON_INTO);
		Animation.StartGroup("SUMMON");
			Animation.AddCombat("SUMMON_OUT_OF",	ANIM_CREATURE_SUMMONER_SUMMON_OUT_OF);
			Animation.AddCombat("ST_IDLE_SUBTLE",	ANIM_CREATURE_SUMMONER_SUMMON_LOOP);
			Animation.AddCombat("ST_IDLE",			ANIM_CREATURE_SUMMONER_SUMMON_LOOP);
		Animation.EndGroup();
		
		Animation.Add("LIGHTNING_ORB_INTO",					ANIM_CREATURE_SUMMONER_LIGHTING_INTO);
		Animation.StartGroup("LIGHTNING_ORB");	
			Animation.Add("LIGHTNING_ORB_OUT_OF",				ANIM_CREATURE_SUMMONER_LIGHTNING_OUT_OF);
			Animation.Add("LIGHTNING_ORB_OUT_OF_GROUND_SMASH",	ANIM_CREATURE_SUMMONER_LIGHTNING_OUT_OF_GROUND_SMASH);
			Animation.Add("ST_IDLE",						ANIM_CREATURE_SUMMONER_LIGHTING_LOOP);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_SUMMONER_LIGHTING_LOOP);
		Animation.EndGroup();
		Animation.Add("LIGHTNING_FOLLOWUP_IDLE",			ANIM_CREATURE_SUMMONER_COMBAT_IDLE_04);
		
		Animation.AddCombat("FALL_TO_KNEES_INTO",			ANIM_CREATURE_SUMMONER_DEATH_INTO);
		Animation.StartGroup("DYING");
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_SUMMONER_DEATH_LOOP);
			Animation.Add("ST_IDLE",						ANIM_CREATURE_SUMMONER_DEATH_LOOP);
			Animation.Add("FALL_TO_KNEES_OUT_OF",			ANIM_CREATURE_SUMMONER_DEATH_LOOP);
		Animation.EndGroup();
		
		// CUTSCENE ANIMS
		Animation.AddCombat("CS_SUMMON_INTO",				ANIM_CREATURE_SUMMONER_SUMMON_INTO);
		Animation.AddCombat("CS_SUMMON_LOOP",				ANIM_CREATURE_SUMMONER_SUMMON_LOOP);
		Animation.AddCombat("CS_SUMMON_OUTOF",				ANIM_CREATURE_SUMMONER_SUMMON_OUT_OF);
		Animation.Add("CS_SUMMONER_APPEARS",				CS_SUMMONER_APPEARS);
		Animation.Add("CS_SUMMONER_MENACE",					ANIM_CREATURE_SUMMONER_COMBAT_IDLE_05);
		
		//added by Dan for milestone
		Animation.AddCombat("FALL_TO_KNEES",					ANIM_CREATURE_SUMMONER_FALL_TO_KNEES);
		Animation.AddCombat("DIE_LOOP",							ANIM_CREATURE_SUMMONER_DIE_LOOP);
		
		Animation.AddCombat("MOVEMENT_CHARGE_FORWARD",		ANIM_CREATURE_SUMMONER_CHARGE);
		Animation.AddCombat("BK_CHARGE_ATTACK",				ANIM_CREATURE_SUMMONER_CHARGE_SUCCESS);		
		Animation.AddCombat("CHARGE",						ANIM_CREATURE_SUMMONER_CHARGE);
		Animation.AddCombat("CHARGE_SUCCESS",				ANIM_CREATURE_SUMMONER_CHARGE_SUCCESS);
		Animation.AddCombat("CHARGE_FAILURE",				ANIM_CREATURE_SUMMONER_CHARGE_FAILURE);
		
		Animation.AddCombat("BLOCK_IDLE",					ANIM_CREATURE_SUMMONER_BLOCK_IDLE);
		Animation.AddCombat("BLOCK_RECOIL_LEFT",			ANIM_CREATURE_SUMMONER_BLOCK_RECOIL_LEFT);
		Animation.AddCombat("BLOCK_RECOIL_RIGHT",			ANIM_CREATURE_SUMMONER_BLOCK_RECOIL_RIGHT);
		
		Animation.AddCombat("STRIKE_TURN_LEFT",				ANIM_CREATURE_SUMMONER_STRIKE_LEFT_90);
		Animation.AddCombat("STRIKE_TURN_RIGHT",			ANIM_CREATURE_SUMMONER_STRIKE_LEFT_AND_RIGHT);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_CREATURE_SUMMONER_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_CREATURE_SUMMONER_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		

	<\CAppearanceDef>
	
	<CAppearanceDef>
		// add the battlecharge anims here
		Animation.Add("ST_BATTLE_CHARGE_RUN",	ANIM_HORNET_HOVER_IDLE);
		
		Animation.StartGroup("BATTLE_CHARGE");
			Animation.Add("ST_WALK",				ANIM_CREATURE_SUMMONER_CHARGE);
			Animation.Add("ST_JOG",					ANIM_CREATURE_SUMMONER_CHARGE);
			Animation.Add("ST_RUN",					ANIM_CREATURE_SUMMONER_CHARGE);
			Animation.Add("ST_IDLE_SUBTLE",			ANIM_CREATURE_SUMMONER_CHARGE);
			Animation.Add("ST_IDLE",				ANIM_CREATURE_SUMMONER_CHARGE);
		Animation.EndGroup();
		
		Animation.AddCombat("ST_BATTLE_CHARGE_CAST",			ANIM_CREATURE_SUMMONER_CHARGE);
		Animation.AddCombat("ST_BATTLE_CHARGE_BUILD_UP",		ANIM_CREATURE_SUMMONER_CHARGE, Delay(0));
		Animation.AddCombat("ST_BATTLE_CHARGE_IMPACT",			ANIM_CREATURE_SUMMONER_CHARGE_SUCCESS);
		Animation.AddCombat("ST_BATTLE_CHARGE_MISS",			ANIM_CREATURE_SUMMONER_CHARGE_FAILURE);
		Animation.AddCombat("ST_BATTLE_CHARGE_TURN_LEFT",		ANIM_CREATURE_SUMMONER_CHARGE);
		Animation.AddCombat("ST_BATTLE_CHARGE_TURN_RIGHT",		ANIM_CREATURE_SUMMONER_CHARGE);
	<\CAppearanceDef>
	
	<CSpecialEffectsDef>
		SpecialEffects.Add("LIGHTNING_ORB_CHARGE",			SUMMONER_GLOBE_CHARGE);
		SpecialEffects.Add("LIGHTNING_CHARGE",				SUMMONER_LIGHTNING_CHARGE);	
	<\CSpecialEffectsDef>

	Components.Add("CTCWillResponse");
	<CWillResponseDef>
		IsAbleToBeLifted		FALSE;
		IsForcePushable			FALSE;
	<\CWillResponseDef>

	GroupDef					G_CREATURES_FAE;
#end_definition

//*******************************************************************************************************************
#definition_template 	CREATURE 	CREATURE_STAG_BEETLE_BASE		  specialises CREATURE_COMBAT_ENEMY_ANIMAL_TEMPLATE
	PBrain 				BRAIN_BEETLE;

	CombatTypeDef		BEETLE_ATTACK_STYLE;
	
	DeadBodyDecayEffect		DEATH_CRUMBLE_SMALL;
	
	Components.Add("CTCWeaponTrail");

	MaxWalkingSpeed 	0.045;
	MaxRunningSpeed 	0.15;
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_BEETLE);
	<\CHitLocationsDef>

	Graphic.Type		ENGINE_GRAPHIC_ANIMATING_MESH;

	<CCreatureModeDef>
//		DefaultCreatureMode	MODE_HOVER;
	<\CCreatureModeDef>

	<CLookDef>
		DrawEyePrimitives	FALSE;
	<\CLookDef>	

	<CCreatureDef>
		Stats.ExperienceWorth		0;
		Stats.RenownWorth		1;
		Stats.MoralityForKill		0;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;
	<\CCreatureDef>

	<CEntitySoundDef>
		SoundIdentifier	"SI_BEETLE";
	<\CEntitySoundDef>

	<CAppearanceDef>
		Animation.Add("DEFAULT",					ANIM_STAG_BEETLE_IDLE_ON_GROUND_01);
		Animation.Add("ST_IDLE",					ANIM_STAG_BEETLE_IDLE_ON_GROUND_01);
		Animation.Add("ST_IDLE_SUBTLE",				ANIM_STAG_BEETLE_IDLE_ON_GROUND_01);
	
		Animation.Add("ST_WALK",					ANIM_STAG_BEETLE_WALK_01);
		Animation.Add("ST_RUN",						ANIM_STAG_BEETLE_WALK_01);
		Animation.Add("ST_WALK_IDLE",				ANIM_STAG_BEETLE_IDLE_ON_GROUND_01);
	
		Animation.Add("ST_WALK_FORWARD_SLOW",		ANIM_STAG_BEETLE_WALK_01);
		Animation.Add("ST_WALK_BACK_SLOW",			ANIM_STAG_BEETLE_WALK_BACKWARDS_01);
		Animation.Add("ST_WALK_LEFT_SLOW",			ANIM_STAG_BEETLE_STRAFE_LEFT_01);
		Animation.Add("ST_WALK_RIGHT_SLOW",			ANIM_STAG_BEETLE_STRAFE_RIGHT_01);

		Animation.Add("ST_WALK_FORWARD_MEDIUM",		ANIM_STAG_BEETLE_WALK_01);
		Animation.Add("ST_WALK_BACK_MEDIUM",		ANIM_STAG_BEETLE_WALK_BACKWARDS_01);
		Animation.Add("ST_WALK_LEFT_MEDIUM",		ANIM_STAG_BEETLE_STRAFE_LEFT_01);
		Animation.Add("ST_WALK_RIGHT_MEDIUM",		ANIM_STAG_BEETLE_STRAFE_RIGHT_01);

		Animation.Add("ST_WALK_FORWARD_FAST",		ANIM_STAG_BEETLE_WALK_01);
		Animation.Add("ST_WALK_BACK_FAST",			ANIM_STAG_BEETLE_WALK_BACKWARDS_01);
		Animation.Add("ST_WALK_LEFT_FAST",			ANIM_STAG_BEETLE_STRAFE_LEFT_01);
		Animation.Add("ST_WALK_RIGHT_FAST",			ANIM_STAG_BEETLE_STRAFE_RIGHT_01);

		Animation.Add("STRAFE_IDLE",				ANIM_STAG_BEETLE_IDLE_ON_GROUND_01);
		Animation.Add("STRAFE_MOVEMENT_LEFT",		ANIM_STAG_BEETLE_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",		ANIM_STAG_BEETLE_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",		ANIM_STAG_BEETLE_WALK_BACKWARDS_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",	ANIM_STAG_BEETLE_WALK_01);

		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",	ANIM_STAG_BEETLE_HOVER_FORWARDS_01);


		///////////////////////////////////////////////////////////////////////////////////////////


		Animation.AddCombat("ST_HOVER_IDLE",			ANIM_STAG_BEETLE_HOVER_IDLE_01);
		Animation.AddCombat("SPECIAL_IDLE",			ANIM_STAG_BEETLE_HOVER_IDLE_01);

		Animation.AddCombat("ST_HOVER_FORWARD_SLOW",	ANIM_STAG_BEETLE_HOVER_FORWARDS_01);
		Animation.AddCombat("ST_HOVER_BACK_SLOW",		ANIM_STAG_BEETLE_HOVER_BACK_01);
		Animation.AddCombat("ST_HOVER_RIGHT_SLOW",	ANIM_STAG_BEETLE_HOVER_RIGHT_01);
		Animation.AddCombat("ST_HOVER_LEFT_SLOW",		ANIM_STAG_BEETLE_HOVER_LEFT_01);
		
		Animation.AddCombat("ST_HOVER_FORWARD_MEDIUM",ANIM_STAG_BEETLE_HOVER_FORWARDS_01);
		Animation.AddCombat("ST_HOVER_BACK_MEDIUM",	ANIM_STAG_BEETLE_HOVER_BACK_01);
		Animation.AddCombat("ST_HOVER_RIGHT_MEDIUM",	ANIM_STAG_BEETLE_HOVER_RIGHT_01);
		Animation.AddCombat("ST_HOVER_LEFT_MEDIUM",	ANIM_STAG_BEETLE_HOVER_LEFT_01);
		
		Animation.AddCombat("ST_HOVER_FORWARD_FAST",	ANIM_STAG_BEETLE_HOVER_FORWARDS_01);
		Animation.AddCombat("ST_HOVER_BACK_FAST",		ANIM_STAG_BEETLE_HOVER_BACK_01);
		Animation.AddCombat("ST_HOVER_RIGHT_FAST",	ANIM_STAG_BEETLE_HOVER_RIGHT_01);
		Animation.AddCombat("ST_HOVER_LEFT_FAST",		ANIM_STAG_BEETLE_HOVER_LEFT_01);

		Animation.AddCombat("STRIKE_SHORT_FRONT",	ANIM_STAG_BEETLE_ATTACK_01);
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",	ANIM_STAG_BEETLE_ATTACK_01);
		Animation.AddCombat("STRIKE_RECOIL",		ANIM_STAG_BEETLE_ATTACK_BLOCKED_01);
		Animation.AddCombat("FLIP_TO_BACK",			ANIM_STAG_BEETLE_FLIP_01);
		Animation.AddCombat("ATTACK_BLOCKED",		ANIM_STAG_BEETLE_ATTACK_BLOCKED_01);
		Animation.AddCombat("POSE_DEAD",			ANIM_STAG_BEETLE_POSE_DEAD_01);
			
		Animation.Add("STANDARD_DIE",						ANIM_STAG_BEETLE_POSE_DEAD_01);
		Animation.Add("STANDARD_DEAD",						ANIM_STAG_BEETLE_POSE_DEAD_01);
		Animation.Add("STABBED_TO_DEAD",					ANIM_STAG_BEETLE_STABBED_01);
		Animation.Add("STABBED_ALREADY_DEAD",				ANIM_STAG_BEETLE_POSE_DEAD_01);

		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN", ANIM_STAG_BEETLE_FLIP_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN", ANIM_STAG_BEETLE_FLIP_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN", ANIM_STAG_BEETLE_FLIP_01);

		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_STAG_BEETLE_HIT_ON_GROUND_RIGHT_01 );
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_STAG_BEETLE_HIT_ON_GROUND_LEFT_01	);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_STAG_BEETLE_HIT_ON_GROUND_LEFT_01	);

		Animation.AddCombat("FALL_DEAD",			ANIM_STAG_BEETLE_FLIP_01);
		Animation.AddCombat("FALL_UNCONSCIOUS",		ANIM_STAG_BEETLE_FLIP_01);

		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_STAG_BEETLE_RECOVER_ON_GROUND_01);

		Animation.StartGroup("HOVER");
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN", ANIM_STAG_BEETLE_KNOCKED_DOWN_FROM_HOVER_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN", ANIM_STAG_BEETLE_KNOCKED_DOWN_FROM_HOVER_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN", ANIM_STAG_BEETLE_KNOCKED_DOWN_FROM_HOVER_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_STAG_BEETLE_HIT_RIGHT_01 );
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_STAG_BEETLE_HIT_LEFT_01	);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_STAG_BEETLE_HIT_LEFT_01	);

			Animation.AddCombat("FALL_DEAD",			ANIM_STAG_BEETLE_KNOCKED_DOWN_FROM_HOVER_01);
			Animation.AddCombat("FALL_UNCONSCIOUS",			ANIM_STAG_BEETLE_KNOCKED_DOWN_FROM_HOVER_01);

			Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER", ANIM_STAG_BEETLE_RECOVER_01);			
		Animation.EndGroup();
	
		Animation.AddCombat("HIT_ON_GROUND_LEFT",	ANIM_STAG_BEETLE_HIT_ON_GROUND_LEFT_01);
		Animation.AddCombat("HIT_ON_GROUND_RIGHT",	ANIM_STAG_BEETLE_HIT_ON_GROUND_RIGHT_01);
//		Animation.AddCombat("LEAP",					ANIM_STAG_BEETLE_LEAP_01);
//		Animation.AddCombat("STRAFE_LEFT",			ANIM_STAG_BEETLE_STRAFE_LEFT_01);
//		Animation.AddCombat("STRAFE_RIGHT",			ANIM_STAG_BEETLE_STRAFE_RIGHT_01);

		Animation.AddCombat("TAKE_OFF",				ANIM_STAG_BEETLE_TAKE_OFF_01);
		Animation.AddCombat("LAND",					ANIM_STAG_BEETLE_LAND_01);
		
		Animation.Add("GENERATE_DROP",				ANIM_STAG_BEETLE_BURROW_FROM_GROUND_01);
		Animation.Add("RISE_UP",					ANIM_STAG_BEETLE_BURROW_FROM_GROUND_01);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_STAG_BEETLE_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_STAG_BEETLE_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	<\CAppearanceDef>

	DefaultOwner		0;

	<CSpecialEffectsDef>
		SpecialEffects.Add("RISE",					SCORPION_RISE_DUST_01);
		SpecialEffects.Add("GENERATE",				SCORPION_RISE_DUST_01);
	<\CSpecialEffectsDef>
	
	<CSummonableCreatureDef>
		Rank								4;
		SummonedBrain						"BRAIN_SUMMONNED_BEETLE";
	<\CSummonableCreatureDef>

	GroupDef				G_CREATURES_HOSTILE;
	
#end_definition

//*******************************************************************************************************************
#definition_template 	CREATURE 	CREATURE_HORNET_TEMPLATE   specialises CREATURE_COMBAT_ENEMY_ANIMAL_TEMPLATE
	PBrain 				BRAIN_HORNET;
	
	DeadBodyDecayEffect		DEATH_CRUMBLE_SMALL;
	
	<CCreatureModeDef>
		DefaultCreatureMode	MODE_HOVER;
	<\CCreatureModeDef>
	
	<CLookDef>
		DrawEyePrimitives	FALSE;
	<\CLookDef>	

	<CPerceivedThingDef>
		FieldOfView			360;
		SightRadius			15;
		ExtendedSightRadius	18;
		SoundRadius			10;
		SmellRadius			0;
		Type				PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer		8.0;
	<\CPerceivedThingDef>

	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_WASP);
	<\CHitLocationsDef>

	NavigatorTypes.Add(NAV_INIT_FLYER);
	
	AbleToStrafe		TRUE;
	Health 					2;
	
	StunHealthThreshold 10;
	StunTimeMin			5;
	StunTimeMax			5;
	
	Components.Add("CTCWeaponTrail");
	Components.Add("CTCWeapon");
	
	<CWeaponDef>
		ProjectileWeaponHelperNameTip "weapon_pos_sting";
		ProjectileWeaponHelperNameBase "weapon_pos_sting";
		Damage	1.0;
	<\CWeaponDef>
	
	Graphic.Type		ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 	MESH_HORNET_01;
	
	CombatTypeDef			FODDER_CREATURE_ATTACK_STYLE;
	CombatDiameter			1.0;	//most things don't need this so don't just copy it around you fuck!

	<CEntitySoundDef>
		SoundMap.AddSingle("CREATURE_CONTINUOUS", SND_HORNETLOOP);
		SoundIdentifier	"SI_HORNET";
	<\CEntitySoundDef>
	
	<CSpecialEffectsDef>
		SpecialEffects.Add("FEED_ON_MAN",				HORNET_FEASTING);
		SpecialEffects.Add("BLOOD_SPURT",				BLOOD_SPRAY_YELLOW_UP);
		SpecialEffects.Add("BLOOD_SPRAY_WASP_STAB",		BLOOD_SPRAY_WASP_STAB);
	<\CSpecialEffectsDef>
	
	//Sound["STF_PAIN"] 		SND_HORNETHIT_01;	Sound["STL_PAIN"] 			SND_HORNETHIT_02;

	<CPhysicsDef>
		Diameter		0.2;
	<\CPhysicsDef>

	MaxHoverSpeedSlow	0.5;
//	MaxHoverSpeedMedium 0.3;
	MaxHoverSpeedFast	1.0;
	MaxRunningSpeed		1.0;
	
	<CAppearanceDef>
		Animation.Add("DEFAULT",					ANIM_HORNET_HOVER_IDLE);
		Animation.Add("ST_HOVER_IDLE",				ANIM_HORNET_HOVER_IDLE);
		Animation.Add("ST_HOVER_FORWARD_SLOW",		ANIM_HORNET_HOVER_FORWARD_01);
		Animation.Add("ST_HOVER_BACK_SLOW",			ANIM_HORNET_HOVER_BACK_01);
		Animation.Add("ST_HOVER_RIGHT_SLOW",		ANIM_HORNET_HOVER_RIGHT_01);
		Animation.Add("ST_HOVER_LEFT_SLOW",			ANIM_HORNET_HOVER_LEFT_01);
		Animation.Add("ST_HOVER_FORWARD_MEDIUM",	ANIM_HORNET_HOVER_FORWARD_01);
		Animation.Add("ST_HOVER_BACK_MEDIUM",		ANIM_HORNET_HOVER_BACK_01);
		Animation.Add("ST_HOVER_RIGHT_MEDIUM",		ANIM_HORNET_HOVER_RIGHT_01);
		Animation.Add("ST_HOVER_LEFT_MEDIUM",		ANIM_HORNET_HOVER_LEFT_01);
		Animation.Add("ST_HOVER_FORWARD_FAST",		ANIM_HORNET_HOVER_FORWARD_01);
		Animation.Add("ST_HOVER_BACK_FAST",			ANIM_HORNET_HOVER_BACK_01);
		Animation.Add("ST_HOVER_RIGHT_FAST",		ANIM_HORNET_HOVER_RIGHT_01);
		Animation.Add("ST_HOVER_LEFT_FAST",			ANIM_HORNET_HOVER_LEFT_01);

		Animation.Add("STRAFE_IDLE",				ANIM_HORNET_HOVER_IDLE);
		Animation.Add("STRAFE_MOVEMENT_LEFT",		ANIM_HORNET_HOVER_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",		ANIM_HORNET_HOVER_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",		ANIM_HORNET_HOVER_BACK_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",	ANIM_HORNET_HOVER_FORWARD_01);
		
		Animation.Add("MOVEMENT_STRAFE_FORWARD",	ANIM_HORNET_HOVER_FORWARD_01);
		
		Animation.Add("ST_FEED_INTO",				ANIM_HORNET_FEED_INTO);
		Animation.Add("ST_FEED_LOOP",				ANIM_HORNET_FEED_LOOP);
		Animation.Add("ST_FEED_OUTOF",				ANIM_HORNET_FEED_OUTOF);
	
		Animation.StartGroup("HELP_I_AM_A_PROJECTILE");
			Animation.AddCombat("ST_IDLE", ANIM_HORNET_CURLED_UP_01);
			Animation.AddCombat("ST_IDLE_SUBTLE", ANIM_HORNET_CURLED_UP_01);
			Animation.AddCombat("ST_RUN", ANIM_HORNET_CURLED_UP_01);
			Animation.AddCombat("ST_WALK", ANIM_HORNET_CURLED_UP_01);
		Animation.EndGroup();

//		Animation.Add("ST_FEED_ON_HUMAN_FLESH_GWA_HA_HA_HA_01", ANIM_HORNET_FEED_ON_HUMAN_FLESH_GWA_HA_HA_HA_01);

		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_HORNET_ATTACK_01, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_HORNET_RECOIL_01));
		Animation.AddCombat("STRIKE_MEDIUM_FRONT",		ANIM_HORNET_ATTACK_02, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_HORNET_RECOIL_01));
		Animation.AddCombat("STRIKE_RECOIL",		ANIM_HORNET_RECOIL_01);
		Animation.AddCombat("STRIKE_MEDIUM_SECONDARY",	ANIM_HORNET_ATTACK_01);
		Animation.AddCombat("SPECIAL_IDLE",				ANIM_HORNET_IDLE_SHORT_01);
		Animation.AddCombat("WASP_VS_WASP",			ANIM_HORNET_ATTACK_02);
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_HORNET_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_HORNET_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
	<\CAppearanceDef>

	<CCreatureDef>
		Stats.ExperienceWorth	5;
		Stats.RenownWorth		2;

		Stats.MoralityForKill		1;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		CreatureGroup			CREATURE_GROUP_WASP;
	<\CCreatureDef>
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//the complete set of generic responses and dead and stunned etc idles
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////
	<CAppearanceDef>
		Animation.AddCombat("KNOCKDOWN_IDLE",					ANIM_HORNET_STAB_TWITCH_01);
//		Animation.AddCombat("KNOCKDOWN_IDLE",					ANIM_HORNET_STAB_TWITCH_02);
		Animation.AddCombat("STANDARD_DEAD",					ANIM_HORNET_DEAD_01);
		Animation.AddCombat("STANDARD_DIE",					ANIM_HORNET_FALL_DEAD_01);
		Animation.AddCombat("STABBED_TO_DEAD",				ANIM_HORNET_FALL_DEAD_01);
		Animation.AddCombat("STABBED_ALREADY_DEAD",				ANIM_HORNET_DEAD_01);
		Animation.AddCombat("ST_STABBED_WHEN_DEAD",			ANIM_HORNET_DEAD_01);
		Animation.AddCombat("FEED",							ANIM_HORNET_FEED_01);

		Animation.StartGroup("STUNNED");
			Animation.AddCombat("ST_IDLE",								ANIM_HORNET_STAB_TWITCH_01); // ANIM_HORNET_STAB_TWITCH_02);
			Animation.AddCombat("ST_IDLE_SUBTLE",							ANIM_HORNET_STAB_TWITCH_01);
			Animation.AddCombat("ST_IDLE_SUBTLE",							ANIM_HORNET_STAB_TWITCH_02);
			Animation.AddCombat("STABBED_TO_DEAD",						ANIM_HORNET_FALL_DEAD_01);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_HORNET_STAB_TWITCH_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_HORNET_STAB_TWITCH_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_HORNET_STAB_TWITCH_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_HORNET_STAB_TWITCH_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_HORNET_STAB_TWITCH_01);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_HORNET_STAB_TWITCH_01);
		Animation.EndGroup();
		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_HORNET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_HORNET_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_HORNET_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_HORNET_KO_LIVE_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_HORNET_KO_LIVE_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_HORNET_KO_LIVE_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_HORNET_KO_RECOVER_01);
		
		Animation.AddCombat("FALL_DEAD",					ANIM_HORNET_FALL_DEAD_01);
		Animation.AddCombat("FALL_UNCONSCIOUS",				ANIM_HORNET_FALL_DEAD_01);
	<\CAppearanceDef>

#end_definition

//*******************************************************************************************
//************ WHISPER TEMPLATE *************************************************************
//*******************************************************************************************
#definition_template 	CREATURE 	CREATURE_RIVAL_HERO_WHISPER_BASE			specialises  CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE

	Health 						25;
	
	PBrain						BRAIN_WHISPER;
	
	Components.Add("CTCHero");
	<CHeroDef>
		DefaultTitle			OBJECT_HERO_TITLE_WHISPER;
	<\CHeroDef>

	Sex							SEX_FEMALE;
	CreatureInteractionType		CREATURE_INTERACTION_CONVERSATION;

	Damage						2.0;
	AbleToStrafe				TRUE;
	
	<CPerceivedThingDef>
		FieldOfView				360;
		SightRadius				20;
		GiveUpChaseRadius		15;
		ExtendedSightRadius		25;
		SoundRadius				15;
		SmellRadius				0;
		AwarenessTimer			20.0;
	<\CPerceivedThingDef>
	
	Components.Add("CTCWeaponTrail");

	<CSpecialEffectsDef>
		SpecialEffects.Add("UNBLOCKABLE_EFFECT",	WHISPER_LUNGE_01);
	<\CSpecialEffectsDef>
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_WHISPER);
	<\CHitLocationsDef>
	
	EyeGraphic.Type				ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex		MESH_RIVAL_HERO_WHISPER_EYE_01;
	EyeGraphic.RenderSizeX		1.34;
	
	InitialWeaponDef			NULL;
	PrimaryMeleeWeaponDef		OBJECT_RIVAL_HERO_WHISPER_STAFF;

	CombatTypeDef				HERO_WHISPER_ATTACK_STYLE;
	
	StunHealthThreshold		8;
	StunTimeMin				3;
	StunTimeMax				3;

	Components.Add("CTCBoss");
	
	<CBossDef>
		PhaseHealthPercent[0]	50;
		PhaseHealthPercent[1]	25;
		PhaseHealthPercent[2]	0;
	<\CBossDef>
	
	<CWhisperBattleDef>
		NumGetHitsBeforeSommersault	1;
		NumPhase2Potions			5;
	<\CWhisperBattleDef>
	
	<CWeaponDef>
		Shot				SHOT_THROWING_POTION;
	<\CWeaponDef>
	
	Components.Add("CTCRandomAppearanceMorph");
	Components.Add("CTCSkeletalMorph");

	<CAppearanceDef>
	
		Animation.Add("DEFAULT",										ANIM_VILLAGER_FEMALE_IDLE_01);
		Animation.Add("TURNING_C90",									ANIM_VILLAGER_FEMALE_TURN_90_RIGHT_01);
		Animation.Add("TURNING_AC90",									ANIM_VILLAGER_FEMALE_TURN_90_LEFT_01);
		Animation.Add("TURNING_C180",									ANIM_VILLAGER_FEMALE_TURN_180_RIGHT_01);
		Animation.Add("TURNING_AC180",									ANIM_VILLAGER_FEMALE_TURN_180_LEFT_01);
		Animation.Add("ST_IDLE",										ANIM_VILLAGER_FEMALE_IDLE_01);
		Animation.Add("ST_IDLE_SUBTLE",									ANIM_VILLAGER_FEMALE_IDLE_01);
		Animation.Add("ST_WALK",										ANIM_BIPED_NEW_VILLAGER_FEMALE_WALK);
		Animation.Add("ST_RUN",											ANIM_RIVAL_HERO_WHISPER_RUN_WITHOUT_WEAPON_01);
		Animation.Add("ST_HEAD_TURN_V",									ANIM_BIPED_NEW_VILLAGER_FEMALE_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_HEAD_TURN_H",									ANIM_BIPED_NEW_VILLAGER_FEMALE_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));

		Animation.StartGroup("STAND");
			Animation.Add("DEFAULT",										ANIM_VILLAGER_FEMALE_IDLE_01);
			Animation.Add("ST_POSE",										ANIM_VILLAGER_FEMALE_IDLE_01);
			Animation.Add("ST_IDLE",										ANIM_VILLAGER_FEMALE_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",									ANIM_VILLAGER_FEMALE_IDLE_01);
			Animation.Add("ST_WALK",										ANIM_BIPED_NEW_VILLAGER_FEMALE_WALK);
			Animation.Add("ST_RUN",											ANIM_RIVAL_HERO_WHISPER_RUN_WITHOUT_WEAPON_01);
		Animation.EndGroup();
	
		Animation.StartGroup("STAFF");
			Animation.Add("TURNING_C90",									ANIM_RIVAL_HERO_WHISPER_TURN_RIGHT_01);
			Animation.Add("TURNING_AC90",									ANIM_RIVAL_HERO_WHISPER_TURN_LEFT_01);
			Animation.Add("DEFAULT",										ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);
			Animation.Add("ST_POSE",										ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);
			Animation.Add("ST_IDLE",										ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);
			Animation.Add("ST_IDLE_SUBTLE",									ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);
			Animation.Add("ST_WALK",										ANIM_RIVAL_HERO_WHISPER_WALK_01);
			Animation.Add("ST_RUN",											ANIM_RIVAL_HERO_WHISPER_RUN_01);
			
			Animation.AddCombat("STRIKE_MEDIUM_FRONT",						ANIM_RIVAL_HERO_WHISPER_STRIKE_LEFT_01,  Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_RIVAL_HERO_WHISPER_STRIKE_LEFT_RECOIL_01));
			Animation.AddCombat("STRIKE_MEDIUM_FRONT",						ANIM_RIVAL_HERO_WHISPER_STRIKE_RIGHT_01, Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_RIVAL_HERO_WHISPER_STRIKE_RIGHT_RECOIL_01));
			Animation.AddCombat("STRIKE_SHORT_FRONT",						ANIM_RIVAL_HERO_WHISPER_STRIKE_LEFT_01, Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_RIVAL_HERO_WHISPER_STRIKE_LEFT_RECOIL_01));
		
			Animation.AddCombat("STRIKE_MEDIUM_FRONT",						ANIM_RIVAL_HERO_WHISPER_STRIKE_KICK_01, Handedness(HANDED_RIGHT, HANDED_LEFT));
			Animation.AddCombat("STRIKE_MEDIUM_360",						ANIM_RIVAL_HERO_WHISPER_STRIKE_360_01);
		
			Animation.AddCombat("BLOCK_FRONT_RESPONSE",						ANIM_RIVAL_HERO_WHISPER_BLOCK_01);
			
			Animation.AddCombat("STRIKE_RECOIL",							ANIM_RIVAL_HERO_WHISPER_STRIKE_LEFT_RECOIL_01);
			Animation.AddCombat("STRIKE_RECOIL",							ANIM_RIVAL_HERO_WHISPER_STRIKE_RIGHT_RECOIL_01);
		
			Animation.AddCombat("BLOCK_IDLE",								ANIM_RIVAL_HERO_WHISPER_BLOCK_IDLE_01);
			Animation.AddCombat("BLOCK_COUNTER_ATTACK",						ANIM_RIVAL_HERO_WHISPER_STRIKE_LUNGE_01);
		Animation.EndGroup();
		
		
		Animation.Add("STANDARD_DEAD",									ANIM_VILLAGER_FEMALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.Add("STANDARD_DIE",									ANIM_VILLAGER_FEMALE_UNCONSCIOUS_TO_DEAD_01);
		Animation.Add("SCRIPT_WHISPER_BOAST_01",						ANIM_RIVAL_HERO_WHISPER_BOAST_01);
		Animation.Add("SCRIPT_WHISPER_BOAST_02",						ANIM_BANDIT_BOAST_THREATEN_01);
		Animation.Add("SCRIPT_WHISPER_BOAST_03",						ANIM_BANDIT_BOAST_SHOUT_01);
		
		Animation.Add("WHATS_THAT",										ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);
		
		Animation.Add("STRAFE_IDLE",									ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",							ANIM_RIVAL_HERO_WHISPER_STRAFE_LEFT_01);
		Animation.Add("STRAFE_MOVEMENT_LEFT",							ANIM_RIVAL_HERO_WHISPER_STRAFE_RIGHT_01);
		Animation.Add("STRAFE_MOVEMENT_BACK",							ANIM_RIVAL_HERO_WHISPER_JUMP_BACK_SHORT_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",						ANIM_RIVAL_HERO_WHISPER_JUMP_FORWARD_SHORT_01);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",						ANIM_RIVAL_HERO_WHISPER_STRAFE_FORWARD_01);

		Animation.AddCombat("SPECIAL_BOAST",							ANIM_RIVAL_HERO_WHISPER_BLOW_KISS_01);
//		Animation.AddCombat("SPECIAL_BOAST",							ANIM_RIVAL_HERO_WHISPER_BOAST_01);
		Animation.AddCombat("SPECIAL_IDLE",								ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);

		
		
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",					ANIM_RIVAL_HERO_WHISPER_JUMP_FORWARD_SHORT_01);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",					ANIM_RIVAL_HERO_WHISPER_STRAFE_FORWARD_01);
		Animation.AddCombat("MOVEMENT_LONG_BACK",						ANIM_RIVAL_HERO_WHISPER_JUMP_BACK_LONG_01);
		Animation.AddCombat("MOVEMENT_LONG_FORWARD",					ANIM_RIVAL_HERO_WHISPER_JUMP_FORWARD_LONG_01);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",					ANIM_RIVAL_HERO_WHISPER_JUMP_BACK_SHORT_01);
		
		Animation.AddCombat("WHISPER_THROW_ITEM",						ANIM_RIVAL_HERO_WHISPER_THROW_ITEM_01);
		
		Animation.AddCombat("STANDARD_SHEATHE",							ANIM_RIVAL_HERO_WHISPER_SHEATHE_01);
		Animation.AddCombat("STANDARD_UNSHEATHE",						ANIM_RIVAL_HERO_WHISPER_UNSHEATHE_01);
		Animation.AddCombat("ST_UNSHEATHE_TO_COMBAT_POSE",				ANIM_RIVAL_HERO_WHISPER_UNSHEATHE_01);
		
	
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",				ANIM_RIVAL_HERO_WHISPER_HIT_BACK_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",				ANIM_RIVAL_HERO_WHISPER_HIT_LEFT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",				ANIM_RIVAL_HERO_WHISPER_HIT_RIGHT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",		ANIM_RIVAL_HERO_WHISPER_HIT_KNOCKOUT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",		ANIM_RIVAL_HERO_WHISPER_HIT_KNOCKOUT_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",		ANIM_RIVAL_HERO_WHISPER_HIT_KNOCKOUT_BACK_01);
		Animation.AddCombat("KNOCKDOWN_IDLE",							ANIM_RIVAL_HERO_WHISPER_KNOCKOUT_IDLE_01);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_KNOCKDOWN_RECOVER",	ANIM_RIVAL_HERO_WHISPER_KNOCKOUT_RECOVER_01);
		
		Animation.AddCombat("FALL_DEAD",								ANIM_RIVAL_HERO_WHISPER_HIT_KNOCKOUT_01); 
		Animation.AddCombat("FALL_UNCONSCIOUS",							ANIM_RIVAL_HERO_WHISPER_HIT_KNOCKOUT_01); 

		Animation.AddCombat("ST_CAST_PHYSICAL_SHIELD",					ANIM_RIVAL_HERO_WHISPER_WILL_CAST_01);
		Animation.AddCombat("ST_RELEASE_PHYSICAL_SHIELD",				ANIM_RIVAL_HERO_WHISPER_COMBAT_IDLE_01);		
		Animation.AddCombat("WILL_CAST_FORCE_SPELL_INTO",				ANIM_RIVAL_HERO_WHISPER_WILL_CAST_01);
		Animation.AddCombat("WILL_CAST_FORCE_SPELL_BUILDUP",			ANIM_RIVAL_HERO_WHISPER_WILL_CAST_01);
		Animation.AddCombat("WILL_CAST_FORCE_SPELL_DELIVER_LEVEL_1",	ANIM_RIVAL_HERO_WHISPER_WILL_CAST_01);
		Animation.AddCombat("WILL_CAST_FORCE_SPELL_DELIVER_LEVEL_2",	ANIM_RIVAL_HERO_WHISPER_JUMP_BACK_SHORT_01);
		
		Animation.AddCombat("ST_CAST_ASSASSIN_RUSH",					ANIM_RIVAL_HERO_WHISPER_WILL_CAST_02);
		
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_UNBLOCKABLE",			ANIM_RIVAL_HERO_WHISPER_STRIKE_LUNGE_01, Handedness(HANDED_NONE, HANDED_NONE));
	
		Animation.AddCombat("GENERATE_DROP",							ANIM_RIVAL_HERO_WHISPER_LAND_APPEAR_01);
		Animation.AddCombat("JUMP_INTO_SKY",							ANIM_RIVAL_HERO_WHISPER_JUMP_DISAPPEAR_01);
		Animation.AddCombat("THROW_OBJECT",								ANIM_RIVAL_HERO_WHISPER_THROW_ITEM_01);

		Animation.AddCombat("STANDARD_SHEATHE",							ANIM_RIVAL_HERO_WHISPER_SHEATHE_01);
		Animation.AddCombat("STANDARD_UNSHEATHE",						ANIM_RIVAL_HERO_WHISPER_UNSHEATHE_01);
		
		Animation.StartGroup("CONVERSATION_HAPPY");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_BELLIGERENT");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_ANGRY");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_FEAR");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SCARED_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_SAD");
			Animation.Add("DEFAULT",		ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BASE_01);
			Animation.Add("ST_IDLE",		ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BASE_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",	ANIM_VILLAGER_FEMALE_CONVERSATION_SAD_BREAKOFF_04);
		Animation.EndGroup();
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_RIVAL_HERO_WHISPER_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_RIVAL_HERO_WHISPER_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();		
		
	<\CAppearanceDef>
	
	<CAppearanceDef>
		Animation.Add("ST_OPINION_APPROVAL_CHEERING_BOTH_ARMS_UP", ANIM_VILLAGER_FEMALE_AWE_02);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_ARMS_UP", ANIM_VILLAGER_FEMALE_AWE_03);
		Animation.Add("ST_OPINION_APPROVAL_CLAPPING_NORMAL", ANIM_VILLAGER_FEMALE_AWE_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_INTO", ANIM_VILLAGER_FEMALE_BLOW_KISS_INTO_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_LOOP", ANIM_VILLAGER_FEMALE_BLOW_KISS_LOOP_01);
		Animation.Add("ST_OPINION_APPROVAL_ECSTATIC_GESTURING_OUTOF", ANIM_VILLAGER_FEMALE_BLOW_KISS_OUT_01);
		Animation.Add("ST_OPINION_APPROVAL_REACTION_ARMS_WIDE_GREET", ANIM_VILLAGER_FEMALE_FRIENDLY_01);
		Animation.Add("ST_OPINION_APPROVAL_WAVING_AT_DISTANCE", ANIM_VILLAGER_FEMALE_RESPONSE_WAVE_01);
		Animation.Add("ST_OPINION_ATTRACTED_HANDS_CLASPED_SWAYING", ANIM_VILLAGER_FEMALE_ATTRACTED_02);
		Animation.Add("ST_OPINION_ATTRACTED_PREENING_SELF", ANIM_VILLAGER_FEMALE_CHECK_APPEARANCE_01);
		Animation.Add("ANIM_VILLAGER_FEMALE_ATTRACT_SHOUT_01", ANIM_VILLAGER_FEMALE_ATTRACT_SHOUT_01);
		Animation.Add("ST_OPINION_ATTRACTED_WAVING_AT", ANIM_VILLAGER_FEMALE_ATTRACT_WAVE_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_BOOING", ANIM_VILLAGER_FEMALE_CROWD_HECKLE_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_CALLING_OVER_FOR_FIGHT", ANIM_VILLAGER_FEMALE_HOMICIDAL_INTRO);
		Animation.Add("ST_OPINION_DISAPPROVAL_DISMISSING_HAND_SWIPE", ANIM_VILLAGER_FEMALE_OUTRAGED_06);
		//Animation.Add("ST_OPINION_DISAPPROVAL_NYAH_NYAH", ANIM_VILLAGER_FEMALE_);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINT_AT", ANIM_VILLAGER_FEMALE_OUTRAGED_05);
		Animation.Add("ST_OPINION_DISAPPROVAL_POINTING_AWAY_GET_OUT", ANIM_VILLAGER_FEMALE_OUTRAGED_01);
		Animation.Add("ST_OPINION_DISAPPROVAL_SHAKE_FIST", ANIM_VILLAGER_FEMALE_OUTRAGED_03);
		Animation.Add("ST_OPINION_DISAPPROVAL_STAMP_FOOT", ANIM_VILLAGER_FEMALE_OUTRAGED_04);
		Animation.Add("ST_OPINION_DISAPPROVAL_THUMBS_DOWN", ANIM_VILLAGER_FEMALE_THUMBS_DOWN_01);
		Animation.Add("ST_OPINION_FEAR_IDLE_COWERING", ANIM_VILLAGER_FEMALE_AFRAID_LOOP_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SHRINKING_AWAY", ANIM_VILLAGER_FEMALE_FEAR_01);
		Animation.Add("ST_OPINION_FEAR_REACTION_SURPRISED", ANIM_VILLAGER_FEMALE_SURPRISE_01);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_FRONT", ANIM_BIPED_NEW_VILLAGER_FEMALE_SCARED_RUN);
		Animation.Add("ST_OPINION_FEAR_RUN_AWAY_ARMS_UP", ANIM_VILLAGER_FEMALE_FEAR_RUN_01);
		Animation.Add("ST_OPINION_NEUTRAL_POINT_AT", ANIM_VILLAGER_FEMALE_OUTRAGED_02);
		Animation.Add("ST_OPINION_NEUTRAL_POINTING_CALLING_FRIEND", ANIM_VILLAGER_FEMALE_FASCINATION_01);
		Animation.Add("ST_OPINION_NEUTRAL_REACTION_HAND_UP_GREET", ANIM_VILLAGER_FEMALE_GREET_01);
		Animation.Add("ST_OPINION_NEUTRAL_SHOUTING_WITH_HANDS_CUPPED", ANIM_VILLAGER_FEMALE_SHOUT_INSULT_01);
		Animation.Add("ST_OPINION_NEUTRAL_SURPRISE", ANIM_VILLAGER_FEMALE_SURPRISE_LOOP_01);
		Animation.Add("ST_OPINION_NEUTRAL_WALK_NERVOUS_LOOKING_BACK", ANIM_VILLAGER_FEMALE_FEAR_WALK_02);
		Animation.Add("ST_OPINION_RIDICULE_BELLY_LAUGH", ANIM_VILLAGER_FEMALE_RIDICULE_03);
		Animation.Add("ST_OPINION_RIDICULE_POINT_AND_LAUGH", ANIM_VILLAGER_FEMALE_RIDICULE_01);
		Animation.Add("ST_OPINION_RIDICULE_SNIGGER", ANIM_VILLAGER_FEMALE_RIDICULE_02);

		Animation.AddCombat("ST_OPINION_FEAR_WALK_EDGING_BACKWARDS", ANIM_VILLAGER_FEMALE_FEAR_WALK_01);

		// CUTSCENE ANIMATIONS
		Animation.Add("CS_OUTOF_BOAST",										CS_FEMALE_BOASTING_OUTOF);
		Animation.Add("CS_BEG_INTO",										ANIM_VILLAGER_FEMALE_BEG_INTO_01);
		Animation.Add("CS_BEG_LOOP",										ANIM_VILLAGER_FEMALE_BEG_LOOP_01);

		Animation.Add("CS_TALK_HAPPY_LOOP",									ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BASE_01);
		Animation.Add("CS_TALK_HAPPY_BR1",									ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_01);
		Animation.Add("CS_TALK_HAPPY_BR2",									ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_02);
		Animation.Add("CS_TALK_HAPPY_BR3",									ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_03);
		Animation.Add("CS_TALK_HAPPY_BR4",									ANIM_VILLAGER_FEMALE_CONVERSATION_HAPPY_BREAKOFF_04);

		Animation.Add("CS_TALK_ANGRY_LOOP",									ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BASE_01);
		Animation.Add("CS_TALK_ANGRY_BR1",									ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_01);
		Animation.Add("CS_TALK_ANGRY_BR2",									ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_02);
		Animation.Add("CS_TALK_ANGRY_BR3",									ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_03);
		Animation.Add("CS_TALK_ANGRY_BR4",									ANIM_VILLAGER_FEMALE_CONVERSATION_ANGRY_BREAKOFF_04);
		
		Animation.Add("CS_WHISPER_LOOK_UP",									CS_WHISPER_LOOKING_UP);
	<\CAppearanceDef>
	
	<CCreatureDef>
		PhonemeAnim["AH"]				ANIM_VILLAGER_FEMALE_PHONEME_AH;
		PhonemeAnim["EE"]				ANIM_VILLAGER_FEMALE_PHONEME_EE;
		PhonemeAnim["MM"]				ANIM_VILLAGER_FEMALE_PHONEME_MM;
		PhonemeAnim["OH"]				ANIM_VILLAGER_FEMALE_PHONEME_OH;
		PhonemeAnim["SZ"]				ANIM_VILLAGER_FEMALE_PHONEME_SZ;
		PhonemeAnim["WW"]				ANIM_VILLAGER_FEMALE_PHONEME_WW;

		DialogueVoices.clear();
		DialogueVoices.Add("WHISPER");
	<\CCreatureDef>

	<CCreatureDef>
		Stats.ExperienceWorth	25;
		Stats.RenownWorth	19;

		Stats.MoralityForKill		0;	// Dene's default setup
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;
		
		CreatureGroup			CREATURE_GROUP_RIVAL_HERO;
	<\CCreatureDef>

	<CEnemyDef>
		Faction					FACTION_RIVAL_HERO;
	<\CEnemyDef>
	
	GroupDef				G_CREATURES_RIVAL_HERO;

#end_definition

//*******************************************************************************************
//************ JACK OF BLADES TEMPLATE ******************************************************
//*******************************************************************************************
#definition_template		CREATURE	CREATURE_RIVAL_HERO_JACK_OF_BLADES_BASE	specialises CREATURE_COMBAT_ENEMY_HUMANOID_TEMPLATE
	Graphic.Type					ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 				MESH_JACK_OF_BLADES_01;
	Graphic.RenderSizeX				1.2;

	EyeGraphic.Type					ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex			MESH_JACK_OF_BLADES_EYES_01;
	EyeGraphic.RenderSizeX			1.43;

	RenderFadeDistance				50;
	
	CombatTypeDef					HERO_JACK_OF_BLADES_ATTACK_STYLE;
	Health 							1000;
	PBrain							BRAIN_JACK_OF_BLADES;
	
	<CTargetingDef>
		TargetingRanges[TARGETING_SHOOTABLE]	40.0;
		TargetingRanges[TARGETING_MELEE]		40.0;
	<\CTargetingDef>
	
	Components.Add("CTCHero");
	<CHeroDef>
		DefaultTitle				OBJECT_HERO_TITLE_JACK;
	<\CHeroDef>
	
	Components.Add("CTCHasName");
	<CHasNameDef>
		DefaultNameTag			TEXT_GUI_NPCNAME_SPECIAL_JACK_OF_BLADES_NAME;
	<\CHasNameDef>
	
	LeaveDeadCreature		FALSE;
	
	Components.Add("CTCGraphicAppearanceAnimatedMesh");
	Components.Add("CTCAICreatureWillPowerIndicator");
	
//	Material				MATERIAL_JACK_BODY;
	<CWeaponDef>
		Shot				FIREBALL_JACK_OF_BLADES;
	<\CWeaponDef>
	
	Components.Add("CTCWillResponse");
	<CWillResponseDef>
		IsLifeDrainable			FALSE;
		IsAffectedBySlowTime	FALSE;
		IsAbleToBeLifted		FALSE;
		IsEpicPowerExplodable	FALSE;
	<\CWillResponseDef>
	
	<CPerceivedThingDef>
		FieldOfView				360;
		SightRadius				50;
		GiveUpChaseRadius		15;
		ExtendedSightRadius		55;
		SoundRadius				21;
		SmellRadius				0;
		Type					PERCEIVED_THING_FIND_PLAYER;
		AwarenessTimer			20.0;
	<\CPerceivedThingDef>
	
	<CCreatureDef>
		PhonemeAnim["AH"]				ANIM_BANDIT_PHONEME_AH;
		PhonemeAnim["EE"]				ANIM_BANDIT_PHONEME_EE;
		PhonemeAnim["MM"]				ANIM_BANDIT_PHONEME_MM;
		PhonemeAnim["OH"]				ANIM_BANDIT_PHONEME_OH;
		PhonemeAnim["SZ"]				ANIM_BANDIT_PHONEME_SZ;
		PhonemeAnim["WW"]				ANIM_BANDIT_PHONEME_WW;

		DialogueVoices.clear();
		DialogueVoices.Add("JACK_OF_BLADES");
	<\CCreatureDef>

	<CCreatureDef>
		Stats.MoralityForKill		0;
		Stats.MoralityForWeaponHit	0;
		Stats.MoralityForPunch		0;

		Stats.ExperienceWorth 		0;
		Stats.RenownWorth			500;

		CreatureGroup				CREATURE_GROUP_RIVAL_HERO;
	<\CCreatureDef>

	<CEntitySoundDef>
		SoundIdentifier				"SI_HERO_JOB";
	<\CEntitySoundDef>

	Components.Add("CTCBoss");
	<CBossDef>
		PhaseHealthPercent[0]	50; //melee and minions
		PhaseHealthPercent[1]	50; //transition
		PhaseHealthPercent[2]	50; //summon pillars
		PhaseHealthPercent[3]	1; //floaty-shooty
		PhaseHealthPercent[4]	1; //transition
		PhaseHealthPercent[5]	1;  //chop his head off
		PhaseHealthPercent[6]	0;  //death
	<\CBossDef>
	
	<CJackOfBladesBattleDef>
		IdealShootDistance		5.0;
		TimeBetweenShots		2.0;
		ScreamInAirTime			3.0;
		TimeBetweenPillars		0.5;
		BattleFloatHeight		4.0;
		BattleScale				2.0;
		ScaleUpTime				1.5;
		ScaleDownTime			1.0;
		DeathScreamTime			8.0;
		DeathHeight				5.0;
		BurnDamage				3.0;
		FlashDuration			3.0;
		FlashBuildUpTime		1.2;
		NumGetHitsBeforeRush	3;
		RushAwayDistance	   10.0;	
	<\CJackOfBladesBattleDef>
	
	<CHitLocationsDef>
		HitLocations.clear();
		HitLocations.Add(HIT_LOCATION_JACK_OF_BLADES_FORCEFIELD);
		//HitLocations.Add(HIT_LOCATION_JACK_OF_BLADES_CAUSE_RUSH);
		HitLocations.Add(HIT_LOCATION_JACK_OF_BLADES_BIG);
		HitLocations.Add(HIT_LOCATION_JACK_OF_BLADES);
	<\CHitLocationsDef>
	
	<CAppearanceDef>
		Animation.Add("DEFAULT",							ANIM_RIVAL_HERO_JACK_COMBAT_IDLE);
		Animation.Add("ST_IDLE",							ANIM_RIVAL_HERO_JACK_COMBAT_IDLE);
		Animation.Add("ST_IDLE_SUBTLE",						ANIM_RIVAL_HERO_JACK_COMBAT_IDLE);
		Animation.Add("ST_WALK",							ANIM_RIVAL_HERO_JACK_STRAFE_FRONT);
		Animation.Add("ST_RUN",								ANIM_RIVAL_HERO_JACK_STRAFE_FRONT);
		Animation.Add("STANDARD_DEAD",						ANIM_RIVAL_HERO_JACK_DEAD_POSE);
		Animation.Add("STANDARD_DIE",						ANIM_RIVAL_HERO_JACK_DEAD_POSE);
		Animation.Add("ST_HEAD_TURN_H",				ANIM_BIPED_BANDIT_HEAD_TURN_H, Flags(ANIM_FLAG_PRELOAD));
		Animation.Add("ST_HEAD_TURN_V",				ANIM_BIPED_BANDIT_HEAD_TURN_V, Flags(ANIM_FLAG_PRELOAD));
		
		Animation.Add("STRAFE_IDLE",						ANIM_BANDIT_IDLE_01);
		Animation.Add("STRAFE_MOVEMENT_LEFT",				ANIM_RIVAL_HERO_JACK_STRAFE_LEFT);
		Animation.Add("STRAFE_MOVEMENT_RIGHT",				ANIM_RIVAL_HERO_JACK_STRAFE_RIGHT);
		Animation.Add("STRAFE_MOVEMENT_BACK",				ANIM_RIVAL_HERO_JACK_STRAFE_BACK);
		Animation.Add("STRAFE_MOVEMENT_FORWARD",			ANIM_RIVAL_HERO_JACK_STRAFE_FRONT);
		
		Animation.AddCombat("MOVEMENT_LONG_BACK",			ANIM_BIPED_BANDIT_BACK_JUMP);
		Animation.AddCombat("MOVEMENT_LONG_FRONT",			ANIM_BIPED_BANDIT_RUN);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_LEFT",	ANIM_RIVAL_HERO_JACK_STRAFE_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_FRONT_RIGHT",	ANIM_RIVAL_HERO_JACK_STRAFE_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_LEFT",	ANIM_RIVAL_HERO_JACK_STRAFE_LEFT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACK_RIGHT",	ANIM_RIVAL_HERO_JACK_STRAFE_RIGHT);
		Animation.AddCombat("MOVEMENT_STRAFE_FORWARD",		ANIM_RIVAL_HERO_JACK_STRAFE_FRONT);
		Animation.AddCombat("MOVEMENT_STRAFE_BACKWARD",		ANIM_RIVAL_HERO_JACK_STRAFE_BACK);
		
		Animation.AddCombat("RUSH_INTO",					ANIM_RIVAL_HERO_JACK_RUSH_INTO);
		Animation.AddCombat("RUSH_OUTOF",					ANIM_RIVAL_HERO_JACK_RUSH_OUTOF);
		Animation.AddCombat("RUSH_POSE",					ANIM_RIVAL_HERO_JACK_RUSH_POSE);
		
		Animation.AddCombat("STRIKE_MEDIUM_FRONT_UNBLOCKABLE",	ANIM_RIVAL_HERO_JACK_NEAR_COMBO);
		Animation.AddCombat("STRIKE_SHOT_NEAR",					ANIM_RIVAL_HERO_JACK_SHOT_NEAR);
		Animation.AddCombat("STRIKE_SHOT_FAR",					ANIM_RIVAL_HERO_JACK_SHOT_LONG);	
		
		Animation.Add("BLOCK_IDLE",							ANIM_BANDIT_BLOCK_IDLE_01);
		Animation.AddCombat("BLOCK_FRONT_RESPONSE",			ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_LEFT_RESPONSE",			ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_RIGHT_RESPONSE",			ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_BACK_RESPONSE",			ANIM_BANDIT_BLOCK_1);
		Animation.AddCombat("BLOCK_COUNTER_ATTACK",			ANIM_BANDIT_BLOCK_COUNTER_ATTACK_01);
		Animation.AddCombat("COUNTER_BLOCK_RECOIL",			ANIM_BANDIT_COUNTER_BLOCK_RECOIL_01);	
		
		Animation.AddCombat("STRIKE_SHORT_FRONT",			ANIM_BANDIT_JUMP_BACK_01);
		
		Animation.Add("SPECIAL_BOAST",						ANIM_RIVAL_HERO_JACK_TAUNT_LAUGH);
		Animation.Add("SPECIAL_BOAST",						ANIM_RIVAL_HERO_JACK_TAUNT);
		
		Animation.AddCombat("STRIKE_RECOIL",				ANIM_BANDIT_ATTACK_LEFT_RECOIL_1);

		Animation.Add("ST_FORCE_PUSH_INTO",					ANIM_RIVAL_HERO_JACK_FORCE_PUSH_INTO);
		Animation.Add("ST_FORCE_PUSH_RELEASE",				ANIM_RIVAL_HERO_JACK_FORCE_PUSH_RELEASE);
		
		Animation.AddCombat("SUMMON_INTO",					ANIM_RIVAL_HERO_JACK_SUMMON_INTO);
		Animation.AddCombat("SUMMON_LOOP",					ANIM_RIVAL_HERO_JACK_SUMMON_LOOP);
		Animation.AddCombat("SUMMON_OUTOF",					ANIM_RIVAL_HERO_JACK_SUMMON_OUTOF);

		Animation.AddCombat("SPECIAL_IDLE",						ANIM_RIVAL_HERO_JACK_COMBAT_IDLE);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_RUSH",	ANIM_RIVAL_HERO_JACK_GET_HIT_BACK);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_FRONT_RUSH",	ANIM_RIVAL_HERO_JACK_GET_HIT_LEFT);
		
		Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_RIVAL_HERO_JACK_GET_HIT_BACK);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_RIVAL_HERO_JACK_GET_HIT_LEFT_NO_RUSH);
		Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_RIVAL_HERO_JACK_GET_HIT_RIGHT_NO_RUSH);
			
		Animation.Add("RISE_TO_FLOAT",						ANIM_RIVAL_HERO_JACK_SPIN_AROUND_RISING);
		Animation.AddCombat("ST_GET_UP_FROM_FALL",			ANIM_RIVAL_HERO_JACK_GET_UP_FROM_FALL);
		Animation.AddCombat("SCREAM_INTO",					ANIM_RIVAL_HERO_JACK_INTO_SCREAMING_LOOP);
		Animation.Add("DEATH_INTO",							ANIM_RIVAL_HERO_JACK_DEATH_LOOP_INTO);
		Animation.Add("ST_CAST_ASSASSIN_RUSH",				ANIM_RIVAL_HERO_JACK_RUSH_INTO);
		
		Animation.StartGroup("SWORD");
			Animation.Add("TURNING_C90",					ANIM_BANDIT_TURN_90_RIGHT_01);
			Animation.Add("TURNING_AC90",					ANIM_BANDIT_TURN_90_LEFT_01);
			Animation.Add("TURNING_C180",					ANIM_BANDIT_TURN_180_RIGHT_01);
			Animation.Add("TURNING_AC180",					ANIM_BANDIT_TURN_180_LEFT_01);
		
			//the anims below are stolen from banditrs
			//////////////////////////////////////////////
			//first number in AddComboStage is the combo number (ie 0, to 1, to 2, to 3 etc...)
			//second number is a unique ID for a combo 
			Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_BANDIT_ATTACK_LEFT_1, Combo(0, 0), Handedness(HANDED_RIGHT, HANDED_LEFT), Recoil(ANIM_BANDIT_ATTACK_LEFT_RECOIL_1)); //, StrikeSpeedMultiplier(0.01));
			Animation.AddCombat("STRIKE_MEDIUM_FRONT", ANIM_BANDIT_ATTACK_RIGHT_1, Combo(1, 0), Handedness(HANDED_LEFT, HANDED_RIGHT), Recoil(ANIM_BANDIT_ATTACK_RIGHT_RECOIL_1));
			Animation.AddCombat("STRIKE_SHORT_FRONT", ANIM_BANDIT_PUNCH_RIGHT_01, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_PUNCH_RIGHT_RECOIL_01));
			Animation.AddCombat("STRIKE_LONG_FRONT", ANIM_BANDIT_LUNGE_1, Handedness(HANDED_NONE, HANDED_LEFT), Recoil(ANIM_BANDIT_ATTACK_LEFT_RECOIL_1));
			Animation.AddCombat("STRIKE_MEDIUM_FRONT_UNBLOCKABLE", ANIM_BANDIT_ATTACK_UNBLOCKABLE_01);
			
			Animation.AddCombat("STRIKE_MEDIUM_SIDE", ANIM_BANDIT_ATTACK_LEFT_1, Handedness(HANDED_RIGHT, HANDED_LEFT));
			Animation.AddCombat("STRIKE_MEDIUM_SIDE", ANIM_BANDIT_ATTACK_RIGHT_1, Handedness(HANDED_LEFT, HANDED_RIGHT));
			
			Animation.AddCombat("STRIKE_RECOIL", ANIM_BANDIT_ATTACK_LEFT_RECOIL_1, Handedness(HANDED_LEFT, HANDED_RIGHT));
			Animation.AddCombat("STRIKE_RECOIL", ANIM_BANDIT_ATTACK_RIGHT_RECOIL_LEFT_1, Handedness(HANDED_RIGHT, HANDED_LEFT));
		
		Animation.EndGroup();
		
		Animation.StartGroup("JACK_OF_BLADES_FLOAT");
			Animation.Add("DEFAULT",						ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.Add("ST_IDLE",						ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.Add("ST_SLOW_WALK",					ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.Add("ST_WALK",						ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.Add("ST_JOG",							ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.Add("ST_RUN",							ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			
			Animation.AddCombat("SPECIAL_BOAST",				ANIM_RIVAL_HERO_JACK_FLOAT_TAUNT);
			Animation.AddCombat("SPECIAL_IDLE",					ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_LEFT);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_LEFT);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_RIGHT);
			
			Animation.AddCombat("SUMMON_LOOP",				ANIM_RIVAL_HERO_JACK_FLOAT_IDLE);
				
			Animation.AddCombat("ST_STRIKE_LIGHT_INTO",		ANIM_RIVAL_HERO_JACK_STRIKE_LIGHT_INTO);
			Animation.AddCombat("ST_CAST_FIREBALL_SPELL",	ANIM_RIVAL_HERO_JACK_STRIKE_LEFT_FIREBALL);
			Animation.AddCombat("ST_STRIKE_LEFT_FIREBALL",	ANIM_RIVAL_HERO_JACK_STRIKE_LEFT_FIREBALL);
			Animation.AddCombat("ST_STRIKE_COMBO_FIREBALL",	ANIM_RIVAL_HERO_JACK_STRIKE_COMBO_FIREBALL_01);
		Animation.EndGroup();
		
		Animation.StartGroup("JACK_OF_BLADES_SCREAM");			
			Animation.Add("ST_IDLE",						ANIM_RIVAL_HERO_JACK_SCREAMING_LOOP);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_RIVAL_HERO_JACK_SCREAMING_LOOP);
			Animation.AddCombat("ST_FALL_TO_GROUND",		ANIM_RIVAL_HERO_JACK_FALL_TO_GROUND);
			
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_RIVAL_HERO_JACK_GET_HIT_BACK);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_LEFT);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_RIGHT);
		Animation.EndGroup();
		
		Animation.StartGroup("JACK_OF_BLADES_VULNERABLE");		
			Animation.Add("STUMBLE",									ANIM_RIVAL_HERO_JACK_DEFEATED_IDLE_BREAKOFF);
			Animation.Add("STUMBLE",									ANIM_RIVAL_HERO_JACK_DEFEATED_IDLE_BREAKOFF_LEFT);
			Animation.Add("ST_IDLE",								ANIM_RIVAL_HERO_JACK_WITHOUT_SWORD_IDLE);
			Animation.Add("ST_IDLE_SUBTLE",								ANIM_RIVAL_HERO_JACK_WITHOUT_SWORD_IDLE);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",			ANIM_RIVAL_HERO_JACK_GET_HIT_SPIN_LEFT);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",			ANIM_RIVAL_HERO_JACK_GET_HIT_SPIN_LEFT);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",			ANIM_RIVAL_HERO_JACK_GET_HIT_SPIN_RIGHT);	
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT_KNOCKDOWN",	ANIM_RIVAL_HERO_JACK_DECAPITATION);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT_KNOCKDOWN",	ANIM_RIVAL_HERO_JACK_DECAPITATION);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK_KNOCKDOWN",	ANIM_RIVAL_HERO_JACK_DECAPITATION);			
		Animation.EndGroup();
		
		Animation.StartGroup("JACK_OF_BLADES_DEATH");		
			Animation.Add("ST_IDLE",						ANIM_RIVAL_HERO_JACK_DEATH_LOOP);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_RIVAL_HERO_JACK_DEATH_LOOP);	
		Animation.EndGroup();
		
		Animation.StartGroup("JACK_OF_BLADES_FLASH");
			Animation.Add("DEFAULT",							ANIM_RIVAL_HERO_JACK_STRIKE_LIGHT_LOOP);
			Animation.Add("ST_IDLE",							ANIM_RIVAL_HERO_JACK_STRIKE_LIGHT_LOOP);
			Animation.Add("ST_IDLE_SUBTLE",						ANIM_RIVAL_HERO_JACK_STRIKE_LIGHT_LOOP);
			Animation.Add("ST_STRIKE_LIGHT_OUTOF",				ANIM_RIVAL_HERO_JACK_STRIKE_LIGHT_OUTOF);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_BACK",	ANIM_RIVAL_HERO_JACK_GET_HIT_BACK);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_LEFT",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_LEFT);
			Animation.AddCombat("RESPONSE_GENERIC_HIT_RIGHT",	ANIM_RIVAL_HERO_JACK_FLOAT_GET_HIT_RIGHT);
		Animation.EndGroup();
		
		Animation.StartGroup("ASSASSIN_RUSH");
			Animation.Add("ST_IDLE",						ANIM_RIVAL_HERO_JACK_RUSH_POSE);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_RIVAL_HERO_JACK_RUSH_POSE);
			Animation.Add("ST_SLOW_WALK",					ANIM_RIVAL_HERO_JACK_RUSH_POSE);
			Animation.Add("ST_WALK",						ANIM_RIVAL_HERO_JACK_RUSH_POSE);
			Animation.Add("ST_JOG",							ANIM_RIVAL_HERO_JACK_RUSH_POSE);
			Animation.Add("ST_RUN",							ANIM_RIVAL_HERO_JACK_RUSH_POSE);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_HAPPY");
			Animation.Add("DEFAULT",						ANIM_BANDIT_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("ST_IDLE",						ANIM_BANDIT_CONVERSATION_HAPPY_BASE_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_HAPPY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_BELLIGERENT");
			Animation.Add("DEFAULT",						ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE",						ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_ANGRY");
			Animation.Add("DEFAULT",						ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("ST_IDLE",						ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_FEAR");
			Animation.Add("DEFAULT",						ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
			Animation.Add("ST_IDLE",						ANIM_BANDIT_CONVERSATION_SCARED_BASE_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SCARED_BREAKOFF_04);
		Animation.EndGroup();

		Animation.StartGroup("CONVERSATION_SAD");
			Animation.Add("DEFAULT",						ANIM_BANDIT_CONVERSATION_SAD_BASE_01);
			Animation.Add("ST_IDLE",						ANIM_BANDIT_CONVERSATION_SAD_BASE_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_01);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_02);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_03);
			Animation.Add("CONV_GENERAL",					ANIM_BANDIT_CONVERSATION_SAD_BREAKOFF_04);
		Animation.EndGroup();
		
		Animation.StartGroup("HIT_BY_EPIC_SPELL");
			Animation.Add("ST_IDLE",						ANIM_RIVAL_HERO_JACK_HIT_BY_EPIC_SPELL_01);
			Animation.Add("ST_IDLE_SUBTLE",					ANIM_RIVAL_HERO_JACK_HIT_BY_EPIC_SPELL_01);
		Animation.EndGroup();

//************ CUTSCENE STUFF ***************************************************************
		Animation.Add("CS_HOH_JACK_HAND_ON_SHOULDER_SHOT_12B",			ANIM_CS_HOH_JACK_HAND_ON_SHOULDER_SHOT_12B,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_HOH_JACK_OF_BLADE_SHOT_13",					ANIM_CS_HOH_JACK_OF_BLADE_SHOT_13,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_LANDING",										CS_BANDIT_WIZARD_BATTLE_JACK_OF_BLADES_LANDING,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_SPIN_AROUND_RISING",							CS_JOB_STAGE_2_JACK_OF_BLADES_SPIN_AROUND_RISING,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_HAND_ON_SHOULDER_SHOT_12_B",					CS_MOTHER_STATUE_JACK_OF_BLADES_HAND_ON_SHOULDER_SHOT_12_B,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_SHOT_13",										CS_MOTHER_STATUE_JACK_OF_BLADES_SHOT_13,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_HOLDING_MOTHER",								CS_JOB_FOCAL_SITE_FINALE_JACK_OF_BLADES_HOLDING_MOTHER,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_HOLDING_MOTHER_LOOP",							CS_JOB_FOCAL_SITE_FINALE_JACK_OF_BLADES_HOLDING_MOTHER_LOOP,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_IN_AIR_DODGE_LEFT_THEN_RIGHT_THEN_STRIKE",	CS_BANDIT_INTRO_OF_JOB_JACK_OF_BLADES_IN_AIR_DODGE_LEFT_THEN_RIGHT_THEN_STRIKE,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_IN_AIR_DODGE_RIGHT",							CS_BANDIT_INTRO_OF_JOB_JACK_OF_BLADES_IN_AIR_DODGE_RIGHT,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_LANDS_AND_TAKES_BOW",							CS_BANDIT_INTRO_OF_JOB_JACK_OF_BLADES_LANDS_AND_TAKES_BOW,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JC_JACK_RISES",								CS_BANDIT_WIZARD_BATTLE_JACK_OF_BLADES_FLIES,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_BANDIT_WIZARD_BATTLE_JACK_OF_BLADES_FLIES",	CS_BANDIT_WIZARD_BATTLE_JACK_OF_BLADES_LANDING,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		// JOB fight
		Animation.Add("CS_JOB_JACK_KILLS_MOTHER_END",					ANIM_CS_JOB_JACK_KILLS_MOTHER_END,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JOB_JACK_KILLS_MOTHER_START",					ANIM_CS_JOB_JACK_KILLS_MOTHER_START,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JOB_JACK_lOOKS_MOTHER_FALLING",				ANIM_CS_JOB_JACK_lOOKS_MOTHER_FALLING,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JOB_JACK_TALKING",							ANIM_CS_JOB_JACK_TALKING,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JOB_JACK_TALKING_BEFORE_THROAT_SLIT",			ANIM_CS_JOB_JACK_TALKING_BEFORE_THROAT_SLIT,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JOB_JACK_TALKING_WITH_KNIFE",					ANIM_CS_JOB_JACK_TALKING_WITH_KNIFE,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_JACK_TALKS_LOOP",ANIM_CS_JACK_TALKS_LOOP);
		Animation.Add("CS_JOB_SLITS",ANIM_CS_JOB_SLITS);
		Animation.Add("CS_HOH_JACK_STEP",					CS_HOH_JACK_STEP,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_HOH_JACK_STEP_HOLD",					CS_HOH_JACK_STEP_HOLD,Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_WB_FLYAWAY",CS_WB_FLYAWAY);
		Animation.Add("CS_JB_TAKES_KEY",CS_JB_TAKES_KEY);
		Animation.Add("CS_JOB_HOLD_SWORD_OUTOF",ANIM_CS_JOB_HOLD_SWORD_OUTOF);
		Animation.Add("CS_JOB_GRAB_SWORD",ANIM_CS_JOB_GRAB_SWORD);
		Animation.Add("CS_JOB_HOLD_SWORD",ANIM_CS_JOB_HOLD_SWORD);
		Animation.Add("CS_JOB_HOLD_SWORD_IN_AIR",ANIM_CS_JOB_HOLD_SWORD_IN_AIR);
		Animation.Add("CS_JACK_SWORD_SET",CS_JACK_SWORD_SET);
		Animation.Add("CS_JACK_FALLING_DEAD",CS_JACK_FALLING_DEAD);
		Animation.Add("CS_JACK_FALLING_DEAD_LAND",CS_JACK_FALLING_DEAD_LAND);
		Animation.Add("CS_JACK_DEATH",ANIM_RIVAL_HERO_JACK_DEATH_LOOP);
		Animation.Add("CS_STANDARD_TALK_IDLE1",			ANIM_BIPED_BANDIT_TALK_IDLE_01, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_STANDARD_TALK_IDLE2",			ANIM_BIPED_BANDIT_TALK_IDLE_02, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_STANDARD_TALK_IDLE3",			ANIM_BIPED_BANDIT_TALK_IDLE_03, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_STANDARD_TALK_IDLE4",			ANIM_BIPED_BANDIT_TALK_IDLE_04, Flags(ANIM_FLAG_DISALLOW_COMBINATION_ANIMS));
		Animation.Add("CS_STANDARD_TALK_IDLE5",			ANIM_BIPED_BANDIT_TALK_IDLE_05);
		
		Animation.Add("CS_ANGRY1",						ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
		Animation.Add("CS_ANGRY2",						ANIM_BANDIT_CONVERSATION_ANGRY_BASE_01);
		Animation.Add("CS_ANGRY3",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_01);
		Animation.Add("CS_ANGRY4",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_02);
		Animation.Add("CS_ANGRY5",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_03);
		Animation.Add("CS_ANGRY6",					ANIM_BANDIT_CONVERSATION_ANGRY_BREAKOFF_04);
		Animation.Add("CS_JACK_SCREAM_LOOP",ANIM_RIVAL_HERO_JACK_SCREAMING_LOOP);
		Animation.Add("CS_JOB_DEAD_POSE",CS_JOB_DEAD_POSE);
		Animation.Add("CS_JB_TAKES_KEY",CS_JB_TAKES_KEY);
		Animation.Add("CS_JB_ASKS_KEY",CS_JB_ASKS_KEY);
		Animation.Add("CS_JOB_TALKS_DOWN",CS_JOB_TALKS_DOWN);
		
//******************************************************************************************
	<\CAppearanceDef>
	
	<CSpecialEffectsDef>
		SpecialEffects.Add("FLASH_SWORD_POWER_UP",			JACK_OF_BLADES_LIGHT_SWORD_BUILD_UP_01);
		SpecialEffects.Add("FLASH_SWORD_GLOW",				JACK_OF_BLADES_LIGHT_SWORD_01);
		SpecialEffects.Add("FLOAT_EFFECT",					JACK_OF_BLADES_HOVER_01);
		SpecialEffects.Add("RISE_EFFECT",					JACK_OF_BLADES_RISE_01);
		SpecialEffects.Add("SWORD_OF_AEONS",				JACK_OF_BLADE_SWORD_EONS_01);
		SpecialEffects.Add("FLOAT_POWER",					JACK_OF_BLADES_POWER_01);
		SpecialEffects.Add("GET_HIT",						JACK_OF_BLADES_GET_HIT_01);
		SpecialEffects.Add("FLOAT_SCREAM",					JACK_OF_BLADES_DYING_01);
		SpecialEffects.Add("DEATH",							JACK_OF_BLADES_DIE_01);
		SpecialEffects.Add("HERO_THRUST_SWORD",				JACK_OF_BLADE_SWORD_EONS_RAISED_01);
	<\CSpecialEffectsDef>
/*
	Components.Add("CTCSkeletalMorph");
	<CSkeletalMorphDef>
		SkeletalMorphs.Add("bandit_king_01_set.bncfg");
	<\CSkeletalMorphDef>
*/	
	GroupDef				G_CREATURES_RIVAL_HERO;

#end_definition

//*******************************************************************************************
//************ BANDIT TEMPLATE **************************************************************
//*******************************************************************************************
#definition_template		CREATURE	CREATURE_BANDIT_FOOTSOLDIER_BASE	specialises CREATURE_BANDIT_BASE
	Components.Add("CTCRandomAppearanceMorph");
	Components.Add("CTCDecapitation");
		
	<CCreatureDef>
		RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_BANDIT_HEAD_01, MESH_BANDIT_HEAD_02, MESH_BANDIT_HEAD_03, MESH_BANDIT_HEAD_04);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_BANDIT_TORSO_01, MESH_BANDIT_TORSO_02, MESH_BANDIT_TORSO_03, MESH_BANDIT_TORSO_04);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_BANDIT_LEGS_01, MESH_BANDIT_LEGS_02, MESH_BANDIT_LEGS_03, MESH_BANDIT_LEGS_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_BANDIT_HEAD_01, MESH_BANDIT_HEAD_03, MESH_BANDIT_HEAD_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_BANDIT_TORSO_01, MESH_BANDIT_TORSO_03, MESH_BANDIT_TORSO_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_BANDIT_LEGS_01, MESH_BANDIT_LEGS_03, MESH_BANDIT_LEGS_04);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_01, 0, TEXTURE_BANDIT_FACE_A_01, TEXTURE_BANDIT_FACE_A_01, TEXTURE_BANDIT_FACE_B_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_01, 0, TEXTURE_BANDIT_TORSOSKIN_A_01, TEXTURE_BANDIT_TORSOSKIN_A_01, TEXTURE_BANDIT_TORSOSKIN_B_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_01, 0, TEXTURE_BANDIT_TORSO_A_01, TEXTURE_BANDIT_TORSO_A_01, TEXTURE_BANDIT_TORSO_B_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_01, 0, TEXTURE_BANDIT_LEGS_A_01, TEXTURE_BANDIT_LEGS_A_01, TEXTURE_BANDIT_LEGS_B_01);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_02, 0, TEXTURE_BANDIT_FACE_A_02, TEXTURE_BANDIT_FACE_A_02, TEXTURE_BANDIT_FACE_B_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_02, 0, TEXTURE_BANDIT_TORSOSKIN_A_02, TEXTURE_BANDIT_TORSOSKIN_A_02, TEXTURE_BANDIT_TORSOSKIN_B_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_02, 0, TEXTURE_BANDIT_TORSO_A_02, TEXTURE_BANDIT_TORSO_A_02, TEXTURE_BANDIT_TORSO_B_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_02, 0, TEXTURE_BANDIT_LEGS_A_02, TEXTURE_BANDIT_LEGS_A_02, TEXTURE_BANDIT_LEGS_B_02);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 1, TEXTURE_BANDIT_FACE_A_03, TEXTURE_BANDIT_FACE_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 1, TEXTURE_BANDIT_HAIR_A_03, TEXTURE_BANDIT_HAIR_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 2, TEXTURE_BANDIT_FACE_A_03, TEXTURE_BANDIT_FACE_B_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 2, TEXTURE_BANDIT_HAIR_A_03, TEXTURE_BANDIT_HAIR_B_03);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_03, 0, TEXTURE_BANDIT_TORSOSKIN_A_03, TEXTURE_BANDIT_TORSOSKIN_A_03, TEXTURE_BANDIT_TORSOSKIN_B_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_03, 0, TEXTURE_BANDIT_TORSO_A_03, TEXTURE_BANDIT_TORSO_A_03, TEXTURE_BANDIT_TORSO_B_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_03, 0, TEXTURE_BANDIT_LEGS_A_03, TEXTURE_BANDIT_LEGS_A_03, TEXTURE_BANDIT_LEGS_B_03);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 1, TEXTURE_BANDIT_FACE_A_04, TEXTURE_BANDIT_FACE_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 1, TEXTURE_BANDIT_HAIR_A_04, TEXTURE_BANDIT_HAIR_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 2, TEXTURE_BANDIT_FACE_A_04, TEXTURE_BANDIT_FACE_B_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 2, TEXTURE_BANDIT_HAIR_A_04, TEXTURE_BANDIT_HAIR_B_04);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_04, 0, TEXTURE_BANDIT_TORSOSKIN_A_04, TEXTURE_BANDIT_TORSOSKIN_A_04, TEXTURE_BANDIT_TORSOSKIN_B_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_04, 0, TEXTURE_BANDIT_TORSO_A_04, TEXTURE_BANDIT_TORSO_A_04, TEXTURE_BANDIT_TORSO_B_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_04, 0, TEXTURE_BANDIT_LEGS_A_04, TEXTURE_BANDIT_LEGS_A_04, TEXTURE_BANDIT_LEGS_B_04);
	<\CCreatureDef>

	<CCreatureDef>
		Stats.ExperienceWorth		12;
		Stats.RenownWorth		6;
	<\CCreatureDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("DRAIN_LIFE",				WILL_LEECH_VICTIM);
		SpecialEffects.Add("BLOOD_SPURT",				BLOOD_SPRAY_UP);
	<\CSpecialEffectsDef>
	
	MeshHeight				1.5;

	GroupDef					G_CREATURES_BANDIT;
#end_definition

//*******************************************************************************************
//************ TWINBLADE GANG BANDIT TEMPLATE ***********************************************
//*******************************************************************************************
#definition_template		CREATURE	CREATURE_BANDIT_FOOTSOLDIER_TBG_BASE	specialises CREATURE_BANDIT_BASE
	Components.Add("CTCRandomAppearanceMorph");
	Components.Add("CTCDecapitation");
		
	<CCreatureDef>
		RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_BANDIT_HEAD_01, MESH_BANDIT_HEAD_02, MESH_BANDIT_HEAD_03, MESH_BANDIT_HEAD_04);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_BANDIT_TORSO_01, MESH_BANDIT_TORSO_02, MESH_BANDIT_TORSO_03, MESH_BANDIT_TORSO_04);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_BANDIT_LEGS_01, MESH_BANDIT_LEGS_02, MESH_BANDIT_LEGS_03, MESH_BANDIT_LEGS_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_BANDIT_HEAD_01, MESH_BANDIT_HEAD_03, MESH_BANDIT_HEAD_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_BANDIT_TORSO_01, MESH_BANDIT_TORSO_03, MESH_BANDIT_TORSO_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_BANDIT_LEGS_01, MESH_BANDIT_LEGS_03, MESH_BANDIT_LEGS_04);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_01, 0, TEXTURE_BANDIT_FACE_A_01, TEXTURE_BANDIT_TBG_FACE_A_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_01, 0, TEXTURE_BANDIT_TORSOSKIN_A_01, TEXTURE_BANDIT_TBG_TORSOSKIN_A_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_01, 0, TEXTURE_BANDIT_TORSO_A_01, TEXTURE_BANDIT_TBG_TORSO_A_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_01, 0, TEXTURE_BANDIT_LEGS_A_01, TEXTURE_BANDIT_TBG_LEGS_A_01);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_02, 0, TEXTURE_BANDIT_FACE_A_02, TEXTURE_BANDIT_TBG_FACE_A_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_02, 0, TEXTURE_BANDIT_TORSOSKIN_A_02, TEXTURE_BANDIT_TBG_TORSOSKIN_A_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_02, 0, TEXTURE_BANDIT_TORSO_A_02, TEXTURE_BANDIT_TBG_TORSO_A_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_02, 0, TEXTURE_BANDIT_LEGS_A_02, TEXTURE_BANDIT_LEGS_A_02);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 0, TEXTURE_BANDIT_FACE_A_03, TEXTURE_BANDIT_TBG_FACE_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 0, TEXTURE_BANDIT_HAIR_A_03, TEXTURE_BANDIT_HAIR_A_03);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_03, 0, TEXTURE_BANDIT_TORSOSKIN_A_03, TEXTURE_BANDIT_TBG_TORSOSKIN_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_03, 0, TEXTURE_BANDIT_TORSO_A_03, TEXTURE_BANDIT_TBG_TORSO_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_03, 0, TEXTURE_BANDIT_LEGS_A_03, TEXTURE_BANDIT_TBG_LEGS_A_03);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 0, TEXTURE_BANDIT_FACE_A_04, TEXTURE_BANDIT_TBG_FACE_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 0, TEXTURE_BANDIT_HAIR_A_04, TEXTURE_BANDIT_HAIR_A_04);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_04, 0, TEXTURE_BANDIT_TORSOSKIN_A_04, TEXTURE_BANDIT_TBG_TORSOSKIN_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_04, 0, TEXTURE_BANDIT_TORSO_A_04, TEXTURE_BANDIT_TBG_TORSO_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_04, 0, TEXTURE_BANDIT_LEGS_A_04, TEXTURE_BANDIT_TBG_LEGS_A_04);
	<\CCreatureDef>

	<CCreatureDef>
		Stats.ExperienceWorth		24;
		Stats.RenownWorth		10;
	<\CCreatureDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("DRAIN_LIFE",				WILL_LEECH_VICTIM);
		SpecialEffects.Add("BLOOD_SPURT",				BLOOD_SPRAY_UP);
	<\CSpecialEffectsDef>
	
	MeshHeight				1.5;
	
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_CREATURE_HEAD);
	<\CHitLocationsDef>

	GroupDef					G_CREATURES_BANDIT;
#end_definition

//*******************************************************************************************
//************ ASSASSIN GANG BANDIT TEMPLATE ************************************************
//*******************************************************************************************
#definition_template		CREATURE	CREATURE_BANDIT_FOOTSOLDIER_BLG_BASE	specialises CREATURE_BANDIT_BASE
	Components.Add("CTCRandomAppearanceMorph");
	Components.Add("CTCDecapitation");
		
	<CCreatureDef>
		RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_BANDIT_HEAD_01, MESH_BANDIT_HEAD_02, MESH_BANDIT_HEAD_03, MESH_BANDIT_HEAD_04);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_BANDIT_TORSO_01, MESH_BANDIT_TORSO_02, MESH_BANDIT_TORSO_03, MESH_BANDIT_TORSO_04);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_BANDIT_LEGS_01, MESH_BANDIT_LEGS_02, MESH_BANDIT_LEGS_03, MESH_BANDIT_LEGS_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_BANDIT_HEAD_01, MESH_BANDIT_HEAD_03, MESH_BANDIT_HEAD_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_BANDIT_TORSO_01, MESH_BANDIT_TORSO_03, MESH_BANDIT_TORSO_04);
		//RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_BANDIT_LEGS_01, MESH_BANDIT_LEGS_03, MESH_BANDIT_LEGS_04);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_01, 0, TEXTURE_BANDIT_FACE_A_01, TEXTURE_BANDIT_BLG_FACE_A_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_01, 0, TEXTURE_BANDIT_TORSOSKIN_A_01, TEXTURE_BANDIT_BLG_TORSOSKIN_A_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_01, 0, TEXTURE_BANDIT_TORSO_A_01, TEXTURE_BANDIT_BLG_TORSO_A_01);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_01, 0, TEXTURE_BANDIT_LEGS_A_01, TEXTURE_BANDIT_BLG_LEGS_A_01);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_02, 0, TEXTURE_BANDIT_FACE_A_02, TEXTURE_BANDIT_BLG_FACE_A_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_02, 0, TEXTURE_BANDIT_TORSOSKIN_A_02, TEXTURE_BANDIT_TBG_TORSOSKIN_A_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_02, 0, TEXTURE_BANDIT_TORSO_A_02, TEXTURE_BANDIT_BLG_TORSO_A_02);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_02, 0, TEXTURE_BANDIT_LEGS_A_02, TEXTURE_BANDIT_BLG_LEGS_A_02);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 0, TEXTURE_BANDIT_FACE_A_03, TEXTURE_BANDIT_BLG_FACE_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_03, 0, TEXTURE_BANDIT_HAIR_A_03, TEXTURE_BANDIT_HAIR_A_03);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_03, 0, TEXTURE_BANDIT_TORSOSKIN_A_03, TEXTURE_BANDIT_TBG_TORSOSKIN_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_03, 0, TEXTURE_BANDIT_TORSO_A_03, TEXTURE_BANDIT_BLG_TORSO_A_03);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_03, 0, TEXTURE_BANDIT_LEGS_A_03, TEXTURE_BANDIT_BLG_LEGS_A_03);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 0, TEXTURE_BANDIT_FACE_A_04, TEXTURE_BANDIT_BLG_FACE_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_HEAD_04, 0, TEXTURE_BANDIT_HAIR_A_04, TEXTURE_BANDIT_HAIR_A_04);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_04, 0, TEXTURE_BANDIT_TORSOSKIN_A_04, TEXTURE_BANDIT_BLG_TORSOSKIN_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_TORSO_04, 0, TEXTURE_BANDIT_TORSO_A_04, TEXTURE_BANDIT_BLG_TORSO_A_04);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BANDIT_LEGS_04, 0, TEXTURE_BANDIT_LEGS_A_04, TEXTURE_BANDIT_BLG_LEGS_A_04);
	<\CCreatureDef>

	<CCreatureDef>
		Stats.ExperienceWorth		36;
		Stats.RenownWorth		14;
	<\CCreatureDef>

	<CSpecialEffectsDef>
		SpecialEffects.Add("DRAIN_LIFE",				WILL_LEECH_VICTIM);
		SpecialEffects.Add("BLOOD_SPURT",				BLOOD_SPRAY_UP);
	<\CSpecialEffectsDef>
	
	MeshHeight				1.5;
	
	<CHitLocationsDef>
		HitLocations.Add(HIT_LOCATION_CREATURE_HEAD);
	<\CHitLocationsDef>	

	GroupDef					G_CREATURES_BANDIT;
#end_definition

//*******************************************************************************************************************
//************ GHOSTS ***********************************************************************************************
//*******************************************************************************************************************

#definition 	CREATURE 	CREATURE_GHOST_VILLAGER_MALE specialises  CREATURE_GENERIC_ADULT_MALE_VILLAGER_TEMPLATE

   	Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 		MESH_BS_MALE_MIDDLE_UNCLOTHED_01;

	//PBrain 					BRAIN_BOWERSTONE_VILLAGER;
	//PBrain					BRAIN_FOLLOW_PLAYER;
	//PBrain					BRAIN_VILLAGER_REACTION_TEST;
	PBrain					BRAIN_BANDIT_VILLAGER_BASE;
	Sex						SEX_MALE;
	CreatureInteractionType	CREATURE_INTERACTION_CONVERSATION;

	<CPhysicsDef>
		InteractionFlags  PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY;
	<\CPhysicsDef>

	Graphic.RenderSizeX		1;

	EyeGraphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex	MESH_VILLAGER_GHOST_EYE;
	EyeGraphic.RenderSizeX	1.43;

	Components.Add("CTCRandomAppearanceMorph");
	Components.Add("CTCSkeletalMorph");
	
	<CTargetingDef>
		Type					TARGETING_TALKABLE;
	<\CTargetingDef>

	<CCreatureDef>
		RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_VILLAGER_GHOST_MALE_HEAD_01);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_VILLAGER_GHOST_MALE_TORSO_01, MESH_VILLAGER_GHOST_MALE_TORSO_01);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_VILLAGER_GHOST_MALE_LEGS_01, MESH_VILLAGER_GHOST_MALE_LEGS_01);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_MALE_HEAD_01, 0, TEXTURE_MALE_VILLAGER_GHOST_FACE_A, TEXTURE_MALE_VILLAGER_GHOST_FACE_A);
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_MALE_HEAD_01, 0, TEXTURE_MALE_VILLAGER_GHOST_HAIR_A, TEXTURE_MALE_VILLAGER_GHOST_HAIR_A);
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_MALE_TORSO_01, 0, TEXTURE_MALE_VILLAGER_GHOST_TORSO_A, TEXTURE_MALE_VILLAGER_GHOST_TORSO_A);
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_MALE_LEGS_01, 0, TEXTURE_MALE_VILLAGER_GHOST_LEGS_A, TEXTURE_MALE_VILLAGER_GHOST_LEGS_A);
		
		RandomAppearanceMorph.AddSkeletalMorph(1, "bs_male_short.bncfg", FALSE);
		RandomAppearanceMorph.AddSkeletalMorph(1, "bs_male_tall.bncfg", FALSE);
		RandomAppearanceMorph.AddSkeletalMorph(2, "bs_male_weak.bncfg", TRUE);
		RandomAppearanceMorph.AddSkeletalMorph(2, "bs_male_strong.bncfg", TRUE);
		RandomAppearanceMorph.AddSkeletalMorph(2, "bs_male_fat.bncfg", TRUE);

		Stats.ExperienceWorth	8;
		Stats.RenownWorth		8;
		PickPocketable			FALSE;
		
		AGhostIsWhatIBe			TRUE;
	<\CCreatureDef>
	
	<CAppearanceDef>
		OutlineEffectAlphaRef  16;
		OutlineEffectAlphaBias  100;
	<\CAppearanceDef>
	
	
	GroupDef				G_CREATURES_SPECIAL_CHARACTERS;
	
	Damageable				FALSE;
	
#end_definition

//*******************************************************************************************
#definition 	CREATURE 	CREATURE_GHOST_VILLAGER_FEMALE			specialises  CREATURE_GENERIC_ADULT_FEMALE_VILLAGER_TEMPLATE

   	Graphic.Type			ENGINE_GRAPHIC_ANIMATING_MESH;
	Graphic.BankIndex 		MESH_BS_FEMALE_MIDDLE_UNCLOTHED_01;

	PBrain					BRAIN_GOOD_VILLAGER_BASE;
//	PBrain 					BRAIN_BOWERSTONE_VILLAGER;
//	PBrain		 			BRAIN_FOLLOW_PLAYER;

	<CPhysicsDef>
		InteractionFlags  PHYSICS_COLLIDE_LANDSCAPE | PHYSICS_COLLIDE_THINGS_ONEWAY;
	<\CPhysicsDef>

	<CTargetingDef>
		Type					TARGETING_TALKABLE;
	<\CTargetingDef>
	
	Sex						SEX_FEMALE;
	CreatureInteractionType	CREATURE_INTERACTION_CONVERSATION;

	Graphic.RenderSizeX		1;

	EyeGraphic.Type			ENGINE_GRAPHIC_STATIC_MESH;
	EyeGraphic.BankIndex	MESH_VILLAGER_GHOST_EYE;
	EyeGraphic.RenderSizeX	1.43;

	Components.Add("CTCRandomAppearanceMorph");
	Components.Add("CTCSkeletalMorph");
	
	<CCreatureDef>
		RandomAppearanceMorph.AddBodyPart(BODY_PART_HEAD, 1, MESH_VILLAGER_GHOST_FEMALE_HEAD_01);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_TORSO, 1, MESH_VILLAGER_GHOST_FEMALE_TORSO_01, MESH_VILLAGER_GHOST_FEMALE_TORSO_01);
		RandomAppearanceMorph.AddBodyPart(BODY_PART_LEGS, 1, MESH_VILLAGER_GHOST_FEMALE_LEGS_01, MESH_VILLAGER_GHOST_FEMALE_LEGS_01);
		
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_FEMALE_HEAD_01, 0, TEXTURE_FEMALE_VILLAGER_GHOST_FACE_A, TEXTURE_FEMALE_VILLAGER_GHOST_FACE_A);
		RandomAppearanceMorph.AddTextureToMesh(MESH_BS_FEMALE_MIDDLE_HEAD_01, 0, TEXTURE_FEMALE_VILLAGER_GHOST_HAIR_A, TEXTURE_FEMALE_VILLAGER_GHOST_HAIR_A);
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_FEMALE_TORSO_01, 0, TEXTURE_FEMALE_VILLAGER_GHOST_WAISTCOAT_TORSO_A, TEXTURE_FEMALE_VILLAGER_GHOST_WAISTCOAT_TORSO_A);
		RandomAppearanceMorph.AddTextureToMesh(MESH_VILLAGER_GHOST_FEMALE_LEGS_01, 0, TEXTURE_FEMALE_VILLAGER_GHOST_SKIRT_LEGS_A, TEXTURE_FEMALE_VILLAGER_GHOST_SKIRT_LEGS_A);
		
		RandomAppearanceMorph.AddSkeletalMorph(1, "bs_female_short.bncfg", FALSE);
		RandomAppearanceMorph.AddSkeletalMorph(1, "bs_female_tall.bncfg", FALSE);
		RandomAppearanceMorph.AddSkeletalMorph(2, "bs_female_weak.bncfg", TRUE);
		RandomAppearanceMorph.AddSkeletalMorph(2, "bs_female_strong.bncfg", TRUE);
		RandomAppearanceMorph.AddSkeletalMorph(2, "bs_female_fat.bncfg", TRUE);

		Stats.ExperienceWorth	8;
		Stats.RenownWorth		8;
		
		AGhostIsWhatIBe			TRUE;
	<\CCreatureDef>
			 
	<CAppearanceDef>
		OutlineEffectAlphaRef  16;
		OutlineEffectAlphaBias  100;
	<\CAppearanceDef>

	GroupDef				G_CREATURES_SPECIAL_CHARACTERS;
	
	Damageable				FALSE;

#end_definition
