#pragma once
#ifndef __COMBAT_DEFINES_H__
#define __COMBAT_DEFINES_H__

//---------------------------------------------------------------------------------
enum ECombatZone 
{
	COMBAT_ZONE_FRONT_FAR		= 1<<0,
	COMBAT_ZONE_FRONT_MIDDLE	= 1<<1,
	COMBAT_ZONE_FRONT_NEAR		= 1<<2,
	COMBAT_ZONE_LEFT			= 1<<3,
	COMBAT_ZONE_RIGHT			= 1<<4,
	COMBAT_ZONE_REAR			= 1<<5,
	COMBAT_ZONE_NO_ZONE			= 1<<6,
	COMBAT_ZONE_OUTER_RING		= 1<<7,
	COMBAT_ZONE_ALL_ZONES		= COMBAT_ZONE_FRONT_FAR|COMBAT_ZONE_FRONT_MIDDLE|COMBAT_ZONE_FRONT_NEAR|COMBAT_ZONE_LEFT|COMBAT_ZONE_RIGHT|COMBAT_ZONE_REAR|COMBAT_ZONE_NO_ZONE|COMBAT_ZONE_OUTER_RING,
};

enum ECombatSequenceType
{
	COMBAT_SEQUENCE_NULL = 0,
	COMBAT_SEQUENCE_MELEE,
	COMBAT_SEQUENCE_BREAK_INTO_MELEE,
	COMBAT_SEQUENCE_BOAST,
	COMBAT_SEQUENCE_LEADER,
};

enum ECombatSequenceInterruptionType
{
	COMBAT_SEQUENCE_INTERRUPT_NULL = 0,
	COMBAT_SEQUENCE_INTERRUPTABLE,
	COMBAT_SEQUENCE_INTERRUPTABLE_DUE_TO_ZONE_CHANGE,
};

enum ECombatSequenceIsValidType
{
	COMBAT_SEQUENCE_IS_VALID_NULL = 0,
	COMBAT_SEQUENCE_IS_VALID_TARGET_BLOCKING,
	COMBAT_SEQUENCE_IS_VALID_LOAD_RANGED_WEAPON,
	COMBAT_SEQUENCE_IS_VALID_FIRE_AT_TARGET,
	COMBAT_SEQUENCE_IS_VALID_IS_TARGET_HEALTH_OVER_75,
	COMBAT_SEQUENCE_IS_VALID_IS_MY_HEALTH_BELOW_30,
	COMBAT_SEQUENCE_IS_VALID_IS_BALVERINE_ABLE_TO_LUNGE,
	COMBAT_SEQUENCE_IS_VALID_ABLE_TO_SUMMON,
	COMBAT_SEQUENCE_IS_TARGET_IN_LINE_OF_SIGHT,
};

enum ECombatSequenceOnStartModuleType
{
	COMBAT_SEQUENCE_ON_START_NULL = 0,
	COMBAT_SEQUENCE_ON_START_CONTINUE_AIMING,
};

enum ECombatSequenceOnStopModuleType
{
	COMBAT_SEQUENCE_ON_STOP_NULL = 0,
};

#endif // __COMBAT_DEFINES_H__