/*
 * Decompiled with CFR 0.152.
 */
package com.morerunes.fablex.utils;

import com.morerunes.fablex.utils.Entity;
import com.morerunes.fablex.utils.XFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.Stack;

public class Parser {
    Scanner scanner;
    File inputFile;

    public Parser(File inputFile) throws FileNotFoundException {
        this.inputFile = inputFile;
        this.scanner = new Scanner(inputFile);
        this.handleVerification(this.verifyFileIntegrity());
    }

    public Parser(String fileName) throws FileNotFoundException {
        this.inputFile = new File(fileName);
        this.scanner = new Scanner(this.inputFile);
        this.handleVerification(this.verifyFileIntegrity());
    }

    private void handleVerification(char c) {
        switch (c) {
            case 'i': {
                throw new RuntimeException("File was invalid, are you sure it is the correct type?");
            }
            case 'e': {
                throw new RuntimeException("File was empty");
            }
            case 'b': {
                throw new RuntimeException("File has mismatched/missing start/end brackets");
            }
        }
    }

    private char verifyFileIntegrity() throws FileNotFoundException {
        Stack<Character> brackets = new Stack<Character>();
        if (!this.scanner.hasNextLine()) {
            return 'e';
        }
        if (!(this.scanner.next().equals("xof") && this.scanner.next().equals("0303txt") && this.scanner.next().equals("0032"))) {
            return 'i';
        }
        while (this.scanner.hasNextLine()) {
            char[] linechars;
            block6: for (char linechar : linechars = this.scanner.nextLine().toCharArray()) {
                switch (linechar) {
                    case '[': 
                    case '{': {
                        brackets.push(Character.valueOf(linechar));
                        continue block6;
                    }
                    case ']': {
                        if (((Character)brackets.pop()).charValue() == '[') continue block6;
                        return 'b';
                    }
                    case '}': {
                        if (((Character)brackets.pop()).charValue() == '{') continue block6;
                        return 'b';
                    }
                }
            }
        }
        if (brackets.size() != 0) {
            return 'b';
        }
        this.scanner.close();
        this.scanner = new Scanner(this.inputFile);
        return 'v';
    }

    public XFile parse() throws FileNotFoundException {
        XFile xFile = new XFile();
        xFile.setEntities(this.readEntities());
        for (Entity e : xFile.getEntities()) {
            if (e.isHelper()) continue;
            xFile.setMeshData(e.getData());
            break;
        }
        this.scanner.close();
        return xFile;
    }

    private ArrayList<Entity> readEntities() throws FileNotFoundException {
        String currentLine;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        while (!(currentLine = this.scanner.nextLine()).matches("\\s*Frame\\s+\\w+\\s*\\{\\.*")) {
        }
        while (this.scanner.hasNextLine()) {
            currentLine = this.scanner.nextLine();
            if (!currentLine.matches("\\s*Frame\\s+\\w+\\s*\\{\\.*")) continue;
            entities.add(this.readEntity(currentLine.split("\\s+")[2]));
        }
        return entities;
    }

    private Entity readEntity(String entityName) {
        StringBuilder builder = new StringBuilder();
        Entity entity = new Entity();
        entity.setName(entityName);
        int depth = 1;
        while (true) {
            char[] currentLine;
            for (char c : currentLine = this.scanner.nextLine().toCharArray()) {
                if (c == '}') {
                    --depth;
                    continue;
                }
                if (c != '{') continue;
                ++depth;
            }
            if (depth <= 0) break;
            builder.append(String.valueOf(currentLine));
        }
        entity.setData(builder.toString());
        return entity;
    }

    public String toString() {
        return this.inputFile.getName() + ": " + this.inputFile.length() + " bytes input.";
    }
}

